/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.thinkaurelius.titan.core.Cardinality;
import com.thinkaurelius.titan.core.EdgeLabel;
import com.thinkaurelius.titan.core.Multiplicity;
import com.thinkaurelius.titan.core.PropertyKey;
import com.thinkaurelius.titan.core.TitanEdge;
import com.thinkaurelius.titan.core.TitanException;
import com.thinkaurelius.titan.core.TitanProperty;
import com.thinkaurelius.titan.core.TitanRelation;
import com.thinkaurelius.titan.core.TitanTransaction;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.core.attribute.Cmp;
import com.thinkaurelius.titan.core.attribute.Decimal;
import com.thinkaurelius.titan.core.attribute.Duration;
import com.thinkaurelius.titan.core.attribute.Timestamp;
import com.thinkaurelius.titan.core.schema.ConsistencyModifier;
import com.thinkaurelius.titan.core.schema.TitanGraphIndex;
import com.thinkaurelius.titan.core.schema.TitanSchemaElement;
import com.thinkaurelius.titan.diskstorage.util.TestLockerManager;
import com.thinkaurelius.titan.graphdb.TitanGraphBaseTest;
import com.thinkaurelius.titan.graphdb.configuration.GraphDatabaseConfiguration;
import com.thinkaurelius.titan.testcategory.SerialTests;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Predicate;
import com.tinkerpop.blueprints.Vertex;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={SerialTests.class})
public abstract class TitanEventualGraphTest
extends TitanGraphBaseTest {
    private Logger log = LoggerFactory.getLogger(TitanEventualGraphTest.class);

    @Test
    public void verifyEligibility() {
        Preconditions.checkArgument((!this.graph.getConfiguration().getBackend().getStoreFeatures().hasTxIsolation() ? 1 : 0) != 0, (Object)"This test suite only applies to eventually consistent data stores");
    }

    @Test
    public void concurrentIndexTest() {
        this.makeVertexIndexedUniqueKey("uid", String.class);
        this.makeVertexIndexedKey("value", Object.class);
        this.finishSchema();
        TitanVertex v = this.tx.addVertex();
        v.setProperty("uid", (Object)"v");
        this.clopen(new Object[0]);
        TitanTransaction tx1 = this.graph.newTransaction();
        TitanTransaction tx2 = this.graph.newTransaction();
        TitanEventualGraphTest.getVertex(tx1, "uid", (Object)"v").setProperty("value", (Object)11);
        TitanEventualGraphTest.getVertex(tx2, "uid", (Object)"v").setProperty("value", (Object)11);
        tx1.commit();
        tx2.commit();
        Assert.assertEquals((Object)"v", (Object)((Vertex)Iterables.getOnlyElement((Iterable)this.tx.getVertices("value", (Object)11))).getProperty("uid"));
    }

    @Test
    public void testTimestampSetting() {
        this.clopen(TitanEventualGraphTest.option(GraphDatabaseConfiguration.STORE_META_TIMESTAMPS, "edgestore"), true, TitanEventualGraphTest.option(GraphDatabaseConfiguration.STORE_META_TTL, "edgestore"), true);
        TimeUnit unit = TimeUnit.SECONDS;
        TitanTransaction tx1 = this.graph.buildTransaction().setCommitTime(100L, unit).start();
        String name = "name";
        String age = "age";
        String address = "address";
        TitanVertex v1 = tx1.addVertex();
        TitanVertex v2 = tx1.addVertex();
        v1.setProperty(name, (Object)"a");
        v2.setProperty(age, (Object)"14");
        v2.setProperty(name, (Object)"b");
        v2.setProperty(age, (Object)"42");
        tx1.commit();
        long id1 = v1.getLongId();
        long id2 = v2.getLongId();
        TitanTransaction tx2 = this.graph.buildTransaction().setCommitTime(1000L, unit).start();
        v1 = tx2.getVertex(id1);
        v2 = tx2.getVertex(id2);
        for (TitanProperty prop : v1.getProperties(name)) {
            if (this.features.hasTimestamps()) {
                Timestamp t = (Timestamp)prop.getProperty("$timestamp");
                Assert.assertEquals((long)100L, (long)t.sinceEpoch(unit));
                Assert.assertEquals((long)(TimeUnit.MICROSECONDS.convert(100L, TimeUnit.SECONDS) + 1L), (long)t.sinceEpoch(TimeUnit.MICROSECONDS));
            }
            if (!this.features.hasCellTTL()) continue;
            Duration d = (Duration)prop.getProperty("$ttl");
            Assert.assertEquals((long)0L, (long)d.getLength(unit));
            Assert.assertTrue((boolean)d.isZeroLength());
        }
        Assert.assertEquals((long)1L, (long)v1.query().has("$timestamp", (Object)new Timestamp(100L, unit)).propertyCount());
        Assert.assertEquals((long)1L, (long)v1.query().has("$timestamp", (Predicate)Cmp.GREATER_THAN, (Object)new Timestamp(10L, unit)).propertyCount());
        v1.removeProperty(name);
        v1.setProperty(address, (Object)"xyz");
        Edge edge = tx2.addEdge((Object)1, (Vertex)v2, (Vertex)v1, "parent");
        tx2.commit();
        Object edgeId = edge.getId();
        TitanVertex afterTx2 = this.graph.getVertex(id1);
        Assert.assertFalse((boolean)afterTx2.getPropertyKeys().contains(name));
        Assert.assertEquals((Object)"xyz", (Object)afterTx2.getProperty(address));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)afterTx2.getEdges(Direction.IN, new String[]{"parent"})));
        Assert.assertNotNull((Object)this.graph.getEdge(edgeId));
        this.graph.commit();
        TitanTransaction tx3 = this.graph.buildTransaction().setCommitTime(200L, unit).start();
        v1 = tx3.getVertex(id1);
        v1.removeProperty(address);
        tx3.commit();
        TitanVertex afterTx3 = this.graph.getVertex(id1);
        this.graph.commit();
        Assert.assertEquals((Object)"xyz", (Object)afterTx3.getProperty(address));
        TitanTransaction tx4 = this.graph.buildTransaction().setCommitTime(2000L, unit).start();
        v2 = tx4.getVertex(id2);
        v2.setProperty(age, (Object)"15");
        tx4.removeEdge(tx4.getEdge(edgeId));
        tx4.commit();
        TitanVertex afterTx4 = this.graph.getVertex(id2);
        Assert.assertEquals((Object)"15", (Object)afterTx4.getProperty(age));
        Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)afterTx4.getEdges(Direction.OUT, new String[]{"parent"})));
        Assert.assertNull((Object)this.graph.getEdge(edgeId));
        TitanTransaction tx5 = this.graph.buildTransaction().setCommitTime(1500L, unit).start();
        v2 = tx5.getVertex(id2);
        v2.setProperty(age, (Object)"16");
        tx5.commit();
        TitanVertex afterTx5 = this.graph.getVertex(id2);
        Assert.assertEquals((Object)"15", (Object)afterTx5.getProperty(age));
    }

    @Test
    public void testTimestampedUpdates() {
        this.clopen(TitanEventualGraphTest.option(GraphDatabaseConfiguration.STORE_META_TIMESTAMPS, "edgestore"), true, TitanEventualGraphTest.option(GraphDatabaseConfiguration.STORE_META_TTL, "edgestore"), true);
        TimeUnit unit = TimeUnit.SECONDS;
        TitanTransaction tx = this.graph.buildTransaction().setCommitTime(100L, unit).start();
        TitanVertex v1 = tx.addVertex();
        TitanVertex v2 = tx.addVertex();
        TitanProperty p = v1.addProperty("name", (Object)"xyz");
        p.setProperty("time", (Object)15);
        TitanEdge e = v1.addEdge("related", v2);
        e.setProperty("time", (Object)25);
        tx.commit();
        tx = this.graph.buildTransaction().setCommitTime(200L, unit).start();
        v1 = (TitanVertex)tx.getVertex((Object)v1);
        Assert.assertNotNull((Object)v1);
        p = (TitanProperty)Iterables.getOnlyElement((Iterable)v1.getProperties("name"));
        e = (Edge)Iterables.getOnlyElement((Iterable)v1.getEdges(Direction.OUT, new String[]{"related"}));
        Assert.assertEquals((long)3L, (long)p.getPropertyKeys().size());
        Assert.assertEquals((long)3L, (long)p.getPropertyKeys().size());
        p.setProperty("time", (Object)115);
        e.setProperty("time", (Object)125);
        tx.commit();
        tx = this.graph.buildTransaction().setCommitTime(300L, unit).start();
        v1 = (TitanVertex)tx.getVertex((Object)v1);
        Assert.assertNotNull((Object)v1);
        p = (TitanProperty)Iterables.getOnlyElement((Iterable)v1.getProperties("name"));
        e = (Edge)Iterables.getOnlyElement((Iterable)v1.getEdges(Direction.OUT, new String[]{"related"}));
        Assert.assertEquals((Object)115, (Object)p.getProperty("time"));
        Assert.assertEquals((Object)125, (Object)e.getProperty("time"));
        p.remove();
        e.remove();
        tx.commit();
    }

    @Test
    public void testBatchLoadingNoLock() {
        this.testBatchLoadingLocking(true);
    }

    @Test
    public void testLockException() {
        try {
            this.testBatchLoadingLocking(false);
            Assert.fail();
        }
        catch (TitanException e) {
            Throwable cause = e;
            while (cause.getCause() != null) {
                cause = cause.getCause();
            }
            Assert.assertEquals(UnsupportedOperationException.class, cause.getClass());
        }
    }

    public void testBatchLoadingLocking(boolean batchloading) {
        int i;
        PropertyKey uid = this.makeKey("uid", Long.class);
        TitanGraphIndex uidIndex = this.mgmt.buildIndex("uid", Vertex.class).unique().addKey(uid).buildCompositeIndex();
        this.mgmt.setConsistency((TitanSchemaElement)uid, ConsistencyModifier.LOCK);
        this.mgmt.setConsistency((TitanSchemaElement)uidIndex, ConsistencyModifier.LOCK);
        EdgeLabel knows = this.mgmt.makeEdgeLabel("knows").multiplicity(Multiplicity.ONE2ONE).make();
        this.mgmt.setConsistency((TitanSchemaElement)knows, ConsistencyModifier.LOCK);
        this.finishSchema();
        TestLockerManager.ERROR_ON_LOCKING = true;
        this.clopen(TitanEventualGraphTest.option(GraphDatabaseConfiguration.STORAGE_BATCH, new String[0]), batchloading, TitanEventualGraphTest.option(GraphDatabaseConfiguration.LOCK_BACKEND, new String[0]), "test");
        int numV = 10000;
        long start = System.currentTimeMillis();
        for (i = 0; i < numV; ++i) {
            TitanVertex v = this.tx.addVertex();
            v.setProperty("uid", (Object)(i + 1));
            v.addEdge("knows", v);
        }
        this.clopen(new Object[0]);
        for (i = 0; i < Math.min(numV, 300); ++i) {
            Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)this.graph.query().has("uid", (Object)(i + 1)).vertices()));
            Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)((Vertex)this.graph.query().has("uid", (Object)(i + 1)).vertices().iterator().next()).getEdges(Direction.OUT, new String[]{"knows"})));
        }
    }

    @Test
    public void testConsistencyModifier() throws InterruptedException {
        PropertyKey sig = this.makeKey("sig", Integer.class);
        PropertyKey weight = this.makeKey("weight", Decimal.class);
        PropertyKey name = this.mgmt.makePropertyKey("name").dataType(String.class).cardinality(Cardinality.SET).make();
        PropertyKey value = this.mgmt.makePropertyKey("value").dataType(Integer.class).cardinality(Cardinality.LIST).make();
        PropertyKey valuef = this.mgmt.makePropertyKey("valuef").dataType(Integer.class).cardinality(Cardinality.LIST).make();
        this.mgmt.setConsistency((TitanSchemaElement)valuef, ConsistencyModifier.FORK);
        EdgeLabel em = this.mgmt.makeEdgeLabel("em").multiplicity(Multiplicity.MULTI).make();
        EdgeLabel emf = this.mgmt.makeEdgeLabel("emf").multiplicity(Multiplicity.MULTI).make();
        this.mgmt.setConsistency((TitanSchemaElement)emf, ConsistencyModifier.FORK);
        EdgeLabel es = this.mgmt.makeEdgeLabel("es").multiplicity(Multiplicity.SIMPLE).make();
        EdgeLabel o2o = this.mgmt.makeEdgeLabel("o2o").multiplicity(Multiplicity.ONE2ONE).make();
        EdgeLabel o2m = this.mgmt.makeEdgeLabel("o2m").multiplicity(Multiplicity.ONE2MANY).make();
        this.finishSchema();
        TitanVertex u = this.tx.addVertex();
        TitanVertex v = this.tx.addVertex();
        TitanRelation[] rs = new TitanRelation[9];
        boolean txid = true;
        rs[0] = this.sign((TitanRelation)v.addProperty("weight", (Object)5.0), 1);
        rs[1] = this.sign((TitanRelation)v.addProperty("name", (Object)"John"), 1);
        rs[2] = this.sign((TitanRelation)v.addProperty("value", (Object)2), 1);
        rs[3] = this.sign((TitanRelation)v.addProperty("valuef", (Object)2), 1);
        rs[6] = this.sign((TitanRelation)v.addEdge("es", u), 1);
        rs[7] = this.sign((TitanRelation)v.addEdge("o2o", u), 1);
        rs[8] = this.sign((TitanRelation)v.addEdge("o2m", u), 1);
        rs[4] = this.sign((TitanRelation)v.addEdge("em", u), 1);
        rs[5] = this.sign((TitanRelation)v.addEdge("emf", u), 1);
        this.newTx();
        long vid = v.getLongId();
        long uid = u.getLongId();
        TitanTransaction tx1 = this.graph.newTransaction();
        TitanTransaction tx2 = this.graph.newTransaction();
        int wintx = 20;
        this.processTx(tx1, 10, vid, uid);
        this.processTx(tx2, 20, vid, uid);
        tx1.commit();
        Thread.sleep(5L);
        tx2.commit();
        this.newTx();
        v = this.tx.getVertex(vid);
        Assert.assertEquals((double)6.0, (double)((Decimal)v.getProperty("weight")).doubleValue(), (double)1.0E-5);
        TitanProperty p = (TitanProperty)Iterables.getOnlyElement((Iterable)v.getProperties("weight"));
        Assert.assertEquals((Object)20, (Object)p.getProperty("sig"));
        p = (TitanProperty)Iterables.getOnlyElement((Iterable)v.getProperties("name"));
        Assert.assertEquals((Object)"Bob", (Object)p.getValue());
        Assert.assertEquals((Object)20, (Object)p.getProperty("sig"));
        p = (TitanProperty)Iterables.getOnlyElement((Iterable)v.getProperties("value"));
        Assert.assertEquals((long)rs[2].getLongId(), (long)p.getLongId());
        Assert.assertEquals((Object)20, (Object)p.getProperty("sig"));
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)v.getProperties("valuef")));
        for (TitanProperty pp : v.getProperties("valuef")) {
            Assert.assertNotEquals((long)rs[3].getLongId(), (long)pp.getLongId());
            Assert.assertEquals((Object)2, (Object)pp.getValue());
        }
        TitanEdge e = (TitanEdge)Iterables.getOnlyElement((Iterable)v.getEdges(Direction.OUT, new String[]{"es"}));
        Assert.assertEquals((Object)20, (Object)e.getProperty("sig"));
        Assert.assertNotEquals((long)rs[6].getLongId(), (long)e.getLongId());
        e = (TitanEdge)Iterables.getOnlyElement((Iterable)v.getEdges(Direction.OUT, new String[]{"o2o"}));
        Assert.assertEquals((Object)20, (Object)e.getProperty("sig"));
        Assert.assertEquals((long)rs[7].getLongId(), (long)e.getLongId());
        e = (TitanEdge)Iterables.getOnlyElement((Iterable)v.getEdges(Direction.OUT, new String[]{"o2m"}));
        Assert.assertEquals((Object)20, (Object)e.getProperty("sig"));
        Assert.assertNotEquals((long)rs[8].getLongId(), (long)e.getLongId());
        e = (TitanEdge)Iterables.getOnlyElement((Iterable)v.getEdges(Direction.OUT, new String[]{"em"}));
        Assert.assertEquals((Object)20, (Object)e.getProperty("sig"));
        Assert.assertEquals((long)rs[4].getLongId(), (long)e.getLongId());
        for (Edge ee : v.getEdges(Direction.OUT, new String[]{"emf"})) {
            Assert.assertNotEquals((Object)rs[5].getLongId(), (Object)ee.getId());
            Assert.assertEquals((Object)uid, (Object)ee.getVertex(Direction.IN).getId());
        }
    }

    private void processTx(TitanTransaction tx, int txid, long vid, long uid) {
        TitanVertex v = tx.getVertex(vid);
        TitanVertex u = tx.getVertex(uid);
        Assert.assertEquals((double)5.0, (double)((Decimal)v.getProperty("weight")).doubleValue(), (double)1.0E-5);
        TitanProperty p = (TitanProperty)Iterables.getOnlyElement((Iterable)v.getProperties("weight"));
        Assert.assertEquals((Object)1, (Object)p.getProperty("sig"));
        this.sign((TitanRelation)v.addProperty("weight", (Object)6.0), txid);
        p = (TitanProperty)Iterables.getOnlyElement((Iterable)v.getProperties("name"));
        Assert.assertEquals((Object)1, (Object)p.getProperty("sig"));
        Assert.assertEquals((Object)"John", (Object)p.getValue());
        p.remove();
        this.sign((TitanRelation)v.addProperty("name", (Object)"Bob"), txid);
        for (String pkey : new String[]{"value", "valuef"}) {
            p = (TitanProperty)Iterables.getOnlyElement((Iterable)v.getProperties(pkey));
            Assert.assertEquals((Object)1, (Object)p.getProperty("sig"));
            Assert.assertEquals((Object)2, (Object)p.getValue());
            this.sign((TitanRelation)p, txid);
        }
        TitanEdge e = (TitanEdge)Iterables.getOnlyElement((Iterable)v.getEdges(Direction.OUT, new String[]{"es"}));
        Assert.assertEquals((Object)1, (Object)e.getProperty("sig"));
        e.remove();
        this.sign((TitanRelation)v.addEdge("es", u), txid);
        e = (TitanEdge)Iterables.getOnlyElement((Iterable)v.getEdges(Direction.OUT, new String[]{"o2o"}));
        Assert.assertEquals((Object)1, (Object)e.getProperty("sig"));
        this.sign((TitanRelation)e, txid);
        e = (TitanEdge)Iterables.getOnlyElement((Iterable)v.getEdges(Direction.OUT, new String[]{"o2m"}));
        Assert.assertEquals((Object)1, (Object)e.getProperty("sig"));
        e.remove();
        this.sign((TitanRelation)v.addEdge("o2m", u), txid);
        for (String label : new String[]{"em", "emf"}) {
            e = (TitanEdge)Iterables.getOnlyElement((Iterable)v.getEdges(Direction.OUT, new String[]{label}));
            Assert.assertEquals((Object)1, (Object)e.getProperty("sig"));
            this.sign((TitanRelation)e, txid);
        }
    }

    private TitanRelation sign(TitanRelation r, int id) {
        r.setProperty("sig", (Object)id);
        return r;
    }
}

