/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb;

import com.google.common.collect.Iterables;
import com.thinkaurelius.titan.core.Cardinality;
import com.thinkaurelius.titan.core.EdgeLabel;
import com.thinkaurelius.titan.core.PropertyKey;
import com.thinkaurelius.titan.core.RelationType;
import com.thinkaurelius.titan.core.TitanEdge;
import com.thinkaurelius.titan.core.TitanTransaction;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.core.schema.EdgeLabelMaker;
import com.thinkaurelius.titan.graphdb.TitanGraphBaseTest;
import com.thinkaurelius.titan.graphdb.configuration.GraphDatabaseConfiguration;
import com.thinkaurelius.titan.testcategory.PerformanceTests;
import com.thinkaurelius.titan.testutil.JUnitBenchmarkProvider;
import com.thinkaurelius.titan.testutil.RandomGenerator;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Vertex;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={PerformanceTests.class})
public abstract class TitanGraphConcurrentTest
extends TitanGraphBaseTest {
    @Rule
    public TestRule benchmark = JUnitBenchmarkProvider.get();
    private static final int THREAD_COUNT = TitanGraphConcurrentTest.getThreadCount();
    private static final int TASK_COUNT = THREAD_COUNT * 256;
    private static final int NODE_COUNT = 1000;
    private static final int EDGE_COUNT = 5;
    private static final int REL_COUNT = 5;
    private static final Logger log = LoggerFactory.getLogger(TitanGraphConcurrentTest.class);
    private ExecutorService executor;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.executor = Executors.newFixedThreadPool(THREAD_COUNT);
    }

    private void initializeGraph() {
        int i;
        for (int i2 = 0; i2 < 5; ++i2) {
            this.makeLabel("rel" + i2);
        }
        this.makeVertexIndexedUniqueKey("uid", Integer.class);
        this.finishSchema();
        TitanVertex[] nodes = new TitanVertex[1000];
        for (i = 0; i < 1000; ++i) {
            nodes[i] = this.tx.addVertex();
            nodes[i].addProperty("uid", (Object)i);
        }
        for (i = 0; i < 1000; ++i) {
            for (int r = 0; r < 5; ++r) {
                for (int j = 1; j <= 5; ++j) {
                    nodes[i].addEdge("rel" + r, nodes[TitanGraphConcurrentTest.wrapAround(i + j, 1000)]);
                }
            }
        }
        this.clopen(new Object[0]);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.executor.shutdown();
        if (!this.executor.awaitTermination(30L, TimeUnit.SECONDS)) {
            log.error("Abnormal executor shutdown");
            Thread.dumpStack();
        } else {
            log.debug("Test executor completed normal shutdown");
        }
        super.tearDown();
    }

    @Test
    public void concurrentTxRead() throws Exception {
        int t;
        int i;
        int numTypes = 20;
        int numThreads = 100;
        for (i = 0; i < 10; ++i) {
            if (i % 4 == 0) {
                this.makeVertexIndexedUniqueKey("test" + i, String.class);
                continue;
            }
            this.makeKey("test" + i, String.class);
        }
        for (i = 10; i < 20; ++i) {
            EdgeLabelMaker tm = this.mgmt.makeEdgeLabel("test" + i);
            if (i % 4 == 1) {
                tm.unidirected();
            }
            tm.make();
        }
        this.finishSchema();
        this.clopen(new Object[0]);
        Thread[] threads = new Thread[100];
        for (t = 0; t < 100; ++t) {
            threads[t] = new Thread(new Runnable(){

                @Override
                public void run() {
                    TitanTransaction tx = TitanGraphConcurrentTest.this.graph.newTransaction();
                    for (int i = 0; i < 20; ++i) {
                        RelationType type = tx.getRelationType("test" + i);
                        if (i < 10) {
                            Assert.assertTrue((boolean)type.isPropertyKey());
                            continue;
                        }
                        Assert.assertTrue((boolean)type.isEdgeLabel());
                    }
                    tx.commit();
                }
            });
            threads[t].start();
        }
        for (t = 0; t < 100; ++t) {
            threads[t].join();
        }
    }

    @Test
    public void concurrentReadsOnSingleTransaction() throws Exception {
        this.initializeGraph();
        PropertyKey id = this.tx.getPropertyKey("uid");
        CountDownLatch startLatch = new CountDownLatch(TASK_COUNT);
        CountDownLatch stopLatch = new CountDownLatch(TASK_COUNT);
        for (int i = 0; i < TASK_COUNT; ++i) {
            int nodeid = RandomGenerator.randomInt(0, 1000);
            EdgeLabel rel = this.tx.getEdgeLabel("rel" + RandomGenerator.randomInt(0, 5));
            this.executor.execute(new SimpleReader(this.tx, startLatch, stopLatch, nodeid, rel, 10, id));
            startLatch.countDown();
        }
        stopLatch.await();
    }

    @Test
    public void concurrentReadWriteOnSingleTransaction() throws Exception {
        this.initializeGraph();
        this.mgmt.getPropertyKey("uid");
        this.makeVertexIndexedUniqueKey("dummyProperty", String.class);
        this.makeLabel("dummyRelationship");
        this.finishSchema();
        PropertyKey id = this.tx.getPropertyKey("uid");
        RandomPropertyMaker propMaker = new RandomPropertyMaker(this.tx, 1000, id, this.tx.getPropertyKey("dummyProperty"));
        FixedRelationshipMaker relMaker = new FixedRelationshipMaker(this.tx, id, this.tx.getEdgeLabel("dummyRelationship"));
        Future<?> propFuture = this.executor.submit(propMaker);
        Future<?> relFuture = this.executor.submit(relMaker);
        CountDownLatch startLatch = new CountDownLatch(TASK_COUNT);
        CountDownLatch stopLatch = new CountDownLatch(TASK_COUNT);
        for (int i = 0; i < TASK_COUNT; ++i) {
            int nodeid = RandomGenerator.randomInt(0, 1000);
            EdgeLabel rel = this.tx.getEdgeLabel("rel" + RandomGenerator.randomInt(0, 5));
            this.executor.execute(new SimpleReader(this.tx, startLatch, stopLatch, nodeid, rel, 10, id));
            startLatch.countDown();
        }
        stopLatch.await();
        propFuture.cancel(true);
        relFuture.cancel(true);
    }

    @Test
    public void concurrentIndexReadWriteTest() throws Exception {
        this.clopen(TitanGraphConcurrentTest.option(GraphDatabaseConfiguration.ADJUST_LIMIT, new String[0]), false);
        PropertyKey k = this.mgmt.makePropertyKey("k").dataType(Integer.class).cardinality(Cardinality.SINGLE).make();
        PropertyKey q = this.mgmt.makePropertyKey("q").dataType(Long.class).cardinality(Cardinality.SINGLE).make();
        this.mgmt.buildIndex("byK", Vertex.class).addKey(k).buildCompositeIndex();
        this.finishSchema();
        final AtomicBoolean run = new AtomicBoolean(true);
        int batchV = 10;
        int batchR = 10;
        int maxK = 5;
        int maxQ = 2;
        final Random random = new Random();
        final AtomicInteger duplicates = new AtomicInteger(0);
        Thread writer = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (run.get()) {
                    TitanTransaction tx = TitanGraphConcurrentTest.this.graph.newTransaction();
                    try {
                        for (int i = 0; i < 10; ++i) {
                            TitanVertex v = tx.addVertex();
                            v.setProperty("k", (Object)random.nextInt(5));
                            v.setProperty("q", (Object)random.nextInt(2));
                        }
                        tx.commit();
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                    finally {
                        if (!tx.isOpen()) continue;
                        tx.rollback();
                    }
                }
            }
        });
        Thread reader = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (run.get()) {
                    TitanTransaction tx = TitanGraphConcurrentTest.this.graph.newTransaction();
                    try {
                        for (int i = 0; i < 10; ++i) {
                            HashSet<Vertex> vs = new HashSet<Vertex>();
                            Iterable vertices = tx.query().has("k", (Object)random.nextInt(5)).has("q", (Object)random.nextInt(2)).vertices();
                            for (Vertex v : vertices) {
                                if (vs.add(v)) continue;
                                duplicates.incrementAndGet();
                                System.err.println("Duplicate vertex: " + v);
                            }
                        }
                        tx.commit();
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                    finally {
                        if (!tx.isOpen()) continue;
                        tx.rollback();
                    }
                }
            }
        });
        writer.start();
        reader.start();
        Thread.sleep(10000L);
        run.set(false);
        writer.join();
        reader.join();
        Assert.assertEquals((long)0L, (long)duplicates.get());
    }

    @Test
    public void testStandardIndexVertexPropertyReads() throws InterruptedException, ExecutionException {
        int i;
        int propCount = THREAD_COUNT * 5;
        int vertexCount = 1000;
        log.info("Creating types");
        for (i = 0; i < propCount; ++i) {
            this.makeVertexIndexedUniqueKey("p" + i, String.class);
        }
        this.finishSchema();
        log.info("Creating vertices");
        for (i = 0; i < 1000; ++i) {
            TitanVertex v = this.tx.addVertex();
            for (int j = 0; j < propCount; ++j) {
                this.tx.addProperty(v, "p" + j, (Object)i);
            }
        }
        this.newTx();
        log.info("Querying vertex property indices");
        ArrayList futures = new ArrayList(TASK_COUNT);
        for (int i2 = 0; i2 < TASK_COUNT; ++i2) {
            futures.add(this.executor.submit(new VertexPropertyQuerier(propCount, 1000)));
        }
        for (Future future : futures) {
            future.get();
        }
    }

    private class VertexPropertyQuerier
    implements Runnable {
        private final int propCount;
        private final int vertexCount;

        public VertexPropertyQuerier(int propCount, int vertexCount) {
            this.propCount = propCount;
            this.vertexCount = vertexCount;
        }

        @Override
        public void run() {
            for (int i = 0; i < this.vertexCount; ++i) {
                for (int p = 0; p < this.propCount; ++p) {
                    TitanGraphConcurrentTest.this.tx.getVertices("p" + p, (Object)i);
                }
            }
        }
    }

    private static abstract class BarrierRunnable
    implements Runnable {
        protected final TitanTransaction tx;
        protected final CountDownLatch startLatch;
        protected final CountDownLatch stopLatch;

        public BarrierRunnable(TitanTransaction tx, CountDownLatch startLatch, CountDownLatch stopLatch) {
            this.tx = tx;
            this.startLatch = startLatch;
            this.stopLatch = stopLatch;
        }

        protected abstract void doRun() throws Exception;

        @Override
        public void run() {
            try {
                this.startLatch.await();
            }
            catch (Exception e) {
                throw new RuntimeException("Interrupted while waiting for peers to start");
            }
            try {
                this.doRun();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.stopLatch.countDown();
        }
    }

    private static class SimpleReader
    extends BarrierRunnable {
        private final int nodeid;
        private final EdgeLabel relTypeToTraverse;
        private final long nodeTraversalCount = 256L;
        private final int expectedEdges;
        private final PropertyKey id;

        public SimpleReader(TitanTransaction tx, CountDownLatch startLatch, CountDownLatch stopLatch, int startNodeId, EdgeLabel relTypeToTraverse, int expectedEdges, PropertyKey id) {
            super(tx, startLatch, stopLatch);
            this.nodeid = startNodeId;
            this.relTypeToTraverse = relTypeToTraverse;
            this.expectedEdges = expectedEdges;
            this.id = id;
        }

        @Override
        protected void doRun() throws Exception {
            TitanVertex n = (TitanVertex)Iterables.getOnlyElement((Iterable)this.tx.getVertices(this.id, (Object)this.nodeid));
            int i = 0;
            while ((long)i < 256L) {
                Assert.assertEquals((String)("On vertex: " + n.getLongId()), (long)this.expectedEdges, (long)Iterables.size((Iterable)n.getTitanEdges(Direction.BOTH, new EdgeLabel[]{this.relTypeToTraverse})));
                for (TitanEdge r : n.getTitanEdges(Direction.OUT, new EdgeLabel[]{this.relTypeToTraverse})) {
                    n = r.getVertex(Direction.IN);
                }
                ++i;
            }
        }
    }

    private static class FixedRelationshipMaker
    implements Runnable {
        private final TitanTransaction tx;
        private final PropertyKey idProp;
        private final EdgeLabel relType;

        public FixedRelationshipMaker(TitanTransaction tx, PropertyKey id, EdgeLabel relType) {
            this.tx = tx;
            this.idProp = id;
            this.relType = relType;
        }

        @Override
        public void run() {
            do {
                TitanVertex source = (TitanVertex)Iterables.getOnlyElement((Iterable)this.tx.getVertices(this.idProp, (Object)0));
                TitanVertex sink = (TitanVertex)Iterables.getOnlyElement((Iterable)this.tx.getVertices(this.idProp, (Object)1));
                for (TitanEdge r : source.getTitanEdges(Direction.OUT, new EdgeLabel[]{this.relType})) {
                    if (r.getVertex(Direction.IN).getLongId() != sink.getLongId()) continue;
                    r.remove();
                }
                source.addEdge(this.relType, sink);
            } while (!Thread.interrupted());
        }
    }

    private static class RandomPropertyMaker
    implements Runnable {
        private final TitanTransaction tx;
        private final int nodeCount;
        private final PropertyKey idProp;
        private final PropertyKey randomProp;

        public RandomPropertyMaker(TitanTransaction tx, int nodeCount, PropertyKey idProp, PropertyKey randomProp) {
            this.tx = tx;
            this.nodeCount = nodeCount;
            this.idProp = idProp;
            this.randomProp = randomProp;
        }

        @Override
        public void run() {
            do {
                TitanVertex n = (TitanVertex)Iterables.getOnlyElement((Iterable)this.tx.getVertices(this.idProp, (Object)RandomGenerator.randomInt(0, this.nodeCount)));
                String propVal = RandomGenerator.randomString();
                n.addProperty(this.randomProp, (Object)propVal);
            } while (!Thread.interrupted());
        }
    }
}

