/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Iterators;
import com.thinkaurelius.titan.core.PropertyKey;
import com.thinkaurelius.titan.core.RelationType;
import com.thinkaurelius.titan.core.TitanEdge;
import com.thinkaurelius.titan.core.TitanTransaction;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.diskstorage.BackendException;
import com.thinkaurelius.titan.diskstorage.BaseTransactionConfig;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyColumnValueStore;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyColumnValueStoreManager;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.KeyIterator;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.SliceQuery;
import com.thinkaurelius.titan.diskstorage.keycolumnvalue.StoreTransaction;
import com.thinkaurelius.titan.diskstorage.util.BufferUtil;
import com.thinkaurelius.titan.diskstorage.util.RecordIterator;
import com.thinkaurelius.titan.diskstorage.util.StandardBaseTransactionConfig;
import com.thinkaurelius.titan.diskstorage.util.time.TimestampProvider;
import com.thinkaurelius.titan.diskstorage.util.time.Timestamps;
import com.thinkaurelius.titan.graphdb.TitanGraphBaseTest;
import com.thinkaurelius.titan.graphdb.types.StandardEdgeLabelMaker;
import java.util.Iterator;
import java.util.Random;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;

public abstract class TitanGraphIterativeBenchmark
extends TitanGraphBaseTest {
    private static final Random random = new Random();

    public abstract KeyColumnValueStoreManager openStorageManager() throws BackendException;

    public void testDataSequential() throws Exception {
        this.loadData(200000, 2);
        this.close();
        KeyColumnValueStoreManager manager = this.openStorageManager();
        KeyColumnValueStore store = manager.openDatabase("edgestore");
        SliceQuery query = new SliceQuery(BufferUtil.zeroBuffer((int)8), BufferUtil.oneBuffer((int)8));
        query.setLimit(2);
        Stopwatch watch = Stopwatch.createStarted();
        StoreTransaction txh = manager.beginTransaction((BaseTransactionConfig)StandardBaseTransactionConfig.of((TimestampProvider)Timestamps.MILLI));
        KeyIterator iter = store.getKeys(query, txh);
        int numV = 0;
        while (iter.hasNext()) {
            StaticBuffer key = (StaticBuffer)iter.next();
            RecordIterator entries = iter.getEntries();
            Assert.assertEquals((long)2L, (long)Iterators.size((Iterator)entries));
            ++numV;
        }
        iter.close();
        txh.commit();
        System.out.println("Time taken: " + watch.elapsed(TimeUnit.MILLISECONDS));
        System.out.println("Num Vertices: " + numV);
        store.close();
        manager.close();
    }

    public void testLoadData() throws Exception {
        this.loadData(100000, 2);
    }

    public void loadData(int numVertices, int numThreads) throws Exception {
        this.makeKey("w", Integer.class);
        PropertyKey time = this.makeKey("t", Long.class);
        ((StandardEdgeLabelMaker)this.mgmt.makeEdgeLabel("l")).sortKey(new RelationType[]{time}).make();
        this.finishSchema();
        int maxQueue = 1000;
        int verticesPerTask = 1000;
        int maxWeight = 10;
        int maxTime = 10000;
        ArrayBlockingQueue tasks = new ArrayBlockingQueue(1000);
        ExecutorService exe = Executors.newFixedThreadPool(numThreads);
        for (int i = 0; i < numVertices / 1000; ++i) {
            while (tasks.size() >= 1000) {
                Thread.sleep(1000L);
            }
            assert (tasks.size() < 1000);
            exe.submit(new Runnable(){

                @Override
                public void run() {
                    int j;
                    TitanTransaction tx = TitanGraphIterativeBenchmark.this.graph.newTransaction();
                    TitanVertex[] vs = new TitanVertex[1000];
                    for (j = 0; j < 1000; ++j) {
                        vs[j] = tx.addVertex();
                        vs[j].setProperty("w", (Object)random.nextInt(10));
                    }
                    for (j = 0; j < 10000; ++j) {
                        TitanEdge e = vs[random.nextInt(1000)].addEdge("l", vs[random.nextInt(1000)]);
                        e.setProperty("t", (Object)random.nextInt(10000));
                    }
                    System.out.print(".");
                    tx.commit();
                }
            });
        }
        exe.shutdown();
        exe.awaitTermination(numVertices / 1000, TimeUnit.SECONDS);
        if (!exe.isTerminated()) {
            System.err.println("Could not load data in time");
        }
        System.out.println("Loaded " + numVertices + "vertices");
    }
}

