/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb;

import com.google.common.collect.Iterables;
import com.thinkaurelius.titan.core.PropertyKey;
import com.thinkaurelius.titan.core.RelationType;
import com.thinkaurelius.titan.core.TitanEdge;
import com.thinkaurelius.titan.core.TitanTransaction;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.graphdb.TitanGraphBaseTest;
import com.thinkaurelius.titan.testcategory.MemoryTests;
import com.thinkaurelius.titan.testutil.JUnitBenchmarkProvider;
import com.thinkaurelius.titan.testutil.MemoryAssess;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.math.stat.descriptive.SummaryStatistics;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestRule;

@Category(value={MemoryTests.class})
public abstract class TitanGraphPerformanceMemoryTest
extends TitanGraphBaseTest {
    @Rule
    public TestRule benchmark = JUnitBenchmarkProvider.get();

    @Test
    public void testMemoryLeakage() {
        long memoryBaseline = 0L;
        SummaryStatistics stats = new SummaryStatistics();
        int numRuns = 25;
        for (int r = 0; r < numRuns; ++r) {
            if (r == 1 || r == numRuns - 1) {
                memoryBaseline = MemoryAssess.getMemoryUse();
                stats.addValue((double)memoryBaseline);
            }
            for (int t = 0; t < 1000; ++t) {
                this.graph.addVertex(null);
                this.graph.rollback();
                TitanTransaction tx = this.graph.newTransaction();
                tx.addVertex();
                tx.rollback();
            }
            if (r == 1 || r == numRuns - 1) {
                memoryBaseline = MemoryAssess.getMemoryUse();
                stats.addValue((double)memoryBaseline);
            }
            this.clopen(new Object[0]);
        }
        System.out.println("Average: " + stats.getMean() + " Std. Dev: " + stats.getStandardDeviation());
        Assert.assertTrue((stats.getStandardDeviation() < stats.getMin() ? 1 : 0) != 0);
    }

    @Test
    public void testTransactionalMemory() throws Exception {
        int t;
        int t2;
        this.makeVertexIndexedUniqueKey("uid", Long.class);
        this.makeKey("name", String.class);
        PropertyKey time = this.makeKey("time", Integer.class);
        this.mgmt.makeEdgeLabel("friend").signature(new RelationType[]{time}).directed().make();
        this.finishSchema();
        final Random random = new Random();
        int rounds = 100;
        int commitSize = 1500;
        final AtomicInteger uidCounter = new AtomicInteger(0);
        Thread[] writeThreads = new Thread[4];
        long start = System.currentTimeMillis();
        for (t2 = 0; t2 < writeThreads.length; ++t2) {
            writeThreads[t2] = new Thread(new Runnable(){

                @Override
                public void run() {
                    for (int r = 0; r < 100; ++r) {
                        TitanTransaction tx = TitanGraphPerformanceMemoryTest.this.graph.newTransaction();
                        TitanVertex previous = null;
                        for (int c = 0; c < 1500; ++c) {
                            TitanVertex v = tx.addVertex();
                            long uid = uidCounter.incrementAndGet();
                            v.setProperty("uid", (Object)uid);
                            v.setProperty("name", (Object)("user" + uid));
                            if (previous != null) {
                                v.addEdge("friend", previous).setProperty("time", (Object)Math.abs(random.nextInt()));
                            }
                            previous = v;
                        }
                        tx.commit();
                    }
                }
            });
            writeThreads[t2].start();
        }
        for (t2 = 0; t2 < writeThreads.length; ++t2) {
            writeThreads[t2].join();
        }
        System.out.println("Write time for " + 150000 * writeThreads.length + " vertices & edges: " + (System.currentTimeMillis() - start));
        final int maxUID = uidCounter.get();
        int trials = 1000;
        String fixedName = "john";
        Thread[] readThreads = new Thread[Runtime.getRuntime().availableProcessors() * 2];
        start = System.currentTimeMillis();
        for (t = 0; t < readThreads.length; ++t) {
            readThreads[t] = new Thread(new Runnable(){

                @Override
                public void run() {
                    TitanTransaction tx = TitanGraphPerformanceMemoryTest.this.graph.newTransaction();
                    long ruid = random.nextInt(maxUID) + 1;
                    TitanGraphBaseTest.getVertex(tx, "uid", (Object)ruid).setProperty("name", (Object)"john");
                    for (int t = 1; t <= 1000; ++t) {
                        TitanVertex v = TitanGraphBaseTest.getVertex(tx, "uid", (Object)(random.nextInt(maxUID) + 1));
                        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)v.getProperties()));
                        int count = 0;
                        for (TitanEdge e : v.getEdges()) {
                            ++count;
                            Assert.assertTrue((((Number)e.getProperty("time")).longValue() >= 0L ? 1 : 0) != 0);
                        }
                        Assert.assertTrue((count <= 2 ? 1 : 0) != 0);
                    }
                    Assert.assertEquals((Object)"john", (Object)TitanGraphBaseTest.getVertex(tx, "uid", (Object)ruid).getProperty("name"));
                    tx.commit();
                }
            });
            readThreads[t].start();
        }
        for (t = 0; t < readThreads.length; ++t) {
            readThreads[t].join();
        }
        System.out.println("Read time for " + 1000 * readThreads.length + " vertex lookups: " + (System.currentTimeMillis() - start));
    }
}

