/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import com.thinkaurelius.titan.core.Cardinality;
import com.thinkaurelius.titan.core.EdgeLabel;
import com.thinkaurelius.titan.core.Multiplicity;
import com.thinkaurelius.titan.core.Order;
import com.thinkaurelius.titan.core.PropertyKey;
import com.thinkaurelius.titan.core.QueryDescription;
import com.thinkaurelius.titan.core.RelationType;
import com.thinkaurelius.titan.core.SchemaViolationException;
import com.thinkaurelius.titan.core.TitanConfigurationException;
import com.thinkaurelius.titan.core.TitanEdge;
import com.thinkaurelius.titan.core.TitanElement;
import com.thinkaurelius.titan.core.TitanException;
import com.thinkaurelius.titan.core.TitanFactory;
import com.thinkaurelius.titan.core.TitanGraph;
import com.thinkaurelius.titan.core.TitanGraphQuery;
import com.thinkaurelius.titan.core.TitanProperty;
import com.thinkaurelius.titan.core.TitanTransaction;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.core.TitanVertexQuery;
import com.thinkaurelius.titan.core.VertexLabel;
import com.thinkaurelius.titan.core.VertexList;
import com.thinkaurelius.titan.core.attribute.Cmp;
import com.thinkaurelius.titan.core.attribute.Contain;
import com.thinkaurelius.titan.core.attribute.Decimal;
import com.thinkaurelius.titan.core.attribute.Duration;
import com.thinkaurelius.titan.core.attribute.Geoshape;
import com.thinkaurelius.titan.core.attribute.Precision;
import com.thinkaurelius.titan.core.log.Change;
import com.thinkaurelius.titan.core.log.ChangeProcessor;
import com.thinkaurelius.titan.core.log.ChangeState;
import com.thinkaurelius.titan.core.log.LogProcessorFramework;
import com.thinkaurelius.titan.core.log.TransactionId;
import com.thinkaurelius.titan.core.log.TransactionRecovery;
import com.thinkaurelius.titan.core.schema.ConsistencyModifier;
import com.thinkaurelius.titan.core.schema.Mapping;
import com.thinkaurelius.titan.core.schema.Parameter;
import com.thinkaurelius.titan.core.schema.RelationTypeIndex;
import com.thinkaurelius.titan.core.schema.SchemaAction;
import com.thinkaurelius.titan.core.schema.SchemaStatus;
import com.thinkaurelius.titan.core.schema.TitanGraphIndex;
import com.thinkaurelius.titan.core.schema.TitanIndex;
import com.thinkaurelius.titan.core.schema.TitanManagement;
import com.thinkaurelius.titan.core.schema.TitanSchemaElement;
import com.thinkaurelius.titan.core.schema.TitanSchemaType;
import com.thinkaurelius.titan.core.util.TitanCleanup;
import com.thinkaurelius.titan.diskstorage.BackendException;
import com.thinkaurelius.titan.diskstorage.StaticBuffer;
import com.thinkaurelius.titan.diskstorage.configuration.ConfigElement;
import com.thinkaurelius.titan.diskstorage.configuration.ConfigOption;
import com.thinkaurelius.titan.diskstorage.configuration.ReadConfiguration;
import com.thinkaurelius.titan.diskstorage.configuration.WriteConfiguration;
import com.thinkaurelius.titan.diskstorage.log.Log;
import com.thinkaurelius.titan.diskstorage.log.Message;
import com.thinkaurelius.titan.diskstorage.log.MessageReader;
import com.thinkaurelius.titan.diskstorage.log.ReadMarker;
import com.thinkaurelius.titan.diskstorage.log.kcvs.KCVSLog;
import com.thinkaurelius.titan.diskstorage.util.time.StandardDuration;
import com.thinkaurelius.titan.diskstorage.util.time.Timepoint;
import com.thinkaurelius.titan.diskstorage.util.time.TimestampProvider;
import com.thinkaurelius.titan.graphdb.TestMockLog;
import com.thinkaurelius.titan.graphdb.TitanGraphBaseTest;
import com.thinkaurelius.titan.graphdb.configuration.GraphDatabaseConfiguration;
import com.thinkaurelius.titan.graphdb.database.EdgeSerializer;
import com.thinkaurelius.titan.graphdb.database.StandardTitanGraph;
import com.thinkaurelius.titan.graphdb.database.log.LogTxMeta;
import com.thinkaurelius.titan.graphdb.database.log.LogTxStatus;
import com.thinkaurelius.titan.graphdb.database.log.TransactionLogHeader;
import com.thinkaurelius.titan.graphdb.database.management.ManagementSystem;
import com.thinkaurelius.titan.graphdb.database.serialize.Serializer;
import com.thinkaurelius.titan.graphdb.internal.ElementCategory;
import com.thinkaurelius.titan.graphdb.internal.InternalRelationType;
import com.thinkaurelius.titan.graphdb.internal.OrderList;
import com.thinkaurelius.titan.graphdb.internal.RelationCategory;
import com.thinkaurelius.titan.graphdb.log.StandardTransactionLogProcessor;
import com.thinkaurelius.titan.graphdb.query.StandardQueryDescription;
import com.thinkaurelius.titan.graphdb.query.TitanPredicate;
import com.thinkaurelius.titan.graphdb.query.vertex.BasicVertexCentricQueryBuilder;
import com.thinkaurelius.titan.graphdb.relations.RelationIdentifier;
import com.thinkaurelius.titan.graphdb.schema.EdgeLabelDefinition;
import com.thinkaurelius.titan.graphdb.schema.PropertyKeyDefinition;
import com.thinkaurelius.titan.graphdb.schema.SchemaContainer;
import com.thinkaurelius.titan.graphdb.schema.VertexLabelDefinition;
import com.thinkaurelius.titan.graphdb.serializer.SpecialInt;
import com.thinkaurelius.titan.graphdb.serializer.SpecialIntSerializer;
import com.thinkaurelius.titan.graphdb.transaction.StandardTitanTx;
import com.thinkaurelius.titan.graphdb.types.StandardEdgeLabelMaker;
import com.thinkaurelius.titan.graphdb.types.StandardPropertyKeyMaker;
import com.thinkaurelius.titan.graphdb.types.system.BaseVertexLabel;
import com.thinkaurelius.titan.graphdb.types.system.ImplicitKey;
import com.thinkaurelius.titan.testcategory.BrittleTests;
import com.thinkaurelius.titan.testutil.TestGraphConfigs;
import com.thinkaurelius.titan.testutil.TestUtil;
import com.tinkerpop.blueprints.Compare;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Predicate;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.util.ElementHelper;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TitanGraphTest
extends TitanGraphBaseTest {
    private Logger log = LoggerFactory.getLogger(TitanGraphTest.class);

    protected abstract boolean isLockingOptimistic();

    @Test
    public void testOpenClose() {
    }

    @Test
    public void testBasic() {
        PropertyKey uid = this.makeVertexIndexedUniqueKey("name", String.class);
        this.finishSchema();
        TitanVertex n1 = this.tx.addVertex();
        uid = this.tx.getPropertyKey("name");
        n1.addProperty(uid.getName(), (Object)"abcd");
        this.clopen(new Object[0]);
        long nid = n1.getLongId();
        uid = this.tx.getPropertyKey("name");
        Assert.assertTrue((boolean)this.tx.containsVertex(nid));
        Assert.assertTrue((boolean)this.tx.containsVertex(uid.getLongId()));
        Assert.assertFalse((boolean)this.tx.containsVertex(nid + 64L));
        uid = this.tx.getPropertyKey(uid.getName());
        n1 = this.tx.getVertex(nid);
        Assert.assertEquals((Object)n1, (Object)Iterables.getOnlyElement((Iterable)this.tx.getVertices(uid, (Object)"abcd")));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)n1.query().relations()));
        Assert.assertTrue((boolean)n1.getProperty(uid).equals("abcd"));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)this.tx.getVertices()));
        this.close();
        TitanCleanup.clear((TitanGraph)this.graph);
        this.open(this.config);
        Assert.assertTrue((boolean)Iterables.isEmpty((Iterable)this.tx.getVertices()));
    }

    @Test
    public void testVertexRemoval() {
        String namen = "name";
        PropertyKey name = this.makeVertexIndexedUniqueKey(namen, String.class);
        this.finishSchema();
        TitanVertex v1 = this.graph.addVertex(null);
        v1.setProperty(namen, (Object)"v1");
        TitanVertex v2 = this.graph.addVertex(null);
        v2.setProperty(namen, (Object)"v2");
        TitanEdge e = this.graph.addEdge(null, (Vertex)v1, (Vertex)v2, "knows");
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)this.graph.getVertices()));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)this.graph.query().has(namen, (Object)"v2").vertices()));
        this.clopen(new Object[0]);
        v1 = this.graph.getVertex((Object)v1);
        v2 = this.graph.getVertex((Object)v2);
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)v1.getEdges(Direction.BOTH, new String[0])));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)v2.getEdges(Direction.BOTH, new String[0])));
        v2.remove();
        Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)v1.getEdges(Direction.BOTH, new String[0])));
        try {
            Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)v2.getEdges(Direction.BOTH, new String[0])));
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)this.graph.getVertices()));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)this.graph.query().has(namen, (Object)"v1").vertices()));
        Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)this.graph.query().has(namen, (Object)"v2").vertices()));
        this.graph.commit();
        Assert.assertNull((Object)this.graph.getVertex((Object)v2));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)this.graph.getVertices()));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)this.graph.query().has(namen, (Object)"v1").vertices()));
        Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)this.graph.query().has(namen, (Object)"v2").vertices()));
    }

    @Test
    public void testGlobalIteration() {
        int numV = 50;
        int deleteV = 5;
        if (this.graph.getFeatures().supportsVertexIteration.booleanValue()) {
            int i;
            TitanVertex previous = this.tx.addVertex();
            previous.setProperty("count", (Object)0);
            for (int i2 = 1; i2 < numV; ++i2) {
                TitanVertex next = this.tx.addVertex();
                next.setProperty("count", (Object)i2);
                previous.addEdge("next", next);
                previous = next;
            }
            int numE = numV - 1;
            Iterable vertices = this.tx.getVertices();
            Assert.assertEquals((long)numV, (long)Iterables.size((Iterable)vertices));
            Assert.assertEquals((long)numV, (long)Iterables.size((Iterable)vertices));
            Assert.assertEquals((long)numV, (long)Iterables.size((Iterable)this.tx.getVertices()));
            Iterable edges = this.tx.getEdges();
            Assert.assertEquals((long)numE, (long)Iterables.size((Iterable)edges));
            Assert.assertEquals((long)numE, (long)Iterables.size((Iterable)edges));
            Assert.assertEquals((long)numE, (long)Iterables.size((Iterable)this.tx.getEdges()));
            this.clopen(new Object[0]);
            vertices = this.tx.getVertices();
            Assert.assertEquals((long)numV, (long)Iterables.size((Iterable)vertices));
            Assert.assertEquals((long)numV, (long)Iterables.size((Iterable)vertices));
            Assert.assertEquals((long)numV, (long)Iterables.size((Iterable)this.tx.getVertices()));
            edges = this.tx.getEdges();
            Assert.assertEquals((long)numE, (long)Iterables.size((Iterable)edges));
            Assert.assertEquals((long)numE, (long)Iterables.size((Iterable)edges));
            Assert.assertEquals((long)numE, (long)Iterables.size((Iterable)this.tx.getEdges()));
            Iterator viter = this.tx.getVertices().iterator();
            for (i = 0; i < deleteV; ++i) {
                Vertex v = (Vertex)viter.next();
                this.tx.removeVertex(v);
            }
            Assert.assertEquals((long)(numV - deleteV), (long)Iterables.size((Iterable)this.tx.getVertices()));
            for (i = 0; i < 10; ++i) {
                Assert.assertEquals((long)(numV - deleteV), (long)Iterables.size((Iterable)this.tx.getVertices()));
                for (Vertex v : this.tx.getVertices()) {
                    Assert.assertTrue(((Integer)v.getProperty("count") >= 0 ? 1 : 0) != 0);
                }
            }
            this.clopen(new Object[0]);
            Assert.assertEquals((long)(numV - deleteV), (long)Iterables.size((Iterable)this.graph.getVertices()));
            for (i = 0; i < 10; ++i) {
                Assert.assertEquals((long)(numV - deleteV), (long)Iterables.size((Iterable)this.tx.getVertices()));
                for (Vertex v : this.tx.getVertices()) {
                    Assert.assertTrue(((Integer)v.getProperty("count") >= 0 ? 1 : 0) != 0);
                }
            }
        }
    }

    @Test
    public void testCreateAndRetrieveComprehensive() {
        this.makeLabel("connect");
        this.makeVertexIndexedUniqueKey("name", String.class);
        PropertyKey weight = this.makeKey("weight", Double.class);
        PropertyKey id = this.makeVertexIndexedUniqueKey("uid", Integer.class);
        ((StandardEdgeLabelMaker)this.mgmt.makeEdgeLabel("knows")).sortKey(new RelationType[]{id}).signature(new RelationType[]{weight}).make();
        this.finishSchema();
        PropertyKey name = this.tx.getPropertyKey("name");
        Assert.assertNotNull((Object)name);
        EdgeLabel connect = this.tx.getEdgeLabel("connect");
        Assert.assertNotNull((Object)connect);
        EdgeLabel knows = this.tx.getEdgeLabel("knows");
        Assert.assertNotNull((Object)knows);
        Assert.assertTrue((boolean)knows.isEdgeLabel());
        TitanVertex n1 = this.tx.addVertex();
        TitanVertex n2 = this.tx.addVertex();
        TitanVertex n3 = this.tx.addVertex();
        Assert.assertNotNull((Object)n1.toString());
        n1.addProperty(name, (Object)"Node1");
        n2.addProperty(name, (Object)"Node2");
        n3.addProperty("weight", (Object)5.0);
        TitanEdge e = n1.addEdge(connect, n2);
        Assert.assertNotNull((Object)e.toString());
        Assert.assertEquals((Object)n1, (Object)e.getVertex(Direction.OUT));
        Assert.assertEquals((Object)n2, (Object)e.getVertex(Direction.IN));
        e = n2.addEdge(knows, n3);
        e.setProperty("weight", (Object)3.0);
        e.setProperty(name, (Object)"HasProperties TitanRelation");
        e = n3.addEdge(knows, n1);
        n3.addEdge(connect, n3);
        e.setProperty("uid", (Object)111);
        Assert.assertEquals((long)4L, (long)Iterables.size((Iterable)n3.getEdges()));
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)n3.getEdges(Direction.OUT, new String[0])));
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)n3.getEdges(Direction.IN, new String[0])));
        this.clopen(new Object[0]);
        connect = this.tx.getEdgeLabel("connect");
        Assert.assertEquals((Object)connect.getName(), (Object)"connect");
        Assert.assertTrue((boolean)connect.isDirected());
        name = this.tx.getPropertyKey("name");
        weight = this.tx.getPropertyKey("weight");
        id = this.tx.getPropertyKey("uid");
        knows = this.tx.getEdgeLabel("knows");
        this.log.debug("Loaded edge types");
        n2 = this.getVertex(name, (Object)"Node2");
        Assert.assertNotNull((Object)n2.toString());
        Assert.assertEquals((Object)"Node2", (Object)n2.getProperty(name));
        e = (TitanEdge)Iterables.getOnlyElement((Iterable)n2.getTitanEdges(Direction.BOTH, new EdgeLabel[]{connect}));
        Assert.assertNotNull((Object)e.toString());
        n1 = e.getVertex(Direction.OUT);
        this.log.debug("Retrieved node!");
        Assert.assertEquals((Object)n1, (Object)e.getVertex(Direction.OUT));
        Assert.assertEquals((Object)n2, (Object)e.getVertex(Direction.IN));
        this.log.debug("First:");
        Assert.assertEquals((Object)e, (Object)Iterables.getOnlyElement((Iterable)n2.getEdges(Direction.IN, new String[0])));
        this.log.debug("Second:");
        Assert.assertEquals((Object)e, (Object)Iterables.getOnlyElement((Iterable)n1.getEdges(Direction.OUT, new String[0])));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)n2.getTitanEdges(Direction.BOTH, new EdgeLabel[]{this.tx.getEdgeLabel("knows")})));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)n1.getTitanEdges(Direction.BOTH, new EdgeLabel[]{this.tx.getEdgeLabel("knows")})));
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)n1.getEdges()));
        this.log.debug("Third:");
        Assert.assertEquals((Object)e, (Object)Iterables.getOnlyElement((Iterable)n2.getEdges(Direction.IN, new String[]{"connect"})));
        this.log.debug("Four:");
        Assert.assertEquals((Object)e, (Object)Iterables.getOnlyElement((Iterable)n1.getTitanEdges(Direction.OUT, new EdgeLabel[]{connect})));
        this.log.debug("Fith:");
        Assert.assertEquals((Object)e, (Object)Iterables.getOnlyElement((Iterable)n2.getEdges(Direction.BOTH, new String[]{"connect"})));
        this.log.debug("Sixth:");
        Assert.assertEquals((Object)e, (Object)Iterables.getOnlyElement((Iterable)n1.getTitanEdges(Direction.BOTH, new EdgeLabel[]{connect})));
        e = (TitanEdge)Iterables.getOnlyElement((Iterable)n2.getTitanEdges(Direction.OUT, new EdgeLabel[]{this.tx.getEdgeLabel("knows")}));
        Assert.assertTrue((boolean)e.getProperty(weight).equals(3.0));
        Assert.assertEquals((Object)"HasProperties TitanRelation", (Object)e.getProperty(name));
        n3 = e.getVertex(Direction.IN);
        e = (TitanEdge)Iterables.getOnlyElement((Iterable)n3.getTitanEdges(Direction.OUT, new EdgeLabel[]{this.tx.getEdgeLabel("knows")}));
        Assert.assertEquals((Object)111, (Object)e.getProperty(id));
        Assert.assertEquals((long)4L, (long)Iterables.size((Iterable)n3.getEdges()));
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)n3.getEdges(Direction.OUT, new String[0])));
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)n3.getEdges(Direction.IN, new String[0])));
        e = (TitanEdge)Iterables.getOnlyElement((Iterable)n2.getTitanEdges(Direction.OUT, new EdgeLabel[]{this.tx.getEdgeLabel("knows")}));
        e.remove();
        Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)n2.getTitanEdges(Direction.BOTH, new EdgeLabel[]{this.tx.getEdgeLabel("knows")})));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)n3.getTitanEdges(Direction.BOTH, new EdgeLabel[]{this.tx.getEdgeLabel("knows")})));
        e = n2.addEdge(knows, n1);
        e.setProperty(weight, (Object)111.5);
        e.setProperty(name, (Object)"New TitanRelation");
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)n2.getEdges(Direction.BOTH, new String[]{"knows"})));
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)n1.getEdges(Direction.BOTH, new String[]{"knows"})));
        this.clopen(new Object[0]);
        n2 = this.getVertex("name", (Object)"Node2");
        e = (TitanEdge)Iterables.getOnlyElement((Iterable)n2.getTitanEdges(Direction.OUT, new EdgeLabel[]{this.tx.getEdgeLabel("knows")}));
        Assert.assertEquals((Object)"New TitanRelation", (Object)e.getProperty(this.tx.getPropertyKey("name")));
        Assert.assertTrue((boolean)e.getProperty("weight").equals(111.5));
    }

    @Test
    public void testCreateAndRetrieveMedium() {
        TitanEdge r;
        Object r22;
        this.makeLabel("connect");
        this.makeVertexIndexedUniqueKey("name", String.class);
        PropertyKey weight = this.makeKey("weight", Double.class);
        PropertyKey id = this.makeVertexIndexedUniqueKey("uid", Integer.class);
        ((StandardEdgeLabelMaker)this.mgmt.makeEdgeLabel("knows")).sortKey(new RelationType[]{id}).signature(new RelationType[]{weight}).make();
        this.finishSchema();
        id = this.tx.getPropertyKey("uid");
        int noNodes = 500;
        String[] names = new String[noNodes];
        int[] ids = new int[noNodes];
        TitanVertex[] nodes = new TitanVertex[noNodes];
        long[] nodeIds = new long[noNodes];
        List[] nodeEdges = new List[noNodes];
        for (int i = 0; i < noNodes; ++i) {
            names[i] = "vertex" + i;
            ids[i] = i;
            nodes[i] = this.tx.addVertex();
            nodes[i].addProperty("name", (Object)names[i]);
            nodes[i].addProperty("uid", (Object)ids[i]);
            if ((i + 1) % 100 != 0) continue;
            this.log.debug("Added 100 nodes");
        }
        this.log.debug("Nodes created");
        int[] connectOff = new int[]{-100, -34, -4, 10, 20};
        int[] knowsOff = new int[]{-400, -18, 8, 232, 334};
        for (int i = 0; i < noNodes; ++i) {
            TitanVertex n = nodes[i];
            nodeEdges[i] = new ArrayList(10);
            for (int c : connectOff) {
                r22 = n.addEdge("connect", nodes[TitanGraphTest.wrapAround(i + c, noNodes)]);
                nodeEdges[i].add(r22);
            }
            for (int k : knowsOff) {
                TitanVertex n2 = nodes[TitanGraphTest.wrapAround(i + k, noNodes)];
                r = n.addEdge("knows", n2);
                r.setProperty(id, (Object)(((Number)n.getProperty(id)).intValue() + ((Number)n2.getProperty(id)).intValue()));
                r.setProperty("weight", (Object)((double)k * 1.5));
                r.setProperty("name", (Object)(i + "-" + k));
                nodeEdges[i].add(r);
            }
            if (i % 100 != 99) continue;
            this.log.debug(".");
        }
        this.tx.commit();
        this.tx = null;
        Set[] nodeEdgeIds = new Set[noNodes];
        for (int i = 0; i < noNodes; ++i) {
            nodeIds[i] = nodes[i].getLongId();
            nodeEdgeIds[i] = new HashSet(10);
            Object object = nodeEdges[i].iterator();
            while (object.hasNext()) {
                Object r3 = object.next();
                nodeEdgeIds[i].add(((TitanEdge)r3).getLongId());
            }
        }
        this.clopen(new Object[0]);
        nodes = new TitanVertex[noNodes];
        PropertyKey name = this.tx.getPropertyKey("name");
        weight = this.tx.getPropertyKey("weight");
        Assert.assertEquals((Object)"name", (Object)name.getName());
        id = this.tx.getPropertyKey("uid");
        Assert.assertTrue((id.getCardinality() == Cardinality.SINGLE ? 1 : 0) != 0);
        for (int i = 0; i < noNodes; ++i) {
            TitanVertex n = this.getVertex(id, (Object)ids[i]);
            Assert.assertEquals((Object)n, (Object)this.getVertex(name, (Object)names[i]));
            Assert.assertEquals((Object)names[i], (Object)n.getProperty(name));
            nodes[i] = n;
            Assert.assertEquals((long)nodeIds[i], (long)n.getLongId());
        }
        EdgeLabel knows = this.tx.getEdgeLabel("knows");
        for (int i = 0; i < noNodes; ++i) {
            TitanVertex n = nodes[i];
            Assert.assertEquals((long)(connectOff.length + knowsOff.length), (long)Iterables.size((Iterable)n.getEdges(Direction.OUT, new String[0])));
            Assert.assertEquals((long)connectOff.length, (long)Iterables.size((Iterable)n.getEdges(Direction.OUT, new String[]{"connect"})));
            Assert.assertEquals((long)(connectOff.length * 2), (long)Iterables.size((Iterable)n.getTitanEdges(Direction.BOTH, new EdgeLabel[]{this.tx.getEdgeLabel("connect")})));
            Assert.assertEquals((float)(knowsOff.length * 2), (float)Iterables.size((Iterable)n.getTitanEdges(Direction.BOTH, new EdgeLabel[]{knows})), (float)i);
            Assert.assertEquals((long)(connectOff.length + knowsOff.length + 2), (long)Iterables.size((Iterable)n.query().direction(Direction.OUT).relations()));
            for (Object r22 : n.getTitanEdges(Direction.OUT, new EdgeLabel[]{knows})) {
                TitanVertex n2 = r22.getOtherVertex(n);
                int idsum = ((Number)n.getProperty(id)).intValue() + ((Number)n2.getProperty(id)).intValue();
                Assert.assertEquals((Object)idsum, (Object)r22.getProperty(id));
                double k = ((Number)r22.getProperty(weight)).doubleValue() / 1.5;
                int ki = (int)k;
                Assert.assertEquals((Object)(i + "-" + ki), (Object)r22.getProperty(name));
            }
            HashSet<Long> edgeIds = new HashSet<Long>(10);
            r22 = n.getTitanEdges(Direction.OUT, new EdgeLabel[0]).iterator();
            while (r22.hasNext()) {
                r = (TitanEdge)r22.next();
                edgeIds.add(r.getLongId());
            }
            Assert.assertTrue((boolean)edgeIds.equals(nodeEdgeIds[i]));
        }
        this.newTx();
        long[] vids1 = new long[noNodes / 10];
        for (int i = 0; i < vids1.length; ++i) {
            vids1[i] = nodeIds[i];
        }
        Map vs1 = this.tx.getVertices(vids1);
        this.verifyVerticesRetrieval(vids1, vs1);
        Map vs12 = this.tx.getVertices(vids1);
        this.verifyVerticesRetrieval(vids1, vs12);
        long[] vids2 = new long[noNodes / 10 * 2];
        for (int i = 0; i < vids2.length; ++i) {
            vids2[i] = nodeIds[i];
        }
        Map vs2 = this.tx.getVertices(vids2);
        this.verifyVerticesRetrieval(vids2, vs2);
    }

    private void verifyVerticesRetrieval(long[] vids, Map<Long, TitanVertex> vs) {
        for (int i = 0; i < vids.length; ++i) {
            Assert.assertTrue((boolean)vs.containsKey(vids[i]));
            Assert.assertEquals((long)vids[i], (long)vs.get(vids[i]).getLongId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSchemaTypes() {
        String nstr;
        PropertyKey weight = this.makeKey("weight", Decimal.class);
        PropertyKey id = this.makeVertexIndexedUniqueKey("uid", String.class);
        PropertyKey someid = this.makeVertexIndexedKey("someid", Object.class);
        PropertyKey name = this.mgmt.makePropertyKey("name").dataType(String.class).cardinality(Cardinality.SET).make();
        PropertyKey value = this.mgmt.makePropertyKey("value").dataType(Precision.class).signature(new RelationType[]{weight}).cardinality(Cardinality.LIST).make();
        EdgeLabel friend = this.mgmt.makeEdgeLabel("friend").make();
        EdgeLabel link = this.mgmt.makeEdgeLabel("link").unidirected().multiplicity(Multiplicity.MANY2ONE).make();
        EdgeLabel connect = this.mgmt.makeEdgeLabel("connect").signature(new RelationType[]{id, link}).multiplicity(Multiplicity.SIMPLE).make();
        EdgeLabel parent = this.mgmt.makeEdgeLabel("parent").multiplicity(Multiplicity.MANY2ONE).make();
        EdgeLabel child = this.mgmt.makeEdgeLabel("child").multiplicity(Multiplicity.ONE2MANY).make();
        EdgeLabel spouse = this.mgmt.makeEdgeLabel("spouse").multiplicity(Multiplicity.ONE2ONE).make();
        VertexLabel person = this.mgmt.makeVertexLabel("person").make();
        VertexLabel tag = this.mgmt.makeVertexLabel("tag").make();
        VertexLabel tweet = this.mgmt.makeVertexLabel("tweet").setStatic().make();
        Assert.assertTrue((boolean)this.mgmt.isOpen());
        Assert.assertEquals((Object)"weight", (Object)weight.toString());
        Assert.assertTrue((boolean)this.mgmt.containsRelationType("weight"));
        Assert.assertTrue((boolean)this.mgmt.containsPropertyKey("weight"));
        Assert.assertFalse((boolean)this.mgmt.containsEdgeLabel("weight"));
        Assert.assertTrue((boolean)this.mgmt.containsEdgeLabel("connect"));
        Assert.assertFalse((boolean)this.mgmt.containsPropertyKey("connect"));
        Assert.assertFalse((boolean)this.mgmt.containsRelationType("bla"));
        Assert.assertNull((Object)this.mgmt.getPropertyKey("bla"));
        Assert.assertNull((Object)this.mgmt.getEdgeLabel("bla"));
        Assert.assertNotNull((Object)this.mgmt.getPropertyKey("weight"));
        Assert.assertNotNull((Object)this.mgmt.getEdgeLabel("connect"));
        Assert.assertTrue((boolean)weight.isPropertyKey());
        Assert.assertFalse((boolean)weight.isEdgeLabel());
        Assert.assertEquals((Object)Cardinality.SINGLE, (Object)weight.getCardinality());
        Assert.assertEquals((Object)Cardinality.SINGLE, (Object)someid.getCardinality());
        Assert.assertEquals((Object)Cardinality.SET, (Object)name.getCardinality());
        Assert.assertEquals((Object)Cardinality.LIST, (Object)value.getCardinality());
        Assert.assertEquals(Object.class, (Object)someid.getDataType());
        Assert.assertEquals(Decimal.class, (Object)weight.getDataType());
        long[] sig = ((InternalRelationType)value).getSignature();
        Assert.assertEquals((long)1L, (long)sig.length);
        Assert.assertEquals((long)weight.getLongId(), (long)sig[0]);
        Assert.assertTrue((boolean)this.mgmt.getGraphIndex(id.getName()).isUnique());
        Assert.assertFalse((boolean)this.mgmt.getGraphIndex(someid.getName()).isUnique());
        Assert.assertEquals((Object)"friend", (Object)friend.getName());
        Assert.assertTrue((boolean)friend.isEdgeLabel());
        Assert.assertFalse((boolean)friend.isPropertyKey());
        Assert.assertEquals((Object)Multiplicity.ONE2ONE, (Object)spouse.getMultiplicity());
        Assert.assertEquals((Object)Multiplicity.ONE2MANY, (Object)child.getMultiplicity());
        Assert.assertEquals((Object)Multiplicity.MANY2ONE, (Object)parent.getMultiplicity());
        Assert.assertEquals((Object)Multiplicity.MULTI, (Object)friend.getMultiplicity());
        Assert.assertEquals((Object)Multiplicity.SIMPLE, (Object)connect.getMultiplicity());
        Assert.assertTrue((boolean)link.isUnidirected());
        Assert.assertFalse((boolean)link.isDirected());
        Assert.assertFalse((boolean)child.isUnidirected());
        Assert.assertTrue((boolean)spouse.isDirected());
        Assert.assertFalse((boolean)((InternalRelationType)friend).isHiddenType());
        Assert.assertTrue((boolean)((InternalRelationType)friend).isHidden());
        Assert.assertEquals((long)0L, (long)((InternalRelationType)friend).getSignature().length);
        sig = ((InternalRelationType)connect).getSignature();
        Assert.assertEquals((long)2L, (long)sig.length);
        Assert.assertEquals((long)id.getLongId(), (long)sig[0]);
        Assert.assertEquals((long)link.getLongId(), (long)sig[1]);
        Assert.assertEquals((long)0L, (long)((InternalRelationType)friend).getSortKey().length);
        Assert.assertEquals((Object)Order.DEFAULT, (Object)((InternalRelationType)friend).getSortOrder());
        Assert.assertEquals((Object)SchemaStatus.ENABLED, (Object)((InternalRelationType)friend).getStatus());
        Assert.assertEquals((long)5L, (long)Iterables.size((Iterable)this.mgmt.getRelationTypes(PropertyKey.class)));
        Assert.assertEquals((long)6L, (long)Iterables.size((Iterable)this.mgmt.getRelationTypes(EdgeLabel.class)));
        Assert.assertEquals((long)11L, (long)Iterables.size((Iterable)this.mgmt.getRelationTypes(RelationType.class)));
        Assert.assertEquals((long)3L, (long)Iterables.size((Iterable)this.mgmt.getVertexLabels()));
        Assert.assertEquals((Object)"tweet", (Object)tweet.getName());
        Assert.assertTrue((boolean)this.mgmt.containsVertexLabel("person"));
        Assert.assertFalse((boolean)this.mgmt.containsVertexLabel("bla"));
        Assert.assertFalse((boolean)person.isPartitioned());
        Assert.assertFalse((boolean)person.isStatic());
        Assert.assertFalse((boolean)tag.isPartitioned());
        Assert.assertTrue((boolean)tweet.isStatic());
        try {
            this.mgmt.makePropertyKey("fid").make();
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.mgmt.makeEdgeLabel("link").unidirected().make();
            Assert.fail();
        }
        catch (SchemaViolationException schemaViolationException) {
            // empty catch block
        }
        try {
            ((StandardEdgeLabelMaker)this.mgmt.makeEdgeLabel("other")).sortKey(new RelationType[]{someid, weight}).signature(new RelationType[]{someid}).make();
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            ((StandardEdgeLabelMaker)this.mgmt.makeEdgeLabel("other")).multiplicity(Multiplicity.SIMPLE).sortKey(new RelationType[]{weight}).make();
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            ((StandardEdgeLabelMaker)this.mgmt.makeEdgeLabel("other")).multiplicity(Multiplicity.MANY2ONE).sortKey(new RelationType[]{weight}).make();
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.mgmt.makeVertexLabel("tweet").make();
            Assert.fail();
        }
        catch (SchemaViolationException schemaViolationException) {
            // empty catch block
        }
        try {
            this.mgmt.makeEdgeLabel("test").signature(new RelationType[]{friend}).make();
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.finishSchema();
        this.clopen(new Object[0]);
        weight = this.mgmt.getPropertyKey("weight");
        id = this.mgmt.getPropertyKey("uid");
        someid = this.mgmt.getPropertyKey("someid");
        name = this.mgmt.getPropertyKey("name");
        value = this.mgmt.getPropertyKey("value");
        friend = this.mgmt.getEdgeLabel("friend");
        link = this.mgmt.getEdgeLabel("link");
        connect = this.mgmt.getEdgeLabel("connect");
        parent = this.mgmt.getEdgeLabel("parent");
        child = this.mgmt.getEdgeLabel("child");
        spouse = this.mgmt.getEdgeLabel("spouse");
        person = this.mgmt.getVertexLabel("person");
        tag = this.mgmt.getVertexLabel("tag");
        tweet = this.mgmt.getVertexLabel("tweet");
        Assert.assertTrue((boolean)this.mgmt.isOpen());
        Assert.assertEquals((Object)"weight", (Object)weight.toString());
        Assert.assertTrue((boolean)this.mgmt.containsRelationType("weight"));
        Assert.assertTrue((boolean)this.mgmt.containsPropertyKey("weight"));
        Assert.assertFalse((boolean)this.mgmt.containsEdgeLabel("weight"));
        Assert.assertTrue((boolean)this.mgmt.containsEdgeLabel("connect"));
        Assert.assertFalse((boolean)this.mgmt.containsPropertyKey("connect"));
        Assert.assertFalse((boolean)this.mgmt.containsRelationType("bla"));
        Assert.assertNull((Object)this.mgmt.getPropertyKey("bla"));
        Assert.assertNull((Object)this.mgmt.getEdgeLabel("bla"));
        Assert.assertNotNull((Object)this.mgmt.getPropertyKey("weight"));
        Assert.assertNotNull((Object)this.mgmt.getEdgeLabel("connect"));
        Assert.assertTrue((boolean)weight.isPropertyKey());
        Assert.assertFalse((boolean)weight.isEdgeLabel());
        Assert.assertEquals((Object)Cardinality.SINGLE, (Object)weight.getCardinality());
        Assert.assertEquals((Object)Cardinality.SINGLE, (Object)someid.getCardinality());
        Assert.assertEquals((Object)Cardinality.SET, (Object)name.getCardinality());
        Assert.assertEquals((Object)Cardinality.LIST, (Object)value.getCardinality());
        Assert.assertEquals(Object.class, (Object)someid.getDataType());
        Assert.assertEquals(Decimal.class, (Object)weight.getDataType());
        sig = ((InternalRelationType)value).getSignature();
        Assert.assertEquals((long)1L, (long)sig.length);
        Assert.assertEquals((long)weight.getLongId(), (long)sig[0]);
        Assert.assertTrue((boolean)this.mgmt.getGraphIndex(id.getName()).isUnique());
        Assert.assertFalse((boolean)this.mgmt.getGraphIndex(someid.getName()).isUnique());
        Assert.assertEquals((Object)"friend", (Object)friend.getName());
        Assert.assertTrue((boolean)friend.isEdgeLabel());
        Assert.assertFalse((boolean)friend.isPropertyKey());
        Assert.assertEquals((Object)Multiplicity.ONE2ONE, (Object)spouse.getMultiplicity());
        Assert.assertEquals((Object)Multiplicity.ONE2MANY, (Object)child.getMultiplicity());
        Assert.assertEquals((Object)Multiplicity.MANY2ONE, (Object)parent.getMultiplicity());
        Assert.assertEquals((Object)Multiplicity.MULTI, (Object)friend.getMultiplicity());
        Assert.assertEquals((Object)Multiplicity.SIMPLE, (Object)connect.getMultiplicity());
        Assert.assertTrue((boolean)link.isUnidirected());
        Assert.assertFalse((boolean)link.isDirected());
        Assert.assertFalse((boolean)child.isUnidirected());
        Assert.assertTrue((boolean)spouse.isDirected());
        Assert.assertFalse((boolean)((InternalRelationType)friend).isHiddenType());
        Assert.assertTrue((boolean)((InternalRelationType)friend).isHidden());
        Assert.assertEquals((long)0L, (long)((InternalRelationType)friend).getSignature().length);
        sig = ((InternalRelationType)connect).getSignature();
        Assert.assertEquals((long)2L, (long)sig.length);
        Assert.assertEquals((long)id.getLongId(), (long)sig[0]);
        Assert.assertEquals((long)link.getLongId(), (long)sig[1]);
        Assert.assertEquals((long)0L, (long)((InternalRelationType)friend).getSortKey().length);
        Assert.assertEquals((Object)Order.DEFAULT, (Object)((InternalRelationType)friend).getSortOrder());
        Assert.assertEquals((Object)SchemaStatus.ENABLED, (Object)((InternalRelationType)friend).getStatus());
        Assert.assertEquals((long)5L, (long)Iterables.size((Iterable)this.mgmt.getRelationTypes(PropertyKey.class)));
        Assert.assertEquals((long)6L, (long)Iterables.size((Iterable)this.mgmt.getRelationTypes(EdgeLabel.class)));
        Assert.assertEquals((long)11L, (long)Iterables.size((Iterable)this.mgmt.getRelationTypes(RelationType.class)));
        Assert.assertEquals((long)3L, (long)Iterables.size((Iterable)this.mgmt.getVertexLabels()));
        Assert.assertEquals((Object)"tweet", (Object)tweet.getName());
        Assert.assertTrue((boolean)this.mgmt.containsVertexLabel("person"));
        Assert.assertFalse((boolean)this.mgmt.containsVertexLabel("bla"));
        Assert.assertFalse((boolean)person.isPartitioned());
        Assert.assertFalse((boolean)person.isStatic());
        Assert.assertFalse((boolean)tag.isPartitioned());
        Assert.assertTrue((boolean)tweet.isStatic());
        try {
            this.mgmt.makePropertyKey("fid").make();
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.mgmt.makeEdgeLabel("link").unidirected().make();
            Assert.fail();
        }
        catch (SchemaViolationException schemaViolationException) {
            // empty catch block
        }
        try {
            ((StandardEdgeLabelMaker)this.mgmt.makeEdgeLabel("other")).sortKey(new RelationType[]{someid, weight}).signature(new RelationType[]{someid}).make();
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            ((StandardEdgeLabelMaker)this.mgmt.makeEdgeLabel("other")).multiplicity(Multiplicity.SIMPLE).sortKey(new RelationType[]{weight}).make();
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            ((StandardEdgeLabelMaker)this.mgmt.makeEdgeLabel("other")).multiplicity(Multiplicity.MANY2ONE).sortKey(new RelationType[]{weight}).make();
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.mgmt.makeVertexLabel("tweet").make();
            Assert.fail();
        }
        catch (SchemaViolationException schemaViolationException) {
            // empty catch block
        }
        try {
            this.mgmt.makeEdgeLabel("test").signature(new RelationType[]{friend}).make();
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.clopen(new Object[0]);
        weight = this.tx.getPropertyKey("weight");
        id = this.tx.getPropertyKey("uid");
        someid = this.tx.getPropertyKey("someid");
        name = this.tx.getPropertyKey("name");
        value = this.tx.getPropertyKey("value");
        friend = this.tx.getEdgeLabel("friend");
        link = this.tx.getEdgeLabel("link");
        connect = this.tx.getEdgeLabel("connect");
        parent = this.tx.getEdgeLabel("parent");
        child = this.tx.getEdgeLabel("child");
        spouse = this.tx.getEdgeLabel("spouse");
        person = this.tx.getVertexLabel("person");
        tag = this.tx.getVertexLabel("tag");
        tweet = this.tx.getVertexLabel("tweet");
        Assert.assertNull((Object)this.getVertex(id, (Object)"v1"));
        TitanVertex v = this.tx.addVertex();
        v.addProperty(id, (Object)"v1");
        v.addProperty(weight, (Object)1.5);
        v.setProperty(someid, (Object)"Hello");
        v.addProperty(name, (Object)"Bob");
        v.addProperty(name, (Object)"John");
        TitanProperty p = v.addProperty(value, (Object)11);
        p.setProperty(weight, (Object)22);
        p = v.addProperty(value, (Object)33.3);
        p.setProperty(weight, (Object)66.6);
        p = v.addProperty(value, (Object)11);
        p.setProperty(weight, (Object)22);
        TitanVertex v12 = this.tx.addVertexWithLabel(person);
        TitanVertex v13 = this.tx.addVertexWithLabel(person);
        v12.setProperty(id, (Object)"v12");
        v13.setProperty(id, (Object)"v13");
        v12.addEdge(parent, v).setProperty(weight, (Object)4.5);
        v13.addEdge(parent, v).setProperty(weight, (Object)4.5);
        v.addEdge(child, v12);
        v.addEdge(child, v13);
        v.addEdge(spouse, v12);
        v.addEdge(friend, v12);
        v.addEdge(friend, v12);
        TitanEdge edge = v.addEdge(connect, v12);
        edge.setProperty(id, (Object)"e1");
        edge.setProperty(link, v);
        v.addEdge(link, v13);
        TitanVertex v2 = this.tx.addVertexWithLabel(tweet);
        v2.addEdge(link, v13);
        v12.addEdge(connect, v2);
        Assert.assertEquals((Object)v, (Object)Iterables.getOnlyElement((Iterable)this.tx.query().has(id, (TitanPredicate)Cmp.EQUAL, (Object)"v1").vertices()));
        v = (TitanVertex)Iterables.getOnlyElement((Iterable)this.tx.query().has(id, (TitanPredicate)Cmp.EQUAL, (Object)"v1").vertices());
        v12 = (TitanVertex)Iterables.getOnlyElement((Iterable)this.tx.query().has(id, (TitanPredicate)Cmp.EQUAL, (Object)"v12").vertices());
        v13 = (TitanVertex)Iterables.getOnlyElement((Iterable)this.tx.query().has(id, (TitanPredicate)Cmp.EQUAL, (Object)"v13").vertices());
        try {
            v.setProperty(weight, (Object)"x");
            Assert.fail();
        }
        catch (SchemaViolationException schemaViolationException) {
            // empty catch block
        }
        try {
            v.addProperty(name, (Object)"John");
            Assert.fail();
        }
        catch (SchemaViolationException schemaViolationException) {
            // empty catch block
        }
        try {
            v.setProperty(name, (Object)"Don");
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        v.addProperty(weight, (Object)1.0);
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)v.getProperties(weight)));
        v.setProperty(weight, (Object)0.5);
        Assert.assertEquals((double)0.5, (double)((Decimal)v.getProperty(weight)).doubleValue(), (double)1.0E-5);
        Assert.assertEquals((Object)"v1", (Object)v.getProperty(id));
        Assert.assertEquals((long)2L, (long)((List)v.getProperty(name)).size());
        for (TitanProperty prop : v.getProperties(name)) {
            nstr = (String)prop.getValue();
            Assert.assertTrue((nstr.equals("Bob") || nstr.equals("John") ? 1 : 0) != 0);
        }
        Assert.assertTrue((((List)v.getProperty(value)).size() >= 3 ? 1 : 0) != 0);
        for (TitanProperty prop : v.getProperties(value)) {
            Assert.assertEquals((double)(((Number)prop.getValue()).doubleValue() * 2.0), (double)((Number)prop.getProperty(weight)).doubleValue(), (double)1.0E-5);
        }
        p = v.addProperty(value, (Object)44.4);
        p.setProperty(weight, (Object)88.8);
        Assert.assertEquals((Object)v, (Object)Iterables.getOnlyElement((Iterable)this.tx.query().has(someid, (TitanPredicate)Cmp.EQUAL, (Object)"Hello").vertices()));
        try {
            v12.addEdge(parent, v13);
            Assert.fail();
        }
        catch (SchemaViolationException schemaViolationException) {
            // empty catch block
        }
        try {
            v13.addEdge(child, v12);
            Assert.fail();
        }
        catch (SchemaViolationException schemaViolationException) {
            // empty catch block
        }
        try {
            v13.addEdge(spouse, v12);
            Assert.fail();
        }
        catch (SchemaViolationException schemaViolationException) {
            // empty catch block
        }
        try {
            v.addEdge(spouse, v13);
            Assert.fail();
        }
        catch (SchemaViolationException schemaViolationException) {
            // empty catch block
        }
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)v.query().direction(Direction.IN).types(new RelationType[]{parent}).edges()));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)v12.query().direction(Direction.OUT).types(new RelationType[]{parent}).has(weight, (Predicate)Cmp.EQUAL, (Object)4.5).edges()));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)v13.query().direction(Direction.OUT).types(new RelationType[]{parent}).has(weight, (Predicate)Cmp.EQUAL, (Object)4.5).edges()));
        Assert.assertEquals((Object)v12, (Object)Iterables.getOnlyElement((Iterable)v.getVertices(Direction.OUT, new String[]{spouse.getName()})));
        edge = (TitanEdge)Iterables.getOnlyElement((Iterable)v.query().types(new RelationType[]{connect}).direction(Direction.BOTH).edges());
        Assert.assertEquals((long)2L, (long)edge.getPropertyKeys().size());
        Assert.assertEquals((Object)"e1", (Object)edge.getProperty(id));
        Assert.assertEquals((Object)v, (Object)edge.getProperty(link));
        try {
            v.addEdge(connect, v12);
            Assert.fail();
        }
        catch (SchemaViolationException schemaViolationException) {
            // empty catch block
        }
        Assert.assertEquals((long)1L, (long)v.query().types(new RelationType[]{link}).direction(Direction.BOTH).count());
        Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)v13.query().types(new RelationType[]{link}).direction(Direction.BOTH).edges()));
        v.addEdge(friend, v12);
        v2 = (TitanVertex)Iterables.getOnlyElement((Iterable)v12.getVertices(Direction.OUT, new String[]{connect.getName()}));
        Assert.assertEquals((Object)v13, (Object)((Edge)Iterables.getOnlyElement((Iterable)v2.getEdges(Direction.OUT, new String[]{link.getName()}))).getVertex(Direction.IN));
        Assert.assertEquals((Object)BaseVertexLabel.DEFAULT_VERTEXLABEL, (Object)v.getVertexLabel());
        Assert.assertEquals((Object)person, (Object)v12.getVertexLabel());
        Assert.assertEquals((Object)person, (Object)v13.getVertexLabel());
        Assert.assertEquals((long)4L, (long)Iterables.size((Iterable)this.tx.getVertices()));
        this.clopen(new Object[0]);
        weight = this.tx.getPropertyKey("weight");
        id = this.tx.getPropertyKey("uid");
        someid = this.tx.getPropertyKey("someid");
        name = this.tx.getPropertyKey("name");
        value = this.tx.getPropertyKey("value");
        friend = this.tx.getEdgeLabel("friend");
        link = this.tx.getEdgeLabel("link");
        connect = this.tx.getEdgeLabel("connect");
        parent = this.tx.getEdgeLabel("parent");
        child = this.tx.getEdgeLabel("child");
        spouse = this.tx.getEdgeLabel("spouse");
        person = this.tx.getVertexLabel("person");
        tag = this.tx.getVertexLabel("tag");
        tweet = this.tx.getVertexLabel("tweet");
        Assert.assertEquals((Object)v, (Object)Iterables.getOnlyElement((Iterable)this.tx.query().has(id, (TitanPredicate)Cmp.EQUAL, (Object)"v1").vertices()));
        v = (TitanVertex)Iterables.getOnlyElement((Iterable)this.tx.query().has(id, (TitanPredicate)Cmp.EQUAL, (Object)"v1").vertices());
        v12 = (TitanVertex)Iterables.getOnlyElement((Iterable)this.tx.query().has(id, (TitanPredicate)Cmp.EQUAL, (Object)"v12").vertices());
        v13 = (TitanVertex)Iterables.getOnlyElement((Iterable)this.tx.query().has(id, (TitanPredicate)Cmp.EQUAL, (Object)"v13").vertices());
        try {
            v.setProperty(weight, (Object)"x");
            Assert.fail();
        }
        catch (SchemaViolationException schemaViolationException) {
            // empty catch block
        }
        try {
            v.addProperty(name, (Object)"John");
            Assert.fail();
        }
        catch (SchemaViolationException schemaViolationException) {
            // empty catch block
        }
        try {
            v.setProperty(name, (Object)"Don");
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        v.addProperty(weight, (Object)1.0);
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)v.getProperties(weight)));
        v.setProperty(weight, (Object)0.5);
        Assert.assertEquals((double)0.5, (double)((Decimal)v.getProperty(weight)).doubleValue(), (double)1.0E-5);
        Assert.assertEquals((Object)"v1", (Object)v.getProperty(id));
        Assert.assertEquals((long)2L, (long)((List)v.getProperty(name)).size());
        for (TitanProperty prop : v.getProperties(name)) {
            nstr = (String)prop.getValue();
            Assert.assertTrue((nstr.equals("Bob") || nstr.equals("John") ? 1 : 0) != 0);
        }
        Assert.assertTrue((((List)v.getProperty(value)).size() >= 3 ? 1 : 0) != 0);
        for (TitanProperty prop : v.getProperties(value)) {
            Assert.assertEquals((double)(((Number)prop.getValue()).doubleValue() * 2.0), (double)((Number)prop.getProperty(weight)).doubleValue(), (double)1.0E-5);
        }
        p = v.addProperty(value, (Object)44.4);
        p.setProperty(weight, (Object)88.8);
        Assert.assertEquals((Object)v, (Object)Iterables.getOnlyElement((Iterable)this.tx.query().has(someid, (TitanPredicate)Cmp.EQUAL, (Object)"Hello").vertices()));
        try {
            v12.addEdge(parent, v13);
            Assert.fail();
        }
        catch (SchemaViolationException schemaViolationException) {
            // empty catch block
        }
        try {
            v13.addEdge(child, v12);
            Assert.fail();
        }
        catch (SchemaViolationException schemaViolationException) {
            // empty catch block
        }
        try {
            v13.addEdge(spouse, v12);
            Assert.fail();
        }
        catch (SchemaViolationException schemaViolationException) {
            // empty catch block
        }
        try {
            v.addEdge(spouse, v13);
            Assert.fail();
        }
        catch (SchemaViolationException schemaViolationException) {
            // empty catch block
        }
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)v.query().direction(Direction.IN).types(new RelationType[]{parent}).edges()));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)v12.query().direction(Direction.OUT).types(new RelationType[]{parent}).has(weight, (Predicate)Cmp.EQUAL, (Object)4.5).edges()));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)v13.query().direction(Direction.OUT).types(new RelationType[]{parent}).has(weight, (Predicate)Cmp.EQUAL, (Object)4.5).edges()));
        Assert.assertEquals((Object)v12, (Object)Iterables.getOnlyElement((Iterable)v.getVertices(Direction.OUT, new String[]{spouse.getName()})));
        edge = (TitanEdge)Iterables.getOnlyElement((Iterable)v.query().types(new RelationType[]{connect}).direction(Direction.BOTH).edges());
        Assert.assertEquals((long)2L, (long)edge.getPropertyKeys().size());
        Assert.assertEquals((Object)"e1", (Object)edge.getProperty(id));
        Assert.assertEquals((Object)v, (Object)edge.getProperty(link));
        try {
            v.addEdge(connect, v12);
            Assert.fail();
        }
        catch (SchemaViolationException schemaViolationException) {
            // empty catch block
        }
        Assert.assertEquals((long)1L, (long)v.query().types(new RelationType[]{link}).direction(Direction.BOTH).count());
        Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)v13.query().types(new RelationType[]{link}).direction(Direction.BOTH).edges()));
        v.addEdge(friend, v12);
        v2 = (TitanVertex)Iterables.getOnlyElement((Iterable)v12.getVertices(Direction.OUT, new String[]{connect.getName()}));
        Assert.assertEquals((Object)v13, (Object)((Edge)Iterables.getOnlyElement((Iterable)v2.getEdges(Direction.OUT, new String[]{link.getName()}))).getVertex(Direction.IN));
        Assert.assertEquals((long)4L, (long)Iterables.size((Iterable)this.tx.getVertices()));
        TitanTransaction tx2 = this.graph.newTransaction();
        try {
            TitanVertex vx = tx2.addVertex();
            try {
                vx.setProperty(id, (Object)"v1");
                Assert.fail();
            }
            catch (SchemaViolationException prop) {
                // empty catch block
            }
            vx.setProperty(id, (Object)"unique");
            TitanVertex vx2 = tx2.addVertex();
            try {
                vx2.setProperty(id, (Object)"unique");
                Assert.fail();
            }
            catch (SchemaViolationException nstr2) {
                // empty catch block
            }
        }
        finally {
            tx2.rollback();
        }
        v2 = (TitanVertex)this.tx.getVertex((Object)v2);
        Assert.assertEquals((Object)tweet, (Object)v2.getVertexLabel());
        try {
            v2.setProperty(weight, (Object)11);
            Assert.fail();
        }
        catch (SchemaViolationException vx) {
            // empty catch block
        }
        try {
            v2.addEdge(friend, v12);
            Assert.fail();
        }
        catch (SchemaViolationException vx) {
            // empty catch block
        }
        this.tx.getVertex((Object)v13).remove();
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)v.query().types(new RelationType[]{link}).direction(Direction.BOTH).edges()));
        SchemaContainer schemaContainer = new SchemaContainer((TitanGraph)this.graph);
        Assert.assertTrue((boolean)schemaContainer.containsRelationType("weight"));
        Assert.assertTrue((boolean)schemaContainer.containsRelationType("friend"));
        Assert.assertTrue((boolean)schemaContainer.containsVertexLabel("person"));
        VertexLabelDefinition vld = schemaContainer.getVertexLabel("tag");
        Assert.assertFalse((boolean)vld.isPartitioned());
        Assert.assertFalse((boolean)vld.isStatic());
        PropertyKeyDefinition pkd = schemaContainer.getPropertyKey("name");
        Assert.assertEquals((Object)Cardinality.SET, (Object)pkd.getCardinality());
        Assert.assertEquals(String.class, (Object)pkd.getDataType());
        EdgeLabelDefinition eld = schemaContainer.getEdgeLabel("child");
        Assert.assertEquals((Object)"child", (Object)eld.getName());
        Assert.assertEquals((long)child.getLongId(), (long)eld.getLongId());
        Assert.assertEquals((Object)Multiplicity.ONE2MANY, (Object)eld.getMultiplicity());
        Assert.assertFalse((boolean)eld.isUnidirected());
    }

    @Test
    public void testDataTypes() throws Exception {
        HashMap map;
        Object value;
        this.clopen(TitanGraphTest.option(GraphDatabaseConfiguration.CUSTOM_ATTRIBUTE_CLASS, "attribute10"), SpecialInt.class.getCanonicalName(), TitanGraphTest.option(GraphDatabaseConfiguration.CUSTOM_SERIALIZER_CLASS, "attribute10"), SpecialIntSerializer.class.getCanonicalName());
        PropertyKey sint = this.makeKey("int", SpecialInt.class);
        PropertyKey arrayKey = this.makeKey("barr", byte[].class);
        PropertyKey boolKey = this.makeKey("boolval", Boolean.class);
        PropertyKey birthday = this.makeKey("birthday", GregorianCalendar.class);
        PropertyKey geo = this.makeKey("geo", Geoshape.class);
        PropertyKey precision = this.makeKey("precise", Precision.class);
        PropertyKey any = this.mgmt.makePropertyKey("any").cardinality(Cardinality.LIST).dataType(Object.class).make();
        try {
            this.makeKey("pint", Integer.TYPE);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.makeKey("number", Number.class);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.finishSchema();
        this.clopen(new Object[0]);
        boolKey = this.tx.getPropertyKey("boolval");
        sint = this.tx.getPropertyKey("int");
        arrayKey = this.tx.getPropertyKey("barr");
        birthday = this.tx.getPropertyKey("birthday");
        geo = this.tx.getPropertyKey("geo");
        precision = this.tx.getPropertyKey("precise");
        any = this.tx.getPropertyKey("any");
        Assert.assertEquals(Boolean.class, (Object)boolKey.getDataType());
        Assert.assertEquals(byte[].class, (Object)arrayKey.getDataType());
        Assert.assertEquals(Object.class, (Object)any.getDataType());
        Calendar c = Calendar.getInstance();
        c.setTime(new SimpleDateFormat("ddMMyyyy").parse("28101978"));
        Geoshape shape = Geoshape.box((double)10.0, (double)10.0, (double)20.0, (double)20.0);
        TitanVertex v = this.tx.addVertex();
        v.addProperty(boolKey, (Object)true);
        v.setProperty(birthday, (Object)c);
        v.setProperty(sint, (Object)new SpecialInt(10));
        v.setProperty(arrayKey, (Object)new byte[]{1, 2, 3, 4});
        v.setProperty(geo, (Object)shape);
        v.setProperty(precision, (Object)10.12345);
        v.addProperty(any, (Object)"Hello");
        v.addProperty(any, (Object)10L);
        HashMap<String, Integer> testmap = new HashMap<String, Integer>(1);
        testmap.put("test", 10);
        v.addProperty(any, testmap);
        Assert.assertTrue((boolean)((Boolean)v.getProperty(boolKey)));
        Assert.assertEquals((long)10L, (long)((SpecialInt)v.getProperty(sint)).getValue());
        Assert.assertEquals((Object)c, (Object)v.getProperty(birthday));
        Assert.assertEquals((long)4L, (long)((byte[])v.getProperty(arrayKey)).length);
        Assert.assertEquals((Object)shape, (Object)v.getProperty(geo));
        Assert.assertEquals((double)10.12345, (double)((Precision)v.getProperty(precision)).doubleValue(), (double)1.0E-6);
        Assert.assertEquals((long)3L, (long)Iterables.size((Iterable)v.getProperties(any)));
        for (TitanProperty prop : v.getProperties(any)) {
            value = prop.getValue();
            if (value instanceof String) {
                Assert.assertEquals((Object)"Hello", (Object)value);
                continue;
            }
            if (value instanceof Long) {
                Assert.assertEquals((Object)10L, (Object)value);
                continue;
            }
            if (value instanceof Map) {
                map = (HashMap)value;
                Assert.assertEquals((long)1L, (long)map.size());
                continue;
            }
            Assert.fail();
        }
        this.clopen(new Object[0]);
        v = (TitanVertex)this.tx.getVertex((Object)v);
        boolKey = this.tx.getPropertyKey("boolval");
        sint = this.tx.getPropertyKey("int");
        arrayKey = this.tx.getPropertyKey("barr");
        birthday = this.tx.getPropertyKey("birthday");
        geo = this.tx.getPropertyKey("geo");
        precision = this.tx.getPropertyKey("precise");
        any = this.tx.getPropertyKey("any");
        Assert.assertTrue((boolean)((Boolean)v.getProperty(boolKey)));
        Assert.assertEquals((long)10L, (long)((SpecialInt)v.getProperty(sint)).getValue());
        Assert.assertEquals((Object)c, (Object)v.getProperty(birthday));
        Assert.assertEquals((long)4L, (long)((byte[])v.getProperty(arrayKey)).length);
        Assert.assertEquals((Object)shape, (Object)v.getProperty(geo));
        Assert.assertEquals((double)10.12345, (double)((Precision)v.getProperty(precision)).doubleValue(), (double)1.0E-6);
        Assert.assertEquals((long)3L, (long)Iterables.size((Iterable)v.getProperties(any)));
        for (TitanProperty prop : v.getProperties(any)) {
            value = prop.getValue();
            if (value instanceof String) {
                Assert.assertEquals((Object)"Hello", (Object)value);
                continue;
            }
            if (value instanceof Long) {
                Assert.assertEquals((Object)10L, (Object)value);
                continue;
            }
            if (value instanceof Map) {
                map = (HashMap)value;
                Assert.assertEquals((long)1L, (long)map.size());
                continue;
            }
            Assert.fail();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTransactionalScopeOfSchemaTypes() {
        TitanVertex v2;
        this.makeVertexIndexedUniqueKey("domain", String.class);
        this.finishSchema();
        TitanVertex v1 = this.tx.addVertex();
        try {
            v1.setProperty("domain", (Object)"unique1");
        }
        catch (SchemaViolationException schemaViolationException) {
        }
        finally {
            this.tx.rollback();
            this.tx = null;
        }
        this.newTx();
        v1 = this.tx.addVertex();
        v1.addProperty("domain", (Object)"unique1");
        try {
            v2 = this.tx.addVertex();
            v2.addProperty("domain", (Object)"unique1");
            Assert.fail();
        }
        catch (SchemaViolationException schemaViolationException) {
        }
        finally {
            this.tx.rollback();
            this.tx = null;
        }
        this.newTx();
        this.clopen(new Object[0]);
        v1 = this.tx.addVertex();
        v1.addProperty("domain", (Object)"unique1");
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)this.tx.getVertices("domain", (Object)"unique1")));
        try {
            v2 = this.tx.addVertex();
            v2.addProperty("domain", (Object)"unique1");
            Assert.fail();
        }
        catch (SchemaViolationException schemaViolationException) {
        }
        finally {
            this.tx.rollback();
            this.tx = null;
        }
        this.newTx();
    }

    @Test
    public void testAutomaticTypeCreation() {
        Assert.assertFalse((boolean)this.tx.containsVertexLabel("person"));
        Assert.assertFalse((boolean)this.tx.containsVertexLabel("person"));
        Assert.assertFalse((boolean)this.tx.containsRelationType("value"));
        Assert.assertNull((Object)this.tx.getPropertyKey("value"));
        PropertyKey value = this.tx.getOrCreatePropertyKey("value");
        Assert.assertNotNull((Object)value);
        Assert.assertTrue((boolean)this.tx.containsRelationType("value"));
        TitanVertex v = this.tx.addVertexWithLabel("person");
        Assert.assertTrue((boolean)this.tx.containsVertexLabel("person"));
        Assert.assertEquals((Object)"person", (Object)v.getLabel());
        Assert.assertFalse((boolean)this.tx.containsRelationType("knows"));
        TitanEdge e = v.addEdge("knows", v);
        Assert.assertTrue((boolean)this.tx.containsRelationType("knows"));
        Assert.assertNotNull((Object)this.tx.getEdgeLabel(e.getLabel()));
        this.clopen(TitanGraphTest.option(GraphDatabaseConfiguration.AUTO_TYPE, new String[0]), "none");
        Assert.assertTrue((boolean)this.tx.containsRelationType("value"));
        Assert.assertTrue((boolean)this.tx.containsVertexLabel("person"));
        Assert.assertTrue((boolean)this.tx.containsRelationType("knows"));
        v = this.tx.getVertex(v.getLongId());
        try {
            this.tx.addVertexWithLabel("org");
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            v.setProperty("bla", (Object)5);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            v.addEdge("blub", v);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testSchemaNameChange() {
        PropertyKey time = this.mgmt.makePropertyKey("time").dataType(Integer.class).cardinality(Cardinality.SINGLE).make();
        EdgeLabel knows = this.mgmt.makeEdgeLabel("knows").multiplicity(Multiplicity.MULTI).make();
        this.mgmt.buildEdgeIndex(knows, "byTime", Direction.BOTH, new RelationType[]{time});
        this.mgmt.buildIndex("timeIndex", Vertex.class).addKey(time).buildCompositeIndex();
        this.mgmt.makeVertexLabel("people").make();
        this.finishSchema();
        TitanVertex v = this.tx.addVertexWithLabel("people");
        v.setProperty("time", (Object)5);
        v.addEdge("knows", v).setProperty("time", (Object)11);
        this.newTx();
        v = (TitanVertex)Iterables.getOnlyElement((Iterable)this.tx.query().has("time", (Object)5).vertices());
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)"people", (Object)v.getLabel());
        Assert.assertEquals((Object)5, (Object)v.getProperty("time"));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)v.getEdges(Direction.IN, new String[]{"knows"})));
        Assert.assertEquals((long)1L, (long)v.query().labels(new String[]{"knows"}).direction(Direction.OUT).has("time", (Object)11).count());
        this.newTx();
        Assert.assertTrue((boolean)this.mgmt.containsRelationType("knows"));
        knows = this.mgmt.getEdgeLabel("knows");
        this.mgmt.changeName((TitanSchemaElement)knows, "know");
        Assert.assertEquals((Object)"know", (Object)knows.getName());
        Assert.assertTrue((boolean)this.mgmt.containsRelationIndex((RelationType)knows, "byTime"));
        RelationTypeIndex rindex = this.mgmt.getRelationIndex((RelationType)knows, "byTime");
        Assert.assertEquals((Object)"byTime", (Object)rindex.getName());
        this.mgmt.changeName((TitanSchemaElement)rindex, "overTime");
        Assert.assertEquals((Object)"overTime", (Object)rindex.getName());
        Assert.assertTrue((boolean)this.mgmt.containsVertexLabel("people"));
        VertexLabel vl = this.mgmt.getVertexLabel("people");
        this.mgmt.changeName((TitanSchemaElement)vl, "person");
        Assert.assertEquals((Object)"person", (Object)vl.getName());
        Assert.assertTrue((boolean)this.mgmt.containsGraphIndex("timeIndex"));
        TitanGraphIndex gindex = this.mgmt.getGraphIndex("timeIndex");
        this.mgmt.changeName((TitanSchemaElement)gindex, "byTime");
        Assert.assertEquals((Object)"byTime", (Object)gindex.getName());
        this.finishSchema();
        Assert.assertTrue((boolean)this.mgmt.containsRelationType("know"));
        Assert.assertFalse((boolean)this.mgmt.containsRelationType("knows"));
        knows = this.mgmt.getEdgeLabel("know");
        Assert.assertTrue((boolean)this.mgmt.containsRelationIndex((RelationType)knows, "overTime"));
        Assert.assertFalse((boolean)this.mgmt.containsRelationIndex((RelationType)knows, "byTime"));
        Assert.assertTrue((boolean)this.mgmt.containsVertexLabel("person"));
        Assert.assertFalse((boolean)this.mgmt.containsVertexLabel("people"));
        Assert.assertTrue((boolean)this.mgmt.containsGraphIndex("byTime"));
        Assert.assertFalse((boolean)this.mgmt.containsGraphIndex("timeIndex"));
        this.newTx();
        v = (TitanVertex)Iterables.getOnlyElement((Iterable)this.tx.query().has("time", (Object)5).vertices());
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((Object)"person", (Object)v.getLabel());
        Assert.assertEquals((Object)5, (Object)v.getProperty("time"));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)v.getEdges(Direction.IN, new String[]{"know"})));
        Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)v.getEdges(Direction.IN, new String[]{"knows"})));
        Assert.assertEquals((long)1L, (long)v.query().labels(new String[]{"know"}).direction(Direction.OUT).has("time", (Object)11).count());
    }

    @Test
    public void testIndexUpdatesWithoutReindex() throws InterruptedException {
        TitanVertex o;
        int i;
        this.clopen(TitanGraphTest.option(GraphDatabaseConfiguration.LOG_SEND_DELAY, "titan"), new StandardDuration(0L, TimeUnit.MILLISECONDS), TitanGraphTest.option(KCVSLog.LOG_READ_LAG_TIME, "titan"), new StandardDuration(50L, TimeUnit.MILLISECONDS), TitanGraphTest.option(GraphDatabaseConfiguration.LOG_READ_INTERVAL, "titan"), new StandardDuration(250L, TimeUnit.MILLISECONDS));
        PropertyKey time = this.mgmt.makePropertyKey("time").dataType(Integer.class).make();
        PropertyKey name = this.mgmt.makePropertyKey("name").dataType(String.class).cardinality(Cardinality.SET).make();
        EdgeLabel friend = this.mgmt.makeEdgeLabel("friend").multiplicity(Multiplicity.MULTI).make();
        PropertyKey sensor = this.mgmt.makePropertyKey("sensor").dataType(Double.class).cardinality(Cardinality.LIST).make();
        this.finishSchema();
        TitanVertex v = this.tx.addVertex();
        for (i = 0; i < 10; ++i) {
            v.addProperty("sensor", (Object)i).setProperty("time", (Object)i);
            v.addProperty("name", (Object)("v" + i));
            o = this.tx.addVertex();
            v.addEdge("friend", o).setProperty("time", (Object)i);
        }
        this.newTx();
        v = this.tx.getVertex(v.getLongId());
        TitanGraphTest.evaluateQuery(v.query().keys(new String[]{"sensor"}).interval("time", (Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(5)).orderBy("time", Order.DESC), RelationCategory.PROPERTY, 4, 1, new boolean[]{false, false}, this.tx.getPropertyKey("time"), Order.DESC);
        TitanGraphTest.evaluateQuery(v.query().keys(new String[]{"sensor"}).interval("time", (Comparable)Integer.valueOf(101), (Comparable)Integer.valueOf(105)).orderBy("time", Order.DESC), RelationCategory.PROPERTY, 0, 1, new boolean[]{false, false}, this.tx.getPropertyKey("time"), Order.DESC);
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(5)).orderBy("time", Order.DESC), RelationCategory.EDGE, 4, 1, new boolean[]{false, false}, this.tx.getPropertyKey("time"), Order.DESC);
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(101), (Comparable)Integer.valueOf(105)).orderBy("time", Order.DESC), RelationCategory.EDGE, 0, 1, new boolean[]{false, false}, this.tx.getPropertyKey("time"), Order.DESC);
        TitanGraphTest.evaluateQuery(this.tx.query().has("name", (Object)"v5"), ElementCategory.VERTEX, 1, new boolean[]{false, true}, new String[0]);
        TitanGraphTest.evaluateQuery(this.tx.query().has("name", (Object)"v105"), ElementCategory.VERTEX, 0, new boolean[]{false, true}, new String[0]);
        this.newTx();
        this.finishSchema();
        sensor = this.mgmt.getPropertyKey("sensor");
        time = this.mgmt.getPropertyKey("time");
        name = this.mgmt.getPropertyKey("name");
        friend = this.mgmt.getEdgeLabel("friend");
        this.mgmt.buildPropertyIndex(sensor, "byTime", Order.DESC, new RelationType[]{time});
        this.mgmt.buildEdgeIndex(friend, "byTime", Direction.OUT, Order.DESC, new RelationType[]{time});
        this.mgmt.buildIndex("bySensorReading", Vertex.class).addKey(name).buildCompositeIndex();
        this.finishSchema();
        this.newTx();
        v = this.tx.getVertex(v.getLongId());
        for (i = 100; i < 110; ++i) {
            v.addProperty("sensor", (Object)i).setProperty("time", (Object)i);
            v.addProperty("name", (Object)("v" + i));
            o = this.tx.addVertex();
            v.addEdge("friend", o).setProperty("time", (Object)i);
        }
        this.tx.commit();
        try {
            this.mgmt.updateIndex((TitanIndex)this.mgmt.getRelationIndex(this.mgmt.getRelationType("sensor"), "byTime"), SchemaAction.ENABLE_INDEX);
            Assert.fail();
        }
        catch (IllegalArgumentException i2) {
            // empty catch block
        }
        try {
            this.mgmt.updateIndex((TitanIndex)this.mgmt.getRelationIndex(this.mgmt.getRelationType("friend"), "byTime"), SchemaAction.ENABLE_INDEX);
            Assert.fail();
        }
        catch (IllegalArgumentException i2) {
            // empty catch block
        }
        try {
            this.mgmt.updateIndex((TitanIndex)this.mgmt.getGraphIndex("bySensorReading"), SchemaAction.ENABLE_INDEX);
            Assert.fail();
        }
        catch (IllegalArgumentException i2) {
            // empty catch block
        }
        this.mgmt.updateIndex((TitanIndex)this.mgmt.getRelationIndex(this.mgmt.getRelationType("sensor"), "byTime"), SchemaAction.REGISTER_INDEX);
        this.mgmt.updateIndex((TitanIndex)this.mgmt.getRelationIndex(this.mgmt.getRelationType("friend"), "byTime"), SchemaAction.REGISTER_INDEX);
        this.mgmt.updateIndex((TitanIndex)this.mgmt.getGraphIndex("bySensorReading"), SchemaAction.REGISTER_INDEX);
        this.mgmt.commit();
        Thread.sleep(10000L);
        this.finishSchema();
        this.mgmt.updateIndex((TitanIndex)this.mgmt.getRelationIndex(this.mgmt.getRelationType("sensor"), "byTime"), SchemaAction.ENABLE_INDEX);
        this.mgmt.updateIndex((TitanIndex)this.mgmt.getRelationIndex(this.mgmt.getRelationType("friend"), "byTime"), SchemaAction.ENABLE_INDEX);
        this.mgmt.updateIndex((TitanIndex)this.mgmt.getGraphIndex("bySensorReading"), SchemaAction.ENABLE_INDEX);
        this.finishSchema();
        this.newTx();
        v = this.tx.getVertex(v.getLongId());
        for (int i3 = 200; i3 < 210; ++i3) {
            v.addProperty("sensor", (Object)i3).setProperty("time", (Object)i3);
            v.addProperty("name", (Object)("v" + i3));
            o = this.tx.addVertex();
            v.addEdge("friend", o).setProperty("time", (Object)i3);
        }
        this.newTx();
        v = this.tx.getVertex(v.getLongId());
        TitanGraphTest.evaluateQuery(v.query().keys(new String[]{"sensor"}).interval("time", (Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(5)).orderBy("time", Order.DESC), RelationCategory.PROPERTY, 0, 1, new boolean[]{true, true}, this.tx.getPropertyKey("time"), Order.DESC);
        TitanGraphTest.evaluateQuery(v.query().keys(new String[]{"sensor"}).interval("time", (Comparable)Integer.valueOf(101), (Comparable)Integer.valueOf(105)).orderBy("time", Order.DESC), RelationCategory.PROPERTY, 4, 1, new boolean[]{true, true}, this.tx.getPropertyKey("time"), Order.DESC);
        TitanGraphTest.evaluateQuery(v.query().keys(new String[]{"sensor"}).interval("time", (Comparable)Integer.valueOf(201), (Comparable)Integer.valueOf(205)).orderBy("time", Order.DESC), RelationCategory.PROPERTY, 4, 1, new boolean[]{true, true}, this.tx.getPropertyKey("time"), Order.DESC);
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(5)).orderBy("time", Order.DESC), RelationCategory.EDGE, 0, 1, new boolean[]{true, true}, this.tx.getPropertyKey("time"), Order.DESC);
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(101), (Comparable)Integer.valueOf(105)).orderBy("time", Order.DESC), RelationCategory.EDGE, 4, 1, new boolean[]{true, true}, this.tx.getPropertyKey("time"), Order.DESC);
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(201), (Comparable)Integer.valueOf(205)).orderBy("time", Order.DESC), RelationCategory.EDGE, 4, 1, new boolean[]{true, true}, this.tx.getPropertyKey("time"), Order.DESC);
        TitanGraphTest.evaluateQuery(this.tx.query().has("name", (Object)"v5"), ElementCategory.VERTEX, 0, new boolean[]{true, true}, "bySensorReading");
        TitanGraphTest.evaluateQuery(this.tx.query().has("name", (Object)"v105"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "bySensorReading");
        TitanGraphTest.evaluateQuery(this.tx.query().has("name", (Object)"v205"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "bySensorReading");
    }

    @Category(value={BrittleTests.class})
    @Test
    public void testIndexUpdateSyncWithMultipleInstances() throws InterruptedException {
        this.clopen(TitanGraphTest.option(GraphDatabaseConfiguration.LOG_SEND_DELAY, "titan"), new StandardDuration(0L, TimeUnit.MILLISECONDS), TitanGraphTest.option(KCVSLog.LOG_READ_LAG_TIME, "titan"), new StandardDuration(50L, TimeUnit.MILLISECONDS), TitanGraphTest.option(GraphDatabaseConfiguration.LOG_READ_INTERVAL, "titan"), new StandardDuration(250L, TimeUnit.MILLISECONDS));
        StandardTitanGraph graph2 = (StandardTitanGraph)TitanFactory.open((ReadConfiguration)this.config);
        PropertyKey name = this.mgmt.makePropertyKey("name").dataType(String.class).make();
        this.finishSchema();
        ElementHelper.setProperties((Element)this.tx.addVertex(), (Object[])new Object[]{"name", "v1"});
        this.newTx();
        TitanGraphTest.evaluateQuery(this.tx.query().has("name", (Object)"v1"), ElementCategory.VERTEX, 1, new boolean[]{false, true}, new String[0]);
        TitanTransaction tx2 = graph2.newTransaction();
        TitanGraphTest.evaluateQuery(tx2.query().has("name", (Object)"v1"), ElementCategory.VERTEX, 1, new boolean[]{false, true}, new String[0]);
        this.mgmt.buildIndex("theIndex", Vertex.class).addKey(this.mgmt.getPropertyKey("name")).buildCompositeIndex();
        this.mgmt.commit();
        TitanTransaction tx3 = graph2.newTransaction();
        ElementHelper.setProperties((Element)tx3.addVertex(), (Object[])new Object[]{"name", "v2"});
        tx3.commit();
        this.newTx();
        ElementHelper.setProperties((Element)this.tx.addVertex(), (Object[])new Object[]{"name", "v3"});
        this.tx.commit();
        Thread.sleep(2000L);
        this.finishSchema();
        try {
            this.mgmt.updateIndex((TitanIndex)this.mgmt.getGraphIndex("theIndex"), SchemaAction.ENABLE_INDEX);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.finishSchema();
        tx2.commit();
        this.mgmt.rollback();
        ManagementSystem.awaitGraphIndexStatus((TitanGraph)this.graph, (String)"theIndex", (SchemaStatus)SchemaStatus.REGISTERED, (long)TestGraphConfigs.getSchemaConvergenceTime(TimeUnit.SECONDS), (TimeUnit)TimeUnit.SECONDS);
        this.finishSchema();
        this.mgmt.updateIndex((TitanIndex)this.mgmt.getGraphIndex("theIndex"), SchemaAction.ENABLE_INDEX);
        this.finishSchema();
        tx2 = graph2.newTransaction();
        ElementHelper.setProperties((Element)tx2.addVertex(), (Object[])new Object[]{"name", "v4"});
        tx2.commit();
        this.newTx();
        TitanGraphTest.evaluateQuery(this.tx.query().has("name", (Object)"v1"), ElementCategory.VERTEX, 0, new boolean[]{true, true}, "theIndex");
        TitanGraphTest.evaluateQuery(this.tx.query().has("name", (Object)"v2"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "theIndex");
        TitanGraphTest.evaluateQuery(this.tx.query().has("name", (Object)"v3"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "theIndex");
        TitanGraphTest.evaluateQuery(this.tx.query().has("name", (Object)"v4"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "theIndex");
        Thread.sleep(2000L);
        tx2 = graph2.newTransaction();
        TitanGraphTest.evaluateQuery(tx2.query().has("name", (Object)"v1"), ElementCategory.VERTEX, 0, new boolean[]{true, true}, "theIndex");
        TitanGraphTest.evaluateQuery(tx2.query().has("name", (Object)"v2"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "theIndex");
        TitanGraphTest.evaluateQuery(tx2.query().has("name", (Object)"v3"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "theIndex");
        TitanGraphTest.evaluateQuery(tx2.query().has("name", (Object)"v4"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "theIndex");
        tx2.commit();
        Set openInstances = this.mgmt.getOpenInstances();
        Assert.assertEquals((long)2L, (long)openInstances.size());
        Assert.assertTrue((boolean)openInstances.contains(this.graph.getConfiguration().getUniqueGraphId() + "(current)"));
        Assert.assertTrue((boolean)openInstances.contains(graph2.getConfiguration().getUniqueGraphId()));
        try {
            this.mgmt.forceCloseInstance(this.graph.getConfiguration().getUniqueGraphId());
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.mgmt.forceCloseInstance(graph2.getConfiguration().getUniqueGraphId());
        graph2.shutdown();
    }

    @Test
    public void testImplicitKey() {
        TitanVertex v = this.graph.addVertex(null);
        TitanVertex u = this.graph.addVertex(null);
        v.setProperty("name", (Object)"Dan");
        TitanEdge e = v.addEdge("knows", u);
        this.graph.commit();
        RelationIdentifier eid = (RelationIdentifier)e.getId();
        Assert.assertEquals((Object)v.getId(), (Object)v.getProperty("id"));
        Assert.assertEquals((Object)eid, (Object)e.getProperty("id"));
        Assert.assertEquals((Object)"knows", (Object)e.getProperty("label"));
        Assert.assertEquals((Object)BaseVertexLabel.DEFAULT_VERTEXLABEL.getName(), (Object)v.getProperty("label"));
        Assert.assertEquals((long)1L, (long)v.query().labels(new String[]{"knows"}).direction(Direction.BOTH).has("id", (Object)eid).count());
        Assert.assertEquals((long)0L, (long)v.query().labels(new String[]{"knows"}).direction(Direction.BOTH).has("id", (Object)RelationIdentifier.get((long[])new long[]{4L, 5L, 6L, 7L})).count());
        Assert.assertEquals((long)1L, (long)v.query().labels(new String[]{"knows"}).direction(Direction.BOTH).has("$titanid", (Object)eid.getRelationId()).count());
        Assert.assertEquals((long)0L, (long)v.query().labels(new String[]{"knows"}).direction(Direction.BOTH).has("$titanid", (Object)110111).count());
        Assert.assertEquals((long)1L, (long)v.query().has("$adjacent", (Object)u.getLongId()).count());
        Assert.assertEquals((long)1L, (long)v.query().has("$adjacent", (Object)((int)u.getLongId())).count());
        try {
            Assert.assertEquals((long)0L, (long)v.query().has("$adjacent", (Object)110111).count());
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertNotNull((Object)this.graph.getEdge((Object)eid));
        Assert.assertEquals((Object)eid, (Object)this.graph.getEdge((Object)eid).getId());
    }

    @Test
    public void testArrayEqualityUsingImplicitKey() {
        TitanVertex v = this.graph.addVertex(null);
        byte[] singleDimension = new byte[]{127, 0, 0, 1};
        byte[] singleDimensionCopy = new byte[]{127, 0, 0, 1};
        String singlePropName = "single";
        v.setProperty("single", (Object)singleDimension);
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)this.graph.query().has("single", (Object)singleDimension).vertices()));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)this.graph.query().has("single", (Object)singleDimensionCopy).vertices()));
        this.graph.commit();
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)this.graph.query().has("single", (Object)singleDimension).vertices()));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)this.graph.query().has("single", (Object)singleDimensionCopy).vertices()));
        byte[][] multiDimension = new byte[1][1];
        multiDimension[0][0] = 42;
        byte[][] multiDimensionCopy = new byte[1][1];
        multiDimensionCopy[0][0] = 42;
        String multiPropName = "multi";
        v = this.graph.addVertex(null);
        v.setProperty("multi", (Object)multiDimension);
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)this.graph.query().has("multi", (Object)multiDimension).vertices()));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)this.graph.query().has("multi", (Object)multiDimensionCopy).vertices()));
        this.graph.commit();
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)this.graph.query().has("multi", (Object)multiDimension).vertices()));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)this.graph.query().has("multi", (Object)multiDimensionCopy).vertices()));
    }

    @Test
    public void testSelfLoop() {
        TitanVertex v = this.tx.addVertex();
        this.tx.addEdge(null, (Vertex)v, (Vertex)v, "self");
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)v.getEdges(Direction.OUT, new String[]{"self"})));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)v.getEdges(Direction.IN, new String[]{"self"})));
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)v.getEdges(Direction.BOTH, new String[]{"self"})));
        this.clopen(new Object[0]);
        v = this.tx.getVertex(v.getId());
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)v.getEdges(Direction.IN, new String[]{"self"})));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)v.getEdges(Direction.OUT, new String[]{"self"})));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)v.getEdges(Direction.IN, new String[]{"self"})));
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)v.getEdges(Direction.BOTH, new String[]{"self"})));
    }

    @Test
    public void testThreadBoundTx() {
        PropertyKey t = this.mgmt.makePropertyKey("type").dataType(Integer.class).make();
        this.mgmt.buildIndex("etype", Edge.class).addKey(t).buildCompositeIndex();
        ((StandardEdgeLabelMaker)this.mgmt.makeEdgeLabel("friend")).sortKey(new RelationType[]{t}).make();
        this.finishSchema();
        TitanVertex v1 = this.graph.addVertex(null);
        TitanVertex v2 = this.graph.addVertex(null);
        TitanVertex v3 = this.graph.addVertex(null);
        v1.setProperty("name", (Object)"Vertex1");
        v1.setProperty("age", (Object)35);
        v2.setProperty("name", (Object)"Vertex2");
        v2.setProperty("age", (Object)45);
        v3.setProperty("name", (Object)"Vertex3");
        v3.setProperty("age", (Object)55);
        Edge e1 = v1.addEdge("knows", (Vertex)v2);
        e1.setProperty("time", (Object)5);
        Edge e2 = v2.addEdge("knows", (Vertex)v3);
        e2.setProperty("time", (Object)15);
        Edge e3 = v3.addEdge("knows", (Vertex)v1);
        e3.setProperty("time", (Object)25);
        Edge e4 = v2.addEdge("friend", (Vertex)v2);
        e4.setProperty("type", (Object)1);
        for (Vertex v : new Vertex[]{v1, v2, v3}) {
            Assert.assertEquals((long)2L, (long)v.query().direction(Direction.BOTH).labels(new String[]{"knows"}).count());
            Assert.assertEquals((long)1L, (long)v.query().direction(Direction.OUT).labels(new String[]{"knows"}).count());
            Assert.assertEquals((long)5L, (long)(((Number)((Edge)Iterables.getOnlyElement((Iterable)v.getEdges(Direction.OUT, new String[]{"knows"}))).getProperty("time")).intValue() % 10));
        }
        e3.setProperty("time", (Object)35);
        Assert.assertEquals((Object)35, (Object)e3.getProperty("time"));
        v1.addEdge("friend", (Vertex)v2).setProperty("type", (Object)0);
        this.graph.commit();
        e4.setProperty("type", (Object)2);
        Edge ef = (Edge)Iterables.getOnlyElement((Iterable)v1.getEdges(Direction.OUT, new String[]{"friend"}));
        Assert.assertEquals((Object)ef, (Object)Iterables.getOnlyElement((Iterable)this.graph.getEdges("type", (Object)0)));
        ef.setProperty("type", (Object)1);
        this.graph.commit();
        Assert.assertEquals((Object)35, (Object)e3.getProperty("time"));
        e3 = this.graph.getEdge((Object)e3);
        e3.setProperty("time", (Object)45);
        Assert.assertEquals((Object)45, (Object)e3.getProperty("time"));
        Assert.assertEquals((Object)15, (Object)e2.getProperty("time"));
        e2.setProperty("time", (Object)25);
        Assert.assertEquals((Object)25, (Object)e2.getProperty("time"));
        Assert.assertEquals((Object)35, (Object)v1.getProperty("age"));
        Assert.assertEquals((Object)55, (Object)v3.getProperty("age"));
        v3.setProperty("age", (Object)65);
        Assert.assertEquals((Object)65, (Object)v3.getProperty("age"));
        e1 = this.graph.getEdge((Object)e1);
        for (Vertex v : new Vertex[]{v1, v2, v3}) {
            Assert.assertEquals((long)2L, (long)v.query().direction(Direction.BOTH).labels(new String[]{"knows"}).count());
            Assert.assertEquals((long)1L, (long)v.query().direction(Direction.OUT).labels(new String[]{"knows"}).count());
            Assert.assertEquals((long)5L, (long)(((Number)((Edge)Iterables.getOnlyElement((Iterable)v.getEdges(Direction.OUT, new String[]{"knows"}))).getProperty("time")).intValue() % 10));
        }
        this.graph.commit();
        TitanProperty prop = (TitanProperty)v1.getProperties().iterator().next();
        Assert.assertTrue((prop.getLongId() > 0L ? 1 : 0) != 0);
        prop = (TitanProperty)((Iterable)this.graph.multiQuery(new TitanVertex[]{v1}).properties().values().iterator().next()).iterator().next();
        Assert.assertTrue((prop.getLongId() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((Object)45, (Object)e3.getProperty("time"));
        Assert.assertEquals((Object)5, (Object)e1.getProperty("time"));
        Assert.assertEquals((Object)35, (Object)v1.getProperty("age"));
        Assert.assertEquals((Object)65, (Object)v3.getProperty("age"));
        for (Vertex v : new Vertex[]{v1, v2, v3}) {
            Assert.assertEquals((long)2L, (long)v.query().direction(Direction.BOTH).labels(new String[]{"knows"}).count());
            Assert.assertEquals((long)1L, (long)v.query().direction(Direction.OUT).labels(new String[]{"knows"}).count());
            Assert.assertEquals((long)5L, (long)(((Number)((Edge)Iterables.getOnlyElement((Iterable)v.getEdges(Direction.OUT, new String[]{"knows"}))).getProperty("time")).intValue() % 10));
        }
        this.graph.commit();
        v1 = this.graph.addVertex(null);
        v2 = this.graph.addVertex(null);
        this.graph.addEdge(null, (Vertex)v1, (Vertex)v2, "knows");
        this.graph.commit();
        v3 = this.graph.addVertex(null);
        TitanEdge e = this.graph.addEdge(null, (Vertex)v1, (Vertex)v3, "knows");
        Assert.assertNull((Object)e.getProperty("age"));
    }

    @Test
    public void testStaleVertex() {
        PropertyKey name = this.mgmt.makePropertyKey("name").dataType(String.class).make();
        PropertyKey age = this.mgmt.makePropertyKey("age").dataType(Integer.class).make();
        this.mgmt.buildIndex("byName", Vertex.class).addKey(name).unique().buildCompositeIndex();
        this.finishSchema();
        TitanVertex cartman = this.graph.addVertex(null);
        ElementHelper.setProperties((Element)cartman, (Object[])new Object[]{"name", "cartman", "age", 10});
        TitanVertex stan = this.graph.addVertex(null);
        ElementHelper.setProperties((Element)stan, (Object[])new Object[]{"name", "stan", "age", 8});
        this.graph.commit();
        cartman = (TitanVertex)this.graph.getVertices("name", (Object)"cartman").iterator().next();
        this.graph.commit();
        TitanProperty p = (TitanProperty)cartman.getProperties().iterator().next();
        System.out.println(p.getLongId());
        this.graph.commit();
    }

    @Test
    public void testTransactionIsolation() {
        this.makeLabel("knows");
        this.finishSchema();
        TitanTransaction tx1 = this.graph.newTransaction();
        TitanTransaction tx2 = this.graph.newTransaction();
        TitanVertex v11 = tx1.addVertex();
        TitanVertex v12 = tx1.addVertex();
        tx1.addEdge(v11, v12, "knows");
        TitanVertex v21 = tx2.addVertex();
        try {
            v21.addEdge("knows", v11);
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        TitanVertex v22 = tx2.addVertex();
        v21.addEdge("knows", v22);
        tx2.commit();
        try {
            v22.addEdge("knows", v21);
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        tx1.rollback();
        try {
            v11.setProperty("test", (Object)5);
            Assert.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.newTx();
        v21 = this.tx.getVertex(v21.getLongId());
        this.tx.makeEdgeLabel("link").unidirected().make();
        TitanVertex v3 = this.tx.addVertex();
        v21.addEdge("link", v3);
        this.newTx();
        v21 = this.tx.getVertex(v21.getLongId());
        v3 = (TitanVertex)Iterables.getOnlyElement((Iterable)v21.getVertices(Direction.OUT, new String[]{"link"}));
        Assert.assertFalse((boolean)v3.isRemoved());
        v3.remove();
        this.newTx();
        v21 = this.tx.getVertex(v21.getLongId());
        v3 = (TitanVertex)Iterables.getOnlyElement((Iterable)v21.getVertices(Direction.OUT, new String[]{"link"}));
        Assert.assertFalse((boolean)v3.isRemoved());
        this.newTx();
        TitanTransaction tx3 = this.graph.buildTransaction().checkInternalVertexExistence(true).start();
        v21 = tx3.getVertex(v21.getLongId());
        v3 = (TitanVertex)Iterables.getOnlyElement((Iterable)v21.getVertices(Direction.OUT, new String[]{"link"}));
        Assert.assertTrue((boolean)v3.isRemoved());
        tx3.commit();
    }

    @Test
    public void testMultivaluedVertexProperty() {
        String foo = "foo";
        String bar = "bar";
        String weight = "weight";
        ImmutableList values = ImmutableList.of((Object)"four", (Object)"score", (Object)"and", (Object)"seven");
        Assert.assertTrue((String)"Values list must have multiple elements for this test to make sense", (2 <= values.size() ? 1 : 0) != 0);
        PropertyKey w = this.makeKey("weight", Integer.class);
        PropertyKey f = ((StandardPropertyKeyMaker)this.mgmt.makePropertyKey("foo")).dataType(String.class).cardinality(Cardinality.LIST).sortKey(new RelationType[]{w}).sortOrder(Order.DESC).make();
        this.mgmt.buildIndex("foo", Vertex.class).addKey(f).buildCompositeIndex();
        PropertyKey b = this.mgmt.makePropertyKey("bar").dataType(String.class).cardinality(Cardinality.LIST).make();
        this.mgmt.buildIndex("bar", Vertex.class).addKey(b).buildCompositeIndex();
        this.finishSchema();
        TitanVertex v = this.tx.addVertex();
        int i = 0;
        for (String s : values) {
            TitanProperty p = v.addProperty("foo", (Object)s);
            p.setProperty("weight", (Object)(++i));
            p = v.addProperty("bar", (Object)s);
            p.setProperty("weight", (Object)i);
        }
        Assert.assertEquals((long)values.size(), (long)Iterables.size((Iterable)v.getProperties("foo")));
        Assert.assertEquals((long)values.size(), (long)Iterables.size((Iterable)v.getProperties("bar")));
        for (String prop : new String[]{"foo", "bar"}) {
            int sum = 0;
            int index = values.size();
            for (TitanProperty p : v.getProperties("foo")) {
                Assert.assertTrue((boolean)values.contains(p.getValue()));
                int wint = (Integer)p.getProperty("weight");
                sum += wint;
                if (prop == "foo") {
                    Assert.assertEquals((long)index, (long)wint);
                }
                --index;
            }
            Assert.assertEquals((long)(values.size() * (values.size() + 1) / 2), (long)sum);
        }
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)this.tx.query().has("foo", values.get(1)).vertices()));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)this.tx.query().has("foo", values.get(3)).vertices()));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)this.tx.query().has("bar", values.get(1)).vertices()));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)this.tx.query().has("bar", values.get(3)).vertices()));
        String lastValueRemoved = (String)v.removeProperty("foo");
        Assert.assertNotNull((Object)lastValueRemoved);
        Assert.assertTrue((boolean)values.contains(lastValueRemoved));
        Assert.assertFalse((boolean)v.getProperties("foo").iterator().hasNext());
        this.clopen(new Object[0]);
        Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)this.tx.query().has("foo", values.get(1)).vertices()));
        Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)this.tx.query().has("foo", values.get(3)).vertices()));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)this.tx.query().has("bar", values.get(1)).vertices()));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)this.tx.query().has("bar", values.get(3)).vertices()));
        v = this.tx.getVertex(v.getLongId());
        Iterable iter = v.getProperties("foo");
        Assert.assertFalse((String)"Failed to durably remove multivalued property", (boolean)iter.iterator().hasNext());
        Assert.assertEquals((long)values.size(), (long)Iterables.size((Iterable)v.getProperties("bar")));
        for (String s : values) {
            v.addProperty("foo", (Object)s);
        }
        Assert.assertEquals((long)values.size(), (long)Iterables.size((Iterable)v.getProperties("foo")));
        lastValueRemoved = (String)v.removeProperty("foo");
        Assert.assertNotNull((Object)lastValueRemoved);
        Assert.assertTrue((boolean)values.contains(lastValueRemoved));
        Assert.assertFalse((boolean)v.getProperties("foo").iterator().hasNext());
    }

    @Test
    public void testLocalGraphConfiguration() {
        this.setIllegalGraphOption(GraphDatabaseConfiguration.STORAGE_READONLY, ConfigOption.Type.LOCAL, true);
    }

    @Test
    public void testMaskableGraphConfig() {
        this.setAndCheckGraphOption(GraphDatabaseConfiguration.DB_CACHE, ConfigOption.Type.MASKABLE, true, false);
    }

    @Test
    public void testGlobalGraphConfig() {
        this.setAndCheckGraphOption(GraphDatabaseConfiguration.SYSTEM_LOG_TRANSACTIONS, ConfigOption.Type.GLOBAL, true, false);
    }

    @Test
    public void testGlobalOfflineGraphConfig() {
        this.setAndCheckGraphOption(GraphDatabaseConfiguration.DB_CACHE_TIME, ConfigOption.Type.GLOBAL_OFFLINE, 500L, 777L);
    }

    @Test
    public void testFixedGraphConfig() {
        this.setIllegalGraphOption(GraphDatabaseConfiguration.INITIAL_TITAN_VERSION, ConfigOption.Type.FIXED, "foo");
    }

    @Test
    public void testManagedOptionMasking() throws BackendException {
        StandardDuration customCommitTime = new StandardDuration(456L, TimeUnit.MILLISECONDS);
        Preconditions.checkState((true == (Boolean)GraphDatabaseConfiguration.ALLOW_STALE_CONFIG.getDefaultValue() ? 1 : 0) != 0);
        Preconditions.checkState((boolean)GraphDatabaseConfiguration.ALLOW_STALE_CONFIG.getType().equals((Object)ConfigOption.Type.MASKABLE));
        Preconditions.checkState((!customCommitTime.equals(GraphDatabaseConfiguration.MAX_COMMIT_TIME.getDefaultValue()) ? 1 : 0) != 0);
        this.close();
        WriteConfiguration wc = this.getConfiguration();
        wc.set(ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.ALLOW_STALE_CONFIG, (String[])new String[0]), (Object)false);
        wc.set(ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.MAX_COMMIT_TIME, (String[])new String[0]), (Object)customCommitTime.getLength(TimeUnit.MILLISECONDS));
        try {
            this.graph = (StandardTitanGraph)TitanFactory.open((ReadConfiguration)wc);
            Assert.fail((String)"Masking managed config options should be disabled in this configuration");
        }
        catch (TitanConfigurationException e) {
            Assert.assertTrue((boolean)e.getMessage().contains(ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.MAX_COMMIT_TIME, (String[])new String[0])));
        }
        this.close();
        wc = this.getConfiguration();
        wc.set(ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.ALLOW_STALE_CONFIG, (String[])new String[0]), (Object)true);
        wc.set(ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.MAX_COMMIT_TIME, (String[])new String[0]), (Object)customCommitTime.getLength(TimeUnit.MILLISECONDS));
        this.graph = (StandardTitanGraph)TitanFactory.open((ReadConfiguration)wc);
        Assert.assertEquals((Object)GraphDatabaseConfiguration.MAX_COMMIT_TIME.getDefaultValue(), (Object)this.graph.getConfiguration().getMaxCommitTime());
        this.graph.getBackend().clearStorage();
        try {
            this.graph.shutdown();
        }
        catch (Throwable t) {
            this.log.debug("Swallowing throwable during shutdown after clearing backend storage", t);
        }
        wc = this.getConfiguration();
        wc.set(ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.ALLOW_STALE_CONFIG, (String[])new String[0]), (Object)false);
        this.graph = (StandardTitanGraph)TitanFactory.open((ReadConfiguration)wc);
        this.close();
        wc = this.getConfiguration();
        wc.set(ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.MAX_COMMIT_TIME, (String[])new String[0]), (Object)customCommitTime.getLength(TimeUnit.MILLISECONDS));
        try {
            this.graph = (StandardTitanGraph)TitanFactory.open((ReadConfiguration)wc);
            Assert.fail((String)"Masking managed config options should be disabled in this configuration");
        }
        catch (TitanConfigurationException e) {
            Assert.assertTrue((boolean)e.getMessage().contains(ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.MAX_COMMIT_TIME, (String[])new String[0])));
        }
        wc = this.getConfiguration();
        wc.set(ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.ALLOW_STALE_CONFIG, (String[])new String[0]), (Object)true);
        wc.set(ConfigElement.getPath((ConfigElement)GraphDatabaseConfiguration.MAX_COMMIT_TIME, (String[])new String[0]), (Object)customCommitTime.getLength(TimeUnit.MILLISECONDS));
        this.graph = (StandardTitanGraph)TitanFactory.open((ReadConfiguration)wc);
        Assert.assertEquals((Object)GraphDatabaseConfiguration.MAX_COMMIT_TIME.getDefaultValue(), (Object)this.graph.getConfiguration().getMaxCommitTime());
    }

    @Test
    public void testTransactionConfiguration() {
        block2: {
            TitanTransaction readOnlyTx = this.graph.buildTransaction().readOnly().start();
            try {
                readOnlyTx.addVertex();
                readOnlyTx.commit();
                Assert.fail((String)"Read-only transactions should not be able to add a vertex and commit");
            }
            catch (Throwable t) {
                if (!readOnlyTx.isOpen()) break block2;
                readOnlyTx.rollback();
            }
        }
        String logID = "spam";
        StandardTitanTx customLogIDTx = (StandardTitanTx)this.graph.buildTransaction().setLogIdentifier(logID).start();
        Assert.assertEquals((Object)logID, (Object)customLogIDTx.getConfiguration().getLogIdentifier());
        customLogIDTx.rollback();
        long customTimestamp = -42L;
        StandardTitanTx customTimeTx = (StandardTitanTx)this.graph.buildTransaction().setCommitTime(customTimestamp, TimeUnit.MILLISECONDS).start();
        Assert.assertTrue((boolean)customTimeTx.getConfiguration().hasCommitTime());
        Assert.assertEquals((long)customTimestamp, (long)customTimeTx.getConfiguration().getCommitTime().getTimestamp(TimeUnit.MILLISECONDS));
        customTimeTx.rollback();
    }

    private <T> void setAndCheckGraphOption(ConfigOption<T> opt, ConfigOption.Type requiredType, T firstValue, T secondValue) {
        Preconditions.checkState((boolean)opt.getType().equals((Object)requiredType));
        EnumSet<ConfigOption.Type> allowedTypes = EnumSet.of(ConfigOption.Type.GLOBAL, ConfigOption.Type.GLOBAL_OFFLINE, ConfigOption.Type.MASKABLE);
        Preconditions.checkState((boolean)allowedTypes.contains(opt.getType()));
        Preconditions.checkArgument((!firstValue.equals(secondValue) ? 1 : 0) != 0);
        String path = ConfigElement.getPath(opt, (String[])new String[0]);
        this.mgmt.set(path, firstValue);
        Assert.assertEquals((Object)firstValue.toString(), (Object)this.mgmt.get(path));
        this.tx.rollback();
        this.mgmt.commit();
        this.clopen(new Object[0]);
        this.tx.rollback();
        Assert.assertEquals((Object)firstValue.toString(), (Object)this.mgmt.get(path));
        this.mgmt.set(path, secondValue);
        Assert.assertEquals((Object)secondValue.toString(), (Object)this.mgmt.get(path));
        this.mgmt.commit();
        this.clopen(new Object[0]);
        this.tx.rollback();
        Assert.assertEquals((Object)secondValue.toString(), (Object)this.mgmt.get(path));
        TitanGraph g2 = TitanFactory.open((ReadConfiguration)this.config);
        TitanManagement m2 = g2.getManagementSystem();
        Assert.assertEquals((Object)secondValue.toString(), (Object)m2.get(path));
        if (opt.getType().equals((Object)ConfigOption.Type.GLOBAL_OFFLINE)) {
            try {
                this.mgmt.set(path, firstValue);
                this.mgmt.commit();
                Assert.fail((String)("Option " + path + " with type " + ConfigOption.Type.GLOBAL_OFFLINE + " should not be modifiable with concurrent instances"));
            }
            catch (RuntimeException e) {
                this.log.debug("Caught expected exception", (Throwable)e);
            }
            Assert.assertEquals((Object)secondValue.toString(), (Object)this.mgmt.get(path));
        } else {
            this.mgmt.set(path, firstValue);
            Assert.assertEquals((Object)firstValue.toString(), (Object)this.mgmt.get(path));
            this.mgmt.commit();
            this.clopen(new Object[0]);
            Assert.assertEquals((Object)firstValue.toString(), (Object)this.mgmt.get(path));
        }
        m2.rollback();
        g2.shutdown();
    }

    private <T> void setIllegalGraphOption(ConfigOption<T> opt, ConfigOption.Type requiredType, T attemptedValue) {
        ConfigOption.Type type = opt.getType();
        Preconditions.checkState((boolean)type.equals((Object)requiredType));
        Preconditions.checkArgument((requiredType.equals((Object)ConfigOption.Type.LOCAL) || requiredType.equals((Object)ConfigOption.Type.FIXED) ? 1 : 0) != 0);
        String path = ConfigElement.getPath(opt, (String[])new String[0]);
        try {
            this.mgmt.get(path);
        }
        catch (Throwable t) {
            this.log.debug("Caught expected exception", t);
        }
        try {
            this.mgmt.set(path, attemptedValue);
            this.mgmt.commit();
            Assert.fail((String)("Option " + path + " with type " + type + " should not be modifiable in the persistent graph config"));
        }
        catch (Throwable t) {
            this.log.debug("Caught expected exception", t);
        }
    }

    @Test
    public void testConsistencyEnforcement() {
        PropertyKey id = this.makeVertexIndexedUniqueKey("uid", Integer.class);
        PropertyKey name = this.makeKey("name", String.class);
        this.mgmt.setConsistency((TitanSchemaElement)id, ConsistencyModifier.LOCK);
        this.mgmt.setConsistency((TitanSchemaElement)name, ConsistencyModifier.LOCK);
        this.mgmt.setConsistency((TitanSchemaElement)this.mgmt.getGraphIndex("uid"), ConsistencyModifier.LOCK);
        EdgeLabel knows = this.mgmt.makeEdgeLabel("knows").multiplicity(Multiplicity.SIMPLE).make();
        EdgeLabel spouse = this.mgmt.makeEdgeLabel("spouse").multiplicity(Multiplicity.ONE2ONE).make();
        EdgeLabel connect = this.mgmt.makeEdgeLabel("connect").multiplicity(Multiplicity.MULTI).make();
        EdgeLabel related = this.mgmt.makeEdgeLabel("related").multiplicity(Multiplicity.MULTI).make();
        this.mgmt.setConsistency((TitanSchemaElement)knows, ConsistencyModifier.LOCK);
        this.mgmt.setConsistency((TitanSchemaElement)spouse, ConsistencyModifier.LOCK);
        this.mgmt.setConsistency((TitanSchemaElement)related, ConsistencyModifier.FORK);
        this.finishSchema();
        name = this.tx.getPropertyKey("name");
        connect = this.tx.getEdgeLabel("connect");
        related = this.tx.getEdgeLabel("related");
        TitanVertex v1 = this.tx.addVertex();
        v1.setProperty("uid", (Object)1);
        TitanVertex v2 = this.tx.addVertex();
        v2.setProperty("uid", (Object)2);
        TitanVertex v3 = this.tx.addVertex();
        v3.setProperty("uid", (Object)3);
        TitanEdge e1 = v1.addEdge(connect.getName(), v2);
        e1.setProperty(name.getName(), (Object)"e1");
        TitanEdge e2 = v1.addEdge(related.getName(), v2);
        e2.setProperty(name.getName(), (Object)"e2");
        this.newTx();
        name = this.tx.getPropertyKey("name");
        connect = this.tx.getEdgeLabel("connect");
        related = this.tx.getEdgeLabel("related");
        v1 = this.tx.getVertex(v1.getLongId());
        long e1id = e1.getLongId();
        long e2id = e2.getLongId();
        e1 = (TitanEdge)Iterables.getOnlyElement((Iterable)v1.getEdges(Direction.OUT, new String[]{connect.getName()}));
        Assert.assertEquals((Object)"e1", (Object)e1.getProperty(name.getName()));
        Assert.assertEquals((long)e1id, (long)e1.getLongId());
        e2 = (TitanEdge)Iterables.getOnlyElement((Iterable)v1.getEdges(Direction.OUT, new String[]{related.getName()}));
        Assert.assertEquals((Object)"e2", (Object)e2.getProperty(name.getName()));
        Assert.assertEquals((long)e2id, (long)e2.getLongId());
        e1.setProperty(name.getName(), (Object)"e1.2");
        e2.setProperty(name.getName(), (Object)"e2.2");
        this.newTx();
        name = this.tx.getPropertyKey("name");
        connect = this.tx.getEdgeLabel("connect");
        related = this.tx.getEdgeLabel("related");
        v1 = this.tx.getVertex(v1.getLongId());
        e1 = (TitanEdge)Iterables.getOnlyElement((Iterable)v1.getEdges(Direction.OUT, new String[]{connect.getName()}));
        Assert.assertEquals((Object)"e1.2", (Object)e1.getProperty(name.getName()));
        Assert.assertEquals((long)e1id, (long)e1.getLongId());
        e2 = (TitanEdge)Iterables.getOnlyElement((Iterable)v1.getEdges(Direction.OUT, new String[]{related.getName()}));
        Assert.assertEquals((Object)"e2.2", (Object)e2.getProperty(name.getName()));
        Assert.assertNotEquals((long)e2id, (long)e2.getLongId());
        this.clopen(new Object[0]);
        final Random random = new Random();
        final long[] vids = new long[]{v1.getLongId(), v2.getLongId(), v3.getLongId()};
        this.executeLockConflictingTransactionJobs((TitanGraph)this.graph, new TransactionJob(){
            private int pos = 0;

            @Override
            public void run(TitanTransaction tx) {
                TitanVertex u = tx.getVertex(vids[this.pos++]);
                u.setProperty("uid", (Object)5);
            }
        });
        this.executeLockConflictingTransactionJobs((TitanGraph)this.graph, new TransactionJob(){

            @Override
            public void run(TitanTransaction tx) {
                TitanVertex u = tx.getVertex(vids[0]);
                u.setProperty("name", (Object)("v" + random.nextInt(10)));
            }
        });
        this.executeLockConflictingTransactionJobs((TitanGraph)this.graph, new TransactionJob(){

            @Override
            public void run(TitanTransaction tx) {
                TitanVertex u1 = tx.getVertex(vids[0]);
                TitanVertex u2 = tx.getVertex(vids[1]);
                u1.addEdge("knows", (Vertex)u2);
            }
        });
        this.executeLockConflictingTransactionJobs((TitanGraph)this.graph, new TransactionJob(){
            private int pos = 1;

            @Override
            public void run(TitanTransaction tx) {
                TitanVertex u1 = tx.getVertex(vids[0]);
                TitanVertex u2 = tx.getVertex(vids[this.pos++]);
                u1.addEdge("spouse", (Vertex)u2);
            }
        });
        this.executeLockConflictingTransactionJobs((TitanGraph)this.graph, new TransactionJob(){
            private int pos = 1;

            @Override
            public void run(TitanTransaction tx) {
                TitanVertex u1 = tx.getVertex(vids[this.pos++]);
                TitanVertex u2 = tx.getVertex(vids[0]);
                u1.addEdge("spouse", (Vertex)u2);
            }
        });
        try {
            this.mgmt.setConsistency((TitanSchemaElement)this.mgmt.getPropertyKey("name"), ConsistencyModifier.FORK);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void executeLockConflictingTransactionJobs(TitanGraph graph, TransactionJob job) {
        TitanTransaction tx1 = graph.newTransaction();
        TitanTransaction tx2 = graph.newTransaction();
        job.run(tx1);
        job.run(tx2);
        if (this.isLockingOptimistic()) {
            tx1.commit();
            try {
                tx2.commit();
                Assert.fail((String)"Storage backend does not abort conflicting transactions");
            }
            catch (TitanException titanException) {}
        } else {
            try {
                tx1.commit();
                Assert.fail((String)"Storage backend does not abort conflicting transactions");
            }
            catch (TitanException titanException) {
                // empty catch block
            }
            tx2.commit();
        }
    }

    @Test
    public void testConcurrentConsistencyEnforcement() throws Exception {
        PropertyKey name = this.mgmt.makePropertyKey("name").dataType(String.class).cardinality(Cardinality.SINGLE).make();
        TitanGraphIndex nameIndex = this.mgmt.buildIndex("name", Vertex.class).addKey(name).unique().buildCompositeIndex();
        this.mgmt.setConsistency((TitanSchemaElement)nameIndex, ConsistencyModifier.LOCK);
        EdgeLabel married = this.mgmt.makeEdgeLabel("married").multiplicity(Multiplicity.ONE2ONE).make();
        this.mgmt.setConsistency((TitanSchemaElement)married, ConsistencyModifier.LOCK);
        EdgeLabel friend = this.mgmt.makeEdgeLabel("friend").multiplicity(Multiplicity.MULTI).make();
        this.finishSchema();
        TitanVertex baseV = this.tx.addVertex();
        baseV.setProperty("name", (Object)"base");
        this.newTx();
        final long baseVid = baseV.getLongId();
        String nameA = "a";
        String nameB = "b";
        int parallelThreads = 4;
        AtomicInteger totalExe = new AtomicInteger();
        int numSuccess = this.executeParallelTransactions(new TransactionJob(){

            @Override
            public void run(TitanTransaction tx) {
                TitanVertex a = tx.addVertex();
                TitanVertex base = tx.getVertex(baseVid);
                base.addEdge("married", a);
            }
        }, 4);
        Assert.assertTrue((String)("At most 1 tx should succeed: " + numSuccess), (numSuccess <= 1 ? 1 : 0) != 0);
        numSuccess = this.executeParallelTransactions(new TransactionJob(){

            @Override
            public void run(TitanTransaction tx) {
                TitanVertex a = tx.addVertex();
                a.setProperty("name", (Object)"a");
                TitanVertex b = tx.addVertex();
                b.setProperty("name", (Object)"b");
                b.addEdge("friend", (Vertex)b);
            }
        }, 4);
        this.newTx();
        int numA = Iterables.size((Iterable)this.tx.query().has("name", (Object)"a").vertices());
        int numB = Iterables.size((Iterable)this.tx.query().has("name", (Object)"b").vertices());
        Assert.assertTrue((String)("At most 1 tx should succeed: " + numSuccess), (numSuccess <= 1 ? 1 : 0) != 0);
        Assert.assertTrue((numA <= 1 ? 1 : 0) != 0);
        Assert.assertTrue((numB <= 1 ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void failTransactionOnCommit(TransactionJob job) {
        TitanTransaction tx = this.graph.newTransaction();
        try {
            job.run(tx);
            tx.commit();
            Assert.fail();
        }
        catch (Exception exception) {
        }
        finally {
            if (tx.isOpen()) {
                tx.rollback();
            }
        }
    }

    private int executeSerialTransaction(TransactionJob job, int number) {
        AtomicInteger txSuccess = new AtomicInteger(0);
        for (int i = 0; i < number; ++i) {
            TitanTransaction tx = this.graph.newTransaction();
            try {
                job.run(tx);
                tx.commit();
                txSuccess.incrementAndGet();
                continue;
            }
            catch (Exception ex) {
                tx.rollback();
                ex.printStackTrace();
            }
        }
        return txSuccess.get();
    }

    private int executeParallelTransactions(final TransactionJob job, int number) {
        final CountDownLatch startLatch = new CountDownLatch(number);
        final CountDownLatch finishLatch = new CountDownLatch(number);
        final AtomicInteger txSuccess = new AtomicInteger(0);
        for (int i = 0; i < number; ++i) {
            new Thread(){

                @Override
                public void run() {
                    this.awaitAllThreadsReady();
                    TitanTransaction tx = TitanGraphTest.this.graph.newTransaction();
                    try {
                        job.run(tx);
                        tx.commit();
                        txSuccess.incrementAndGet();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        if (tx.isOpen()) {
                            tx.rollback();
                        }
                    }
                    finally {
                        finishLatch.countDown();
                    }
                }

                private void awaitAllThreadsReady() {
                    startLatch.countDown();
                    try {
                        startLatch.await();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }.start();
        }
        try {
            finishLatch.await(10000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return txSuccess.get();
    }

    @Test
    public void testVertexCentricQuery() {
        int nowTime3;
        int i;
        VertexList vl;
        int i2;
        this.makeVertexIndexedUniqueKey("name", String.class);
        PropertyKey time = this.makeKey("time", Integer.class);
        PropertyKey weight = this.makeKey("weight", Precision.class);
        EdgeLabel author = this.mgmt.makeEdgeLabel("author").multiplicity(Multiplicity.MANY2ONE).unidirected().make();
        ((StandardEdgeLabelMaker)this.mgmt.makeEdgeLabel("connect")).sortKey(new RelationType[]{time}).make();
        ((StandardEdgeLabelMaker)this.mgmt.makeEdgeLabel("connectDesc")).sortKey(new RelationType[]{time}).sortOrder(Order.DESC).make();
        ((StandardEdgeLabelMaker)this.mgmt.makeEdgeLabel("friend")).sortKey(new RelationType[]{weight, time}).sortOrder(Order.ASC).signature(new RelationType[]{author}).make();
        ((StandardEdgeLabelMaker)this.mgmt.makeEdgeLabel("friendDesc")).sortKey(new RelationType[]{weight, time}).sortOrder(Order.DESC).signature(new RelationType[]{author}).make();
        ((StandardEdgeLabelMaker)this.mgmt.makeEdgeLabel("knows")).sortKey(new RelationType[]{author, weight}).make();
        this.mgmt.makeEdgeLabel("follows").make();
        this.finishSchema();
        TitanVertex v = this.tx.addVertex();
        v.addProperty("name", (Object)"v");
        TitanVertex u = this.tx.addVertex();
        u.addProperty("name", (Object)"u");
        int noVertices = 10000;
        Assert.assertEquals((long)0L, (long)((noVertices - 1) % 3));
        TitanVertex[] vs = new TitanVertex[noVertices];
        for (int i3 = 1; i3 < noVertices; ++i3) {
            vs[i3] = this.tx.addVertex();
            vs[i3].addProperty("name", (Object)("v" + i3));
        }
        EdgeLabel[] labelsV = new EdgeLabel[]{this.tx.getEdgeLabel("connect"), this.tx.getEdgeLabel("friend"), this.tx.getEdgeLabel("knows")};
        EdgeLabel[] labelsU = new EdgeLabel[]{this.tx.getEdgeLabel("connectDesc"), this.tx.getEdgeLabel("friendDesc"), this.tx.getEdgeLabel("knows")};
        for (int i4 = 1; i4 < noVertices; ++i4) {
            for (TitanVertex vertex : new TitanVertex[]{v, u}) {
                for (Direction d : new Direction[]{Direction.OUT, Direction.IN}) {
                    EdgeLabel label = vertex == v ? labelsV[i4 % 3] : labelsU[i4 % 3];
                    TitanEdge e = d == Direction.OUT ? vertex.addEdge(label, vs[i4]) : vs[i4].addEdge(label, vertex);
                    e.setProperty("time", (Object)i4);
                    e.setProperty("weight", (Object)((double)(i4 % 4) + 0.5));
                    e.setProperty("name", (Object)("e" + i4));
                    e.setProperty("author", (Object)(i4 % 5 == 0 ? v : vs[i4 % 5]));
                }
            }
        }
        int edgesPerLabel = noVertices / 3;
        this.clopen(new Object[0]);
        long[] vidsubset = new long[28];
        for (i2 = 0; i2 < vidsubset.length; ++i2) {
            vidsubset[i2] = vs[i2 + 3].getLongId();
        }
        Arrays.sort(vidsubset);
        this.clopen(new Object[0]);
        for (i2 = 1; i2 < noVertices; ++i2) {
            vs[i2] = this.tx.getVertex(vs[i2].getLongId());
        }
        v = this.tx.getVertex(v.getLongId());
        u = this.tx.getVertex(u.getLongId());
        Object[] qvs = new TitanVertex[]{vs[6], vs[9], vs[12], vs[15], vs[60]};
        Assert.assertEquals((long)(2 * (noVertices - 1)), (long)Iterables.size((Iterable)v.getEdges()));
        Assert.assertEquals((long)10L, (long)Iterables.size((Iterable)v.query().labels(new String[]{"connect"}).limit(10).vertices()));
        Assert.assertEquals((long)10L, (long)Iterables.size((Iterable)u.query().labels(new String[]{"connectDesc"}).limit(10).vertices()));
        Assert.assertEquals((long)10L, (long)Iterables.size((Iterable)v.query().labels(new String[]{"connect"}).has("time", (Predicate)Compare.GREATER_THAN, (Object)30).limit(10).vertices()));
        Assert.assertEquals((long)10L, (long)Iterables.size((Iterable)u.query().labels(new String[]{"connectDesc"}).has("time", (Predicate)Compare.GREATER_THAN, (Object)30).limit(10).vertices()));
        int lastTime = 0;
        for (Edge e : v.query().labels(new String[]{"connect"}).direction(Direction.OUT).limit(20).edges()) {
            int nowTime2 = (Integer)e.getProperty("time");
            Assert.assertTrue((String)(lastTime + " vs. " + nowTime2), (lastTime <= nowTime2 ? 1 : 0) != 0);
            lastTime = nowTime2;
        }
        lastTime = Integer.MAX_VALUE;
        for (Edge e : u.query().labels(new String[]{"connectDesc"}).direction(Direction.OUT).limit(20).edges()) {
            int nowTime3 = (Integer)e.getProperty("time");
            Assert.assertTrue((String)(lastTime + " vs. " + nowTime3), (lastTime >= nowTime3 ? 1 : 0) != 0);
            lastTime = nowTime3;
        }
        Assert.assertEquals((long)10L, (long)Iterables.size((Iterable)v.query().labels(new String[]{"connect"}).direction(Direction.OUT).has("time", (Predicate)Compare.GREATER_THAN, (Object)60).limit(10).vertices()));
        Assert.assertEquals((long)10L, (long)Iterables.size((Iterable)u.query().labels(new String[]{"connectDesc"}).direction(Direction.OUT).has("time", (Predicate)Compare.GREATER_THAN, (Object)60).limit(10).vertices()));
        Iterator outer = v.query().labels(new String[]{"connect"}).direction(Direction.OUT).limit(20).edges().iterator();
        for (Edge e : v.query().labels(new String[]{"connect"}).direction(Direction.OUT).limit(10).edges()) {
            Assert.assertEquals((Object)e, outer.next());
        }
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(31)), RelationCategory.EDGE, 10, 1, new boolean[]{true, true});
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).direction(Direction.OUT).has("time", (Object)15).has("weight", (Object)3.5), RelationCategory.EDGE, 1, 1, new boolean[]{false, true});
        TitanGraphTest.evaluateQuery(u.query().labels(new String[]{"connectDesc"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(31)), RelationCategory.EDGE, 10, 1, new boolean[]{true, true});
        Assert.assertEquals((long)10L, (long)v.query().labels(new String[]{"connect"}).direction(Direction.IN).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(31)).count());
        Assert.assertEquals((long)10L, (long)u.query().labels(new String[]{"connectDesc"}).direction(Direction.IN).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(31)).count());
        Assert.assertEquals((long)0L, (long)v.query().labels(new String[]{"connect"}).direction(Direction.OUT).has("time", null).count());
        Assert.assertEquals((long)10L, (long)v.query().labels(new String[]{"connect"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(31)).vertexIds().size());
        Assert.assertEquals((long)(edgesPerLabel - 10), (long)v.query().labels(new String[]{"connect"}).direction(Direction.OUT).has("time", (Predicate)Compare.GREATER_THAN, (Object)31).count());
        Assert.assertEquals((long)10L, (long)Iterables.size((Iterable)v.query().labels(new String[]{"connect"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(31)).vertices()));
        Assert.assertEquals((long)3L, (long)v.query().labels(new String[]{"friend"}).direction(Direction.OUT).limit(3).count());
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).has("weight", (Object)0.5).limit(3), RelationCategory.EDGE, 3, 1, new boolean[]{true, true});
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(33)).has("weight", (Object)0.5), RelationCategory.EDGE, 3, 1, new boolean[]{true, true});
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(33)).has("weight", (Predicate)Contain.IN, (Object)ImmutableList.of((Object)0.5)), RelationCategory.EDGE, 3, 1, new boolean[]{true, true});
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).has("weight", (Predicate)Contain.IN, (Object)ImmutableList.of((Object)0.5, (Object)1.5, (Object)2.5)).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(33)), RelationCategory.EDGE, 7, 3, new boolean[]{true, true});
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).has("weight", (Predicate)Contain.IN, (Object)ImmutableList.of((Object)0.5, (Object)1.5)), RelationCategory.EDGE, 1667, 2, new boolean[]{true, true});
        Assert.assertEquals((long)3L, (long)u.query().labels(new String[]{"friendDesc"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(33)).has("weight", (Object)0.5).count());
        Assert.assertEquals((long)1L, (long)v.query().labels(new String[]{"friend"}).direction(Direction.OUT).has("weight", (Object)0.5).interval("time", (Comparable)Integer.valueOf(4), (Comparable)Integer.valueOf(10)).count());
        Assert.assertEquals((long)1L, (long)u.query().labels(new String[]{"friendDesc"}).direction(Direction.OUT).has("weight", (Object)0.5).interval("time", (Comparable)Integer.valueOf(4), (Comparable)Integer.valueOf(10)).count());
        Assert.assertEquals((long)3L, (long)v.query().labels(new String[]{"friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(33)).has("weight", (Object)0.5).count());
        Assert.assertEquals((long)4L, (long)v.query().labels(new String[]{"friend"}).direction(Direction.OUT).has("time", (Predicate)Compare.LESS_THAN_EQUAL, (Object)10).count());
        Assert.assertEquals((long)(edgesPerLabel - 4), (long)v.query().labels(new String[]{"friend"}).direction(Direction.OUT).has("time", (Predicate)Compare.GREATER_THAN, (Object)10).count());
        Assert.assertEquals((long)20L, (long)v.query().labels(new String[]{"friend", "connect"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(33)).count());
        Assert.assertEquals((long)((int)Math.ceil((double)edgesPerLabel / 5.0)), (long)v.query().labels(new String[]{"knows"}).direction(Direction.OUT).has("author", (Object)v).count());
        Assert.assertEquals((long)((int)Math.ceil((double)edgesPerLabel / 5.0)), (long)v.query().labels(new String[]{"knows"}).direction(Direction.OUT).has("author", (Object)v).interval("weight", (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(4.0)).count());
        Assert.assertEquals((long)((int)Math.ceil((double)edgesPerLabel / 10.0)), (long)v.query().labels(new String[]{"knows"}).direction(Direction.OUT).has("author", (Object)v).interval("weight", (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(2.0)).count());
        Assert.assertEquals((long)((int)Math.floor((double)edgesPerLabel / 10.0)), (long)v.query().labels(new String[]{"knows"}).direction(Direction.OUT).has("author", (Object)v).interval("weight", (Comparable)Double.valueOf(2.1), (Comparable)Double.valueOf(4.0)).count());
        Assert.assertEquals((long)20L, (long)Iterables.size((Iterable)v.query().labels(new String[]{"connect", "friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(33)).vertices()));
        Assert.assertEquals((long)20L, (long)Iterables.size((Iterable)v.query().labels(new String[]{"connect", "friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(33)).vertexIds()));
        Assert.assertEquals((long)30L, (long)v.query().labels(new String[]{"friend", "connect", "knows"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(33)).count());
        Assert.assertEquals((long)(noVertices - 2), (long)v.query().labels(new String[]{"friend", "connect", "knows"}).direction(Direction.OUT).has("time", (Predicate)Compare.NOT_EQUAL, (Object)10).count());
        Assert.assertEquals((long)0L, (long)v.query().has("age", null).labels(new String[]{"undefined"}).direction(Direction.OUT).count());
        Assert.assertEquals((long)1L, (long)v.query().labels(new String[]{"connect"}).direction(Direction.OUT).adjacent(vs[6]).has("time", (Object)6).count());
        Assert.assertEquals((long)1L, (long)v.query().labels(new String[]{"knows"}).direction(Direction.OUT).adjacent(vs[11]).count());
        Assert.assertEquals((long)1L, (long)v.query().labels(new String[]{"knows"}).direction(Direction.IN).adjacent(vs[11]).count());
        Assert.assertEquals((long)2L, (long)v.query().labels(new String[]{"knows"}).direction(Direction.BOTH).adjacent(vs[11]).count());
        Assert.assertEquals((long)1L, (long)v.query().labels(new String[]{"knows"}).direction(Direction.OUT).adjacent(vs[11]).has("weight", (Object)3.5).count());
        Assert.assertEquals((long)2L, (long)v.query().labels(new String[]{"connect"}).adjacent(vs[6]).has("time", (Object)6).count());
        Assert.assertEquals((long)0L, (long)v.query().labels(new String[]{"connect"}).adjacent(vs[8]).has("time", (Object)8).count());
        Assert.assertEquals((long)edgesPerLabel, (long)v.query().labels(new String[]{"connect"}).direction(Direction.OUT).count());
        Assert.assertEquals((long)edgesPerLabel, (long)v.query().labels(new String[]{"connect"}).direction(Direction.IN).count());
        Assert.assertEquals((long)(2 * edgesPerLabel), (long)v.query().labels(new String[]{"connect"}).direction(Direction.BOTH).count());
        Assert.assertEquals((long)edgesPerLabel, (long)v.query().labels(new String[]{"connect"}).has("undefined", null).direction(Direction.OUT).count());
        Assert.assertEquals((long)(2 * (int)Math.ceil((double)(noVertices - 1) / 4.0)), (long)Iterables.size((Iterable)v.query().labels(new String[]{"connect", "friend", "knows"}).has("weight", (Object)1.5).vertexIds()));
        Assert.assertEquals((long)1L, (long)v.query().direction(Direction.IN).has("time", (Object)1).count());
        Assert.assertEquals((long)10L, (long)v.query().direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(4), (Comparable)Integer.valueOf(14)).count());
        Assert.assertEquals((long)9L, (long)v.query().direction(Direction.IN).interval("time", (Comparable)Integer.valueOf(4), (Comparable)Integer.valueOf(14)).has("time", (Predicate)Compare.NOT_EQUAL, (Object)10).count());
        Assert.assertEquals((long)9L, (long)v.query().direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(4), (Comparable)Integer.valueOf(14)).has("time", (Predicate)Compare.NOT_EQUAL, (Object)10).count());
        Assert.assertEquals((long)(noVertices - 1), (long)Iterables.size((Iterable)v.query().direction(Direction.OUT).vertices()));
        Assert.assertEquals((long)(noVertices - 1), (long)Iterables.size((Iterable)v.query().direction(Direction.IN).vertices()));
        for (Direction dir : new Direction[]{Direction.IN, Direction.OUT}) {
            vl = v.query().labels(new String[0]).direction(dir).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(31)).vertexIds();
            vl.sort();
            for (i = 0; i < vl.size(); ++i) {
                Assert.assertEquals((long)vidsubset[i], (long)vl.getID(i));
            }
        }
        Assert.assertEquals((long)(2 * (noVertices - 1)), (long)Iterables.size((Iterable)v.getEdges()));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)v.query().properties()));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)v.query().keys(new String[]{"name"}).properties()));
        Map results = this.tx.multiQuery((TitanVertex[])qvs).direction(Direction.IN).labels(new String[]{"connect"}).titanEdges();
        for (Iterable result : results.values()) {
            Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)result));
        }
        results = this.tx.multiQuery((Collection)Sets.newHashSet((Object[])qvs)).labels(new String[]{"connect"}).titanEdges();
        for (Iterable result : results.values()) {
            Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)result));
        }
        results = this.tx.multiQuery((TitanVertex[])qvs).labels(new String[]{"knows"}).titanEdges();
        for (Iterable result : results.values()) {
            Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)result));
        }
        results = this.tx.multiQuery((TitanVertex[])qvs).titanEdges();
        for (Iterable result : results.values()) {
            Assert.assertEquals((long)4L, (long)Iterables.size((Iterable)result));
        }
        Map results2 = this.tx.multiQuery((TitanVertex[])qvs).properties();
        for (Iterable result : results2.values()) {
            Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)result));
        }
        results2 = this.tx.multiQuery((TitanVertex[])qvs).keys(new String[]{"name"}).properties();
        for (Iterable result : results2.values()) {
            Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)result));
        }
        this.clopen(new Object[0]);
        for (int i5 = 1; i5 < noVertices; ++i5) {
            vs[i5] = this.tx.getVertex(vs[i5].getLongId());
        }
        v = this.tx.getVertex(v.getLongId());
        u = this.tx.getVertex(u.getLongId());
        qvs = new TitanVertex[]{vs[6], vs[9], vs[12], vs[15], vs[60]};
        Assert.assertEquals((long)10L, (long)Iterables.size((Iterable)v.query().labels(new String[]{"connect"}).limit(10).vertices()));
        Assert.assertEquals((long)10L, (long)Iterables.size((Iterable)u.query().labels(new String[]{"connectDesc"}).limit(10).vertices()));
        Assert.assertEquals((long)10L, (long)Iterables.size((Iterable)v.query().labels(new String[]{"connect"}).has("time", (Predicate)Compare.GREATER_THAN, (Object)30).limit(10).vertices()));
        Assert.assertEquals((long)10L, (long)Iterables.size((Iterable)u.query().labels(new String[]{"connectDesc"}).has("time", (Predicate)Compare.GREATER_THAN, (Object)30).limit(10).vertices()));
        lastTime = 0;
        for (Edge e : v.query().labels(new String[]{"connect"}).direction(Direction.OUT).limit(20).edges()) {
            nowTime3 = (Integer)e.getProperty("time");
            Assert.assertTrue((String)(lastTime + " vs. " + nowTime3), (lastTime <= nowTime3 ? 1 : 0) != 0);
            lastTime = nowTime3;
        }
        lastTime = Integer.MAX_VALUE;
        for (Edge e : u.query().labels(new String[]{"connectDesc"}).direction(Direction.OUT).limit(20).edges()) {
            nowTime3 = (Integer)e.getProperty("time");
            Assert.assertTrue((String)(lastTime + " vs. " + nowTime3), (lastTime >= nowTime3 ? 1 : 0) != 0);
            lastTime = nowTime3;
        }
        Assert.assertEquals((long)10L, (long)Iterables.size((Iterable)v.query().labels(new String[]{"connect"}).direction(Direction.OUT).has("time", (Predicate)Compare.GREATER_THAN, (Object)60).limit(10).vertices()));
        Assert.assertEquals((long)10L, (long)Iterables.size((Iterable)u.query().labels(new String[]{"connectDesc"}).direction(Direction.OUT).has("time", (Predicate)Compare.GREATER_THAN, (Object)60).limit(10).vertices()));
        outer = v.query().labels(new String[]{"connect"}).direction(Direction.OUT).limit(20).edges().iterator();
        for (Edge e : v.query().labels(new String[]{"connect"}).direction(Direction.OUT).limit(10).edges()) {
            Assert.assertEquals((Object)e, outer.next());
        }
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(31)), RelationCategory.EDGE, 10, 1, new boolean[]{true, true});
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"connect"}).direction(Direction.OUT).has("time", (Object)15).has("weight", (Object)3.5), RelationCategory.EDGE, 1, 1, new boolean[]{false, true});
        TitanGraphTest.evaluateQuery(u.query().labels(new String[]{"connectDesc"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(31)), RelationCategory.EDGE, 10, 1, new boolean[]{true, true});
        Assert.assertEquals((long)10L, (long)v.query().labels(new String[]{"connect"}).direction(Direction.IN).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(31)).count());
        Assert.assertEquals((long)10L, (long)u.query().labels(new String[]{"connectDesc"}).direction(Direction.IN).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(31)).count());
        Assert.assertEquals((long)0L, (long)v.query().labels(new String[]{"connect"}).direction(Direction.OUT).has("time", null).count());
        Assert.assertEquals((long)10L, (long)v.query().labels(new String[]{"connect"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(31)).vertexIds().size());
        Assert.assertEquals((long)(edgesPerLabel - 10), (long)v.query().labels(new String[]{"connect"}).direction(Direction.OUT).has("time", (Predicate)Compare.GREATER_THAN, (Object)31).count());
        Assert.assertEquals((long)10L, (long)Iterables.size((Iterable)v.query().labels(new String[]{"connect"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(31)).vertices()));
        Assert.assertEquals((long)3L, (long)v.query().labels(new String[]{"friend"}).direction(Direction.OUT).limit(3).count());
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).has("weight", (Object)0.5).limit(3), RelationCategory.EDGE, 3, 1, new boolean[]{true, true});
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(33)).has("weight", (Object)0.5), RelationCategory.EDGE, 3, 1, new boolean[]{true, true});
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(33)).has("weight", (Predicate)Contain.IN, (Object)ImmutableList.of((Object)0.5)), RelationCategory.EDGE, 3, 1, new boolean[]{true, true});
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).has("weight", (Predicate)Contain.IN, (Object)ImmutableList.of((Object)0.5, (Object)1.5, (Object)2.5)).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(33)), RelationCategory.EDGE, 7, 3, new boolean[]{true, true});
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{"friend"}).direction(Direction.OUT).has("weight", (Predicate)Contain.IN, (Object)ImmutableList.of((Object)0.5, (Object)1.5)), RelationCategory.EDGE, 1667, 2, new boolean[]{true, true});
        Assert.assertEquals((long)3L, (long)u.query().labels(new String[]{"friendDesc"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(33)).has("weight", (Object)0.5).count());
        Assert.assertEquals((long)1L, (long)v.query().labels(new String[]{"friend"}).direction(Direction.OUT).has("weight", (Object)0.5).interval("time", (Comparable)Integer.valueOf(4), (Comparable)Integer.valueOf(10)).count());
        Assert.assertEquals((long)1L, (long)u.query().labels(new String[]{"friendDesc"}).direction(Direction.OUT).has("weight", (Object)0.5).interval("time", (Comparable)Integer.valueOf(4), (Comparable)Integer.valueOf(10)).count());
        Assert.assertEquals((long)3L, (long)v.query().labels(new String[]{"friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(33)).has("weight", (Object)0.5).count());
        Assert.assertEquals((long)4L, (long)v.query().labels(new String[]{"friend"}).direction(Direction.OUT).has("time", (Predicate)Compare.LESS_THAN_EQUAL, (Object)10).count());
        Assert.assertEquals((long)(edgesPerLabel - 4), (long)v.query().labels(new String[]{"friend"}).direction(Direction.OUT).has("time", (Predicate)Compare.GREATER_THAN, (Object)10).count());
        Assert.assertEquals((long)20L, (long)v.query().labels(new String[]{"friend", "connect"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(33)).count());
        Assert.assertEquals((long)((int)Math.ceil((double)edgesPerLabel / 5.0)), (long)v.query().labels(new String[]{"knows"}).direction(Direction.OUT).has("author", (Object)v).count());
        Assert.assertEquals((long)((int)Math.ceil((double)edgesPerLabel / 5.0)), (long)v.query().labels(new String[]{"knows"}).direction(Direction.OUT).has("author", (Object)v).interval("weight", (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(4.0)).count());
        Assert.assertEquals((long)((int)Math.ceil((double)edgesPerLabel / 10.0)), (long)v.query().labels(new String[]{"knows"}).direction(Direction.OUT).has("author", (Object)v).interval("weight", (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(2.0)).count());
        Assert.assertEquals((long)((int)Math.floor((double)edgesPerLabel / 10.0)), (long)v.query().labels(new String[]{"knows"}).direction(Direction.OUT).has("author", (Object)v).interval("weight", (Comparable)Double.valueOf(2.1), (Comparable)Double.valueOf(4.0)).count());
        Assert.assertEquals((long)20L, (long)Iterables.size((Iterable)v.query().labels(new String[]{"connect", "friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(33)).vertices()));
        Assert.assertEquals((long)20L, (long)Iterables.size((Iterable)v.query().labels(new String[]{"connect", "friend"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(33)).vertexIds()));
        Assert.assertEquals((long)30L, (long)v.query().labels(new String[]{"friend", "connect", "knows"}).direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(33)).count());
        Assert.assertEquals((long)(noVertices - 2), (long)v.query().labels(new String[]{"friend", "connect", "knows"}).direction(Direction.OUT).has("time", (Predicate)Compare.NOT_EQUAL, (Object)10).count());
        Assert.assertEquals((long)0L, (long)v.query().has("age", null).labels(new String[]{"undefined"}).direction(Direction.OUT).count());
        Assert.assertEquals((long)1L, (long)v.query().labels(new String[]{"connect"}).direction(Direction.OUT).adjacent(vs[6]).has("time", (Object)6).count());
        Assert.assertEquals((long)1L, (long)v.query().labels(new String[]{"knows"}).direction(Direction.OUT).adjacent(vs[11]).count());
        Assert.assertEquals((long)1L, (long)v.query().labels(new String[]{"knows"}).direction(Direction.IN).adjacent(vs[11]).count());
        Assert.assertEquals((long)2L, (long)v.query().labels(new String[]{"knows"}).direction(Direction.BOTH).adjacent(vs[11]).count());
        Assert.assertEquals((long)1L, (long)v.query().labels(new String[]{"knows"}).direction(Direction.OUT).adjacent(vs[11]).has("weight", (Object)3.5).count());
        Assert.assertEquals((long)2L, (long)v.query().labels(new String[]{"connect"}).adjacent(vs[6]).has("time", (Object)6).count());
        Assert.assertEquals((long)0L, (long)v.query().labels(new String[]{"connect"}).adjacent(vs[8]).has("time", (Object)8).count());
        Assert.assertEquals((long)edgesPerLabel, (long)v.query().labels(new String[]{"connect"}).direction(Direction.OUT).count());
        Assert.assertEquals((long)edgesPerLabel, (long)v.query().labels(new String[]{"connect"}).direction(Direction.IN).count());
        Assert.assertEquals((long)(2 * edgesPerLabel), (long)v.query().labels(new String[]{"connect"}).direction(Direction.BOTH).count());
        Assert.assertEquals((long)edgesPerLabel, (long)v.query().labels(new String[]{"connect"}).has("undefined", null).direction(Direction.OUT).count());
        Assert.assertEquals((long)(2 * (int)Math.ceil((double)(noVertices - 1) / 4.0)), (long)Iterables.size((Iterable)v.query().labels(new String[]{"connect", "friend", "knows"}).has("weight", (Object)1.5).vertexIds()));
        Assert.assertEquals((long)1L, (long)v.query().direction(Direction.IN).has("time", (Object)1).count());
        Assert.assertEquals((long)10L, (long)v.query().direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(4), (Comparable)Integer.valueOf(14)).count());
        Assert.assertEquals((long)9L, (long)v.query().direction(Direction.IN).interval("time", (Comparable)Integer.valueOf(4), (Comparable)Integer.valueOf(14)).has("time", (Predicate)Compare.NOT_EQUAL, (Object)10).count());
        Assert.assertEquals((long)9L, (long)v.query().direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(4), (Comparable)Integer.valueOf(14)).has("time", (Predicate)Compare.NOT_EQUAL, (Object)10).count());
        Assert.assertEquals((long)(noVertices - 1), (long)Iterables.size((Iterable)v.query().direction(Direction.OUT).vertices()));
        Assert.assertEquals((long)(noVertices - 1), (long)Iterables.size((Iterable)v.query().direction(Direction.IN).vertices()));
        for (Direction dir : new Direction[]{Direction.IN, Direction.OUT}) {
            vl = v.query().labels(new String[0]).direction(dir).interval("time", (Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(31)).vertexIds();
            vl.sort();
            for (i = 0; i < vl.size(); ++i) {
                Assert.assertEquals((long)vidsubset[i], (long)vl.getID(i));
            }
        }
        Assert.assertEquals((long)(2 * (noVertices - 1)), (long)Iterables.size((Iterable)v.getEdges()));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)v.query().properties()));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)v.query().keys(new String[]{"name"}).properties()));
        results = this.tx.multiQuery((TitanVertex[])qvs).direction(Direction.IN).labels(new String[]{"connect"}).titanEdges();
        for (Iterable result : results.values()) {
            Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)result));
        }
        results = this.tx.multiQuery((Collection)Sets.newHashSet((Object[])qvs)).labels(new String[]{"connect"}).titanEdges();
        for (Iterable result : results.values()) {
            Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)result));
        }
        results = this.tx.multiQuery((TitanVertex[])qvs).labels(new String[]{"knows"}).titanEdges();
        for (Iterable result : results.values()) {
            Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)result));
        }
        results = this.tx.multiQuery((TitanVertex[])qvs).titanEdges();
        for (Iterable result : results.values()) {
            Assert.assertEquals((long)4L, (long)Iterables.size((Iterable)result));
        }
        results2 = this.tx.multiQuery((TitanVertex[])qvs).properties();
        for (Iterable result : results2.values()) {
            Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)result));
        }
        results2 = this.tx.multiQuery((TitanVertex[])qvs).keys(new String[]{"name"}).properties();
        for (Iterable result : results2.values()) {
            Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)result));
        }
        this.newTx();
        v = (TitanVertex)this.tx.getVertices("name", (Object)"v").iterator().next();
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((long)2L, (long)v.query().has("weight", (Object)1.5).interval("time", (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(30)).limit(2).vertexIds().size());
        Assert.assertEquals((long)10L, (long)v.query().has("weight", (Object)1.5).interval("time", (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(30)).vertexIds().size());
        this.newTx();
        v = (TitanVertex)this.tx.getVertices("name", (Object)"v").iterator().next();
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((long)2L, (long)v.query().has("weight", (Object)1.5).interval("time", (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(30)).limit(2).count());
        Assert.assertEquals((long)10L, (long)v.query().has("weight", (Object)1.5).interval("time", (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(30)).count());
        this.newTx();
        TitanVertex[] qvs2 = new TitanVertex[qvs.length + 2];
        qvs2[0] = this.tx.addVertex();
        for (int i6 = 0; i6 < qvs.length; ++i6) {
            qvs2[i6 + 1] = this.tx.getVertex(qvs[i6].getLongId());
        }
        qvs2[qvs2.length - 1] = this.tx.addVertex();
        qvs2[0].addEdge("connect", qvs2[qvs2.length - 1]);
        qvs2[qvs2.length - 1].addEdge("connect", qvs2[0]);
        results = this.tx.multiQuery(qvs2).direction(Direction.IN).labels(new String[]{"connect"}).titanEdges();
        for (Iterable result : results.values()) {
            Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)result));
        }
    }

    @Test
    public void testRelationTypeIndexes() {
        PropertyKey weight = this.makeKey("weight", Decimal.class);
        PropertyKey time = this.makeKey("time", Long.class);
        PropertyKey name = this.mgmt.makePropertyKey("name").dataType(String.class).cardinality(Cardinality.LIST).make();
        EdgeLabel connect = this.mgmt.makeEdgeLabel("connect").signature(new RelationType[]{time}).make();
        EdgeLabel child = this.mgmt.makeEdgeLabel("child").multiplicity(Multiplicity.ONE2MANY).make();
        EdgeLabel link = this.mgmt.makeEdgeLabel("link").unidirected().make();
        RelationTypeIndex name1 = this.mgmt.buildPropertyIndex(name, "weightDesc", new RelationType[]{weight});
        RelationTypeIndex connect1 = this.mgmt.buildEdgeIndex(connect, "weightAsc", Direction.BOTH, Order.ASC, new RelationType[]{weight});
        RelationTypeIndex connect2 = this.mgmt.buildEdgeIndex(connect, "weightDesc", Direction.OUT, Order.DESC, new RelationType[]{weight});
        RelationTypeIndex connect3 = this.mgmt.buildEdgeIndex(connect, "time+weight", Direction.OUT, Order.DESC, new RelationType[]{time, weight});
        RelationTypeIndex child1 = this.mgmt.buildEdgeIndex(child, "time", Direction.OUT, new RelationType[]{time});
        RelationTypeIndex link1 = this.mgmt.buildEdgeIndex(link, "time", Direction.OUT, new RelationType[]{time});
        String name1n = name1.getName();
        String connect1n = connect1.getName();
        String connect2n = connect2.getName();
        String connect3n = connect3.getName();
        String child1n = child1.getName();
        String link1n = link1.getName();
        Assert.assertTrue((boolean)this.mgmt.containsRelationIndex((RelationType)name, "weightDesc"));
        Assert.assertTrue((boolean)this.mgmt.containsRelationIndex((RelationType)connect, "weightDesc"));
        Assert.assertFalse((boolean)this.mgmt.containsRelationIndex((RelationType)child, "weightDesc"));
        Assert.assertEquals((Object)"time+weight", (Object)this.mgmt.getRelationIndex((RelationType)connect, "time+weight").getName());
        Assert.assertNotNull((Object)this.mgmt.getRelationIndex((RelationType)link, "time"));
        Assert.assertNull((Object)this.mgmt.getRelationIndex((RelationType)name, "time"));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)this.mgmt.getRelationIndexes((RelationType)child)));
        Assert.assertEquals((long)3L, (long)Iterables.size((Iterable)this.mgmt.getRelationIndexes((RelationType)connect)));
        Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)this.mgmt.getRelationIndexes((RelationType)weight)));
        try {
            this.mgmt.buildEdgeIndex(connect, "weightAsc", Direction.OUT, new RelationType[]{time});
            Assert.fail();
        }
        catch (SchemaViolationException schemaViolationException) {
            // empty catch block
        }
        try {
            this.mgmt.buildEdgeIndex(child, "blablub", Direction.IN, new RelationType[]{time});
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.mgmt.buildEdgeIndex(link, "blablub", Direction.BOTH, new RelationType[]{time});
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.finishSchema();
        weight = this.mgmt.getPropertyKey("weight");
        time = this.mgmt.getPropertyKey("time");
        name = this.mgmt.getPropertyKey("name");
        connect = this.mgmt.getEdgeLabel("connect");
        child = this.mgmt.getEdgeLabel("child");
        link = this.mgmt.getEdgeLabel("link");
        Assert.assertTrue((boolean)this.mgmt.containsRelationIndex((RelationType)name, "weightDesc"));
        Assert.assertTrue((boolean)this.mgmt.containsRelationIndex((RelationType)connect, "weightDesc"));
        Assert.assertFalse((boolean)this.mgmt.containsRelationIndex((RelationType)child, "weightDesc"));
        Assert.assertEquals((Object)"time+weight", (Object)this.mgmt.getRelationIndex((RelationType)connect, "time+weight").getName());
        Assert.assertNotNull((Object)this.mgmt.getRelationIndex((RelationType)link, "time"));
        Assert.assertNull((Object)this.mgmt.getRelationIndex((RelationType)name, "time"));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)this.mgmt.getRelationIndexes((RelationType)child)));
        Assert.assertEquals((long)3L, (long)Iterables.size((Iterable)this.mgmt.getRelationIndexes((RelationType)connect)));
        Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)this.mgmt.getRelationIndexes((RelationType)weight)));
        try {
            this.mgmt.buildEdgeIndex(connect, "weightAsc", Direction.OUT, new RelationType[]{time});
            Assert.fail();
        }
        catch (SchemaViolationException schemaViolationException) {
            // empty catch block
        }
        try {
            this.mgmt.buildEdgeIndex(child, "blablub", Direction.IN, new RelationType[]{time});
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.mgmt.buildEdgeIndex(link, "blablub", Direction.BOTH, new RelationType[]{time});
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.mgmt.rollback();
        weight = this.tx.getPropertyKey("weight");
        time = this.tx.getPropertyKey("time");
        name = this.tx.getPropertyKey("name");
        connect = this.tx.getEdgeLabel("connect");
        child = this.tx.getEdgeLabel("child");
        link = this.tx.getEdgeLabel("link");
        int numV = 100;
        TitanVertex v = this.tx.addVertex();
        TitanVertex[] ns = new TitanVertex[100];
        for (int i = 0; i < 100; ++i) {
            double w = (double)i * 0.5 % 5.0;
            long t = (i + 77) % 100;
            TitanProperty p = v.addProperty(name, (Object)("v" + i));
            p.setProperty(weight, (Object)w);
            p.setProperty(time, (Object)t);
            ns[i] = this.tx.addVertex();
            for (EdgeLabel label : new EdgeLabel[]{connect, child, link}) {
                TitanEdge e = v.addEdge(label, ns[i]);
                e.setProperty(weight, (Object)w);
                e.setProperty(time, (Object)t);
            }
        }
        TitanVertex u = ns[0];
        v = (TitanVertex)this.tx.getVertex((Object)v);
        u = (TitanVertex)this.tx.getVertex((Object)u);
        TitanGraphTest.evaluateQuery(v.query().keys(new String[]{name.getName()}).has(weight, (Predicate)Cmp.GREATER_THAN, (Object)3.6), RelationCategory.PROPERTY, 20, 1, new boolean[]{false, true});
        TitanGraphTest.evaluateQuery(v.query().keys(new String[]{name.getName()}).has(weight, (Predicate)Cmp.LESS_THAN, (Object)0.9).orderBy(weight, Order.ASC), RelationCategory.PROPERTY, 20, 1, new boolean[]{true, true}, weight, Order.ASC);
        TitanGraphTest.evaluateQuery(v.query().keys(new String[]{name.getName()}).interval(weight, (Comparable)Double.valueOf(1.1), (Comparable)Double.valueOf(2.2)).orderBy(weight, Order.DESC).limit(10), RelationCategory.PROPERTY, 10, 1, new boolean[]{true, false}, weight, Order.DESC);
        TitanGraphTest.evaluateQuery(v.query().keys(new String[]{name.getName()}).has(time, (Predicate)Cmp.EQUAL, (Object)5).orderBy(weight, Order.DESC), RelationCategory.PROPERTY, 1, 1, new boolean[]{false, false}, weight, Order.DESC);
        TitanGraphTest.evaluateQuery(v.query().keys(new String[]{name.getName()}), RelationCategory.PROPERTY, 100, 1, new boolean[]{true, true});
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{child.getName()}).direction(Direction.OUT).has(time, (Predicate)Cmp.EQUAL, (Object)5), RelationCategory.EDGE, 1, 1, new boolean[]{true, true});
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{child.getName()}).direction(Direction.BOTH).has(time, (Predicate)Cmp.EQUAL, (Object)5), RelationCategory.EDGE, 1, 2, new boolean[0]);
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{child.getName()}).direction(Direction.OUT).interval(time, (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(20)).orderBy(weight, Order.DESC).limit(5), RelationCategory.EDGE, 5, 1, new boolean[]{true, false}, weight, Order.DESC);
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{child.getName()}).direction(Direction.BOTH).interval(weight, (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(1.0)).orderBy(weight, Order.DESC), RelationCategory.EDGE, 20, 2, new boolean[]{false, false}, weight, Order.DESC);
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{child.getName()}).direction(Direction.OUT).interval(weight, (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(1.0)), RelationCategory.EDGE, 20, 1, new boolean[]{false, true});
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{child.getName()}).direction(Direction.BOTH), RelationCategory.EDGE, 100, 1, new boolean[]{true, true});
        VertexList vl = v.query().labels(new String[]{child.getName()}).direction(Direction.BOTH).vertexIds();
        Assert.assertEquals((long)100L, (long)vl.size());
        Assert.assertTrue((boolean)vl.isSorted());
        Assert.assertTrue((boolean)this.isSortedByID(vl));
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{child.getName()}).interval(weight, (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(1.0)).direction(Direction.OUT), RelationCategory.EDGE, 20, 1, new boolean[]{false, true});
        vl = v.query().labels(new String[]{child.getName()}).interval(weight, (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(1.0)).direction(Direction.OUT).vertexIds();
        Assert.assertEquals((long)20L, (long)vl.size());
        Assert.assertTrue((boolean)vl.isSorted());
        Assert.assertTrue((boolean)this.isSortedByID(vl));
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{child.getName()}).interval(time, (Comparable)Integer.valueOf(70), (Comparable)Integer.valueOf(80)).direction(Direction.OUT).orderBy(time, Order.ASC), RelationCategory.EDGE, 10, 1, new boolean[]{true, true}, time, Order.ASC);
        vl = v.query().labels(new String[]{child.getName()}).interval(time, (Comparable)Integer.valueOf(70), (Comparable)Integer.valueOf(80)).direction(Direction.OUT).orderBy(time, Order.ASC).vertexIds();
        Assert.assertEquals((long)10L, (long)vl.size());
        Assert.assertFalse((boolean)vl.isSorted());
        Assert.assertFalse((boolean)this.isSortedByID(vl));
        vl.sort();
        Assert.assertTrue((boolean)vl.isSorted());
        Assert.assertTrue((boolean)this.isSortedByID(vl));
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{connect.getName()}).has(time, (Predicate)Cmp.EQUAL, (Object)5).interval(weight, (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(5.0)).direction(Direction.OUT), RelationCategory.EDGE, 1, 1, new boolean[]{true, true});
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{connect.getName()}).has(time, (Predicate)Cmp.EQUAL, (Object)5).interval(weight, (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(5.0)).direction(Direction.BOTH), RelationCategory.EDGE, 1, 2, new boolean[0]);
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{connect.getName()}).interval(time, (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(20)).interval(weight, (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(5.0)).direction(Direction.OUT), RelationCategory.EDGE, 10, 1, new boolean[]{false, true});
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{connect.getName()}).direction(Direction.OUT).orderBy(weight, Order.ASC).limit(10), RelationCategory.EDGE, 10, 1, new boolean[]{true, true}, weight, Order.ASC);
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{connect.getName()}).direction(Direction.OUT).orderBy(weight, Order.DESC).limit(10), RelationCategory.EDGE, 10, 1, new boolean[]{true, true}, weight, Order.DESC);
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{connect.getName()}).direction(Direction.OUT).interval(weight, (Comparable)Double.valueOf(1.4), (Comparable)Double.valueOf(2.75)).orderBy(weight, Order.DESC), RelationCategory.EDGE, 30, 1, new boolean[]{true, true}, weight, Order.DESC);
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{connect.getName()}).direction(Direction.OUT).has(time, (Predicate)Cmp.EQUAL, (Object)22).orderBy(weight, Order.DESC), RelationCategory.EDGE, 1, 1, new boolean[]{true, true}, weight, Order.DESC);
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{connect.getName()}).direction(Direction.OUT).has(time, (Predicate)Cmp.EQUAL, (Object)22).orderBy(weight, Order.ASC), RelationCategory.EDGE, 1, 1, new boolean[]{true, false}, weight, Order.ASC);
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{connect.getName()}).direction(Direction.OUT).adjacent(u), RelationCategory.EDGE, 1, 1, new boolean[]{true, true});
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{connect.getName()}).direction(Direction.OUT).has(weight, (Predicate)Cmp.EQUAL, (Object)0.0).adjacent(u), RelationCategory.EDGE, 1, 1, new boolean[]{true, true});
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{connect.getName()}).direction(Direction.OUT).interval(weight, (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(1.0)).adjacent(u), RelationCategory.EDGE, 1, 1, new boolean[]{false, true});
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{connect.getName()}).direction(Direction.OUT).interval(time, (Comparable)Integer.valueOf(50), (Comparable)Integer.valueOf(100)).adjacent(u), RelationCategory.EDGE, 1, 1, new boolean[]{false, true});
        TitanGraphTest.evaluateQuery(v.query(), RelationCategory.RELATION, 400, 1, new boolean[]{true, true});
        TitanGraphTest.evaluateQuery(v.query().direction(Direction.OUT), RelationCategory.RELATION, 400, 1, new boolean[]{false, true});
        this.clopen(new Object[0]);
        weight = this.tx.getPropertyKey("weight");
        time = this.tx.getPropertyKey("time");
        name = this.tx.getPropertyKey("name");
        connect = this.tx.getEdgeLabel("connect");
        child = this.tx.getEdgeLabel("child");
        link = this.tx.getEdgeLabel("link");
        v = (TitanVertex)this.tx.getVertex((Object)v);
        u = (TitanVertex)this.tx.getVertex((Object)u);
        TitanGraphTest.evaluateQuery(v.query().keys(new String[]{name.getName()}).has(weight, (Predicate)Cmp.GREATER_THAN, (Object)3.6), RelationCategory.PROPERTY, 20, 1, new boolean[]{false, true});
        TitanGraphTest.evaluateQuery(v.query().keys(new String[]{name.getName()}).has(weight, (Predicate)Cmp.LESS_THAN, (Object)0.9).orderBy(weight, Order.ASC), RelationCategory.PROPERTY, 20, 1, new boolean[]{true, true}, weight, Order.ASC);
        TitanGraphTest.evaluateQuery(v.query().keys(new String[]{name.getName()}).interval(weight, (Comparable)Double.valueOf(1.1), (Comparable)Double.valueOf(2.2)).orderBy(weight, Order.DESC).limit(10), RelationCategory.PROPERTY, 10, 1, new boolean[]{true, false}, weight, Order.DESC);
        TitanGraphTest.evaluateQuery(v.query().keys(new String[]{name.getName()}).has(time, (Predicate)Cmp.EQUAL, (Object)5).orderBy(weight, Order.DESC), RelationCategory.PROPERTY, 1, 1, new boolean[]{false, false}, weight, Order.DESC);
        TitanGraphTest.evaluateQuery(v.query().keys(new String[]{name.getName()}), RelationCategory.PROPERTY, 100, 1, new boolean[]{true, true});
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{child.getName()}).direction(Direction.OUT).has(time, (Predicate)Cmp.EQUAL, (Object)5), RelationCategory.EDGE, 1, 1, new boolean[]{true, true});
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{child.getName()}).direction(Direction.BOTH).has(time, (Predicate)Cmp.EQUAL, (Object)5), RelationCategory.EDGE, 1, 2, new boolean[0]);
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{child.getName()}).direction(Direction.OUT).interval(time, (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(20)).orderBy(weight, Order.DESC).limit(5), RelationCategory.EDGE, 5, 1, new boolean[]{true, false}, weight, Order.DESC);
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{child.getName()}).direction(Direction.BOTH).interval(weight, (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(1.0)).orderBy(weight, Order.DESC), RelationCategory.EDGE, 20, 2, new boolean[]{false, false}, weight, Order.DESC);
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{child.getName()}).direction(Direction.OUT).interval(weight, (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(1.0)), RelationCategory.EDGE, 20, 1, new boolean[]{false, true});
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{child.getName()}).direction(Direction.BOTH), RelationCategory.EDGE, 100, 1, new boolean[]{true, true});
        vl = v.query().labels(new String[]{child.getName()}).direction(Direction.BOTH).vertexIds();
        Assert.assertEquals((long)100L, (long)vl.size());
        Assert.assertTrue((boolean)vl.isSorted());
        Assert.assertTrue((boolean)this.isSortedByID(vl));
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{child.getName()}).interval(weight, (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(1.0)).direction(Direction.OUT), RelationCategory.EDGE, 20, 1, new boolean[]{false, true});
        vl = v.query().labels(new String[]{child.getName()}).interval(weight, (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(1.0)).direction(Direction.OUT).vertexIds();
        Assert.assertEquals((long)20L, (long)vl.size());
        Assert.assertTrue((boolean)vl.isSorted());
        Assert.assertTrue((boolean)this.isSortedByID(vl));
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{child.getName()}).interval(time, (Comparable)Integer.valueOf(70), (Comparable)Integer.valueOf(80)).direction(Direction.OUT).orderBy(time, Order.ASC), RelationCategory.EDGE, 10, 1, new boolean[]{true, true}, time, Order.ASC);
        vl = v.query().labels(new String[]{child.getName()}).interval(time, (Comparable)Integer.valueOf(70), (Comparable)Integer.valueOf(80)).direction(Direction.OUT).orderBy(time, Order.ASC).vertexIds();
        Assert.assertEquals((long)10L, (long)vl.size());
        Assert.assertFalse((boolean)vl.isSorted());
        Assert.assertFalse((boolean)this.isSortedByID(vl));
        vl.sort();
        Assert.assertTrue((boolean)vl.isSorted());
        Assert.assertTrue((boolean)this.isSortedByID(vl));
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{connect.getName()}).has(time, (Predicate)Cmp.EQUAL, (Object)5).interval(weight, (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(5.0)).direction(Direction.OUT), RelationCategory.EDGE, 1, 1, new boolean[]{true, true});
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{connect.getName()}).has(time, (Predicate)Cmp.EQUAL, (Object)5).interval(weight, (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(5.0)).direction(Direction.BOTH), RelationCategory.EDGE, 1, 2, new boolean[0]);
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{connect.getName()}).interval(time, (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(20)).interval(weight, (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(5.0)).direction(Direction.OUT), RelationCategory.EDGE, 10, 1, new boolean[]{false, true});
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{connect.getName()}).direction(Direction.OUT).orderBy(weight, Order.ASC).limit(10), RelationCategory.EDGE, 10, 1, new boolean[]{true, true}, weight, Order.ASC);
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{connect.getName()}).direction(Direction.OUT).orderBy(weight, Order.DESC).limit(10), RelationCategory.EDGE, 10, 1, new boolean[]{true, true}, weight, Order.DESC);
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{connect.getName()}).direction(Direction.OUT).interval(weight, (Comparable)Double.valueOf(1.4), (Comparable)Double.valueOf(2.75)).orderBy(weight, Order.DESC), RelationCategory.EDGE, 30, 1, new boolean[]{true, true}, weight, Order.DESC);
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{connect.getName()}).direction(Direction.OUT).has(time, (Predicate)Cmp.EQUAL, (Object)22).orderBy(weight, Order.DESC), RelationCategory.EDGE, 1, 1, new boolean[]{true, true}, weight, Order.DESC);
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{connect.getName()}).direction(Direction.OUT).has(time, (Predicate)Cmp.EQUAL, (Object)22).orderBy(weight, Order.ASC), RelationCategory.EDGE, 1, 1, new boolean[]{true, false}, weight, Order.ASC);
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{connect.getName()}).direction(Direction.OUT).adjacent(u), RelationCategory.EDGE, 1, 1, new boolean[]{true, true});
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{connect.getName()}).direction(Direction.OUT).has(weight, (Predicate)Cmp.EQUAL, (Object)0.0).adjacent(u), RelationCategory.EDGE, 1, 1, new boolean[]{true, true});
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{connect.getName()}).direction(Direction.OUT).interval(weight, (Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(1.0)).adjacent(u), RelationCategory.EDGE, 1, 1, new boolean[]{false, true});
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{connect.getName()}).direction(Direction.OUT).interval(time, (Comparable)Integer.valueOf(50), (Comparable)Integer.valueOf(100)).adjacent(u), RelationCategory.EDGE, 1, 1, new boolean[]{false, true});
        TitanGraphTest.evaluateQuery(v.query(), RelationCategory.RELATION, 400, 1, new boolean[]{true, true});
        TitanGraphTest.evaluateQuery(v.query().direction(Direction.OUT), RelationCategory.RELATION, 400, 1, new boolean[]{false, true});
        for (TitanProperty p : v.getProperties(name)) {
            if ((Long)p.getProperty(time) >= 50L) continue;
            p.remove();
        }
        for (TitanEdge e : v.getEdges()) {
            if ((Long)e.getProperty(time) >= 50L) continue;
            e.remove();
        }
        ns = new TitanVertex[150];
        for (int i = 100; i < 150; ++i) {
            double w = (double)i * 0.5 % 5.0;
            long t = i;
            TitanProperty p = v.addProperty(name, (Object)("v" + i));
            p.setProperty(weight, (Object)w);
            p.setProperty(time, (Object)t);
            ns[i] = this.tx.addVertex();
            for (EdgeLabel label : new EdgeLabel[]{connect, child, link}) {
                TitanEdge e = v.addEdge(label, ns[i]);
                e.setProperty(weight, (Object)w);
                e.setProperty(time, (Object)t);
            }
        }
        TitanGraphTest.evaluateQuery(v.query().keys(new String[]{name.getName()}).has(weight, (Predicate)Cmp.GREATER_THAN, (Object)3.6), RelationCategory.PROPERTY, 20, 1, new boolean[]{false, true});
        TitanGraphTest.evaluateQuery(v.query().keys(new String[]{name.getName()}).interval(time, (Comparable)Integer.valueOf(40), (Comparable)Integer.valueOf(60)), RelationCategory.PROPERTY, 10, 1, new boolean[]{false, true});
        TitanGraphTest.evaluateQuery(v.query().keys(new String[]{name.getName()}).interval(time, (Comparable)Integer.valueOf(40), (Comparable)Integer.valueOf(60)).orderBy(weight, Order.DESC), RelationCategory.PROPERTY, 10, 1, new boolean[]{false, false}, weight, Order.DESC);
        TitanGraphTest.evaluateQuery(v.query().keys(new String[]{name.getName()}).interval(time, (Comparable)Integer.valueOf(100), (Comparable)Integer.valueOf(110)).limit(5), RelationCategory.PROPERTY, 5, 1, new boolean[]{false, true});
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{child.getName()}).direction(Direction.OUT).has(time, (Predicate)Cmp.EQUAL, (Object)5), RelationCategory.EDGE, 0, 1, new boolean[]{true, true});
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{child.getName()}).direction(Direction.OUT).has(time, (Predicate)Cmp.EQUAL, (Object)105), RelationCategory.EDGE, 1, 1, new boolean[]{true, true});
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{child.getName()}).direction(Direction.OUT).interval(time, (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(20)).orderBy(weight, Order.DESC).limit(5), RelationCategory.EDGE, 0, 1, new boolean[]{true, false}, weight, Order.DESC);
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{child.getName()}).direction(Direction.OUT).interval(time, (Comparable)Integer.valueOf(110), (Comparable)Integer.valueOf(120)).orderBy(weight, Order.DESC).limit(5), RelationCategory.EDGE, 5, 1, new boolean[]{true, false}, weight, Order.DESC);
        TitanGraphTest.evaluateQuery(v.query(), RelationCategory.RELATION, 400, 1, new boolean[]{true, true});
        TitanGraphTest.evaluateQuery(v.query().direction(Direction.OUT), RelationCategory.RELATION, 400, 1, new boolean[]{false, true});
        this.newTx();
        weight = this.tx.getPropertyKey("weight");
        time = this.tx.getPropertyKey("time");
        name = this.tx.getPropertyKey("name");
        connect = this.tx.getEdgeLabel("connect");
        child = this.tx.getEdgeLabel("child");
        link = this.tx.getEdgeLabel("link");
        v = (TitanVertex)this.tx.getVertex((Object)v);
        u = (TitanVertex)this.tx.getVertex((Object)u);
        TitanGraphTest.evaluateQuery(v.query().keys(new String[]{name.getName()}).has(weight, (Predicate)Cmp.GREATER_THAN, (Object)3.6), RelationCategory.PROPERTY, 20, 1, new boolean[]{false, true});
        TitanGraphTest.evaluateQuery(v.query().keys(new String[]{name.getName()}).interval(time, (Comparable)Integer.valueOf(40), (Comparable)Integer.valueOf(60)), RelationCategory.PROPERTY, 10, 1, new boolean[]{false, true});
        TitanGraphTest.evaluateQuery(v.query().keys(new String[]{name.getName()}).interval(time, (Comparable)Integer.valueOf(40), (Comparable)Integer.valueOf(60)).orderBy(weight, Order.DESC), RelationCategory.PROPERTY, 10, 1, new boolean[]{false, false}, weight, Order.DESC);
        TitanGraphTest.evaluateQuery(v.query().keys(new String[]{name.getName()}).interval(time, (Comparable)Integer.valueOf(100), (Comparable)Integer.valueOf(110)).limit(5), RelationCategory.PROPERTY, 5, 1, new boolean[]{false, true});
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{child.getName()}).direction(Direction.OUT).has(time, (Predicate)Cmp.EQUAL, (Object)5), RelationCategory.EDGE, 0, 1, new boolean[]{true, true});
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{child.getName()}).direction(Direction.OUT).has(time, (Predicate)Cmp.EQUAL, (Object)105), RelationCategory.EDGE, 1, 1, new boolean[]{true, true});
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{child.getName()}).direction(Direction.OUT).interval(time, (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(20)).orderBy(weight, Order.DESC).limit(5), RelationCategory.EDGE, 0, 1, new boolean[]{true, false}, weight, Order.DESC);
        TitanGraphTest.evaluateQuery(v.query().labels(new String[]{child.getName()}).direction(Direction.OUT).interval(time, (Comparable)Integer.valueOf(110), (Comparable)Integer.valueOf(120)).orderBy(weight, Order.DESC).limit(5), RelationCategory.EDGE, 5, 1, new boolean[]{true, false}, weight, Order.DESC);
        TitanGraphTest.evaluateQuery(v.query(), RelationCategory.RELATION, 400, 1, new boolean[]{true, true});
        TitanGraphTest.evaluateQuery(v.query().direction(Direction.OUT), RelationCategory.RELATION, 400, 1, new boolean[]{false, true});
    }

    private boolean isSortedByID(VertexList vl) {
        for (int i = 1; i < vl.size(); ++i) {
            if (vl.getID(i - 1) <= vl.getID(i)) continue;
            return false;
        }
        return true;
    }

    public static void evaluateQuery(TitanVertexQuery query, RelationCategory resultType, int expectedResults, int numSubQueries, boolean[] subQuerySpecs) {
        TitanGraphTest.evaluateQuery(query, resultType, expectedResults, numSubQueries, subQuerySpecs, (Map<PropertyKey, Order>)ImmutableMap.of());
    }

    public static void evaluateQuery(TitanVertexQuery query, RelationCategory resultType, int expectedResults, int numSubQueries, boolean[] subQuerySpecs, PropertyKey orderKey, Order order) {
        TitanGraphTest.evaluateQuery(query, resultType, expectedResults, numSubQueries, subQuerySpecs, (Map<PropertyKey, Order>)ImmutableMap.of((Object)orderKey, (Object)order));
    }

    public static void evaluateQuery(TitanVertexQuery query, RelationCategory resultType, int expectedResults, int numSubQueries, boolean[] subQuerySpecs, Map<PropertyKey, Order> orderMap) {
        Iterable result;
        QueryDescription qd;
        switch (resultType) {
            case PROPERTY: {
                qd = query.describeForProperties();
                break;
            }
            case EDGE: {
                qd = query.describeForEdges();
                break;
            }
            case RELATION: {
                qd = ((BasicVertexCentricQueryBuilder)query).describeForRelations();
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        Assert.assertEquals((long)1L, (long)qd.getNoCombinedQueries());
        Assert.assertEquals((long)numSubQueries, (long)qd.getNoSubQueries());
        List subqs = qd.getSubQueries();
        Assert.assertEquals((long)numSubQueries, (long)subqs.size());
        for (int i = 0; i < numSubQueries; ++i) {
            QueryDescription.SubQuery sq = (QueryDescription.SubQuery)subqs.get(i);
            Assert.assertNotNull((Object)sq);
            if (subQuerySpecs.length == 2) {
                Assert.assertEquals((Object)subQuerySpecs[0], (Object)sq.isFitted());
                Assert.assertEquals((Object)subQuerySpecs[1], (Object)sq.isSorted());
            }
            Assert.assertEquals((long)1L, (long)((StandardQueryDescription.StandardSubQuery)sq).numIntersectingQueries());
        }
        OrderList orders = ((StandardQueryDescription)qd).getQueryOrder();
        Assert.assertNotNull((Object)orders);
        Assert.assertEquals((long)orderMap.size(), (long)orders.size());
        for (int i = 0; i < orders.size(); ++i) {
            Assert.assertEquals((Object)orderMap.get(orders.getKey(i)), (Object)orders.getOrder(i));
        }
        for (PropertyKey key : orderMap.keySet()) {
            Assert.assertTrue((boolean)orders.containsKey(key));
        }
        switch (resultType) {
            case PROPERTY: {
                result = query.properties();
                break;
            }
            case EDGE: {
                result = query.edges();
                break;
            }
            case RELATION: {
                result = query.relations();
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        int no = 0;
        TitanElement previous = null;
        for (TitanElement e : result) {
            Assert.assertNotNull((Object)e);
            ++no;
            if (previous != null && !orders.isEmpty()) {
                Assert.assertTrue((orders.compare(previous, e) <= 0 ? 1 : 0) != 0);
            }
            previous = e;
        }
        Assert.assertEquals((long)expectedResults, (long)no);
    }

    @Test
    public void testEdgesExceedCacheSize() {
        int numEdges = this.graph.getConfiguration().getTxVertexCacheSize();
        TitanVertex parentVertex = this.graph.addVertex(null);
        for (int i = 0; i < numEdges; ++i) {
            TitanVertex childVertex = this.graph.addVertex(null);
            parentVertex.addEdge("friend", (Vertex)childVertex);
        }
        this.graph.commit();
        Assert.assertEquals((long)numEdges, (long)Iterables.size((Iterable)parentVertex.getEdges(Direction.OUT, new String[0])));
        Edge edge = (Edge)parentVertex.getEdges(Direction.OUT, new String[0]).iterator().next();
        edge.remove();
        Assert.assertEquals((long)(numEdges - 1), (long)Iterables.size((Iterable)parentVertex.getEdges(Direction.OUT, new String[0])));
        Assert.assertEquals((long)(numEdges - 1), (long)Iterables.size((Iterable)parentVertex.getEdges(Direction.OUT, new String[0])));
    }

    @Test
    public void simpleLogTest() throws InterruptedException {
        this.simpleLogTest(false);
    }

    @Test
    public void simpleLogTestWithFailure() throws InterruptedException {
        this.simpleLogTest(true);
    }

    public void simpleLogTest(final boolean withLogFailure) throws InterruptedException {
        String userlogName = "test";
        final Serializer serializer = this.graph.getDataSerializer();
        EdgeSerializer edgeSerializer = this.graph.getEdgeSerializer();
        final TimestampProvider times = this.graph.getConfiguration().getTimestampProvider();
        TimeUnit unit = times.getUnit();
        final long startTime = times.getTime().getTimestamp(TimeUnit.MILLISECONDS);
        this.clopen(TitanGraphTest.option(GraphDatabaseConfiguration.SYSTEM_LOG_TRANSACTIONS, new String[0]), true, TitanGraphTest.option(GraphDatabaseConfiguration.LOG_BACKEND, "user"), withLogFailure ? TestMockLog.class.getName() : (String)GraphDatabaseConfiguration.LOG_BACKEND.getDefaultValue(), TitanGraphTest.option(TestMockLog.LOG_MOCK_FAILADD, "user"), withLogFailure, TitanGraphTest.option(KCVSLog.LOG_READ_LAG_TIME, "user"), new StandardDuration(50L, TimeUnit.MILLISECONDS), TitanGraphTest.option(GraphDatabaseConfiguration.LOG_READ_INTERVAL, "user"), new StandardDuration(250L, TimeUnit.MILLISECONDS), TitanGraphTest.option(GraphDatabaseConfiguration.LOG_SEND_DELAY, "user"), new StandardDuration(100L, TimeUnit.MILLISECONDS), TitanGraphTest.option(KCVSLog.LOG_READ_LAG_TIME, "tx"), new StandardDuration(50L, TimeUnit.MILLISECONDS), TitanGraphTest.option(GraphDatabaseConfiguration.LOG_READ_INTERVAL, "tx"), new StandardDuration(250L, TimeUnit.MILLISECONDS), TitanGraphTest.option(GraphDatabaseConfiguration.MAX_COMMIT_TIME, new String[0]), new StandardDuration(1L, TimeUnit.SECONDS));
        final String instanceid = this.graph.getConfiguration().getUniqueGraphId();
        PropertyKey weight = this.tx.makePropertyKey("weight").dataType(Decimal.class).cardinality(Cardinality.SINGLE).make();
        EdgeLabel knows = this.tx.makeEdgeLabel("knows").make();
        TitanVertex n1 = this.tx.addVertex();
        n1.addProperty(weight, (Object)10.5);
        this.newTx();
        final Timepoint[] txTimes = new Timepoint[4];
        txTimes[0] = times.getTime();
        TitanTransaction tx2 = this.graph.buildTransaction().setLogIdentifier("test").start();
        TitanVertex v1 = tx2.addVertex();
        v1.setProperty("weight", (Object)111.1);
        v1.addEdge("knows", v1);
        tx2.commit();
        final long v1id = v1.getLongId();
        txTimes[1] = times.getTime();
        tx2 = this.graph.buildTransaction().setLogIdentifier("test").start();
        TitanVertex v2 = tx2.addVertex();
        v2.setProperty("weight", (Object)222.2);
        v2.addEdge("knows", tx2.getVertex(v1id));
        tx2.commit();
        final long v2id = v2.getLongId();
        tx2 = this.graph.buildTransaction().setLogIdentifier("test").start();
        v1 = tx2.getVertex(v1id);
        Assert.assertEquals((double)111.1, (double)((Decimal)v1.getProperty("weight")).doubleValue(), (double)0.0);
        Assert.assertEquals((double)222.2, (double)((Decimal)tx2.getVertex((Object)v2).getProperty("weight")).doubleValue(), (double)0.0);
        tx2.commit();
        txTimes[2] = times.getTime();
        tx2 = this.graph.buildTransaction().setLogIdentifier("test").start();
        v2 = tx2.getVertex(v2id);
        Assert.assertEquals((double)222.2, (double)((Decimal)v2.getProperty("weight")).doubleValue(), (double)0.0);
        v2.remove();
        tx2.commit();
        txTimes[3] = times.getTime();
        tx2 = this.graph.buildTransaction().setLogIdentifier("test").start();
        v1 = tx2.getVertex(v1id);
        Assert.assertEquals((double)111.1, (double)((Decimal)v1.getProperty("weight")).doubleValue(), (double)0.0);
        Edge e = (Edge)Iterables.getOnlyElement((Iterable)v1.getEdges(Direction.OUT, new String[]{"knows"}));
        Assert.assertNull((Object)e.getProperty("weight"));
        e.setProperty("weight", (Object)44.4);
        tx2.commit();
        this.close();
        final long endTime = times.getTime().getTimestamp(TimeUnit.MILLISECONDS);
        ReadMarker startMarker = ReadMarker.fromTime((long)startTime, (TimeUnit)TimeUnit.MILLISECONDS);
        Log txlog = this.openTxLog();
        Log userLog = this.openUserLog("test");
        final EnumMap<LogTxStatus, AtomicInteger> txMsgCounter = new EnumMap<LogTxStatus, AtomicInteger>(LogTxStatus.class);
        for (LogTxStatus status : LogTxStatus.values()) {
            txMsgCounter.put(status, new AtomicInteger(0));
        }
        final AtomicInteger userlogMeta = new AtomicInteger(0);
        txlog.registerReader(startMarker, new MessageReader[]{new MessageReader(){

            public void read(Message message) {
                long msgTime = message.getTimestamp(TimeUnit.MILLISECONDS);
                Assert.assertTrue((msgTime >= startTime ? 1 : 0) != 0);
                Assert.assertNotNull((Object)message.getSenderId());
                TransactionLogHeader.Entry txEntry = TransactionLogHeader.parse((StaticBuffer)message.getContent(), (Serializer)serializer, (TimestampProvider)times);
                TransactionLogHeader header = txEntry.getHeader();
                Assert.assertTrue((header.getTimestamp(TimeUnit.MILLISECONDS) >= startTime ? 1 : 0) != 0);
                Assert.assertTrue((header.getTimestamp(TimeUnit.MILLISECONDS) <= msgTime ? 1 : 0) != 0);
                Assert.assertNotNull((Object)txEntry.getMetadata());
                Assert.assertNull(txEntry.getMetadata().get(LogTxMeta.GROUPNAME));
                LogTxStatus status = txEntry.getStatus();
                if (status == LogTxStatus.PRECOMMIT) {
                    Assert.assertTrue((boolean)txEntry.hasContent());
                    Object logid = txEntry.getMetadata().get(LogTxMeta.LOG_ID);
                    if (logid != null) {
                        Assert.assertTrue((boolean)(logid instanceof String));
                        Assert.assertEquals((Object)"test", logid);
                        userlogMeta.incrementAndGet();
                    }
                } else if (withLogFailure) {
                    Assert.assertTrue((status.isPrimarySuccess() || status == LogTxStatus.SECONDARY_FAILURE ? 1 : 0) != 0);
                    if (status == LogTxStatus.SECONDARY_FAILURE) {
                        TransactionLogHeader.SecondaryFailures secFail = txEntry.getContentAsSecondaryFailures(serializer);
                        Assert.assertTrue((boolean)secFail.failedIndexes.isEmpty());
                        Assert.assertTrue((boolean)secFail.userLogFailure);
                    }
                } else {
                    Assert.assertFalse((boolean)txEntry.hasContent());
                    Assert.assertTrue((boolean)status.isSuccess());
                }
                ((AtomicInteger)txMsgCounter.get(txEntry.getStatus())).incrementAndGet();
            }
        }});
        final EnumMap<Change, AtomicInteger> userChangeCounter = new EnumMap<Change, AtomicInteger>(Change.class);
        for (Change change : Change.values()) {
            userChangeCounter.put(change, new AtomicInteger(0));
        }
        final AtomicInteger userLogMsgCounter = new AtomicInteger(0);
        userLog.registerReader(startMarker, new MessageReader[]{new MessageReader(){

            public void read(Message message) {
                long msgTime = message.getTimestamp(TimeUnit.MILLISECONDS);
                Assert.assertTrue((msgTime >= startTime ? 1 : 0) != 0);
                Assert.assertNotNull((Object)message.getSenderId());
                StaticBuffer content = message.getContent();
                Assert.assertTrue((content != null && content.length() > 0 ? 1 : 0) != 0);
                TransactionLogHeader.Entry txentry = TransactionLogHeader.parse((StaticBuffer)content, (Serializer)serializer, (TimestampProvider)times);
                long txTime = txentry.getHeader().getTimestamp(TimeUnit.MILLISECONDS);
                Assert.assertTrue((txTime <= msgTime ? 1 : 0) != 0);
                Assert.assertTrue((txTime >= startTime ? 1 : 0) != 0);
                long txid = txentry.getHeader().getId();
                Assert.assertTrue((txid > 0L ? 1 : 0) != 0);
                for (TransactionLogHeader.Modification modification : txentry.getContentAsModifications(serializer)) {
                    Assert.assertTrue((modification.state == Change.ADDED || modification.state == Change.REMOVED ? 1 : 0) != 0);
                    ((AtomicInteger)userChangeCounter.get(modification.state)).incrementAndGet();
                }
                userLogMsgCounter.incrementAndGet();
            }
        }});
        Thread.sleep(4000L);
        Assert.assertEquals((long)5L, (long)((AtomicInteger)txMsgCounter.get(LogTxStatus.PRECOMMIT)).get());
        Assert.assertEquals((long)4L, (long)((AtomicInteger)txMsgCounter.get(LogTxStatus.PRIMARY_SUCCESS)).get());
        Assert.assertEquals((long)1L, (long)((AtomicInteger)txMsgCounter.get(LogTxStatus.COMPLETE_SUCCESS)).get());
        Assert.assertEquals((long)4L, (long)userlogMeta.get());
        if (withLogFailure) {
            Assert.assertEquals((long)4L, (long)((AtomicInteger)txMsgCounter.get(LogTxStatus.SECONDARY_FAILURE)).get());
        } else {
            Assert.assertEquals((long)4L, (long)((AtomicInteger)txMsgCounter.get(LogTxStatus.SECONDARY_SUCCESS)).get());
        }
        if (withLogFailure) {
            Assert.assertEquals((long)0L, (long)userLogMsgCounter.get());
        } else {
            Assert.assertEquals((long)4L, (long)userLogMsgCounter.get());
            Assert.assertEquals((long)7L, (long)((AtomicInteger)userChangeCounter.get(Change.ADDED)).get());
            Assert.assertEquals((long)4L, (long)((AtomicInteger)userChangeCounter.get(Change.REMOVED)).get());
        }
        this.clopen(TitanGraphTest.option(GraphDatabaseConfiguration.VERBOSE_TX_RECOVERY, new String[0]), true);
        TransactionRecovery recovery = TitanFactory.startTransactionRecovery((TitanGraph)this.graph, (long)startTime, (TimeUnit)TimeUnit.MILLISECONDS);
        final AtomicInteger userLogCount = new AtomicInteger(0);
        LogProcessorFramework userlogs = TitanFactory.openTransactionLog((TitanGraph)this.graph);
        userlogs.addLogProcessor("test").setStartTime(startTime, TimeUnit.MILLISECONDS).setRetryAttempts(1).addProcessor(new ChangeProcessor(){

            public void process(TitanTransaction tx, TransactionId txId, ChangeState changes) {
                TitanProperty p;
                TitanVertex v;
                int txNo;
                Assert.assertEquals((Object)instanceid, (Object)txId.getInstanceId());
                Assert.assertTrue((txId.getTransactionId() > 0L && txId.getTransactionId() < 100L ? 1 : 0) != 0);
                long txTime = txId.getTransactionTime().sinceEpoch(TimeUnit.MILLISECONDS);
                Assert.assertTrue((String)String.format("tx timestamp %s not between start %s and end time %s", txTime, startTime, endTime), (txTime >= startTime && txTime <= endTime ? 1 : 0) != 0);
                Assert.assertTrue((boolean)tx.containsRelationType("knows"));
                Assert.assertTrue((boolean)tx.containsRelationType("weight"));
                EdgeLabel knows = tx.getEdgeLabel("knows");
                PropertyKey weight = tx.getPropertyKey("weight");
                long txTimeMicro = txId.getTransactionTime().sinceEpoch(TimeUnit.MICROSECONDS);
                if (txTimeMicro < txTimes[1].getTimestamp(TimeUnit.MICROSECONDS)) {
                    txNo = 1;
                    Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)changes.getVertices(Change.ADDED)));
                    Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)changes.getVertices(Change.REMOVED)));
                    Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)changes.getVertices(Change.ANY)));
                    Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)changes.getRelations(Change.ADDED, new RelationType[0])));
                    Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)changes.getRelations(Change.ADDED, new RelationType[]{knows})));
                    Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)changes.getRelations(Change.ADDED, new RelationType[]{weight})));
                    Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)changes.getRelations(Change.ANY, new RelationType[0])));
                    Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)changes.getRelations(Change.REMOVED, new RelationType[0])));
                    v = (TitanVertex)Iterables.getOnlyElement((Iterable)changes.getVertices(Change.ADDED));
                    Assert.assertEquals((long)v1id, (long)v.getLongId());
                    p = (TitanProperty)Iterables.getOnlyElement((Iterable)changes.getProperties(v, Change.ADDED, new String[]{"weight"}));
                    Assert.assertEquals((double)111.1, (double)((Decimal)p.getValue()).doubleValue(), (double)1.0E-4);
                    Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)changes.getEdges(v, Change.ADDED, Direction.OUT, new String[0])));
                    Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)changes.getEdges(v, Change.ADDED, Direction.BOTH, new String[0])));
                } else if (txTimeMicro < txTimes[2].getTimestamp(TimeUnit.MICROSECONDS)) {
                    txNo = 2;
                    Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)changes.getVertices(Change.ADDED)));
                    Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)changes.getVertices(Change.REMOVED)));
                    Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)changes.getVertices(Change.ANY)));
                    Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)changes.getRelations(Change.ADDED, new RelationType[0])));
                    Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)changes.getRelations(Change.ADDED, new RelationType[]{knows})));
                    Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)changes.getRelations(Change.ADDED, new RelationType[]{weight})));
                    Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)changes.getRelations(Change.ANY, new RelationType[0])));
                    Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)changes.getRelations(Change.REMOVED, new RelationType[0])));
                    v = (TitanVertex)Iterables.getOnlyElement((Iterable)changes.getVertices(Change.ADDED));
                    Assert.assertEquals((long)v2id, (long)v.getLongId());
                    p = (TitanProperty)Iterables.getOnlyElement((Iterable)changes.getProperties(v, Change.ADDED, new String[]{"weight"}));
                    Assert.assertEquals((double)222.2, (double)((Decimal)p.getValue()).doubleValue(), (double)1.0E-4);
                    Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)changes.getEdges(v, Change.ADDED, Direction.OUT, new String[0])));
                    Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)changes.getEdges(v, Change.ADDED, Direction.BOTH, new String[0])));
                } else if (txTimeMicro < txTimes[3].getTimestamp(TimeUnit.MICROSECONDS)) {
                    txNo = 3;
                    Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)changes.getVertices(Change.ADDED)));
                    Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)changes.getVertices(Change.REMOVED)));
                    Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)changes.getVertices(Change.ANY)));
                    Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)changes.getRelations(Change.ADDED, new RelationType[0])));
                    Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)changes.getRelations(Change.REMOVED, new RelationType[0])));
                    Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)changes.getRelations(Change.REMOVED, new RelationType[]{knows})));
                    Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)changes.getRelations(Change.REMOVED, new RelationType[]{weight})));
                    Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)changes.getRelations(Change.ANY, new RelationType[0])));
                    v = (TitanVertex)Iterables.getOnlyElement((Iterable)changes.getVertices(Change.REMOVED));
                    Assert.assertEquals((long)v2id, (long)v.getLongId());
                    p = (TitanProperty)Iterables.getOnlyElement((Iterable)changes.getProperties(v, Change.REMOVED, new String[]{"weight"}));
                    Assert.assertEquals((double)222.2, (double)((Decimal)p.getValue()).doubleValue(), (double)1.0E-4);
                    Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)changes.getEdges(v, Change.REMOVED, Direction.OUT, new String[0])));
                    Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)changes.getEdges(v, Change.ADDED, Direction.BOTH, new String[0])));
                } else {
                    txNo = 4;
                    Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)changes.getVertices(Change.ADDED)));
                    Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)changes.getVertices(Change.REMOVED)));
                    Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)changes.getVertices(Change.ANY)));
                    Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)changes.getRelations(Change.ADDED, new RelationType[0])));
                    Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)changes.getRelations(Change.REMOVED, new RelationType[0])));
                    Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)changes.getRelations(Change.REMOVED, new RelationType[]{knows})));
                    Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)changes.getRelations(Change.ANY, new RelationType[0])));
                    v = (TitanVertex)Iterables.getOnlyElement((Iterable)changes.getVertices(Change.ANY));
                    Assert.assertEquals((long)v1id, (long)v.getLongId());
                    TitanEdge e = (TitanEdge)Iterables.getOnlyElement((Iterable)changes.getEdges(v, Change.REMOVED, Direction.OUT, new String[]{"knows"}));
                    Assert.assertNull((Object)e.getProperty("weight"));
                    Assert.assertEquals((Object)v, (Object)e.getVertex(Direction.IN));
                    e = (TitanEdge)Iterables.getOnlyElement((Iterable)changes.getEdges(v, Change.ADDED, Direction.OUT, new String[]{"knows"}));
                    Assert.assertEquals((double)44.4, (double)((Decimal)e.getProperty("weight")).doubleValue(), (double)0.0);
                    Assert.assertEquals((Object)v, (Object)e.getVertex(Direction.IN));
                }
                TitanVertex v1 = tx.getVertex(v1id);
                Assert.assertNotNull((Object)v1);
                Assert.assertTrue((boolean)v1.isLoaded());
                TitanVertex v2 = tx.getVertex(v2id);
                if (txNo != 2) {
                    Assert.assertTrue((String)(txNo + " - " + v2), (v2 == null || v2.isRemoved() ? 1 : 0) != 0);
                }
                Assert.assertEquals((double)111.1, (double)((Decimal)v1.getProperty(weight)).doubleValue(), (double)0.0);
                Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)v1.getEdges(Direction.OUT, new String[0])));
                userLogCount.incrementAndGet();
            }
        }).build();
        Thread.sleep(22000L);
        recovery.shutdown();
        long[] recoveryStats = ((StandardTransactionLogProcessor)recovery).getStatistics();
        if (withLogFailure) {
            Assert.assertEquals((long)1L, (long)recoveryStats[0]);
            Assert.assertEquals((long)4L, (long)recoveryStats[1]);
        } else {
            Assert.assertEquals((long)5L, (long)recoveryStats[0]);
            Assert.assertEquals((long)0L, (long)recoveryStats[1]);
        }
        userlogs.removeLogProcessor("test");
        userlogs.shutdown();
        Assert.assertEquals((long)4L, (long)userLogCount.get());
    }

    @Test
    public void testGlobalGraphIndexingAndQueriesForInternalIndexes() {
        TitanEdge e;
        TitanVertex u;
        String txt;
        long t;
        double w;
        TitanProperty p2;
        TitanProperty p1;
        int i;
        PropertyKey weight = this.makeKey("weight", Decimal.class);
        PropertyKey time = this.makeKey("time", Long.class);
        PropertyKey text = this.makeKey("text", String.class);
        PropertyKey name = this.mgmt.makePropertyKey("name").dataType(String.class).cardinality(Cardinality.LIST).make();
        EdgeLabel connect = this.mgmt.makeEdgeLabel("connect").signature(new RelationType[]{weight}).make();
        EdgeLabel related = this.mgmt.makeEdgeLabel("related").signature(new RelationType[]{time}).make();
        VertexLabel person = this.mgmt.makeVertexLabel("person").make();
        VertexLabel org = this.mgmt.makeVertexLabel("organization").make();
        TitanGraphIndex edge1 = this.mgmt.buildIndex("edge1", Edge.class).addKey(time).addKey(weight).buildCompositeIndex();
        TitanGraphIndex edge2 = this.mgmt.buildIndex("edge2", Edge.class).indexOnly((TitanSchemaType)connect).addKey(text).buildCompositeIndex();
        TitanGraphIndex prop1 = this.mgmt.buildIndex("prop1", TitanProperty.class).addKey(time).buildCompositeIndex();
        TitanGraphIndex prop2 = this.mgmt.buildIndex("prop2", TitanProperty.class).addKey(weight).addKey(text).buildCompositeIndex();
        TitanGraphIndex vertex1 = this.mgmt.buildIndex("vertex1", Vertex.class).addKey(time).indexOnly((TitanSchemaType)person).unique().buildCompositeIndex();
        TitanGraphIndex vertex12 = this.mgmt.buildIndex("vertex12", Vertex.class).addKey(text).indexOnly((TitanSchemaType)person).buildCompositeIndex();
        TitanGraphIndex vertex2 = this.mgmt.buildIndex("vertex2", Vertex.class).addKey(time).addKey(name).indexOnly((TitanSchemaType)org).buildCompositeIndex();
        TitanGraphIndex vertex3 = this.mgmt.buildIndex("vertex3", Vertex.class).addKey(name).buildCompositeIndex();
        Assert.assertTrue((boolean)this.mgmt.containsRelationType("name"));
        Assert.assertTrue((boolean)this.mgmt.containsGraphIndex("prop1"));
        Assert.assertFalse((boolean)this.mgmt.containsGraphIndex("prop3"));
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)this.mgmt.getGraphIndexes(Edge.class)));
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)this.mgmt.getGraphIndexes(TitanProperty.class)));
        Assert.assertEquals((long)4L, (long)Iterables.size((Iterable)this.mgmt.getGraphIndexes(Vertex.class)));
        Assert.assertNull((Object)this.mgmt.getGraphIndex("balblub"));
        edge1 = this.mgmt.getGraphIndex("edge1");
        edge2 = this.mgmt.getGraphIndex("edge2");
        prop1 = this.mgmt.getGraphIndex("prop1");
        prop2 = this.mgmt.getGraphIndex("prop2");
        vertex1 = this.mgmt.getGraphIndex("vertex1");
        vertex12 = this.mgmt.getGraphIndex("vertex12");
        vertex2 = this.mgmt.getGraphIndex("vertex2");
        vertex3 = this.mgmt.getGraphIndex("vertex3");
        Assert.assertTrue((boolean)vertex1.isUnique());
        Assert.assertFalse((boolean)edge2.isUnique());
        Assert.assertEquals((Object)"prop1", (Object)prop1.getName());
        Assert.assertTrue((boolean)Vertex.class.isAssignableFrom(vertex3.getIndexedElement()));
        Assert.assertTrue((boolean)TitanProperty.class.isAssignableFrom(prop1.getIndexedElement()));
        Assert.assertTrue((boolean)Edge.class.isAssignableFrom(edge2.getIndexedElement()));
        Assert.assertEquals((long)2L, (long)vertex2.getFieldKeys().length);
        Assert.assertEquals((long)1L, (long)vertex1.getFieldKeys().length);
        try {
            this.mgmt.buildIndex("blablub", Vertex.class).addKey(text, new Parameter[]{Mapping.TEXT.getParameter()}).buildCompositeIndex();
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.mgmt.buildIndex("edge1", Vertex.class).addKey(weight).buildCompositeIndex();
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.mgmt.buildIndex("jupdup", Vertex.class).addKey((PropertyKey)ImplicitKey.ID).buildCompositeIndex();
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.mgmt.buildIndex("edgexyz", Edge.class).addKey(time).unique().buildCompositeIndex();
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.finishSchema();
        this.clopen(new Object[0]);
        text = this.mgmt.getPropertyKey("text");
        time = this.mgmt.getPropertyKey("time");
        weight = this.mgmt.getPropertyKey("weight");
        Assert.assertTrue((boolean)this.mgmt.containsRelationType("name"));
        Assert.assertTrue((boolean)this.mgmt.containsGraphIndex("prop1"));
        Assert.assertFalse((boolean)this.mgmt.containsGraphIndex("prop3"));
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)this.mgmt.getGraphIndexes(Edge.class)));
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)this.mgmt.getGraphIndexes(TitanProperty.class)));
        Assert.assertEquals((long)4L, (long)Iterables.size((Iterable)this.mgmt.getGraphIndexes(Vertex.class)));
        Assert.assertNull((Object)this.mgmt.getGraphIndex("balblub"));
        edge1 = this.mgmt.getGraphIndex("edge1");
        edge2 = this.mgmt.getGraphIndex("edge2");
        prop1 = this.mgmt.getGraphIndex("prop1");
        prop2 = this.mgmt.getGraphIndex("prop2");
        vertex1 = this.mgmt.getGraphIndex("vertex1");
        vertex12 = this.mgmt.getGraphIndex("vertex12");
        vertex2 = this.mgmt.getGraphIndex("vertex2");
        vertex3 = this.mgmt.getGraphIndex("vertex3");
        Assert.assertTrue((boolean)vertex1.isUnique());
        Assert.assertFalse((boolean)edge2.isUnique());
        Assert.assertEquals((Object)"prop1", (Object)prop1.getName());
        Assert.assertTrue((boolean)Vertex.class.isAssignableFrom(vertex3.getIndexedElement()));
        Assert.assertTrue((boolean)TitanProperty.class.isAssignableFrom(prop1.getIndexedElement()));
        Assert.assertTrue((boolean)Edge.class.isAssignableFrom(edge2.getIndexedElement()));
        Assert.assertEquals((long)2L, (long)vertex2.getFieldKeys().length);
        Assert.assertEquals((long)1L, (long)vertex1.getFieldKeys().length);
        try {
            this.mgmt.buildIndex("blablub", Vertex.class).addKey(text, new Parameter[]{Mapping.TEXT.getParameter()}).buildCompositeIndex();
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.mgmt.buildIndex("edge1", Vertex.class).addKey(weight).buildCompositeIndex();
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.mgmt.buildIndex("jupdup", Vertex.class).addKey((PropertyKey)ImplicitKey.ID).buildCompositeIndex();
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.mgmt.buildIndex("edgexyz", Edge.class).addKey(time).unique().buildCompositeIndex();
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        weight = this.tx.getPropertyKey("weight");
        time = this.tx.getPropertyKey("time");
        text = this.tx.getPropertyKey("text");
        name = this.tx.getPropertyKey("name");
        connect = this.tx.getEdgeLabel("connect");
        related = this.tx.getEdgeLabel("related");
        person = this.tx.getVertexLabel("person");
        org = this.tx.getVertexLabel("organization");
        int numV = 100;
        boolean sorted = true;
        TitanVertex[] ns = new TitanVertex[100];
        String[] strs = new String[]{"aaa", "bbb", "ccc", "ddd"};
        for (i = 0; i < 100; ++i) {
            ns[i] = this.tx.addVertexWithLabel(i % 2 == 0 ? person : org);
            p1 = ns[i].addProperty(name, (Object)("v" + i));
            p2 = ns[i].addProperty(name, (Object)("u" + i % 5));
            w = (double)i * 0.5 % 5.0;
            t = i;
            txt = strs[i % strs.length];
            ns[i].setProperty(weight, (Object)w);
            ns[i].setProperty(time, (Object)t);
            ns[i].setProperty(text, (Object)txt);
            for (TitanProperty p : new TitanProperty[]{p1, p2}) {
                p.setProperty(weight, (Object)w);
                p.setProperty(time, (Object)t);
                p.setProperty(text, (Object)txt);
            }
            u = ns[i > 0 ? i - 1 : i];
            EdgeLabel[] edgeLabelArray = new EdgeLabel[]{connect, related};
            int n = edgeLabelArray.length;
            for (int p = 0; p < n; ++p) {
                EdgeLabel label = edgeLabelArray[p];
                e = ns[i].addEdge(label, u);
                double d = w;
                w = d + 1.0;
                e.setProperty(weight, (Object)(d % 5.0));
                e.setProperty(time, (Object)t);
                e.setProperty(text, (Object)txt);
            }
        }
        TitanGraphTest.evaluateQuery(this.tx.query().has(time, (TitanPredicate)Cmp.EQUAL, (Object)10).has(weight, (TitanPredicate)Cmp.EQUAL, (Object)0), ElementCategory.EDGE, 1, new boolean[]{true, true}, edge1.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(time, (TitanPredicate)Contain.IN, (Object)ImmutableList.of((Object)10, (Object)20, (Object)30)).has(weight, (TitanPredicate)Cmp.EQUAL, (Object)0), ElementCategory.EDGE, 3, new boolean[]{true, true}, edge1.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(time, (TitanPredicate)Cmp.EQUAL, (Object)10).has(weight, (TitanPredicate)Cmp.EQUAL, (Object)0).has(text, (TitanPredicate)Cmp.EQUAL, (Object)strs[10 % strs.length]), ElementCategory.EDGE, 1, new boolean[]{false, true}, edge1.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(time, (TitanPredicate)Cmp.EQUAL, (Object)10).has(weight, (TitanPredicate)Cmp.EQUAL, (Object)1), ElementCategory.EDGE, 1, new boolean[]{true, true}, edge1.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(time, (TitanPredicate)Cmp.EQUAL, (Object)20).has(weight, (TitanPredicate)Cmp.EQUAL, (Object)0), ElementCategory.EDGE, 1, new boolean[]{true, true}, edge1.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(time, (TitanPredicate)Cmp.EQUAL, (Object)20).has(weight, (TitanPredicate)Cmp.EQUAL, (Object)3), ElementCategory.EDGE, 0, new boolean[]{true, true}, edge1.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(text, (TitanPredicate)Cmp.EQUAL, (Object)strs[0]).has("label", (Object)connect.getName()), ElementCategory.EDGE, 100 / strs.length, new boolean[]{true, true}, edge2.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(text, (TitanPredicate)Cmp.EQUAL, (Object)strs[0]).has("label", (Object)connect.getName()).limit(10), ElementCategory.EDGE, 10, new boolean[]{true, true}, edge2.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(text, (TitanPredicate)Cmp.EQUAL, (Object)strs[0]), ElementCategory.EDGE, 100 / strs.length * 2, new boolean[]{false, true}, new String[0]);
        TitanGraphTest.evaluateQuery(this.tx.query().has(weight, (TitanPredicate)Cmp.EQUAL, (Object)1.5), ElementCategory.EDGE, 20, new boolean[]{false, true}, new String[0]);
        TitanGraphTest.evaluateQuery(this.tx.query().has(time, (TitanPredicate)Cmp.EQUAL, (Object)50), ElementCategory.PROPERTY, 2, new boolean[]{true, true}, prop1.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(weight, (TitanPredicate)Cmp.EQUAL, (Object)0.0).has(text, (TitanPredicate)Cmp.EQUAL, (Object)strs[0]), ElementCategory.PROPERTY, 10, new boolean[]{true, true}, prop2.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(weight, (TitanPredicate)Cmp.EQUAL, (Object)0.0).has(text, (TitanPredicate)Cmp.EQUAL, (Object)strs[0]).has(time, (TitanPredicate)Cmp.EQUAL, (Object)0), ElementCategory.PROPERTY, 2, new boolean[]{true, true}, prop2.getName(), prop1.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(weight, (TitanPredicate)Cmp.EQUAL, (Object)1.5), ElementCategory.PROPERTY, 20, new boolean[]{false, true}, new String[0]);
        TitanGraphTest.evaluateQuery(this.tx.query().has(time, (TitanPredicate)Cmp.EQUAL, (Object)50).has("label", (Object)person.getName()), ElementCategory.VERTEX, 1, new boolean[]{true, true}, vertex1.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(text, (TitanPredicate)Cmp.EQUAL, (Object)strs[2]).has("label", (Object)person.getName()), ElementCategory.VERTEX, 100 / strs.length, new boolean[]{true, true}, vertex12.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(text, (TitanPredicate)Cmp.EQUAL, (Object)strs[3]).has("label", (Object)person.getName()), ElementCategory.VERTEX, 0, new boolean[]{true, true}, vertex12.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(text, (TitanPredicate)Cmp.EQUAL, (Object)strs[2]).has("label", (Object)person.getName()).has(time, (TitanPredicate)Cmp.EQUAL, (Object)2), ElementCategory.VERTEX, 1, new boolean[]{true, true}, vertex12.getName(), vertex1.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(time, (TitanPredicate)Cmp.EQUAL, (Object)51).has(name, (TitanPredicate)Cmp.EQUAL, (Object)"v51").has("label", (Object)org.getName()), ElementCategory.VERTEX, 1, new boolean[]{true, true}, vertex2.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(time, (TitanPredicate)Cmp.EQUAL, (Object)51).has(name, (TitanPredicate)Cmp.EQUAL, (Object)"u1").has("label", (Object)org.getName()), ElementCategory.VERTEX, 1, new boolean[]{true, true}, vertex2.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(time, (TitanPredicate)Contain.IN, (Object)ImmutableList.of((Object)51, (Object)61, (Object)71, (Object)31, (Object)41)).has(name, (TitanPredicate)Cmp.EQUAL, (Object)"u1").has("label", (Object)org.getName()), ElementCategory.VERTEX, 5, new boolean[]{true, true}, vertex2.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(time, (TitanPredicate)Cmp.EQUAL, (Object)51).has("label", (Object)org.getName()), ElementCategory.VERTEX, 1, new boolean[]{false, true}, new String[0]);
        TitanGraphTest.evaluateQuery(this.tx.query().has(name, (TitanPredicate)Cmp.EQUAL, (Object)"u1"), ElementCategory.VERTEX, 20, new boolean[]{true, true}, vertex3.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(name, (TitanPredicate)Cmp.EQUAL, (Object)"v1"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, vertex3.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(name, (TitanPredicate)Cmp.EQUAL, (Object)"v1").has("label", (Object)org.getName()), ElementCategory.VERTEX, 1, new boolean[]{false, true}, vertex3.getName());
        this.clopen(new Object[0]);
        weight = this.tx.getPropertyKey("weight");
        time = this.tx.getPropertyKey("time");
        text = this.tx.getPropertyKey("text");
        name = this.tx.getPropertyKey("name");
        connect = this.tx.getEdgeLabel("connect");
        related = this.tx.getEdgeLabel("related");
        person = this.tx.getVertexLabel("person");
        org = this.tx.getVertexLabel("organization");
        TitanGraphTest.evaluateQuery(this.tx.query().has(time, (TitanPredicate)Cmp.EQUAL, (Object)10).has(weight, (TitanPredicate)Cmp.EQUAL, (Object)0), ElementCategory.EDGE, 1, new boolean[]{true, true}, edge1.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(time, (TitanPredicate)Contain.IN, (Object)ImmutableList.of((Object)10, (Object)20, (Object)30)).has(weight, (TitanPredicate)Cmp.EQUAL, (Object)0), ElementCategory.EDGE, 3, new boolean[]{true, true}, edge1.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(time, (TitanPredicate)Cmp.EQUAL, (Object)10).has(weight, (TitanPredicate)Cmp.EQUAL, (Object)0).has(text, (TitanPredicate)Cmp.EQUAL, (Object)strs[10 % strs.length]), ElementCategory.EDGE, 1, new boolean[]{false, true}, edge1.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(time, (TitanPredicate)Cmp.EQUAL, (Object)10).has(weight, (TitanPredicate)Cmp.EQUAL, (Object)1), ElementCategory.EDGE, 1, new boolean[]{true, true}, edge1.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(time, (TitanPredicate)Cmp.EQUAL, (Object)20).has(weight, (TitanPredicate)Cmp.EQUAL, (Object)0), ElementCategory.EDGE, 1, new boolean[]{true, true}, edge1.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(time, (TitanPredicate)Cmp.EQUAL, (Object)20).has(weight, (TitanPredicate)Cmp.EQUAL, (Object)3), ElementCategory.EDGE, 0, new boolean[]{true, true}, edge1.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(text, (TitanPredicate)Cmp.EQUAL, (Object)strs[0]).has("label", (Object)connect.getName()), ElementCategory.EDGE, 100 / strs.length, new boolean[]{true, true}, edge2.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(text, (TitanPredicate)Cmp.EQUAL, (Object)strs[0]).has("label", (Object)connect.getName()).limit(10), ElementCategory.EDGE, 10, new boolean[]{true, true}, edge2.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(text, (TitanPredicate)Cmp.EQUAL, (Object)strs[0]), ElementCategory.EDGE, 100 / strs.length * 2, new boolean[]{false, true}, new String[0]);
        TitanGraphTest.evaluateQuery(this.tx.query().has(weight, (TitanPredicate)Cmp.EQUAL, (Object)1.5), ElementCategory.EDGE, 20, new boolean[]{false, true}, new String[0]);
        TitanGraphTest.evaluateQuery(this.tx.query().has(time, (TitanPredicate)Cmp.EQUAL, (Object)50), ElementCategory.PROPERTY, 2, new boolean[]{true, true}, prop1.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(weight, (TitanPredicate)Cmp.EQUAL, (Object)0.0).has(text, (TitanPredicate)Cmp.EQUAL, (Object)strs[0]), ElementCategory.PROPERTY, 10, new boolean[]{true, true}, prop2.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(weight, (TitanPredicate)Cmp.EQUAL, (Object)0.0).has(text, (TitanPredicate)Cmp.EQUAL, (Object)strs[0]).has(time, (TitanPredicate)Cmp.EQUAL, (Object)0), ElementCategory.PROPERTY, 2, new boolean[]{true, true}, prop2.getName(), prop1.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(weight, (TitanPredicate)Cmp.EQUAL, (Object)1.5), ElementCategory.PROPERTY, 20, new boolean[]{false, true}, new String[0]);
        TitanGraphTest.evaluateQuery(this.tx.query().has(time, (TitanPredicate)Cmp.EQUAL, (Object)50).has("label", (Object)person.getName()), ElementCategory.VERTEX, 1, new boolean[]{true, true}, vertex1.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(text, (TitanPredicate)Cmp.EQUAL, (Object)strs[2]).has("label", (Object)person.getName()), ElementCategory.VERTEX, 100 / strs.length, new boolean[]{true, true}, vertex12.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(text, (TitanPredicate)Cmp.EQUAL, (Object)strs[3]).has("label", (Object)person.getName()), ElementCategory.VERTEX, 0, new boolean[]{true, true}, vertex12.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(text, (TitanPredicate)Cmp.EQUAL, (Object)strs[2]).has("label", (Object)person.getName()).has(time, (TitanPredicate)Cmp.EQUAL, (Object)2), ElementCategory.VERTEX, 1, new boolean[]{true, true}, vertex12.getName(), vertex1.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(time, (TitanPredicate)Cmp.EQUAL, (Object)51).has(name, (TitanPredicate)Cmp.EQUAL, (Object)"v51").has("label", (Object)org.getName()), ElementCategory.VERTEX, 1, new boolean[]{true, true}, vertex2.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(time, (TitanPredicate)Cmp.EQUAL, (Object)51).has(name, (TitanPredicate)Cmp.EQUAL, (Object)"u1").has("label", (Object)org.getName()), ElementCategory.VERTEX, 1, new boolean[]{true, true}, vertex2.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(time, (TitanPredicate)Contain.IN, (Object)ImmutableList.of((Object)51, (Object)61, (Object)71, (Object)31, (Object)41)).has(name, (TitanPredicate)Cmp.EQUAL, (Object)"u1").has("label", (Object)org.getName()), ElementCategory.VERTEX, 5, new boolean[]{true, true}, vertex2.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(time, (TitanPredicate)Cmp.EQUAL, (Object)51).has("label", (Object)org.getName()), ElementCategory.VERTEX, 1, new boolean[]{false, true}, new String[0]);
        TitanGraphTest.evaluateQuery(this.tx.query().has(name, (TitanPredicate)Cmp.EQUAL, (Object)"u1"), ElementCategory.VERTEX, 20, new boolean[]{true, true}, vertex3.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(name, (TitanPredicate)Cmp.EQUAL, (Object)"v1"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, vertex3.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(name, (TitanPredicate)Cmp.EQUAL, (Object)"v1").has("label", (Object)org.getName()), ElementCategory.VERTEX, 1, new boolean[]{false, true}, vertex3.getName());
        for (i = 0; i < 50; ++i) {
            TitanVertex v = this.tx.getVertex(ns[i].getLongId());
            v.remove();
        }
        ns = new TitanVertex[150];
        for (i = 100; i < 150; ++i) {
            ns[i] = this.tx.addVertexWithLabel(i % 2 == 0 ? person : org);
            p1 = ns[i].addProperty(name, (Object)("v" + i));
            p2 = ns[i].addProperty(name, (Object)("u" + i % 5));
            w = (double)i * 0.5 % 5.0;
            t = i;
            txt = strs[i % strs.length];
            ns[i].setProperty(weight, (Object)w);
            ns[i].setProperty(time, (Object)t);
            ns[i].setProperty(text, (Object)txt);
            for (TitanProperty p : new TitanVertex[]{p1, p2}) {
                p.setProperty(weight, (Object)w);
                p.setProperty(time, (Object)t);
                p.setProperty(text, (Object)txt);
            }
            u = ns[i > 100 ? i - 1 : i];
            for (EdgeLabel label : new EdgeLabel[]{connect, related}) {
                e = ns[i].addEdge(label, u);
                double d = w;
                w = d + 1.0;
                e.setProperty(weight, (Object)(d % 5.0));
                e.setProperty(time, (Object)t);
                e.setProperty(text, (Object)txt);
            }
        }
        TitanGraphTest.evaluateQuery(this.tx.query().has(time, (TitanPredicate)Cmp.EQUAL, (Object)10).has(weight, (TitanPredicate)Cmp.EQUAL, (Object)0), ElementCategory.EDGE, 0, new boolean[]{true, true}, edge1.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(time, (TitanPredicate)Cmp.EQUAL, (Object)110).has(weight, (TitanPredicate)Cmp.EQUAL, (Object)0), ElementCategory.EDGE, 1, new boolean[]{true, true}, edge1.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(text, (TitanPredicate)Cmp.EQUAL, (Object)strs[0]).has("label", (Object)connect.getName()).limit(10), ElementCategory.EDGE, 10, new boolean[]{true, true}, edge2.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(weight, (TitanPredicate)Cmp.EQUAL, (Object)1.5), ElementCategory.EDGE, 20, new boolean[]{false, true}, new String[0]);
        TitanGraphTest.evaluateQuery(this.tx.query().has(time, (TitanPredicate)Cmp.EQUAL, (Object)20), ElementCategory.PROPERTY, 0, new boolean[]{true, true}, prop1.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(time, (TitanPredicate)Cmp.EQUAL, (Object)120), ElementCategory.PROPERTY, 2, new boolean[]{true, true}, prop1.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(time, (TitanPredicate)Cmp.EQUAL, (Object)30).has("label", (Object)person.getName()), ElementCategory.VERTEX, 0, new boolean[]{true, true}, vertex1.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(time, (TitanPredicate)Cmp.EQUAL, (Object)130).has("label", (Object)person.getName()), ElementCategory.VERTEX, 1, new boolean[]{true, true}, vertex1.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(name, (TitanPredicate)Cmp.EQUAL, (Object)"u1"), ElementCategory.VERTEX, 20, new boolean[]{true, true}, vertex3.getName());
        this.newTx();
        weight = this.tx.getPropertyKey("weight");
        time = this.tx.getPropertyKey("time");
        text = this.tx.getPropertyKey("text");
        name = this.tx.getPropertyKey("name");
        connect = this.tx.getEdgeLabel("connect");
        related = this.tx.getEdgeLabel("related");
        person = this.tx.getVertexLabel("person");
        org = this.tx.getVertexLabel("organization");
        TitanGraphTest.evaluateQuery(this.tx.query().has(time, (TitanPredicate)Cmp.EQUAL, (Object)10).has(weight, (TitanPredicate)Cmp.EQUAL, (Object)0), ElementCategory.EDGE, 0, new boolean[]{true, true}, edge1.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(time, (TitanPredicate)Cmp.EQUAL, (Object)110).has(weight, (TitanPredicate)Cmp.EQUAL, (Object)0), ElementCategory.EDGE, 1, new boolean[]{true, true}, edge1.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(text, (TitanPredicate)Cmp.EQUAL, (Object)strs[0]).has("label", (Object)connect.getName()).limit(10), ElementCategory.EDGE, 10, new boolean[]{true, true}, edge2.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(weight, (TitanPredicate)Cmp.EQUAL, (Object)1.5), ElementCategory.EDGE, 20, new boolean[]{false, true}, new String[0]);
        TitanGraphTest.evaluateQuery(this.tx.query().has(time, (TitanPredicate)Cmp.EQUAL, (Object)20), ElementCategory.PROPERTY, 0, new boolean[]{true, true}, prop1.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(time, (TitanPredicate)Cmp.EQUAL, (Object)120), ElementCategory.PROPERTY, 2, new boolean[]{true, true}, prop1.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(time, (TitanPredicate)Cmp.EQUAL, (Object)30).has("label", (Object)person.getName()), ElementCategory.VERTEX, 0, new boolean[]{true, true}, vertex1.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(time, (TitanPredicate)Cmp.EQUAL, (Object)130).has("label", (Object)person.getName()), ElementCategory.VERTEX, 1, new boolean[]{true, true}, vertex1.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(name, (TitanPredicate)Cmp.EQUAL, (Object)"u1"), ElementCategory.VERTEX, 20, new boolean[]{true, true}, vertex3.getName());
    }

    @Test
    public void testIndexUniqueness() {
        PropertyKey time = this.makeKey("time", Long.class);
        PropertyKey text = this.makeKey("text", String.class);
        VertexLabel person = this.mgmt.makeVertexLabel("person").make();
        VertexLabel org = this.mgmt.makeVertexLabel("organization").make();
        TitanGraphIndex vindex1 = this.mgmt.buildIndex("vindex1", Vertex.class).addKey(time).indexOnly((TitanSchemaType)person).unique().buildCompositeIndex();
        TitanGraphIndex vindex2 = this.mgmt.buildIndex("vindex2", Vertex.class).addKey(time).addKey(text).unique().buildCompositeIndex();
        this.finishSchema();
        this.failTransactionOnCommit(new TransactionJob(){

            @Override
            public void run(TitanTransaction tx) {
                TitanVertex v0 = tx.addVertexWithLabel("person");
                v0.setProperty("time", (Object)1);
                TitanVertex v1 = tx.addVertexWithLabel("person");
                v1.setProperty("time", (Object)1);
            }
        });
        TitanVertex v0 = this.tx.addVertexWithLabel("person");
        v0.setProperty("time", (Object)1);
        this.newTx();
        this.failTransactionOnCommit(new TransactionJob(){

            @Override
            public void run(TitanTransaction tx) {
                TitanVertex v1 = tx.addVertexWithLabel("person");
                v1.setProperty("time", (Object)1);
            }
        });
        TitanVertex v1 = this.tx.addVertexWithLabel("organization");
        v1.setProperty("time", (Object)1);
        this.newTx();
        this.failTransactionOnCommit(new TransactionJob(){

            @Override
            public void run(TitanTransaction tx) {
                TitanVertex v0 = tx.addVertex();
                ElementHelper.setProperties((Element)v0, (Object[])new Object[]{"time", 2, "text", "hello"});
                TitanVertex v1 = tx.addVertex();
                ElementHelper.setProperties((Element)v1, (Object[])new Object[]{"time", 2, "text", "hello"});
            }
        });
        v0 = this.tx.addVertex();
        ElementHelper.setProperties((Element)v0, (Object[])new Object[]{"time", 2, "text", "hello"});
        this.newTx();
        this.failTransactionOnCommit(new TransactionJob(){

            @Override
            public void run(TitanTransaction tx) {
                TitanVertex v1 = tx.addVertex();
                ElementHelper.setProperties((Element)v1, (Object[])new Object[]{"time", 2, "text", "hello"});
            }
        });
    }

    public static void evaluateQuery(TitanGraphQuery query, ElementCategory resultType, int expectedResults, boolean[] subQuerySpecs, PropertyKey orderKey1, Order order1, String ... intersectingIndexes) {
        TitanGraphTest.evaluateQuery(query, resultType, expectedResults, subQuerySpecs, (Map<PropertyKey, Order>)ImmutableMap.of((Object)orderKey1, (Object)order1), intersectingIndexes);
    }

    public static void evaluateQuery(TitanGraphQuery query, ElementCategory resultType, int expectedResults, boolean[] subQuerySpecs, PropertyKey orderKey1, Order order1, PropertyKey orderKey2, Order order2, String ... intersectingIndexes) {
        TitanGraphTest.evaluateQuery(query, resultType, expectedResults, subQuerySpecs, (Map<PropertyKey, Order>)ImmutableMap.of((Object)orderKey1, (Object)order1, (Object)orderKey2, (Object)order2), intersectingIndexes);
    }

    public static void evaluateQuery(TitanGraphQuery query, ElementCategory resultType, int expectedResults, boolean[] subQuerySpecs, String ... intersectingIndexes) {
        TitanGraphTest.evaluateQuery(query, resultType, expectedResults, subQuerySpecs, (Map<PropertyKey, Order>)ImmutableMap.of(), intersectingIndexes);
    }

    public static void evaluateQuery(TitanGraphQuery query, ElementCategory resultType, int expectedResults, boolean[] subQuerySpecs, Map<PropertyKey, Order> orderMap, String ... intersectingIndexes) {
        Iterable result;
        QueryDescription qd;
        if (intersectingIndexes == null) {
            intersectingIndexes = new String[]{};
        }
        switch (resultType) {
            case PROPERTY: {
                qd = query.describeForProperties();
                break;
            }
            case EDGE: {
                qd = query.describeForEdges();
                break;
            }
            case VERTEX: {
                qd = query.describeForVertices();
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        Assert.assertEquals((long)1L, (long)qd.getNoCombinedQueries());
        Assert.assertEquals((long)1L, (long)qd.getNoSubQueries());
        QueryDescription.SubQuery sq = (QueryDescription.SubQuery)qd.getSubQueries().get(0);
        Assert.assertNotNull((Object)sq);
        if (subQuerySpecs.length == 2) {
            Assert.assertEquals((Object)subQuerySpecs[0], (Object)sq.isFitted());
            Assert.assertEquals((Object)subQuerySpecs[1], (Object)sq.isSorted());
        }
        StandardQueryDescription.StandardSubQuery ssq = (StandardQueryDescription.StandardSubQuery)sq;
        Assert.assertEquals((long)intersectingIndexes.length, (long)ssq.numIntersectingQueries());
        Assert.assertEquals((Object)Sets.newHashSet((Object[])intersectingIndexes), (Object)Sets.newHashSet((Iterable)ssq.getIntersectingQueries()));
        OrderList orders = ((StandardQueryDescription)qd).getQueryOrder();
        Assert.assertNotNull((Object)orders);
        Assert.assertEquals((long)orderMap.size(), (long)orders.size());
        for (int i = 0; i < orders.size(); ++i) {
            Assert.assertEquals((Object)orderMap.get(orders.getKey(i)), (Object)orders.getOrder(i));
        }
        for (PropertyKey key : orderMap.keySet()) {
            Assert.assertTrue((boolean)orders.containsKey(key));
        }
        switch (resultType) {
            case PROPERTY: {
                result = query.properties();
                break;
            }
            case EDGE: {
                result = query.edges();
                break;
            }
            case VERTEX: {
                result = query.vertices();
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        int no = 0;
        TitanElement previous = null;
        for (TitanElement e : result) {
            Assert.assertNotNull((Object)e);
            ++no;
            if (previous != null && !orders.isEmpty()) {
                Assert.assertTrue((orders.compare(previous, e) <= 0 ? 1 : 0) != 0);
            }
            previous = e;
        }
        Assert.assertEquals((long)expectedResults, (long)no);
    }

    @Test
    public void testForceIndexUsage() {
        PropertyKey age = this.makeKey("age", Integer.class);
        PropertyKey time = this.makeKey("time", Long.class);
        this.mgmt.buildIndex("time", Vertex.class).addKey(time).buildCompositeIndex();
        this.finishSchema();
        for (int i = 1; i <= 10; ++i) {
            TitanVertex v = this.tx.addVertex();
            v.setProperty("time", (Object)i);
            v.setProperty("age", (Object)i);
        }
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)this.tx.query().has("time", (Object)5).vertices()));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)this.tx.query().has("age", (Object)6).vertices()));
        this.clopen(TitanGraphTest.option(GraphDatabaseConfiguration.FORCE_INDEX_USAGE, new String[0]), true);
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)this.tx.query().has("time", (Object)5).vertices()));
        try {
            Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)this.tx.query().has("age", (Object)6).vertices()));
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testPropertyIndexPersistence() {
        String propName = "favorite_color";
        String sharedValue = "blue";
        this.tx.makePropertyKey("favorite_color").dataType(String.class).make();
        TitanVertex alice = this.tx.addVertex();
        TitanVertex bob = this.tx.addVertex();
        alice.addProperty("favorite_color", (Object)"blue");
        this.clopen(new Object[0]);
        alice = this.tx.getVertex(alice.getLongId());
        bob = this.tx.getVertex(bob.getLongId());
        Assert.assertEquals((Object)"blue", (Object)alice.getProperty("favorite_color"));
        Assert.assertEquals(null, (Object)bob.getProperty("favorite_color"));
        alice.removeProperty("favorite_color");
        bob.addProperty("favorite_color", (Object)"blue");
        this.clopen(new Object[0]);
    }

    @Test
    public void testJointIndexRetrieval() {
        this.makeVertexIndexedKey("name", String.class);
        this.makeVertexIndexedKey("color", String.class);
        this.finishSchema();
        TitanVertex v = this.graph.addVertex(null);
        v.setProperty("name", (Object)"ilya");
        v.setProperty("color", (Object)"blue");
        this.graph.commit();
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)this.graph.query().has("name", (Object)"ilya").vertices()));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)this.graph.query().has("name", (Object)"ilya").has("color", (Object)"blue").vertices()));
    }

    @Test
    public void testLargeJointIndexRetrieval() {
        this.makeVertexIndexedKey("sid", Integer.class);
        this.makeVertexIndexedKey("color", String.class);
        this.finishSchema();
        int sids = 17;
        String[] colors = new String[]{"blue", "red", "yellow", "brown", "green", "orange", "purple"};
        int multiplier = 200;
        int numV = sids * colors.length * multiplier;
        for (int i = 0; i < numV; ++i) {
            TitanVertex v = this.graph.addVertex(null);
            v.setProperty("color", (Object)colors[i % colors.length]);
            v.setProperty("sid", (Object)(i % sids));
        }
        this.graph.commit();
        this.clopen(new Object[0]);
        Assert.assertEquals((long)(numV / sids), (long)Iterables.size((Iterable)this.graph.query().has("sid", (Object)8).vertices()));
        Assert.assertEquals((long)(numV / colors.length), (long)Iterables.size((Iterable)this.graph.query().has("color", (Object)colors[2]).vertices()));
        Assert.assertEquals((long)multiplier, (long)Iterables.size((Iterable)this.graph.query().has("sid", (Object)11).has("color", (Object)colors[3]).vertices()));
    }

    @Test
    public void testIndexRetrieval() {
        int i;
        PropertyKey id = this.mgmt.makePropertyKey("uid").dataType(Integer.class).make();
        this.mgmt.buildIndex("vuid", Vertex.class).unique().addKey(id).buildCompositeIndex();
        this.mgmt.buildIndex("euid", Edge.class).addKey(id).buildCompositeIndex();
        PropertyKey name = this.mgmt.makePropertyKey("name").dataType(String.class).make();
        this.mgmt.buildIndex("vname", Vertex.class).addKey(name).buildCompositeIndex();
        this.mgmt.buildIndex("ename", Edge.class).addKey(name).buildCompositeIndex();
        this.mgmt.makeEdgeLabel("connect").signature(new RelationType[]{id, name}).make();
        this.finishSchema();
        int noNodes = 100;
        int div = 10;
        int mod = noNodes / div;
        for (i = 0; i < noNodes; ++i) {
            TitanVertex n = this.tx.addVertex();
            n.addProperty("uid", (Object)i);
            n.addProperty("name", (Object)("Name" + i % mod));
            TitanVertex other = this.getVertex("uid", (Object)Math.max(0, i - 1));
            Preconditions.checkNotNull((Object)other);
            TitanEdge e = n.addEdge("connect", other);
            e.setProperty("uid", (Object)i);
            e.setProperty("name", (Object)("Edge" + i % mod));
        }
        this.clopen(new Object[0]);
        for (int j = 0; j < mod; ++j) {
            Iterable nodes = this.tx.getVertices("name", (Object)("Name" + j));
            Assert.assertEquals((long)div, (long)Iterables.size((Iterable)nodes));
            for (Vertex n : nodes) {
                int nid = ((Number)n.getProperty("uid")).intValue();
                Assert.assertEquals((long)j, (long)(nid % mod));
            }
            Iterable edges = this.tx.getEdges("name", (Object)("Edge" + j));
            Assert.assertEquals((long)div, (long)Iterables.size((Iterable)edges));
            for (Edge e : edges) {
                int nid = ((Number)e.getProperty("uid")).intValue();
                Assert.assertEquals((long)j, (long)(nid % mod));
            }
        }
        this.clopen(new Object[0]);
        for (i = 0; i < noNodes; ++i) {
            Assert.assertEquals((Object)this.getVertex("uid", (Object)i).getProperty("name").toString().substring(4), (Object)String.valueOf(i % mod));
        }
        for (i = 0; i < noNodes; ++i) {
            Assert.assertEquals((Object)((Edge)Iterables.getOnlyElement((Iterable)this.tx.getEdges("uid", (Object)i))).getProperty("name").toString().substring(4), (Object)String.valueOf(i % mod));
        }
    }

    @Test
    public void testIndexQueryWithLabelsAndContainsIN() {
        String labelName = "labelName";
        VertexLabel label = this.mgmt.makeVertexLabel(labelName).make();
        PropertyKey uid = this.mgmt.makePropertyKey("uid").dataType(String.class).make();
        TitanGraphIndex uidCompositeIndex = this.mgmt.buildIndex("uidIndex", Vertex.class).indexOnly((TitanSchemaType)label).addKey(uid).unique().buildCompositeIndex();
        this.mgmt.setConsistency((TitanSchemaElement)uidCompositeIndex, ConsistencyModifier.LOCK);
        this.finishSchema();
        TitanVertex foo = this.graph.addVertexWithLabel(labelName);
        TitanVertex bar = this.graph.addVertexWithLabel(labelName);
        foo.setProperty("uid", (Object)"foo");
        bar.setProperty("uid", (Object)"bar");
        this.graph.commit();
        Iterable vertexes = this.graph.query().has("uid", (Predicate)Contain.IN, (Object)ImmutableList.of((Object)"foo", (Object)"bar")).has("label", (Object)labelName).vertices();
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)vertexes));
        for (Vertex v : vertexes) {
            Assert.assertEquals((Object)labelName, (Object)((TitanVertex)v).getLabel());
        }
    }

    @Test
    public void testLimitWithMixedIndexCoverage() {
        String vt = "vt";
        String fn = "firstname";
        String user = "user";
        String alice = "alice";
        String bob = "bob";
        PropertyKey vtk = this.makeVertexIndexedKey("vt", String.class);
        PropertyKey fnk = this.makeKey("firstname", String.class);
        this.finishSchema();
        vtk = this.tx.getPropertyKey("vt");
        fnk = this.tx.getPropertyKey("firstname");
        TitanVertex a = this.tx.addVertex();
        a.setProperty(vtk, (Object)"user");
        a.setProperty(fnk, (Object)"alice");
        TitanVertex b = this.tx.addVertex();
        b.setProperty(vtk, (Object)"user");
        b.setProperty(fnk, (Object)"bob");
        Iterable i = this.tx.query().has("vt", (Object)"user").has("firstname", (Object)"bob").limit(1).vertices();
        Assert.assertEquals((Object)"bob", (Object)((Vertex)Iterators.getOnlyElement(i.iterator())).getProperty("firstname"));
        Assert.assertEquals((Object)"user", (Object)((Vertex)Iterators.getOnlyElement(i.iterator())).getProperty("vt"));
        Assert.assertEquals((long)1L, (long)Iterators.size(i.iterator()));
        i = this.tx.query().has("vt", (Object)"user").has("firstname", (Object)"alice").limit(1).vertices();
        Assert.assertEquals((Object)"alice", (Object)((Vertex)Iterators.getOnlyElement(i.iterator())).getProperty("firstname"));
        Assert.assertEquals((Object)"user", (Object)((Vertex)Iterators.getOnlyElement(i.iterator())).getProperty("vt"));
        Assert.assertEquals((long)1L, (long)Iterators.size(i.iterator()));
        this.tx.commit();
        this.tx = this.graph.newTransaction();
        i = this.tx.query().has("vt", (Object)"user").has("firstname", (Object)"bob").limit(1).vertices();
        Assert.assertEquals((Object)"bob", (Object)((Vertex)Iterators.getOnlyElement(i.iterator())).getProperty("firstname"));
        Assert.assertEquals((Object)"user", (Object)((Vertex)Iterators.getOnlyElement(i.iterator())).getProperty("vt"));
        Assert.assertEquals((long)1L, (long)Iterators.size(i.iterator()));
        i = this.tx.query().has("vt", (Object)"user").has("firstname", (Object)"alice").limit(1).vertices();
        Assert.assertEquals((Object)"alice", (Object)((Vertex)Iterators.getOnlyElement(i.iterator())).getProperty("firstname"));
        Assert.assertEquals((Object)"user", (Object)((Vertex)Iterators.getOnlyElement(i.iterator())).getProperty("vt"));
        Assert.assertEquals((long)1L, (long)Iterators.size(i.iterator()));
    }

    @Test
    public void testWithoutIndex() {
        PropertyKey kid = this.mgmt.makePropertyKey("kid").dataType(Long.class).make();
        this.mgmt.makePropertyKey("name").dataType(String.class).make();
        this.mgmt.makeEdgeLabel("knows").signature(new RelationType[]{kid}).make();
        this.finishSchema();
        Random random = new Random();
        int numV = 1000;
        TitanVertex previous = null;
        for (int i = 0; i < numV; ++i) {
            TitanVertex v = this.graph.addVertex(null);
            v.setProperty("kid", (Object)random.nextInt(numV));
            v.setProperty("name", (Object)("v" + i));
            if (previous != null) {
                TitanEdge e = v.addEdge("knows", previous);
                e.setProperty("kid", (Object)random.nextInt(numV / 2));
            }
            previous = v;
        }
        TestUtil.verifyElementOrder(this.graph.query().orderBy("kid", Order.ASC).limit(500).vertices(), "kid", Order.ASC, 500);
        TestUtil.verifyElementOrder(this.graph.query().orderBy("kid", Order.ASC).limit(300).edges(), "kid", Order.ASC, 300);
        TestUtil.verifyElementOrder(this.graph.query().orderBy("kid", Order.DESC).limit(400).vertices(), "kid", Order.DESC, 400);
        TestUtil.verifyElementOrder(this.graph.query().orderBy("kid", Order.DESC).limit(200).edges(), "kid", Order.DESC, 200);
        this.clopen(new Object[0]);
        TestUtil.verifyElementOrder(this.graph.query().orderBy("kid", Order.ASC).limit(500).vertices(), "kid", Order.ASC, 500);
        TestUtil.verifyElementOrder(this.graph.query().orderBy("kid", Order.ASC).limit(300).edges(), "kid", Order.ASC, 300);
        TestUtil.verifyElementOrder(this.graph.query().orderBy("kid", Order.DESC).limit(400).vertices(), "kid", Order.DESC, 400);
        TestUtil.verifyElementOrder(this.graph.query().orderBy("kid", Order.DESC).limit(200).edges(), "kid", Order.DESC, 200);
    }

    @Test
    public void testHasNot() {
        TitanVertex v1 = this.graph.addVertex();
        Vertex v2 = (Vertex)this.graph.query().hasNot("abcd").vertices().iterator().next();
        Assert.assertEquals((Object)v1, (Object)v2);
        v2 = (Vertex)this.graph.query().hasNot("abcd", (Object)true).vertices().iterator().next();
        Assert.assertEquals((Object)v1, (Object)v2);
    }

    @Test
    public void testVertexCentricIndexWithNull() {
        EdgeLabel bought = this.makeLabel("bought");
        PropertyKey time = this.makeKey("time", Long.class);
        this.mgmt.buildEdgeIndex(bought, "byTimeDesc", Direction.BOTH, Order.DESC, new RelationType[]{time});
        this.mgmt.buildEdgeIndex(bought, "byTimeIncr", Direction.BOTH, Order.ASC, new RelationType[]{time});
        this.finishSchema();
        TitanVertex v1 = this.tx.addVertex();
        TitanVertex v2 = this.tx.addVertex();
        v1.addEdge("bought", (Vertex)v2).setProperty("time", (Object)1);
        v1.addEdge("bought", (Vertex)v2).setProperty("time", (Object)2);
        v1.addEdge("bought", (Vertex)v2).setProperty("time", (Object)3);
        v1.addEdge("bought", (Vertex)v2);
        v1.addEdge("bought", (Vertex)v2);
        Assert.assertEquals((long)5L, (long)v1.query().direction(Direction.OUT).labels(new String[]{"bought"}).count());
        Assert.assertEquals((long)1L, (long)v1.query().direction(Direction.OUT).labels(new String[]{"bought"}).has("time", (Object)1).count());
        Assert.assertEquals((long)1L, (long)v1.query().direction(Direction.OUT).labels(new String[]{"bought"}).has("time", (Predicate)Cmp.LESS_THAN, (Object)3).has("time", (Predicate)Cmp.GREATER_THAN, (Object)1).count());
        Assert.assertEquals((long)3L, (long)v1.query().direction(Direction.OUT).labels(new String[]{"bought"}).has("time", (Predicate)Cmp.LESS_THAN, (Object)5).count());
        Assert.assertEquals((long)3L, (long)v1.query().direction(Direction.OUT).labels(new String[]{"bought"}).has("time", (Predicate)Cmp.GREATER_THAN, (Object)0).count());
        Assert.assertEquals((long)2L, (long)v1.query().direction(Direction.OUT).labels(new String[]{"bought"}).has("time", (Predicate)Cmp.LESS_THAN, (Object)3).count());
        Assert.assertEquals((long)1L, (long)v1.query().direction(Direction.OUT).labels(new String[]{"bought"}).has("time", (Predicate)Cmp.GREATER_THAN, (Object)2).count());
        Assert.assertEquals((long)2L, (long)v1.query().direction(Direction.OUT).labels(new String[]{"bought"}).hasNot("time").count());
        Assert.assertEquals((long)5L, (long)v1.query().direction(Direction.OUT).labels(new String[]{"bought"}).count());
        this.newTx();
        v1 = this.tx.getVertex((Object)v1);
        Assert.assertEquals((long)5L, (long)v1.query().direction(Direction.OUT).labels(new String[]{"bought"}).count());
        Assert.assertEquals((long)1L, (long)v1.query().direction(Direction.OUT).labels(new String[]{"bought"}).has("time", (Object)1).count());
        Assert.assertEquals((long)1L, (long)v1.query().direction(Direction.OUT).labels(new String[]{"bought"}).has("time", (Predicate)Cmp.LESS_THAN, (Object)3).has("time", (Predicate)Cmp.GREATER_THAN, (Object)1).count());
        Assert.assertEquals((long)3L, (long)v1.query().direction(Direction.OUT).labels(new String[]{"bought"}).has("time", (Predicate)Cmp.LESS_THAN, (Object)5).count());
        Assert.assertEquals((long)3L, (long)v1.query().direction(Direction.OUT).labels(new String[]{"bought"}).has("time", (Predicate)Cmp.GREATER_THAN, (Object)0).count());
        Assert.assertEquals((long)2L, (long)v1.query().direction(Direction.OUT).labels(new String[]{"bought"}).has("time", (Predicate)Cmp.LESS_THAN, (Object)3).count());
        Assert.assertEquals((long)1L, (long)v1.query().direction(Direction.OUT).labels(new String[]{"bought"}).has("time", (Predicate)Cmp.GREATER_THAN, (Object)2).count());
        Assert.assertEquals((long)2L, (long)v1.query().direction(Direction.OUT).labels(new String[]{"bought"}).hasNot("time").count());
        Assert.assertEquals((long)5L, (long)v1.query().direction(Direction.OUT).labels(new String[]{"bought"}).count());
    }

    @Test
    public void testCreateDelete() {
        this.makeKey("weight", Double.class);
        PropertyKey id = this.makeVertexIndexedUniqueKey("uid", Integer.class);
        ((StandardEdgeLabelMaker)this.mgmt.makeEdgeLabel("knows")).sortKey(new RelationType[]{id}).sortOrder(Order.DESC).directed().make();
        this.mgmt.makeEdgeLabel("father").multiplicity(Multiplicity.MANY2ONE).make();
        this.finishSchema();
        id = this.tx.getPropertyKey("uid");
        TitanVertex n1 = this.graph.addVertex(null);
        TitanVertex n3 = this.graph.addVertex(null);
        TitanEdge e = n3.addEdge("knows", n1);
        TitanEdge e2 = n1.addEdge("friend", n3);
        e.setProperty(id, (Object)111);
        n3.addProperty(id, (Object)445);
        Assert.assertEquals((Object)111, (Object)e.getProperty(id));
        this.graph.commit();
        n3 = this.graph.getVertex(n3.getLongId());
        Assert.assertEquals((Object)445, (Object)n3.getProperty("uid"));
        e = (TitanEdge)Iterables.getOnlyElement((Iterable)n3.getEdges(Direction.OUT, new String[]{"knows"}));
        Assert.assertEquals((Object)111, (Object)e.getProperty("uid"));
        Assert.assertEquals((Object)e, (Object)this.graph.getEdge(e.getId()));
        Assert.assertEquals((Object)e, (Object)this.graph.getEdge((Object)e.getId().toString()));
        TitanProperty p = (TitanProperty)Iterables.getOnlyElement((Iterable)n3.getProperties("uid"));
        p.remove();
        n3.addProperty("uid", (Object)353);
        e = (TitanEdge)Iterables.getOnlyElement((Iterable)n3.getEdges(Direction.OUT, new String[]{"knows"}));
        e.setProperty(id, (Object)222);
        e2 = (Edge)Iterables.getOnlyElement((Iterable)n1.getEdges(Direction.OUT, new String[]{"friend"}));
        e2.setProperty("uid", (Object)1);
        e2.setProperty("weight", (Object)2.0);
        Assert.assertEquals((Object)1, (Object)e2.getProperty("uid"));
        Assert.assertEquals((Object)2.0, (Object)e2.getProperty("weight"));
        this.clopen(new Object[0]);
        n3 = this.graph.getVertex(n3.getLongId());
        Assert.assertEquals((Object)353, (Object)n3.getProperty("uid"));
        e = (TitanEdge)Iterables.getOnlyElement((Iterable)n3.getEdges(Direction.OUT, new String[]{"knows"}));
        Assert.assertEquals((Object)222, (Object)e.getProperty(id));
    }

    @Test
    public void testEdgeTTLTiming() throws Exception {
        if (!this.features.hasCellTTL()) {
            return;
        }
        EdgeLabel label1 = this.mgmt.makeEdgeLabel("likes").make();
        int ttl1 = 1;
        int ttl2 = 4;
        this.mgmt.setTTL((TitanSchemaType)label1, ttl1, TimeUnit.SECONDS);
        EdgeLabel label2 = this.mgmt.makeEdgeLabel("dislikes").make();
        this.mgmt.setTTL((TitanSchemaType)label2, ttl2, TimeUnit.SECONDS);
        EdgeLabel label3 = this.mgmt.makeEdgeLabel("indifferentTo").make();
        Assert.assertEquals((long)ttl1, (long)this.mgmt.getTTL((TitanSchemaType)label1).getLength(TimeUnit.SECONDS));
        Assert.assertEquals((long)ttl2, (long)this.mgmt.getTTL((TitanSchemaType)label2).getLength(TimeUnit.SECONDS));
        Assert.assertEquals((long)0L, (long)this.mgmt.getTTL((TitanSchemaType)label3).getLength(TimeUnit.SECONDS));
        this.mgmt.commit();
        TitanVertex v1 = this.graph.addVertex(null);
        TitanVertex v2 = this.graph.addVertex(null);
        TitanVertex v3 = this.graph.addVertex(null);
        this.graph.addEdge(null, (Vertex)v1, (Vertex)v2, "likes");
        this.graph.addEdge(null, (Vertex)v2, (Vertex)v1, "dislikes");
        this.graph.addEdge(null, (Vertex)v3, (Vertex)v1, "indifferentTo");
        Assert.assertTrue((boolean)v1.getVertices(Direction.OUT, new String[0]).iterator().hasNext());
        Assert.assertTrue((boolean)v2.getVertices(Direction.OUT, new String[0]).iterator().hasNext());
        Assert.assertTrue((boolean)v3.getVertices(Direction.OUT, new String[0]).iterator().hasNext());
        long commitTime = System.currentTimeMillis();
        this.graph.commit();
        Assert.assertTrue((boolean)v1.getVertices(Direction.OUT, new String[0]).iterator().hasNext());
        Assert.assertTrue((boolean)v2.getVertices(Direction.OUT, new String[0]).iterator().hasNext());
        Assert.assertTrue((boolean)v3.getVertices(Direction.OUT, new String[0]).iterator().hasNext());
        Thread.sleep(commitTime + ((long)ttl1 * 1000L + 200L) - System.currentTimeMillis());
        this.graph.rollback();
        Assert.assertFalse((boolean)v1.getVertices(Direction.OUT, new String[0]).iterator().hasNext());
        Assert.assertTrue((boolean)v2.getVertices(Direction.OUT, new String[0]).iterator().hasNext());
        Assert.assertTrue((boolean)v3.getVertices(Direction.OUT, new String[0]).iterator().hasNext());
        Thread.sleep(commitTime + ((long)ttl2 * 1000L + 500L) - System.currentTimeMillis());
        this.graph.rollback();
        Assert.assertFalse((boolean)v1.getVertices(Direction.OUT, new String[0]).iterator().hasNext());
        Assert.assertFalse((boolean)v2.getVertices(Direction.OUT, new String[0]).iterator().hasNext());
        Assert.assertTrue((boolean)v3.getVertices(Direction.OUT, new String[0]).iterator().hasNext());
    }

    @Test
    public void testEdgeTTLWithTransactions() throws Exception {
        if (!this.features.hasCellTTL()) {
            return;
        }
        EdgeLabel label1 = this.mgmt.makeEdgeLabel("likes").make();
        this.mgmt.setTTL((TitanSchemaType)label1, 1, TimeUnit.SECONDS);
        Assert.assertEquals((long)1L, (long)this.mgmt.getTTL((TitanSchemaType)label1).getLength(TimeUnit.SECONDS));
        this.mgmt.commit();
        TitanVertex v1 = this.graph.addVertex(null);
        TitanVertex v2 = this.graph.addVertex(null);
        this.graph.addEdge(null, (Vertex)v1, (Vertex)v2, "likes");
        Assert.assertTrue((boolean)v1.getVertices(Direction.OUT, new String[0]).iterator().hasNext());
        Thread.sleep(1001L);
        Assert.assertTrue((boolean)v1.getVertices(Direction.OUT, new String[0]).iterator().hasNext());
        this.graph.commit();
        Assert.assertTrue((boolean)v1.getVertices(Direction.OUT, new String[0]).iterator().hasNext());
        Thread.sleep(1001L);
        Assert.assertTrue((boolean)v1.getVertices(Direction.OUT, new String[0]).iterator().hasNext());
        this.graph.rollback();
        Assert.assertFalse((boolean)v1.getVertices(Direction.OUT, new String[0]).iterator().hasNext());
    }

    @Category(value={BrittleTests.class})
    @Test
    public void testEdgeTTLWithVertexCentricIndex() throws Exception {
        if (!this.features.hasCellTTL()) {
            return;
        }
        int ttl = 1;
        PropertyKey time = this.mgmt.makePropertyKey("time").dataType(Integer.class).make();
        EdgeLabel wavedAt = this.mgmt.makeEdgeLabel("wavedAt").signature(new RelationType[]{time}).make();
        this.mgmt.buildEdgeIndex(wavedAt, "timeindex", Direction.BOTH, Order.DESC, new RelationType[]{time});
        this.mgmt.setTTL((TitanSchemaType)wavedAt, ttl, TimeUnit.SECONDS);
        Assert.assertEquals((long)0L, (long)this.mgmt.getTTL((TitanSchemaType)time).getLength(TimeUnit.SECONDS));
        Assert.assertEquals((long)ttl, (long)this.mgmt.getTTL((TitanSchemaType)wavedAt).getLength(TimeUnit.SECONDS));
        this.mgmt.commit();
        TitanVertex v1 = this.graph.addVertex(null);
        TitanVertex v2 = this.graph.addVertex(null);
        TitanEdge e1 = this.graph.addEdge(null, (Vertex)v1, (Vertex)v2, "wavedAt");
        e1.setProperty("time", (Object)42);
        Assert.assertTrue((boolean)v1.getEdges(Direction.OUT, new String[0]).iterator().hasNext());
        Assert.assertTrue((boolean)v1.query().direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(100)).edges().iterator().hasNext());
        this.graph.commit();
        long commitTime = System.currentTimeMillis();
        Assert.assertTrue((boolean)v1.getEdges(Direction.OUT, new String[0]).iterator().hasNext());
        Assert.assertTrue((boolean)v1.query().direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(100)).edges().iterator().hasNext());
        Thread.sleep(commitTime + ((long)ttl * 1000L + 100L) - System.currentTimeMillis());
        this.graph.rollback();
        Assert.assertFalse((boolean)v1.getEdges(Direction.OUT, new String[0]).iterator().hasNext());
        Assert.assertFalse((boolean)v1.query().direction(Direction.OUT).interval("time", (Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(100)).edges().iterator().hasNext());
    }

    @Test
    public void testEdgeTTLWithCompositeIndex() throws Exception {
        if (!this.features.hasCellTTL()) {
            return;
        }
        PropertyKey edgeName = this.mgmt.makePropertyKey("edge-name").dataType(String.class).make();
        this.mgmt.buildIndex("edge-name", Edge.class).addKey(edgeName).buildCompositeIndex();
        EdgeLabel label = this.mgmt.makeEdgeLabel("likes").make();
        this.mgmt.setTTL((TitanSchemaType)label, 1, TimeUnit.SECONDS);
        Assert.assertEquals((long)0L, (long)this.mgmt.getTTL((TitanSchemaType)edgeName).getLength(TimeUnit.SECONDS));
        Assert.assertEquals((long)1L, (long)this.mgmt.getTTL((TitanSchemaType)label).getLength(TimeUnit.SECONDS));
        this.mgmt.commit();
        TitanVertex v1 = this.graph.addVertex(null);
        TitanVertex v2 = this.graph.addVertex(null);
        TitanEdge e = this.graph.addEdge(null, (Vertex)v1, (Vertex)v2, "likes");
        e.setProperty("edge-name", (Object)"v1-likes-v2");
        this.graph.commit();
        Assert.assertTrue((boolean)v1.getEdges(Direction.OUT, new String[0]).iterator().hasNext());
        Assert.assertTrue((boolean)this.graph.getEdges("edge-name", (Object)"v1-likes-v2").iterator().hasNext());
        Thread.sleep(1001L);
        this.graph.rollback();
        Assert.assertFalse((boolean)this.graph.getEdges("edge-name", (Object)"v1-likes-v2").iterator().hasNext());
        Assert.assertFalse((boolean)v1.getEdges(Direction.OUT, new String[0]).iterator().hasNext());
    }

    @Category(value={BrittleTests.class})
    @Test
    public void testPropertyTTLTiming() throws Exception {
        if (!this.features.hasCellTTL()) {
            return;
        }
        PropertyKey name = this.mgmt.makePropertyKey("name").dataType(String.class).make();
        PropertyKey place = this.mgmt.makePropertyKey("place").dataType(String.class).make();
        this.mgmt.setTTL((TitanSchemaType)name, 42, TimeUnit.SECONDS);
        this.mgmt.setTTL((TitanSchemaType)place, 1, TimeUnit.SECONDS);
        TitanGraphIndex index1 = this.mgmt.buildIndex("index1", Vertex.class).addKey(name).buildCompositeIndex();
        TitanGraphIndex index2 = this.mgmt.buildIndex("index2", Vertex.class).addKey(name).addKey(place).buildCompositeIndex();
        VertexLabel label1 = this.mgmt.makeVertexLabel("event").setStatic().make();
        this.mgmt.setTTL((TitanSchemaType)label1, 2, TimeUnit.SECONDS);
        Assert.assertEquals((long)42L, (long)this.mgmt.getTTL((TitanSchemaType)name).getLength(TimeUnit.SECONDS));
        Assert.assertEquals((long)1L, (long)this.mgmt.getTTL((TitanSchemaType)place).getLength(TimeUnit.SECONDS));
        Assert.assertEquals((long)2L, (long)this.mgmt.getTTL((TitanSchemaType)label1).getLength(TimeUnit.SECONDS));
        this.mgmt.commit();
        TitanVertex v1 = this.tx.addVertexWithLabel("event");
        v1.setProperty("name", (Object)"some event");
        v1.setProperty("place", (Object)"somewhere");
        this.tx.commit();
        Object id = v1.getId();
        v1 = this.graph.getVertex(id);
        Assert.assertNotNull((Object)v1);
        Assert.assertTrue((boolean)this.graph.query().has("name", (Object)"some event").has("place", (Object)"somewhere").vertices().iterator().hasNext());
        Assert.assertTrue((boolean)this.graph.getVertices("name", (Object)"some event").iterator().hasNext());
        Thread.sleep(1001L);
        this.graph.rollback();
        v1 = this.graph.getVertex(id);
        Assert.assertNotNull((Object)v1);
        Assert.assertFalse((boolean)this.graph.query().has("name", (Object)"some event").has("place", (Object)"somewhere").vertices().iterator().hasNext());
        Assert.assertTrue((boolean)this.graph.getVertices("name", (Object)"some event").iterator().hasNext());
        Thread.sleep(1001L);
        this.graph.rollback();
        Assert.assertFalse((boolean)this.graph.query().has("name", (Object)"some event").has("place", (Object)"somewhere").vertices().iterator().hasNext());
        Assert.assertFalse((boolean)this.graph.getVertices("place", (Object)"somewhere").iterator().hasNext());
        v1 = this.graph.getVertex(id);
        Assert.assertNull((Object)v1);
    }

    @Test
    public void testVertexTTLWithCompositeIndex() throws Exception {
        if (!this.features.hasCellTTL()) {
            return;
        }
        PropertyKey name = this.mgmt.makePropertyKey("name").dataType(String.class).make();
        PropertyKey time = this.mgmt.makePropertyKey("time").dataType(Long.class).make();
        TitanGraphIndex index1 = this.mgmt.buildIndex("index1", Vertex.class).addKey(name).buildCompositeIndex();
        TitanGraphIndex index2 = this.mgmt.buildIndex("index2", Vertex.class).addKey(name).addKey(time).buildCompositeIndex();
        VertexLabel label1 = this.mgmt.makeVertexLabel("event").setStatic().make();
        this.mgmt.setTTL((TitanSchemaType)label1, 1, TimeUnit.SECONDS);
        Assert.assertEquals((long)0L, (long)this.mgmt.getTTL((TitanSchemaType)name).getLength(TimeUnit.SECONDS));
        Assert.assertEquals((long)0L, (long)this.mgmt.getTTL((TitanSchemaType)time).getLength(TimeUnit.SECONDS));
        Assert.assertEquals((long)1L, (long)this.mgmt.getTTL((TitanSchemaType)label1).getLength(TimeUnit.SECONDS));
        this.mgmt.commit();
        TitanVertex v1 = this.tx.addVertexWithLabel("event");
        v1.setProperty("name", (Object)"some event");
        v1.setProperty("time", (Object)System.currentTimeMillis());
        this.tx.commit();
        Object id = v1.getId();
        v1 = this.graph.getVertex(id);
        Assert.assertNotNull((Object)v1);
        Assert.assertTrue((boolean)this.graph.getVertices("name", (Object)"some event").iterator().hasNext());
        Thread.sleep(1001L);
        this.graph.rollback();
        v1 = this.graph.getVertex(id);
        Assert.assertNull((Object)v1);
        Assert.assertFalse((boolean)this.graph.getVertices("name", (Object)"some event").iterator().hasNext());
    }

    @Category(value={BrittleTests.class})
    @Test
    public void testEdgeTTLLimitedByVertexTTL() throws Exception {
        if (!this.features.hasCellTTL()) {
            return;
        }
        Boolean dbCache = (Boolean)this.config.get("cache.db-cache", Boolean.class);
        if (null == dbCache) {
            dbCache = false;
        }
        EdgeLabel likes = this.mgmt.makeEdgeLabel("likes").make();
        this.mgmt.setTTL((TitanSchemaType)likes, 42, TimeUnit.SECONDS);
        EdgeLabel dislikes = this.mgmt.makeEdgeLabel("dislikes").make();
        this.mgmt.setTTL((TitanSchemaType)dislikes, 1, TimeUnit.SECONDS);
        EdgeLabel indifferentTo = this.mgmt.makeEdgeLabel("indifferentTo").make();
        VertexLabel label1 = this.mgmt.makeVertexLabel("person").setStatic().make();
        this.mgmt.setTTL((TitanSchemaType)label1, 2, TimeUnit.SECONDS);
        Assert.assertEquals((long)42L, (long)this.mgmt.getTTL((TitanSchemaType)likes).getLength(TimeUnit.SECONDS));
        Assert.assertEquals((long)1L, (long)this.mgmt.getTTL((TitanSchemaType)dislikes).getLength(TimeUnit.SECONDS));
        Assert.assertEquals((long)0L, (long)this.mgmt.getTTL((TitanSchemaType)indifferentTo).getLength(TimeUnit.SECONDS));
        Assert.assertEquals((long)2L, (long)this.mgmt.getTTL((TitanSchemaType)label1).getLength(TimeUnit.SECONDS));
        this.mgmt.commit();
        TitanVertex v1 = this.tx.addVertexWithLabel("person");
        TitanVertex v2 = this.tx.addVertex();
        Edge v1LikesV2 = this.tx.addEdge(null, (Vertex)v1, (Vertex)v2, "likes");
        Edge v1DislikesV2 = this.tx.addEdge(null, (Vertex)v1, (Vertex)v2, "dislikes");
        Edge v1IndifferentToV2 = this.tx.addEdge(null, (Vertex)v1, (Vertex)v2, "indifferentTo");
        this.tx.commit();
        long commitTime = System.currentTimeMillis();
        Object v1Id = v1.getId();
        Object v2id = v2.getId();
        Object v1LikesV2Id = v1LikesV2.getId();
        Object v1DislikesV2Id = v1DislikesV2.getId();
        Object v1IndifferentToV2Id = v1IndifferentToV2.getId();
        v1 = this.graph.getVertex(v1Id);
        v2 = this.graph.getVertex(v2id);
        v1LikesV2 = this.graph.getEdge(v1LikesV2Id);
        v1DislikesV2 = this.graph.getEdge(v1DislikesV2Id);
        v1IndifferentToV2 = this.graph.getEdge(v1IndifferentToV2Id);
        Assert.assertNotNull((Object)v1);
        Assert.assertNotNull((Object)v2);
        Assert.assertNotNull((Object)v1LikesV2);
        Assert.assertNotNull((Object)v1DislikesV2);
        Assert.assertNotNull((Object)v1IndifferentToV2);
        Assert.assertTrue((boolean)v2.getEdges(Direction.IN, new String[]{"likes"}).iterator().hasNext());
        Assert.assertTrue((boolean)v2.getEdges(Direction.IN, new String[]{"dislikes"}).iterator().hasNext());
        Assert.assertTrue((boolean)v2.getEdges(Direction.IN, new String[]{"indifferentTo"}).iterator().hasNext());
        Thread.sleep(commitTime + 1001L - System.currentTimeMillis());
        this.graph.rollback();
        v1 = this.graph.getVertex(v1Id);
        v2 = this.graph.getVertex(v2id);
        v1LikesV2 = this.graph.getEdge(v1LikesV2Id);
        v1DislikesV2 = this.graph.getEdge(v1DislikesV2Id);
        v1IndifferentToV2 = this.graph.getEdge(v1IndifferentToV2Id);
        Assert.assertNotNull((Object)v1);
        Assert.assertNotNull((Object)v2);
        Assert.assertNotNull((Object)v1LikesV2);
        Assert.assertNull((Object)v1DislikesV2);
        Assert.assertNotNull((Object)v1IndifferentToV2);
        Assert.assertTrue((boolean)v2.getEdges(Direction.IN, new String[]{"likes"}).iterator().hasNext());
        Assert.assertFalse((boolean)v2.getEdges(Direction.IN, new String[]{"dislikes"}).iterator().hasNext());
        Assert.assertTrue((boolean)v2.getEdges(Direction.IN, new String[]{"indifferentTo"}).iterator().hasNext());
        Thread.sleep(commitTime + 2001L - System.currentTimeMillis());
        this.graph.rollback();
        v1 = this.graph.getVertex(v1Id);
        v2 = this.graph.getVertex(v2id);
        v1LikesV2 = this.graph.getEdge(v1LikesV2Id);
        v1DislikesV2 = this.graph.getEdge(v1DislikesV2Id);
        v1IndifferentToV2 = this.graph.getEdge(v1IndifferentToV2Id);
        Assert.assertNull((Object)v1);
        Assert.assertNotNull((Object)v2);
        Assert.assertNull((Object)v1LikesV2);
        Assert.assertNull((Object)v1DislikesV2);
        Assert.assertNull((Object)v1IndifferentToV2);
        if (!dbCache.booleanValue()) {
            Assert.assertFalse((boolean)v2.getEdges(Direction.IN, new String[]{"likes"}).iterator().hasNext());
            Assert.assertFalse((boolean)v2.getEdges(Direction.IN, new String[]{"dislikes"}).iterator().hasNext());
            Assert.assertFalse((boolean)v2.getEdges(Direction.IN, new String[]{"indifferentTo"}).iterator().hasNext());
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSettingTTLOnUnsupportedType() throws Exception {
        if (!this.features.hasCellTTL()) {
            throw new IllegalArgumentException();
        }
        ImplicitKey type = ImplicitKey.ID;
        this.mgmt.setTTL((TitanSchemaType)type, 0, TimeUnit.SECONDS);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testGetTTLFromUnsupportedType() throws Exception {
        if (!this.features.hasCellTTL()) {
            throw new IllegalArgumentException();
        }
        ImplicitKey type = ImplicitKey.ID;
        this.mgmt.getTTL((TitanSchemaType)type);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSettingTTLOnNonStaticVertexLabel() throws Exception {
        if (!this.features.hasCellTTL()) {
            throw new IllegalArgumentException();
        }
        VertexLabel label1 = this.mgmt.makeVertexLabel("event").make();
        this.mgmt.setTTL((TitanSchemaType)label1, 42, TimeUnit.SECONDS);
    }

    @Test
    public void testEdgeTTLImplicitKey() throws Exception {
        if (!this.features.hasCellTTL()) {
            return;
        }
        this.clopen(TitanGraphTest.option(GraphDatabaseConfiguration.STORE_META_TTL, "edgestore"), true);
        Assert.assertEquals((Object)"$ttl", (Object)ImplicitKey.TTL.getName());
        int ttl = 86400;
        EdgeLabel likes = this.mgmt.makeEdgeLabel("likes").make();
        EdgeLabel hasLiked = this.mgmt.makeEdgeLabel("hasLiked").make();
        this.mgmt.setTTL((TitanSchemaType)likes, ttl, TimeUnit.SECONDS);
        Assert.assertEquals((long)ttl, (long)this.mgmt.getTTL((TitanSchemaType)likes).getLength(TimeUnit.SECONDS));
        Assert.assertEquals((long)0L, (long)this.mgmt.getTTL((TitanSchemaType)hasLiked).getLength(TimeUnit.SECONDS));
        this.mgmt.commit();
        TitanVertex v1 = this.graph.addVertex(null);
        TitanVertex v2 = this.graph.addVertex(null);
        TitanEdge e1 = this.graph.addEdge(null, (Vertex)v1, (Vertex)v2, "likes");
        TitanEdge e2 = this.graph.addEdge(null, (Vertex)v1, (Vertex)v2, "hasLiked");
        this.graph.commit();
        Duration d = (Duration)e1.getProperty("$ttl");
        Assert.assertEquals((long)86400L, (long)d.getLength(TimeUnit.SECONDS));
        e1 = (Edge)v1.getEdges(Direction.OUT, new String[]{"likes"}).iterator().next();
        d = (Duration)e1.getProperty("$ttl");
        Assert.assertEquals((long)86400L, (long)d.getLength(TimeUnit.SECONDS));
        Thread.sleep(1001L);
        this.graph.rollback();
        e1 = (Edge)v1.getEdges(Direction.OUT, new String[]{"likes"}).iterator().next();
        d = (Duration)e1.getProperty("$ttl");
        Assert.assertEquals((long)86400L, (long)d.getLength(TimeUnit.SECONDS));
        d = (Duration)e2.getProperty("$ttl");
        Assert.assertEquals((long)0L, (long)d.getLength(TimeUnit.SECONDS));
    }

    @Test
    public void testVertexTTLImplicitKey() throws Exception {
        if (!this.features.hasCellTTL()) {
            return;
        }
        this.clopen(TitanGraphTest.option(GraphDatabaseConfiguration.STORE_META_TTL, "edgestore"), true);
        int ttl1 = 1;
        VertexLabel label1 = this.mgmt.makeVertexLabel("event").setStatic().make();
        this.mgmt.setTTL((TitanSchemaType)label1, ttl1, TimeUnit.SECONDS);
        Assert.assertEquals((long)ttl1, (long)this.mgmt.getTTL((TitanSchemaType)label1).getLength(TimeUnit.SECONDS));
        this.mgmt.commit();
        TitanVertex v1 = this.tx.addVertexWithLabel("event");
        TitanVertex v2 = this.tx.addVertex();
        this.tx.commit();
        Object v1id = v1.getId();
        Object v2id = v2.getId();
        v1 = this.graph.getVertex(v1id);
        v2 = this.graph.getVertex(v2id);
        Duration d = (Duration)v1.getProperty("$ttl");
        Assert.assertEquals((long)1L, (long)d.getLength(TimeUnit.SECONDS));
        d = (Duration)v2.getProperty("$ttl");
        Assert.assertEquals((long)0L, (long)d.getLength(TimeUnit.SECONDS));
    }

    private static interface TransactionJob {
        public void run(TitanTransaction var1);
    }
}

