/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.thinkaurelius.titan.core.EdgeLabel;
import com.thinkaurelius.titan.core.Order;
import com.thinkaurelius.titan.core.PropertyKey;
import com.thinkaurelius.titan.core.RelationType;
import com.thinkaurelius.titan.core.TitanEdge;
import com.thinkaurelius.titan.core.TitanFactory;
import com.thinkaurelius.titan.core.TitanGraph;
import com.thinkaurelius.titan.core.TitanIndexQuery;
import com.thinkaurelius.titan.core.TitanProperty;
import com.thinkaurelius.titan.core.TitanTransaction;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.core.VertexLabel;
import com.thinkaurelius.titan.core.attribute.Cmp;
import com.thinkaurelius.titan.core.attribute.Decimal;
import com.thinkaurelius.titan.core.attribute.Geo;
import com.thinkaurelius.titan.core.attribute.Geoshape;
import com.thinkaurelius.titan.core.attribute.Text;
import com.thinkaurelius.titan.core.log.TransactionRecovery;
import com.thinkaurelius.titan.core.schema.Mapping;
import com.thinkaurelius.titan.core.schema.Parameter;
import com.thinkaurelius.titan.core.schema.SchemaAction;
import com.thinkaurelius.titan.core.schema.TitanGraphIndex;
import com.thinkaurelius.titan.core.schema.TitanIndex;
import com.thinkaurelius.titan.core.schema.TitanSchemaType;
import com.thinkaurelius.titan.diskstorage.Backend;
import com.thinkaurelius.titan.diskstorage.BackendException;
import com.thinkaurelius.titan.diskstorage.configuration.WriteConfiguration;
import com.thinkaurelius.titan.diskstorage.indexing.IndexFeatures;
import com.thinkaurelius.titan.diskstorage.log.kcvs.KCVSLog;
import com.thinkaurelius.titan.diskstorage.util.time.StandardDuration;
import com.thinkaurelius.titan.diskstorage.util.time.TimestampProvider;
import com.thinkaurelius.titan.example.GraphOfTheGodsFactory;
import com.thinkaurelius.titan.graphdb.TestMockIndexProvider;
import com.thinkaurelius.titan.graphdb.TitanGraphBaseTest;
import com.thinkaurelius.titan.graphdb.TitanGraphTest;
import com.thinkaurelius.titan.graphdb.configuration.GraphDatabaseConfiguration;
import com.thinkaurelius.titan.graphdb.internal.ElementCategory;
import com.thinkaurelius.titan.graphdb.log.StandardTransactionLogProcessor;
import com.thinkaurelius.titan.graphdb.query.TitanPredicate;
import com.thinkaurelius.titan.graphdb.types.ParameterType;
import com.thinkaurelius.titan.graphdb.types.StandardEdgeLabelMaker;
import com.thinkaurelius.titan.testcategory.BrittleTests;
import com.thinkaurelius.titan.testutil.TestGraphConfigs;
import com.thinkaurelius.titan.testutil.TestUtil;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Predicate;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.util.ElementHelper;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TitanIndexTest
extends TitanGraphBaseTest {
    public static final String INDEX = "search";
    public static final String VINDEX = "vsearch";
    public static final String EINDEX = "esearch";
    public static final String PINDEX = "psearch";
    public final boolean supportsGeoPoint;
    public final boolean supportsNumeric;
    public final boolean supportsText;
    public IndexFeatures indexFeatures;
    private static final Logger log = LoggerFactory.getLogger(TitanIndexTest.class);
    @Rule
    public TestName methodName = new TestName();

    protected TitanIndexTest(boolean supportsGeoPoint, boolean supportsNumeric, boolean supportsText) {
        this.supportsGeoPoint = supportsGeoPoint;
        this.supportsNumeric = supportsNumeric;
        this.supportsText = supportsText;
    }

    private Parameter getStringMapping() {
        if (this.indexFeatures.supportsStringMapping(Mapping.STRING)) {
            return Mapping.STRING.getParameter();
        }
        if (this.indexFeatures.supportsStringMapping(Mapping.TEXTSTRING)) {
            return Mapping.TEXTSTRING.getParameter();
        }
        throw new AssertionError((Object)"String mapping not supported");
    }

    private Parameter getTextMapping() {
        if (this.indexFeatures.supportsStringMapping(Mapping.TEXT)) {
            return Mapping.TEXT.getParameter();
        }
        if (this.indexFeatures.supportsStringMapping(Mapping.TEXTSTRING)) {
            return Mapping.TEXTSTRING.getParameter();
        }
        throw new AssertionError((Object)"Text mapping not supported");
    }

    private Parameter getFieldMap(PropertyKey key) {
        return ParameterType.MAPPED_NAME.getParameter((Object)key.getName());
    }

    public abstract boolean supportsLuceneStyleQueries();

    @Override
    public void open(WriteConfiguration config) {
        super.open(config);
        this.indexFeatures = (IndexFeatures)this.graph.getBackend().getIndexFeatures().get(INDEX);
    }

    @Test
    public void testGraphOfTheGods() {
        GraphOfTheGodsFactory.load((TitanGraph)this.graph);
        TitanIndexTest.assertGraphOfTheGods((TitanGraph)this.graph);
    }

    public static void assertGraphOfTheGods(TitanGraph gotg) {
        Assert.assertEquals((long)12L, (long)Iterables.size((Iterable)gotg.getVertices()));
        Assert.assertEquals((long)3L, (long)Iterables.size((Iterable)gotg.getVertices("label", (Object)"god")));
        Vertex h = (Vertex)Iterables.getOnlyElement((Iterable)gotg.getVertices("name", (Object)"hercules"));
        Assert.assertEquals((Object)30, (Object)h.getProperty("age"));
        Assert.assertEquals((Object)"demigod", (Object)((TitanVertex)h).getLabel());
        Assert.assertEquals((long)5L, (long)Iterables.size((Iterable)h.getEdges(Direction.BOTH, new String[0])));
        gotg.commit();
    }

    @Test
    public void testSimpleUpdate() {
        PropertyKey name = this.makeKey("name", String.class);
        EdgeLabel knows = this.makeLabel("knows");
        this.mgmt.buildIndex("namev", Vertex.class).addKey(name).buildMixedIndex(INDEX);
        this.mgmt.buildIndex("namee", Edge.class).addKey(name).buildMixedIndex(INDEX);
        this.finishSchema();
        TitanVertex v = this.tx.addVertex();
        v.setProperty("name", (Object)"Marko Rodriguez");
        Edge e = v.addEdge("knows", (Vertex)v);
        e.setProperty("name", (Object)"Hulu Bubab");
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)this.tx.query().has("name", (Predicate)Text.CONTAINS, (Object)"marko").vertices()));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)this.tx.query().has("name", (Predicate)Text.CONTAINS, (Object)"Hulu").edges()));
        for (Vertex u : this.tx.getVertices()) {
            Assert.assertEquals((Object)"Marko Rodriguez", (Object)u.getProperty("name"));
        }
        this.clopen(new Object[0]);
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)this.tx.query().has("name", (Predicate)Text.CONTAINS, (Object)"marko").vertices()));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)this.tx.query().has("name", (Predicate)Text.CONTAINS, (Object)"Hulu").edges()));
        for (Vertex u : this.tx.getVertices()) {
            Assert.assertEquals((Object)"Marko Rodriguez", (Object)u.getProperty("name"));
        }
        v = (Vertex)Iterables.getOnlyElement((Iterable)this.tx.query().has("name", (Predicate)Text.CONTAINS, (Object)"marko").vertices());
        v.setProperty("name", (Object)"Marko");
        e = (Edge)Iterables.getOnlyElement((Iterable)v.getEdges(Direction.OUT, new String[0]));
        e.setProperty("name", (Object)"Tubu Rubu");
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)this.tx.query().has("name", (Predicate)Text.CONTAINS, (Object)"marko").vertices()));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)this.tx.query().has("name", (Predicate)Text.CONTAINS, (Object)"Rubu").edges()));
        Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)this.tx.query().has("name", (Predicate)Text.CONTAINS, (Object)"Hulu").edges()));
        for (Vertex u : this.tx.getVertices()) {
            Assert.assertEquals((Object)"Marko", (Object)u.getProperty("name"));
        }
        this.clopen(new Object[0]);
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)this.tx.query().has("name", (Predicate)Text.CONTAINS, (Object)"marko").vertices()));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)this.tx.query().has("name", (Predicate)Text.CONTAINS, (Object)"Rubu").edges()));
        Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)this.tx.query().has("name", (Predicate)Text.CONTAINS, (Object)"Hulu").edges()));
        for (Vertex u : this.tx.getVertices()) {
            Assert.assertEquals((Object)"Marko", (Object)u.getProperty("name"));
        }
    }

    @Test
    public void testIndexing() {
        int i;
        double distance;
        double offset;
        int i2;
        int numV;
        PropertyKey text = this.makeKey("text", String.class);
        this.createExternalVertexIndex(text, INDEX);
        this.createExternalEdgeIndex(text, INDEX);
        PropertyKey location = this.makeKey("location", Geoshape.class);
        this.createExternalVertexIndex(location, INDEX);
        this.createExternalEdgeIndex(location, INDEX);
        PropertyKey time = this.makeKey("time", Long.class);
        this.createExternalVertexIndex(time, INDEX);
        this.createExternalEdgeIndex(time, INDEX);
        PropertyKey category = this.makeKey("category", Integer.class);
        this.mgmt.buildIndex("vcategory", Vertex.class).addKey(category).buildCompositeIndex();
        this.mgmt.buildIndex("ecategory", Edge.class).addKey(category).buildCompositeIndex();
        PropertyKey group = this.makeKey("group", Byte.class);
        this.createExternalVertexIndex(group, INDEX);
        this.createExternalEdgeIndex(group, INDEX);
        PropertyKey id = this.makeVertexIndexedKey("uid", Integer.class);
        EdgeLabel knows = ((StandardEdgeLabelMaker)this.mgmt.makeEdgeLabel("knows")).sortKey(new RelationType[]{time}).signature(new RelationType[]{location}).make();
        this.finishSchema();
        this.clopen(new Object[0]);
        String[] words = new String[]{"world", "aurelius", "titan", "graph"};
        int numCategories = 5;
        int numGroups = 10;
        int originalNumV = numV = 100;
        for (i2 = 0; i2 < numV; ++i2) {
            TitanVertex v = this.tx.addVertex();
            v.setProperty("uid", (Object)i2);
            v.setProperty("category", (Object)(i2 % numCategories));
            v.setProperty("group", (Object)(i2 % numGroups));
            v.setProperty("text", (Object)("Vertex " + words[i2 % words.length]));
            v.setProperty("time", (Object)i2);
            offset = (double)(i2 % 2 == 0 ? 1 : -1) * ((double)i2 * 50.0 / (double)numV);
            v.setProperty("location", (Object)Geoshape.point((double)(0.0 + offset), (double)(0.0 + offset)));
            Edge e = v.addEdge("knows", (Vertex)this.getVertex("uid", (Object)Math.max(0, i2 - 1)));
            e.setProperty("text", (Object)("Vertex " + words[i2 % words.length]));
            e.setProperty("time", (Object)i2);
            e.setProperty("category", (Object)(i2 % numCategories));
            e.setProperty("group", (Object)(i2 % numGroups));
            e.setProperty("location", (Object)Geoshape.point((double)(0.0 + offset), (double)(0.0 + offset)));
        }
        for (i2 = 0; i2 < words.length; ++i2) {
            int expectedSize = numV / words.length;
            Assert.assertEquals((long)expectedSize, (long)Iterables.size((Iterable)this.tx.query().has("text", (Predicate)Text.CONTAINS, (Object)words[i2]).vertices()));
            Assert.assertEquals((long)expectedSize, (long)Iterables.size((Iterable)this.tx.query().has("text", (Predicate)Text.CONTAINS, (Object)words[i2]).edges()));
            for (String orderKey : new String[]{"time", "category"}) {
                for (Order order : Order.values()) {
                    for (Iterable iter : ImmutableList.of((Object)this.tx.query().has("text", (Predicate)Text.CONTAINS, (Object)words[i2]).orderBy(orderKey, order).vertices(), (Object)this.tx.query().has("text", (Predicate)Text.CONTAINS, (Object)words[i2]).orderBy(orderKey, order).edges())) {
                        Element previous = null;
                        int count = 0;
                        for (Element element : iter) {
                            if (previous != null) {
                                int cmp = ((Comparable)element.getProperty(orderKey)).compareTo(previous.getProperty(orderKey));
                                Assert.assertTrue((String)(element.getProperty(orderKey) + " <> " + previous.getProperty(orderKey)), (boolean)(order == Order.ASC ? cmp >= 0 : cmp <= 0));
                            }
                            previous = element;
                            ++count;
                        }
                        Assert.assertEquals((long)expectedSize, (long)count);
                    }
                }
            }
        }
        Assert.assertEquals((long)3L, (long)Iterables.size((Iterable)this.tx.query().has("group", (Object)3).orderBy("time", Order.ASC).limit(3).vertices()));
        Assert.assertEquals((long)3L, (long)Iterables.size((Iterable)this.tx.query().has("group", (Object)3).orderBy("time", Order.DESC).limit(3).edges()));
        for (i2 = 0; i2 < numV / 2; i2 += numV / 10) {
            Assert.assertEquals((long)i2, (long)Iterables.size((Iterable)this.tx.query().has("time", (Predicate)Cmp.GREATER_THAN_EQUAL, (Object)i2).has("time", (Predicate)Cmp.LESS_THAN, (Object)(i2 + i2)).vertices()));
            Assert.assertEquals((long)i2, (long)Iterables.size((Iterable)this.tx.query().has("time", (Predicate)Cmp.GREATER_THAN_EQUAL, (Object)i2).has("time", (Predicate)Cmp.LESS_THAN, (Object)(i2 + i2)).edges()));
        }
        for (i2 = 0; i2 < numV; i2 += 10) {
            offset = (double)i2 * 50.0 / (double)originalNumV;
            distance = Geoshape.point((double)0.0, (double)0.0).getPoint().distance(Geoshape.point((double)offset, (double)offset).getPoint()) + 20.0;
            Assert.assertEquals((long)(i2 + 1), (long)Iterables.size((Iterable)this.tx.query().has("location", (Predicate)Geo.WITHIN, (Object)Geoshape.circle((double)0.0, (double)0.0, (double)distance)).vertices()));
            Assert.assertEquals((long)(i2 + 1), (long)Iterables.size((Iterable)this.tx.query().has("location", (Predicate)Geo.WITHIN, (Object)Geoshape.circle((double)0.0, (double)0.0, (double)distance)).edges()));
        }
        Assert.assertEquals((long)4L, (long)Iterables.size((Iterable)this.tx.query().has("category", (Object)1).interval("time", (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(28)).vertices()));
        Assert.assertEquals((long)4L, (long)Iterables.size((Iterable)this.tx.query().has("category", (Object)1).interval("time", (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(28)).edges()));
        Assert.assertEquals((long)5L, (long)Iterables.size((Iterable)this.tx.query().has("time", (Predicate)Cmp.GREATER_THAN_EQUAL, (Object)10).has("time", (Predicate)Cmp.LESS_THAN, (Object)30).has("text", (Predicate)Text.CONTAINS, (Object)words[0]).vertices()));
        offset = 950.0 / (double)originalNumV;
        distance = Geoshape.point((double)0.0, (double)0.0).getPoint().distance(Geoshape.point((double)offset, (double)offset).getPoint()) + 20.0;
        Assert.assertEquals((long)5L, (long)Iterables.size((Iterable)this.tx.query().has("location", (Predicate)Geo.INTERSECT, (Object)Geoshape.circle((double)0.0, (double)0.0, (double)distance)).has("text", (Predicate)Text.CONTAINS, (Object)words[0]).vertices()));
        Assert.assertEquals((long)numV, (long)Iterables.size((Iterable)this.tx.getVertices()));
        Assert.assertEquals((long)numV, (long)Iterables.size((Iterable)this.tx.getEdges()));
        this.clopen(new Object[0]);
        for (i2 = 0; i2 < words.length; ++i2) {
            int expectedSize = numV / words.length;
            Assert.assertEquals((long)expectedSize, (long)Iterables.size((Iterable)this.tx.query().has("text", (Predicate)Text.CONTAINS, (Object)words[i2]).vertices()));
            Assert.assertEquals((long)expectedSize, (long)Iterables.size((Iterable)this.tx.query().has("text", (Predicate)Text.CONTAINS, (Object)words[i2]).edges()));
            for (String orderKey : new String[]{"time", "category"}) {
                for (Order order : Order.values()) {
                    for (Iterable iter : ImmutableList.of((Object)this.tx.query().has("text", (Predicate)Text.CONTAINS, (Object)words[i2]).orderBy(orderKey, order).vertices(), (Object)this.tx.query().has("text", (Predicate)Text.CONTAINS, (Object)words[i2]).orderBy(orderKey, order).edges())) {
                        TestUtil.verifyElementOrder(iter, orderKey, order, expectedSize);
                    }
                }
            }
        }
        Assert.assertEquals((long)3L, (long)Iterables.size((Iterable)this.tx.query().has("group", (Object)3).orderBy("time", Order.ASC).limit(3).vertices()));
        Assert.assertEquals((long)3L, (long)Iterables.size((Iterable)this.tx.query().has("group", (Object)3).orderBy("time", Order.DESC).limit(3).edges()));
        for (i2 = 0; i2 < numV / 2; i2 += numV / 10) {
            Assert.assertEquals((long)i2, (long)Iterables.size((Iterable)this.tx.query().has("time", (Predicate)Cmp.GREATER_THAN_EQUAL, (Object)i2).has("time", (Predicate)Cmp.LESS_THAN, (Object)(i2 + i2)).vertices()));
            Assert.assertEquals((long)i2, (long)Iterables.size((Iterable)this.tx.query().has("time", (Predicate)Cmp.GREATER_THAN_EQUAL, (Object)i2).has("time", (Predicate)Cmp.LESS_THAN, (Object)(i2 + i2)).edges()));
        }
        for (i2 = 0; i2 < numV; i2 += 10) {
            offset = (double)i2 * 50.0 / (double)originalNumV;
            distance = Geoshape.point((double)0.0, (double)0.0).getPoint().distance(Geoshape.point((double)offset, (double)offset).getPoint()) + 20.0;
            Assert.assertEquals((long)(i2 + 1), (long)Iterables.size((Iterable)this.tx.query().has("location", (Predicate)Geo.WITHIN, (Object)Geoshape.circle((double)0.0, (double)0.0, (double)distance)).vertices()));
            Assert.assertEquals((long)(i2 + 1), (long)Iterables.size((Iterable)this.tx.query().has("location", (Predicate)Geo.WITHIN, (Object)Geoshape.circle((double)0.0, (double)0.0, (double)distance)).edges()));
        }
        Assert.assertEquals((long)4L, (long)Iterables.size((Iterable)this.tx.query().has("category", (Object)1).interval("time", (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(28)).vertices()));
        Assert.assertEquals((long)4L, (long)Iterables.size((Iterable)this.tx.query().has("category", (Object)1).interval("time", (Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(28)).edges()));
        Assert.assertEquals((long)5L, (long)Iterables.size((Iterable)this.tx.query().has("time", (Predicate)Cmp.GREATER_THAN_EQUAL, (Object)10).has("time", (Predicate)Cmp.LESS_THAN, (Object)30).has("text", (Predicate)Text.CONTAINS, (Object)words[0]).vertices()));
        offset = 950.0 / (double)originalNumV;
        distance = Geoshape.point((double)0.0, (double)0.0).getPoint().distance(Geoshape.point((double)offset, (double)offset).getPoint()) + 20.0;
        Assert.assertEquals((long)5L, (long)Iterables.size((Iterable)this.tx.query().has("location", (Predicate)Geo.INTERSECT, (Object)Geoshape.circle((double)0.0, (double)0.0, (double)distance)).has("text", (Predicate)Text.CONTAINS, (Object)words[0]).vertices()));
        Assert.assertEquals((long)numV, (long)Iterables.size((Iterable)this.tx.getVertices()));
        Assert.assertEquals((long)numV, (long)Iterables.size((Iterable)this.tx.getEdges()));
        this.newTx();
        int numDelete = 12;
        for (i = numV - numDelete; i < numV; ++i) {
            this.getVertex("uid", (Object)i).remove();
        }
        numV -= numDelete;
        for (i = 0; i < words.length; ++i) {
            Assert.assertEquals((long)(numV / words.length), (long)Iterables.size((Iterable)this.tx.query().has("text", (Predicate)Text.CONTAINS, (Object)words[i]).vertices()));
            Assert.assertEquals((long)(numV / words.length), (long)Iterables.size((Iterable)this.tx.query().has("text", (Predicate)Text.CONTAINS, (Object)words[i]).edges()));
        }
        for (i = 0; i < numV / 2; i += numV / 10) {
            Assert.assertEquals((long)i, (long)Iterables.size((Iterable)this.tx.query().has("time", (Predicate)Cmp.GREATER_THAN_EQUAL, (Object)i).has("time", (Predicate)Cmp.LESS_THAN, (Object)(i + i)).vertices()));
            Assert.assertEquals((long)i, (long)Iterables.size((Iterable)this.tx.query().has("time", (Predicate)Cmp.GREATER_THAN_EQUAL, (Object)i).has("time", (Predicate)Cmp.LESS_THAN, (Object)(i + i)).edges()));
        }
        for (i = 0; i < numV; i += 10) {
            offset = (double)i * 50.0 / (double)originalNumV;
            distance = Geoshape.point((double)0.0, (double)0.0).getPoint().distance(Geoshape.point((double)offset, (double)offset).getPoint()) + 20.0;
            Assert.assertEquals((long)(i + 1), (long)Iterables.size((Iterable)this.tx.query().has("location", (Predicate)Geo.WITHIN, (Object)Geoshape.circle((double)0.0, (double)0.0, (double)distance)).vertices()));
            Assert.assertEquals((long)(i + 1), (long)Iterables.size((Iterable)this.tx.query().has("location", (Predicate)Geo.WITHIN, (Object)Geoshape.circle((double)0.0, (double)0.0, (double)distance)).edges()));
        }
        Assert.assertEquals((long)5L, (long)Iterables.size((Iterable)this.tx.query().has("time", (Predicate)Cmp.GREATER_THAN_EQUAL, (Object)10).has("time", (Predicate)Cmp.LESS_THAN, (Object)30).has("text", (Predicate)Text.CONTAINS, (Object)words[0]).vertices()));
        offset = 950.0 / (double)originalNumV;
        distance = Geoshape.point((double)0.0, (double)0.0).getPoint().distance(Geoshape.point((double)offset, (double)offset).getPoint()) + 20.0;
        Assert.assertEquals((long)5L, (long)Iterables.size((Iterable)this.tx.query().has("location", (Predicate)Geo.INTERSECT, (Object)Geoshape.circle((double)0.0, (double)0.0, (double)distance)).has("text", (Predicate)Text.CONTAINS, (Object)words[0]).vertices()));
        Assert.assertEquals((long)numV, (long)Iterables.size((Iterable)this.tx.getVertices()));
        Assert.assertEquals((long)numV, (long)Iterables.size((Iterable)this.tx.getEdges()));
    }

    @Test
    public void testConditionalIndexing() {
        PropertyKey name = this.makeKey("name", String.class);
        PropertyKey weight = this.makeKey("weight", Decimal.class);
        PropertyKey text = this.makeKey("text", String.class);
        VertexLabel person = this.mgmt.makeVertexLabel("person").make();
        VertexLabel org = this.mgmt.makeVertexLabel("org").make();
        TitanGraphIndex index1 = this.mgmt.buildIndex("index1", Vertex.class).addKey(name, new Parameter[]{this.getStringMapping()}).buildMixedIndex(INDEX);
        TitanGraphIndex index2 = this.mgmt.buildIndex("index2", Vertex.class).indexOnly((TitanSchemaType)person).addKey(text, new Parameter[]{this.getTextMapping()}).addKey(weight).buildMixedIndex(INDEX);
        TitanGraphIndex index3 = this.mgmt.buildIndex("index3", Vertex.class).indexOnly((TitanSchemaType)org).addKey(text, new Parameter[]{this.getTextMapping()}).addKey(weight).buildMixedIndex(INDEX);
        Assert.assertTrue((boolean)this.mgmt.containsGraphIndex("index1"));
        Assert.assertFalse((boolean)this.mgmt.containsGraphIndex("index"));
        Assert.assertEquals((long)3L, (long)Iterables.size((Iterable)this.mgmt.getGraphIndexes(Vertex.class)));
        Assert.assertNull((Object)this.mgmt.getGraphIndex("indexx"));
        name = this.mgmt.getPropertyKey("name");
        weight = this.mgmt.getPropertyKey("weight");
        text = this.mgmt.getPropertyKey("text");
        person = this.mgmt.getVertexLabel("person");
        org = this.mgmt.getVertexLabel("org");
        index1 = this.mgmt.getGraphIndex("index1");
        index2 = this.mgmt.getGraphIndex("index2");
        index3 = this.mgmt.getGraphIndex("index3");
        Assert.assertTrue((boolean)Vertex.class.isAssignableFrom(index1.getIndexedElement()));
        Assert.assertEquals((Object)"index2", (Object)index2.getName());
        Assert.assertEquals((Object)INDEX, (Object)index3.getBackingIndex());
        Assert.assertFalse((boolean)index2.isUnique());
        Assert.assertEquals((long)2L, (long)index3.getFieldKeys().length);
        Assert.assertEquals((long)1L, (long)index1.getFieldKeys().length);
        Assert.assertEquals((long)3L, (long)index3.getParametersFor(text).length);
        Assert.assertEquals((long)2L, (long)index3.getParametersFor(weight).length);
        try {
            this.mgmt.buildIndex("index2", Vertex.class).addKey(weight).buildMixedIndex(INDEX);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.mgmt.buildIndex("index2", Vertex.class).addKey(weight).buildCompositeIndex();
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.mgmt.addIndexKey(index2, weight, new Parameter[0]);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.finishSchema();
        this.clopen(new Object[0]);
        Assert.assertTrue((boolean)this.mgmt.containsGraphIndex("index1"));
        Assert.assertFalse((boolean)this.mgmt.containsGraphIndex("index"));
        Assert.assertEquals((long)3L, (long)Iterables.size((Iterable)this.mgmt.getGraphIndexes(Vertex.class)));
        Assert.assertNull((Object)this.mgmt.getGraphIndex("indexx"));
        name = this.mgmt.getPropertyKey("name");
        weight = this.mgmt.getPropertyKey("weight");
        text = this.mgmt.getPropertyKey("text");
        person = this.mgmt.getVertexLabel("person");
        org = this.mgmt.getVertexLabel("org");
        index1 = this.mgmt.getGraphIndex("index1");
        index2 = this.mgmt.getGraphIndex("index2");
        index3 = this.mgmt.getGraphIndex("index3");
        Assert.assertTrue((boolean)Vertex.class.isAssignableFrom(index1.getIndexedElement()));
        Assert.assertEquals((Object)"index2", (Object)index2.getName());
        Assert.assertEquals((Object)INDEX, (Object)index3.getBackingIndex());
        Assert.assertFalse((boolean)index2.isUnique());
        Assert.assertEquals((long)2L, (long)index3.getFieldKeys().length);
        Assert.assertEquals((long)1L, (long)index1.getFieldKeys().length);
        Assert.assertEquals((long)3L, (long)index3.getParametersFor(text).length);
        Assert.assertEquals((long)2L, (long)index3.getParametersFor(weight).length);
        try {
            this.mgmt.buildIndex("index2", Vertex.class).addKey(weight).buildMixedIndex(INDEX);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.mgmt.buildIndex("index2", Vertex.class).addKey(weight).buildCompositeIndex();
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.mgmt.addIndexKey(index2, weight, new Parameter[0]);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        name = this.tx.getPropertyKey("name");
        weight = this.tx.getPropertyKey("weight");
        text = this.tx.getPropertyKey("text");
        person = this.tx.getVertexLabel("person");
        org = this.tx.getVertexLabel("org");
        int numV = 200;
        String[] strs = new String[]{"houseboat", "humanoid", "differential", "extraordinary"};
        String[] strs2 = new String[strs.length];
        for (int i = 0; i < strs.length; ++i) {
            strs2[i] = strs[i] + " " + strs[i];
        }
        int modulo = 5;
        assert (200 % (5 * strs.length * 2) == 0);
        for (int i = 0; i < 200; ++i) {
            TitanVertex v = this.tx.addVertexWithLabel(i % 2 == 0 ? person : org);
            v.addProperty(name, (Object)strs[i % strs.length]);
            v.addProperty(text, (Object)strs[i % strs.length]);
            v.addProperty(weight, (Object)((double)(i % 5) + 0.5));
        }
        TitanGraphTest.evaluateQuery(this.tx.query().has(text, (TitanPredicate)Text.CONTAINS, (Object)strs[0]).has("label", (Predicate)Cmp.EQUAL, (Object)person.getName()), ElementCategory.VERTEX, 200 / strs.length, new boolean[]{true, true}, index2.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(text, (TitanPredicate)Text.CONTAINS, (Object)strs[0]).has("label", (Predicate)Cmp.EQUAL, (Object)person.getName()).orderBy(weight, Order.DESC), ElementCategory.VERTEX, 200 / strs.length, new boolean[]{true, true}, weight, Order.DESC, index2.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(text, (TitanPredicate)Text.CONTAINS, (Object)strs[3]).has("label", (Predicate)Cmp.EQUAL, (Object)org.getName()), ElementCategory.VERTEX, 200 / strs.length, new boolean[]{true, true}, index3.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(text, (TitanPredicate)Text.CONTAINS, (Object)strs[1]).has("label", (Predicate)Cmp.EQUAL, (Object)org.getName()).orderBy(weight, Order.DESC), ElementCategory.VERTEX, 200 / strs.length, new boolean[]{true, true}, weight, Order.DESC, index3.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(text, (TitanPredicate)Text.CONTAINS, (Object)strs[0]).has(weight, (TitanPredicate)Cmp.EQUAL, (Object)2.5).has("label", (Predicate)Cmp.EQUAL, (Object)person.getName()), ElementCategory.VERTEX, 200 / (5 * strs.length), new boolean[]{true, true}, index2.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(name, (TitanPredicate)Cmp.EQUAL, (Object)strs[2]).has("label", (Predicate)Cmp.EQUAL, (Object)person.getName()), ElementCategory.VERTEX, 200 / strs.length, new boolean[]{false, true}, index1.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(name, (TitanPredicate)Cmp.EQUAL, (Object)strs[3]).has("label", (Predicate)Cmp.EQUAL, (Object)person.getName()), ElementCategory.VERTEX, 0, new boolean[]{false, true}, index1.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(name, (TitanPredicate)Cmp.EQUAL, (Object)strs[0]), ElementCategory.VERTEX, 200 / strs.length, new boolean[]{true, true}, index1.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(name, (TitanPredicate)Cmp.EQUAL, (Object)strs[2]).has(text, (TitanPredicate)Text.CONTAINS, (Object)strs[2]).has("label", (Predicate)Cmp.EQUAL, (Object)person.getName()), ElementCategory.VERTEX, 200 / strs.length, new boolean[]{true, true}, index1.getName(), index2.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(name, (TitanPredicate)Cmp.EQUAL, (Object)strs[0]).has(text, (TitanPredicate)Text.CONTAINS, (Object)strs[0]).has("label", (Predicate)Cmp.EQUAL, (Object)person.getName()).orderBy(weight, Order.ASC), ElementCategory.VERTEX, 200 / strs.length, new boolean[]{true, true}, weight, Order.ASC, index1.getName(), index2.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(text, (TitanPredicate)Text.CONTAINS, (Object)strs[0]), ElementCategory.VERTEX, 200 / strs.length, new boolean[]{false, true}, new String[0]);
        TitanGraphTest.evaluateQuery(this.tx.query().has(text, (TitanPredicate)Text.CONTAINS, (Object)strs[0]).orderBy(weight, Order.ASC), ElementCategory.VERTEX, 200 / strs.length, new boolean[]{false, false}, weight, Order.ASC, new String[0]);
        this.clopen(new Object[0]);
        TitanGraphTest.evaluateQuery(this.tx.query().has(text, (TitanPredicate)Text.CONTAINS, (Object)strs[0]).has("label", (Predicate)Cmp.EQUAL, (Object)person.getName()), ElementCategory.VERTEX, 200 / strs.length, new boolean[]{true, true}, index2.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(text, (TitanPredicate)Text.CONTAINS, (Object)strs[0]).has("label", (Predicate)Cmp.EQUAL, (Object)person.getName()).orderBy(weight, Order.DESC), ElementCategory.VERTEX, 200 / strs.length, new boolean[]{true, true}, weight, Order.DESC, index2.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(text, (TitanPredicate)Text.CONTAINS, (Object)strs[3]).has("label", (Predicate)Cmp.EQUAL, (Object)org.getName()), ElementCategory.VERTEX, 200 / strs.length, new boolean[]{true, true}, index3.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(text, (TitanPredicate)Text.CONTAINS, (Object)strs[1]).has("label", (Predicate)Cmp.EQUAL, (Object)org.getName()).orderBy(weight, Order.DESC), ElementCategory.VERTEX, 200 / strs.length, new boolean[]{true, true}, weight, Order.DESC, index3.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(text, (TitanPredicate)Text.CONTAINS, (Object)strs[0]).has(weight, (TitanPredicate)Cmp.EQUAL, (Object)2.5).has("label", (Predicate)Cmp.EQUAL, (Object)person.getName()), ElementCategory.VERTEX, 200 / (5 * strs.length), new boolean[]{true, true}, index2.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(name, (TitanPredicate)Cmp.EQUAL, (Object)strs[2]).has("label", (Predicate)Cmp.EQUAL, (Object)person.getName()), ElementCategory.VERTEX, 200 / strs.length, new boolean[]{false, true}, index1.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(name, (TitanPredicate)Cmp.EQUAL, (Object)strs[3]).has("label", (Predicate)Cmp.EQUAL, (Object)person.getName()), ElementCategory.VERTEX, 0, new boolean[]{false, true}, index1.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(name, (TitanPredicate)Cmp.EQUAL, (Object)strs[0]), ElementCategory.VERTEX, 200 / strs.length, new boolean[]{true, true}, index1.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(name, (TitanPredicate)Cmp.EQUAL, (Object)strs[2]).has(text, (TitanPredicate)Text.CONTAINS, (Object)strs[2]).has("label", (Predicate)Cmp.EQUAL, (Object)person.getName()), ElementCategory.VERTEX, 200 / strs.length, new boolean[]{true, true}, index1.getName(), index2.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(name, (TitanPredicate)Cmp.EQUAL, (Object)strs[0]).has(text, (TitanPredicate)Text.CONTAINS, (Object)strs[0]).has("label", (Predicate)Cmp.EQUAL, (Object)person.getName()).orderBy(weight, Order.ASC), ElementCategory.VERTEX, 200 / strs.length, new boolean[]{true, true}, weight, Order.ASC, index1.getName(), index2.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(text, (TitanPredicate)Text.CONTAINS, (Object)strs[0]), ElementCategory.VERTEX, 200 / strs.length, new boolean[]{false, true}, new String[0]);
        TitanGraphTest.evaluateQuery(this.tx.query().has(text, (TitanPredicate)Text.CONTAINS, (Object)strs[0]).orderBy(weight, Order.ASC), ElementCategory.VERTEX, 200 / strs.length, new boolean[]{false, false}, weight, Order.ASC, new String[0]);
    }

    @Test
    public void testCompositeAndMixedIndexing() {
        PropertyKey name = this.makeKey("name", String.class);
        PropertyKey weight = this.makeKey("weight", Decimal.class);
        PropertyKey text = this.makeKey("text", String.class);
        PropertyKey flag = this.makeKey("flag", Boolean.class);
        TitanGraphIndex composite = this.mgmt.buildIndex("composite", Vertex.class).addKey(name).addKey(weight).buildCompositeIndex();
        TitanGraphIndex mixed = this.mgmt.buildIndex("mixed", Vertex.class).addKey(weight).addKey(text, new Parameter[]{this.getTextMapping()}).buildMixedIndex(INDEX);
        mixed.getName();
        composite.getName();
        this.finishSchema();
        name = this.tx.getPropertyKey("name");
        weight = this.tx.getPropertyKey("weight");
        text = this.tx.getPropertyKey("text");
        flag = this.tx.getPropertyKey("flag");
        int numV = 100;
        String[] strs = new String[]{"houseboat", "humanoid", "differential", "extraordinary"};
        String[] strs2 = new String[strs.length];
        for (int i = 0; i < strs.length; ++i) {
            strs2[i] = strs[i] + " " + strs[i];
        }
        int modulo = 5;
        int divisor = 5 * strs.length;
        for (int i = 0; i < 100; ++i) {
            TitanVertex v = this.tx.addVertex();
            v.addProperty(name, (Object)strs[i % strs.length]);
            v.addProperty(text, (Object)strs[i % strs.length]);
            v.addProperty(weight, (Object)((double)(i % 5) + 0.5));
            v.addProperty(flag, (Object)true);
        }
        TitanGraphTest.evaluateQuery(this.tx.query().has(name, (TitanPredicate)Cmp.EQUAL, (Object)strs[0]), ElementCategory.VERTEX, 100 / strs.length, new boolean[]{false, true}, new String[0]);
        TitanGraphTest.evaluateQuery(this.tx.query().has(text, (TitanPredicate)Text.CONTAINS, (Object)strs[0]), ElementCategory.VERTEX, 100 / strs.length, new boolean[]{true, true}, mixed.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(text, (TitanPredicate)Text.CONTAINS, (Object)strs[0]).has(flag.getName()), ElementCategory.VERTEX, 100 / strs.length, new boolean[]{false, true}, mixed.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(name, (TitanPredicate)Cmp.EQUAL, (Object)strs[0]).has(weight, (TitanPredicate)Cmp.EQUAL, (Object)1.5), ElementCategory.VERTEX, 100 / divisor, new boolean[]{true, true}, composite.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(name, (TitanPredicate)Cmp.EQUAL, (Object)strs[0]).has(weight, (TitanPredicate)Cmp.EQUAL, (Object)1.5).has(flag.getName()), ElementCategory.VERTEX, 100 / divisor, new boolean[]{false, true}, composite.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(text, (TitanPredicate)Text.CONTAINS, (Object)strs[2]).has(weight, (TitanPredicate)Cmp.EQUAL, (Object)2.5), ElementCategory.VERTEX, 100 / divisor, new boolean[]{true, true}, mixed.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(text, (TitanPredicate)Text.CONTAINS, (Object)strs[2]).has(weight, (TitanPredicate)Cmp.EQUAL, (Object)2.5).has(flag.getName()), ElementCategory.VERTEX, 100 / divisor, new boolean[]{false, true}, mixed.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(text, (TitanPredicate)Text.CONTAINS, (Object)strs[3]).has(name, (TitanPredicate)Cmp.EQUAL, (Object)strs[3]).has(weight, (TitanPredicate)Cmp.EQUAL, (Object)3.5), ElementCategory.VERTEX, 100 / divisor, new boolean[]{true, true}, mixed.getName(), composite.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(text, (TitanPredicate)Text.CONTAINS, (Object)strs[3]).has(name, (TitanPredicate)Cmp.EQUAL, (Object)strs[3]).has(weight, (TitanPredicate)Cmp.EQUAL, (Object)3.5).has(flag.getName()), ElementCategory.VERTEX, 100 / divisor, new boolean[]{false, true}, mixed.getName(), composite.getName());
        this.clopen(new Object[0]);
        TitanGraphTest.evaluateQuery(this.tx.query().has(name, (TitanPredicate)Cmp.EQUAL, (Object)strs[0]), ElementCategory.VERTEX, 100 / strs.length, new boolean[]{false, true}, new String[0]);
        TitanGraphTest.evaluateQuery(this.tx.query().has(text, (TitanPredicate)Text.CONTAINS, (Object)strs[0]), ElementCategory.VERTEX, 100 / strs.length, new boolean[]{true, true}, mixed.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(text, (TitanPredicate)Text.CONTAINS, (Object)strs[0]).has(flag.getName()), ElementCategory.VERTEX, 100 / strs.length, new boolean[]{false, true}, mixed.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(name, (TitanPredicate)Cmp.EQUAL, (Object)strs[0]).has(weight, (TitanPredicate)Cmp.EQUAL, (Object)1.5), ElementCategory.VERTEX, 100 / divisor, new boolean[]{true, true}, composite.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(name, (TitanPredicate)Cmp.EQUAL, (Object)strs[0]).has(weight, (TitanPredicate)Cmp.EQUAL, (Object)1.5).has(flag.getName()), ElementCategory.VERTEX, 100 / divisor, new boolean[]{false, true}, composite.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(text, (TitanPredicate)Text.CONTAINS, (Object)strs[2]).has(weight, (TitanPredicate)Cmp.EQUAL, (Object)2.5), ElementCategory.VERTEX, 100 / divisor, new boolean[]{true, true}, mixed.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(text, (TitanPredicate)Text.CONTAINS, (Object)strs[2]).has(weight, (TitanPredicate)Cmp.EQUAL, (Object)2.5).has(flag.getName()), ElementCategory.VERTEX, 100 / divisor, new boolean[]{false, true}, mixed.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(text, (TitanPredicate)Text.CONTAINS, (Object)strs[3]).has(name, (TitanPredicate)Cmp.EQUAL, (Object)strs[3]).has(weight, (TitanPredicate)Cmp.EQUAL, (Object)3.5), ElementCategory.VERTEX, 100 / divisor, new boolean[]{true, true}, mixed.getName(), composite.getName());
        TitanGraphTest.evaluateQuery(this.tx.query().has(text, (TitanPredicate)Text.CONTAINS, (Object)strs[3]).has(name, (TitanPredicate)Cmp.EQUAL, (Object)strs[3]).has(weight, (TitanPredicate)Cmp.EQUAL, (Object)3.5).has(flag.getName()), ElementCategory.VERTEX, 100 / divisor, new boolean[]{false, true}, mixed.getName(), composite.getName());
    }

    private void setupChainGraph(int numV, String[] strs, boolean sameNameMapping) {
        this.clopen(TitanIndexTest.option(GraphDatabaseConfiguration.INDEX_NAME_MAPPING, INDEX), sameNameMapping);
        TitanGraphIndex vindex = this.getExternalIndex(Vertex.class, INDEX);
        TitanGraphIndex eindex = this.getExternalIndex(Edge.class, INDEX);
        TitanGraphIndex pindex = this.getExternalIndex(TitanProperty.class, INDEX);
        PropertyKey name = this.makeKey("name", String.class);
        this.mgmt.addIndexKey(vindex, name, new Parameter[]{this.getStringMapping()});
        this.mgmt.addIndexKey(eindex, name, new Parameter[]{this.getStringMapping()});
        this.mgmt.addIndexKey(pindex, name, new Parameter[]{this.getStringMapping(), Parameter.of((String)"mapped-name", (Object)"xstr")});
        PropertyKey text = this.makeKey("text", String.class);
        this.mgmt.addIndexKey(vindex, text, new Parameter[]{this.getTextMapping(), Parameter.of((String)"mapped-name", (Object)"xtext")});
        this.mgmt.addIndexKey(eindex, text, new Parameter[]{this.getTextMapping()});
        this.mgmt.addIndexKey(pindex, text, new Parameter[]{this.getTextMapping()});
        this.mgmt.makeEdgeLabel("knows").signature(new RelationType[]{name}).make();
        this.mgmt.makePropertyKey("uid").dataType(String.class).signature(new RelationType[]{text}).make();
        this.finishSchema();
        TitanVertex previous = null;
        for (int i = 0; i < numV; ++i) {
            TitanVertex v = this.graph.addVertex(null);
            v.setProperty("name", (Object)strs[i % strs.length]);
            v.setProperty("text", (Object)strs[i % strs.length]);
            TitanEdge e = v.addEdge("knows", previous == null ? v : previous);
            e.setProperty("name", (Object)strs[i % strs.length]);
            e.setProperty("text", (Object)strs[i % strs.length]);
            TitanProperty p = v.addProperty("uid", (Object)("v" + i));
            p.setProperty("name", (Object)strs[i % strs.length]);
            p.setProperty("text", (Object)strs[i % strs.length]);
            previous = v;
        }
    }

    @Test
    public void testIndexParameters() {
        int numV = 1000;
        String[] strs = new String[]{"Uncle Berry has a farm", "and on his farm he has five ducks", "ducks are beautiful animals", "the sky is very blue today"};
        this.setupChainGraph(numV, strs, false);
        TitanGraphTest.evaluateQuery(this.graph.query().has("text", (Predicate)Text.CONTAINS, (Object)"ducks"), ElementCategory.VERTEX, numV / strs.length * 2, new boolean[]{true, true}, VINDEX);
        Assert.assertEquals((long)(numV / strs.length * 2), (long)Iterables.size((Iterable)this.graph.query().has("text", (Predicate)Text.CONTAINS, (Object)"ducks").vertices()));
        Assert.assertEquals((long)(numV / strs.length * 2), (long)Iterables.size((Iterable)this.graph.query().has("text", (Predicate)Text.CONTAINS, (Object)"farm").vertices()));
        Assert.assertEquals((long)(numV / strs.length), (long)Iterables.size((Iterable)this.graph.query().has("text", (Predicate)Text.CONTAINS, (Object)"beautiful").vertices()));
        TitanGraphTest.evaluateQuery(this.graph.query().has("text", (Predicate)Text.CONTAINS_PREFIX, (Object)"beauti"), ElementCategory.VERTEX, numV / strs.length, new boolean[]{true, true}, VINDEX);
        Assert.assertEquals((long)(numV / strs.length), (long)Iterables.size((Iterable)this.graph.query().has("text", (Predicate)Text.CONTAINS_REGEX, (Object)"be[r]+y").vertices()));
        Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)this.graph.query().has("text", (Predicate)Text.CONTAINS, (Object)"lolipop").vertices()));
        Assert.assertEquals((long)(numV / strs.length), (long)Iterables.size((Iterable)this.graph.query().has("name", (Predicate)Cmp.EQUAL, (Object)strs[1]).vertices()));
        Assert.assertEquals((long)(numV / strs.length), (long)Iterables.size((Iterable)this.graph.query().has("name", (Predicate)Cmp.EQUAL, (Object)strs[1]).vertices()));
        Assert.assertEquals((long)(numV / strs.length * (strs.length - 1)), (long)Iterables.size((Iterable)this.graph.query().has("name", (Predicate)Cmp.NOT_EQUAL, (Object)strs[2]).vertices()));
        Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)this.graph.query().has("name", (Predicate)Cmp.EQUAL, (Object)"farm").vertices()));
        Assert.assertEquals((long)(numV / strs.length), (long)Iterables.size((Iterable)this.graph.query().has("name", (Predicate)Text.PREFIX, (Object)"ducks").vertices()));
        Assert.assertEquals((long)(numV / strs.length * 2), (long)Iterables.size((Iterable)this.graph.query().has("name", (Predicate)Text.REGEX, (Object)"(.*)ducks(.*)").vertices()));
        TitanGraphTest.evaluateQuery(this.graph.query().has("text", (Predicate)Text.CONTAINS, (Object)"ducks"), ElementCategory.EDGE, numV / strs.length * 2, new boolean[]{true, true}, EINDEX);
        Assert.assertEquals((long)(numV / strs.length * 2), (long)Iterables.size((Iterable)this.graph.query().has("text", (Predicate)Text.CONTAINS, (Object)"ducks").edges()));
        Assert.assertEquals((long)(numV / strs.length * 2), (long)Iterables.size((Iterable)this.graph.query().has("text", (Predicate)Text.CONTAINS, (Object)"farm").edges()));
        Assert.assertEquals((long)(numV / strs.length), (long)Iterables.size((Iterable)this.graph.query().has("text", (Predicate)Text.CONTAINS, (Object)"beautiful").edges()));
        TitanGraphTest.evaluateQuery(this.graph.query().has("text", (Predicate)Text.CONTAINS_PREFIX, (Object)"beauti"), ElementCategory.EDGE, numV / strs.length, new boolean[]{true, true}, EINDEX);
        Assert.assertEquals((long)(numV / strs.length), (long)Iterables.size((Iterable)this.graph.query().has("text", (Predicate)Text.CONTAINS_REGEX, (Object)"be[r]+y").edges()));
        Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)this.graph.query().has("text", (Predicate)Text.CONTAINS, (Object)"lolipop").edges()));
        Assert.assertEquals((long)(numV / strs.length), (long)Iterables.size((Iterable)this.graph.query().has("name", (Predicate)Cmp.EQUAL, (Object)strs[1]).edges()));
        Assert.assertEquals((long)(numV / strs.length), (long)Iterables.size((Iterable)this.graph.query().has("name", (Predicate)Cmp.EQUAL, (Object)strs[1]).edges()));
        Assert.assertEquals((long)(numV / strs.length * (strs.length - 1)), (long)Iterables.size((Iterable)this.graph.query().has("name", (Predicate)Cmp.NOT_EQUAL, (Object)strs[2]).edges()));
        Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)this.graph.query().has("name", (Predicate)Cmp.EQUAL, (Object)"farm").edges()));
        Assert.assertEquals((long)(numV / strs.length), (long)Iterables.size((Iterable)this.graph.query().has("name", (Predicate)Text.PREFIX, (Object)"ducks").edges()));
        Assert.assertEquals((long)(numV / strs.length * 2), (long)Iterables.size((Iterable)this.graph.query().has("name", (Predicate)Text.REGEX, (Object)"(.*)ducks(.*)").edges()));
        TitanGraphTest.evaluateQuery(this.graph.query().has("text", (Predicate)Text.CONTAINS, (Object)"ducks"), ElementCategory.PROPERTY, numV / strs.length * 2, new boolean[]{true, true}, PINDEX);
        Assert.assertEquals((long)(numV / strs.length * 2), (long)Iterables.size((Iterable)this.graph.query().has("text", (Predicate)Text.CONTAINS, (Object)"ducks").properties()));
        Assert.assertEquals((long)(numV / strs.length * 2), (long)Iterables.size((Iterable)this.graph.query().has("text", (Predicate)Text.CONTAINS, (Object)"farm").properties()));
        Assert.assertEquals((long)(numV / strs.length), (long)Iterables.size((Iterable)this.graph.query().has("text", (Predicate)Text.CONTAINS, (Object)"beautiful").properties()));
        TitanGraphTest.evaluateQuery(this.graph.query().has("text", (Predicate)Text.CONTAINS_PREFIX, (Object)"beauti"), ElementCategory.PROPERTY, numV / strs.length, new boolean[]{true, true}, PINDEX);
        Assert.assertEquals((long)(numV / strs.length), (long)Iterables.size((Iterable)this.graph.query().has("text", (Predicate)Text.CONTAINS_REGEX, (Object)"be[r]+y").properties()));
        Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)this.graph.query().has("text", (Predicate)Text.CONTAINS, (Object)"lolipop").properties()));
        Assert.assertEquals((long)(numV / strs.length), (long)Iterables.size((Iterable)this.graph.query().has("name", (Predicate)Cmp.EQUAL, (Object)strs[1]).properties()));
        Assert.assertEquals((long)(numV / strs.length), (long)Iterables.size((Iterable)this.graph.query().has("name", (Predicate)Cmp.EQUAL, (Object)strs[1]).properties()));
        Assert.assertEquals((long)(numV / strs.length * (strs.length - 1)), (long)Iterables.size((Iterable)this.graph.query().has("label", (Object)"uid").has("name", (Predicate)Cmp.NOT_EQUAL, (Object)strs[2]).properties()));
        Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)this.graph.query().has("name", (Predicate)Cmp.EQUAL, (Object)"farm").properties()));
        Assert.assertEquals((long)(numV / strs.length), (long)Iterables.size((Iterable)this.graph.query().has("name", (Predicate)Text.PREFIX, (Object)"ducks").properties()));
        Assert.assertEquals((long)(numV / strs.length * 2), (long)Iterables.size((Iterable)this.graph.query().has("name", (Predicate)Text.REGEX, (Object)"(.*)ducks(.*)").properties()));
        this.clopen(new Object[0]);
        TitanGraphTest.evaluateQuery(this.graph.query().has("text", (Predicate)Text.CONTAINS, (Object)"ducks"), ElementCategory.VERTEX, numV / strs.length * 2, new boolean[]{true, true}, VINDEX);
        Assert.assertEquals((long)(numV / strs.length * 2), (long)Iterables.size((Iterable)this.graph.query().has("text", (Predicate)Text.CONTAINS, (Object)"ducks").vertices()));
        Assert.assertEquals((long)(numV / strs.length * 2), (long)Iterables.size((Iterable)this.graph.query().has("text", (Predicate)Text.CONTAINS, (Object)"farm").vertices()));
        Assert.assertEquals((long)(numV / strs.length), (long)Iterables.size((Iterable)this.graph.query().has("text", (Predicate)Text.CONTAINS, (Object)"beautiful").vertices()));
        TitanGraphTest.evaluateQuery(this.graph.query().has("text", (Predicate)Text.CONTAINS_PREFIX, (Object)"beauti"), ElementCategory.VERTEX, numV / strs.length, new boolean[]{true, true}, VINDEX);
        Assert.assertEquals((long)(numV / strs.length), (long)Iterables.size((Iterable)this.graph.query().has("text", (Predicate)Text.CONTAINS_REGEX, (Object)"be[r]+y").vertices()));
        Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)this.graph.query().has("text", (Predicate)Text.CONTAINS, (Object)"lolipop").vertices()));
        Assert.assertEquals((long)(numV / strs.length), (long)Iterables.size((Iterable)this.graph.query().has("name", (Predicate)Cmp.EQUAL, (Object)strs[1]).vertices()));
        Assert.assertEquals((long)(numV / strs.length), (long)Iterables.size((Iterable)this.graph.query().has("name", (Predicate)Cmp.EQUAL, (Object)strs[1]).vertices()));
        Assert.assertEquals((long)(numV / strs.length * (strs.length - 1)), (long)Iterables.size((Iterable)this.graph.query().has("name", (Predicate)Cmp.NOT_EQUAL, (Object)strs[2]).vertices()));
        Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)this.graph.query().has("name", (Predicate)Cmp.EQUAL, (Object)"farm").vertices()));
        Assert.assertEquals((long)(numV / strs.length), (long)Iterables.size((Iterable)this.graph.query().has("name", (Predicate)Text.PREFIX, (Object)"ducks").vertices()));
        Assert.assertEquals((long)(numV / strs.length * 2), (long)Iterables.size((Iterable)this.graph.query().has("name", (Predicate)Text.REGEX, (Object)"(.*)ducks(.*)").vertices()));
        TitanGraphTest.evaluateQuery(this.graph.query().has("text", (Predicate)Text.CONTAINS, (Object)"ducks"), ElementCategory.EDGE, numV / strs.length * 2, new boolean[]{true, true}, EINDEX);
        Assert.assertEquals((long)(numV / strs.length * 2), (long)Iterables.size((Iterable)this.graph.query().has("text", (Predicate)Text.CONTAINS, (Object)"ducks").edges()));
        Assert.assertEquals((long)(numV / strs.length * 2), (long)Iterables.size((Iterable)this.graph.query().has("text", (Predicate)Text.CONTAINS, (Object)"farm").edges()));
        Assert.assertEquals((long)(numV / strs.length), (long)Iterables.size((Iterable)this.graph.query().has("text", (Predicate)Text.CONTAINS, (Object)"beautiful").edges()));
        TitanGraphTest.evaluateQuery(this.graph.query().has("text", (Predicate)Text.CONTAINS_PREFIX, (Object)"beauti"), ElementCategory.EDGE, numV / strs.length, new boolean[]{true, true}, EINDEX);
        Assert.assertEquals((long)(numV / strs.length), (long)Iterables.size((Iterable)this.graph.query().has("text", (Predicate)Text.CONTAINS_REGEX, (Object)"be[r]+y").edges()));
        Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)this.graph.query().has("text", (Predicate)Text.CONTAINS, (Object)"lolipop").edges()));
        Assert.assertEquals((long)(numV / strs.length), (long)Iterables.size((Iterable)this.graph.query().has("name", (Predicate)Cmp.EQUAL, (Object)strs[1]).edges()));
        Assert.assertEquals((long)(numV / strs.length), (long)Iterables.size((Iterable)this.graph.query().has("name", (Predicate)Cmp.EQUAL, (Object)strs[1]).edges()));
        Assert.assertEquals((long)(numV / strs.length * (strs.length - 1)), (long)Iterables.size((Iterable)this.graph.query().has("name", (Predicate)Cmp.NOT_EQUAL, (Object)strs[2]).edges()));
        Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)this.graph.query().has("name", (Predicate)Cmp.EQUAL, (Object)"farm").edges()));
        Assert.assertEquals((long)(numV / strs.length), (long)Iterables.size((Iterable)this.graph.query().has("name", (Predicate)Text.PREFIX, (Object)"ducks").edges()));
        Assert.assertEquals((long)(numV / strs.length * 2), (long)Iterables.size((Iterable)this.graph.query().has("name", (Predicate)Text.REGEX, (Object)"(.*)ducks(.*)").edges()));
        TitanGraphTest.evaluateQuery(this.graph.query().has("text", (Predicate)Text.CONTAINS, (Object)"ducks"), ElementCategory.PROPERTY, numV / strs.length * 2, new boolean[]{true, true}, PINDEX);
        Assert.assertEquals((long)(numV / strs.length * 2), (long)Iterables.size((Iterable)this.graph.query().has("text", (Predicate)Text.CONTAINS, (Object)"ducks").properties()));
        Assert.assertEquals((long)(numV / strs.length * 2), (long)Iterables.size((Iterable)this.graph.query().has("text", (Predicate)Text.CONTAINS, (Object)"farm").properties()));
        Assert.assertEquals((long)(numV / strs.length), (long)Iterables.size((Iterable)this.graph.query().has("text", (Predicate)Text.CONTAINS, (Object)"beautiful").properties()));
        TitanGraphTest.evaluateQuery(this.graph.query().has("text", (Predicate)Text.CONTAINS_PREFIX, (Object)"beauti"), ElementCategory.PROPERTY, numV / strs.length, new boolean[]{true, true}, PINDEX);
        Assert.assertEquals((long)(numV / strs.length), (long)Iterables.size((Iterable)this.graph.query().has("text", (Predicate)Text.CONTAINS_REGEX, (Object)"be[r]+y").properties()));
        Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)this.graph.query().has("text", (Predicate)Text.CONTAINS, (Object)"lolipop").properties()));
        Assert.assertEquals((long)(numV / strs.length), (long)Iterables.size((Iterable)this.graph.query().has("name", (Predicate)Cmp.EQUAL, (Object)strs[1]).properties()));
        Assert.assertEquals((long)(numV / strs.length), (long)Iterables.size((Iterable)this.graph.query().has("name", (Predicate)Cmp.EQUAL, (Object)strs[1]).properties()));
        Assert.assertEquals((long)(numV / strs.length * (strs.length - 1)), (long)Iterables.size((Iterable)this.graph.query().has("label", (Object)"uid").has("name", (Predicate)Cmp.NOT_EQUAL, (Object)strs[2]).properties()));
        Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)this.graph.query().has("name", (Predicate)Cmp.EQUAL, (Object)"farm").properties()));
        Assert.assertEquals((long)(numV / strs.length), (long)Iterables.size((Iterable)this.graph.query().has("name", (Predicate)Text.PREFIX, (Object)"ducks").properties()));
        Assert.assertEquals((long)(numV / strs.length * 2), (long)Iterables.size((Iterable)this.graph.query().has("name", (Predicate)Text.REGEX, (Object)"(.*)ducks(.*)").properties()));
        if (this.supportsLuceneStyleQueries()) {
            Assert.assertEquals((long)(numV / strs.length * 2), (long)Iterables.size((Iterable)this.graph.indexQuery(VINDEX, "xtext:ducks").vertices()));
            Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)this.graph.indexQuery(EINDEX, "xtext:ducks").edges()));
        }
    }

    @Test
    public void testRawQueries() {
        if (!this.supportsLuceneStyleQueries()) {
            return;
        }
        int numV = 1000;
        String[] strs = new String[]{"Uncle Berry has a farm", "and on his farm he has five ducks", "ducks are beautiful animals", "the sky is very blue today"};
        this.setupChainGraph(numV, strs, true);
        this.clopen(new Object[0]);
        Assert.assertEquals((long)(numV / strs.length * 2), (long)Iterables.size((Iterable)this.graph.indexQuery(VINDEX, "v.text:ducks").vertices()));
        Assert.assertEquals((long)(numV / strs.length * 2), (long)Iterables.size((Iterable)this.graph.indexQuery(VINDEX, "v.text:(farm uncle berry)").vertices()));
        Assert.assertEquals((long)(numV / strs.length), (long)Iterables.size((Iterable)this.graph.indexQuery(VINDEX, "v.text:(farm uncle berry) AND v.name:\"Uncle Berry has a farm\"").vertices()));
        Assert.assertEquals((long)(numV / strs.length * 2), (long)Iterables.size((Iterable)this.graph.indexQuery(VINDEX, "v.text:(beautiful are ducks)").vertices()));
        Assert.assertEquals((long)(numV / strs.length * 2 - 10), (long)Iterables.size((Iterable)this.graph.indexQuery(VINDEX, "v.text:(beautiful are ducks)").offset(10).vertices()));
        Assert.assertEquals((long)10L, (long)Iterables.size((Iterable)this.graph.indexQuery(VINDEX, "v.\"text\":(beautiful are ducks)").limit(10).vertices()));
        Assert.assertEquals((long)10L, (long)Iterables.size((Iterable)this.graph.indexQuery(VINDEX, "v.\"text\":(beautiful are ducks)").limit(10).offset(10).vertices()));
        Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)this.graph.indexQuery(VINDEX, "v.\"text\":(beautiful are ducks)").limit(10).offset(numV).vertices()));
        Assert.assertEquals((long)(numV / strs.length * 2), (long)Iterables.size((Iterable)this.graph.indexQuery(VINDEX, "xtext:ducks").vertices()));
        Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)this.graph.indexQuery(VINDEX, "text:ducks").vertices()));
        Assert.assertEquals((long)(numV / strs.length * 2), (long)Iterables.size((Iterable)this.graph.indexQuery(VINDEX, "$v$text:ducks").setElementIdentifier("$v$").vertices()));
        Assert.assertEquals((long)(numV / strs.length * 2), (long)Iterables.size((Iterable)this.graph.indexQuery(EINDEX, "e.text:ducks").edges()));
        Assert.assertEquals((long)(numV / strs.length * 2), (long)Iterables.size((Iterable)this.graph.indexQuery(EINDEX, "e.text:(farm uncle berry)").edges()));
        Assert.assertEquals((long)(numV / strs.length), (long)Iterables.size((Iterable)this.graph.indexQuery(EINDEX, "e.text:(farm uncle berry) AND e.name:\"Uncle Berry has a farm\"").edges()));
        Assert.assertEquals((long)(numV / strs.length * 2), (long)Iterables.size((Iterable)this.graph.indexQuery(EINDEX, "e.text:(beautiful are ducks)").edges()));
        Assert.assertEquals((long)(numV / strs.length * 2 - 10), (long)Iterables.size((Iterable)this.graph.indexQuery(EINDEX, "e.text:(beautiful are ducks)").offset(10).edges()));
        Assert.assertEquals((long)10L, (long)Iterables.size((Iterable)this.graph.indexQuery(EINDEX, "e.\"text\":(beautiful are ducks)").limit(10).edges()));
        Assert.assertEquals((long)10L, (long)Iterables.size((Iterable)this.graph.indexQuery(EINDEX, "e.\"text\":(beautiful are ducks)").limit(10).offset(10).edges()));
        Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)this.graph.indexQuery(EINDEX, "e.\"text\":(beautiful are ducks)").limit(10).offset(numV).edges()));
        Assert.assertEquals((long)(numV / strs.length * 2), (long)Iterables.size((Iterable)this.graph.indexQuery(EINDEX, "text:ducks").edges()));
        Assert.assertEquals((long)(numV / strs.length * 2), (long)Iterables.size((Iterable)this.graph.indexQuery(PINDEX, "p.text:ducks").properties()));
        Assert.assertEquals((long)(numV / strs.length * 2), (long)Iterables.size((Iterable)this.graph.indexQuery(PINDEX, "p.text:(farm uncle berry)").properties()));
        Assert.assertEquals((long)(numV / strs.length), (long)Iterables.size((Iterable)this.graph.indexQuery(PINDEX, "p.text:(farm uncle berry) AND p.name:\"Uncle Berry has a farm\"").properties()));
        Assert.assertEquals((long)(numV / strs.length * 2), (long)Iterables.size((Iterable)this.graph.indexQuery(PINDEX, "p.text:(beautiful are ducks)").properties()));
        Assert.assertEquals((long)(numV / strs.length * 2 - 10), (long)Iterables.size((Iterable)this.graph.indexQuery(PINDEX, "p.text:(beautiful are ducks)").offset(10).properties()));
        Assert.assertEquals((long)10L, (long)Iterables.size((Iterable)this.graph.indexQuery(PINDEX, "p.\"text\":(beautiful are ducks)").limit(10).properties()));
        Assert.assertEquals((long)10L, (long)Iterables.size((Iterable)this.graph.indexQuery(PINDEX, "p.\"text\":(beautiful are ducks)").limit(10).offset(10).properties()));
        Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)this.graph.indexQuery(PINDEX, "p.\"text\":(beautiful are ducks)").limit(10).offset(numV).properties()));
        Assert.assertEquals((long)(numV / strs.length * 2), (long)Iterables.size((Iterable)this.graph.indexQuery(PINDEX, "text:ducks").properties()));
    }

    @Test
    public void testDualMapping() {
        if (!this.indexFeatures.supportsStringMapping(Mapping.TEXTSTRING)) {
            return;
        }
        PropertyKey name = this.makeKey("name", String.class);
        TitanGraphIndex mixed = this.mgmt.buildIndex("mixed", Vertex.class).addKey(name, new Parameter[]{Mapping.TEXTSTRING.getParameter()}).buildMixedIndex(INDEX);
        mixed.getName();
        this.finishSchema();
        TitanVertex v = this.tx.addVertex();
        v.setProperty("name", (Object)"Long John Don");
        v = this.tx.addVertex();
        v.setProperty("name", (Object)"Long Little Lewis");
        this.clopen(new Object[0]);
        name = this.tx.getPropertyKey("name");
        TitanGraphTest.evaluateQuery(this.tx.query().has(name, (TitanPredicate)Cmp.EQUAL, (Object)"Long John Don"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "mixed");
        TitanGraphTest.evaluateQuery(this.tx.query().has(name, (TitanPredicate)Text.CONTAINS, (Object)"Long"), ElementCategory.VERTEX, 2, new boolean[]{true, true}, "mixed");
        TitanGraphTest.evaluateQuery(this.tx.query().has(name, (TitanPredicate)Text.CONTAINS, (Object)"Long Don"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "mixed");
        TitanGraphTest.evaluateQuery(this.tx.query().has(name, (TitanPredicate)Text.CONTAINS_PREFIX, (Object)"Lon"), ElementCategory.VERTEX, 2, new boolean[]{true, true}, "mixed");
        TitanGraphTest.evaluateQuery(this.tx.query().has(name, (TitanPredicate)Text.CONTAINS_REGEX, (Object)"Lit*le"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "mixed");
        TitanGraphTest.evaluateQuery(this.tx.query().has(name, (TitanPredicate)Text.REGEX, (Object)"Long.*"), ElementCategory.VERTEX, 2, new boolean[]{true, true}, "mixed");
        for (Vertex u : this.tx.getVertices()) {
            String n = (String)u.getProperty("name");
            if (n.endsWith("Don")) {
                u.remove();
                continue;
            }
            if (!n.endsWith("Lewis")) continue;
            u.setProperty("name", (Object)"Big Brother Bob");
        }
        this.clopen(new Object[0]);
        name = this.tx.getPropertyKey("name");
        TitanGraphTest.evaluateQuery(this.tx.query().has(name, (TitanPredicate)Text.CONTAINS, (Object)"Long"), ElementCategory.VERTEX, 0, new boolean[]{true, true}, "mixed");
        TitanGraphTest.evaluateQuery(this.tx.query().has(name, (TitanPredicate)Text.CONTAINS, (Object)"Big"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "mixed");
        TitanGraphTest.evaluateQuery(this.tx.query().has(name, (TitanPredicate)Text.PREFIX, (Object)"Big"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "mixed");
    }

    @Category(value={BrittleTests.class})
    @Test
    public void testIndexReplay() throws Exception {
        TimestampProvider times = this.graph.getConfiguration().getTimestampProvider();
        long startTime = times.getTime().getTimestamp(TimeUnit.MILLISECONDS);
        this.clopen(TitanIndexTest.option(GraphDatabaseConfiguration.SYSTEM_LOG_TRANSACTIONS, new String[0]), true, TitanIndexTest.option(KCVSLog.LOG_READ_LAG_TIME, "tx"), new StandardDuration(50L, TimeUnit.MILLISECONDS), TitanIndexTest.option(GraphDatabaseConfiguration.LOG_READ_INTERVAL, "tx"), new StandardDuration(250L, TimeUnit.MILLISECONDS), TitanIndexTest.option(GraphDatabaseConfiguration.MAX_COMMIT_TIME, new String[0]), new StandardDuration(1L, TimeUnit.SECONDS), TitanIndexTest.option(GraphDatabaseConfiguration.STORAGE_WRITE_WAITTIME, new String[0]), new StandardDuration(300L, TimeUnit.MILLISECONDS), TitanIndexTest.option(TestMockIndexProvider.INDEX_BACKEND_PROXY, INDEX), this.adjustedConfig.get(GraphDatabaseConfiguration.INDEX_BACKEND, new String[]{INDEX}), TitanIndexTest.option(GraphDatabaseConfiguration.INDEX_BACKEND, INDEX), TestMockIndexProvider.class.getName(), TitanIndexTest.option(TestMockIndexProvider.INDEX_MOCK_FAILADD, INDEX), true);
        PropertyKey name = this.mgmt.makePropertyKey("name").dataType(String.class).make();
        PropertyKey age = this.mgmt.makePropertyKey("age").dataType(Integer.class).make();
        this.mgmt.buildIndex("mi", Vertex.class).addKey(name, new Parameter[]{this.getTextMapping()}).addKey(age).buildMixedIndex(INDEX);
        this.finishSchema();
        TitanVertex[] vs = new TitanVertex[4];
        vs[0] = this.tx.addVertex();
        ElementHelper.setProperties((Element)vs[0], (Object[])new Object[]{"name", "Big Boy Bobson", "age", 55});
        this.newTx();
        vs[1] = this.tx.addVertex();
        vs[2] = this.tx.addVertex();
        vs[3] = this.tx.addVertex();
        ElementHelper.setProperties((Element)vs[1], (Object[])new Object[]{"name", "Long Little Lewis", "age", 35});
        ElementHelper.setProperties((Element)vs[2], (Object[])new Object[]{"name", "Tall Long Tiger", "age", 75});
        ElementHelper.setProperties((Element)vs[3], (Object[])new Object[]{"name", "Long John Don", "age", 15});
        this.newTx();
        vs[2] = this.tx.getVertex(vs[2].getLongId());
        vs[2].remove();
        vs[3] = this.tx.getVertex(vs[3].getLongId());
        vs[3].setProperty("name", (Object)"Bad Boy Badsy");
        vs[3].removeProperty("age");
        this.newTx();
        vs[0] = this.tx.getVertex(vs[0].getLongId());
        vs[0].setProperty("age", (Object)66);
        this.newTx();
        this.clopen(new Object[0]);
        TitanGraphTest.evaluateQuery(this.tx.query().has("name", (Predicate)Text.CONTAINS, (Object)"boy"), ElementCategory.VERTEX, 0, new boolean[]{true, true}, "mi");
        TransactionRecovery recovery = TitanFactory.startTransactionRecovery((TitanGraph)this.graph, (long)startTime, (TimeUnit)TimeUnit.MILLISECONDS);
        Thread.sleep(12000L);
        recovery.shutdown();
        long[] recoveryStats = ((StandardTransactionLogProcessor)recovery).getStatistics();
        this.clopen(new Object[0]);
        TitanGraphTest.evaluateQuery(this.tx.query().has("name", (Predicate)Text.CONTAINS, (Object)"boy"), ElementCategory.VERTEX, 2, new boolean[]{true, true}, "mi");
        TitanGraphTest.evaluateQuery(this.tx.query().has("name", (Predicate)Text.CONTAINS, (Object)"long"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "mi");
        TitanGraphTest.evaluateQuery(this.tx.query().has("name", (Predicate)Text.CONTAINS, (Object)"long").interval("age", (Comparable)Integer.valueOf(30), (Comparable)Integer.valueOf(40)), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "mi");
        TitanGraphTest.evaluateQuery(this.tx.query().has("age", (Object)75), ElementCategory.VERTEX, 0, new boolean[]{true, true}, "mi");
        TitanGraphTest.evaluateQuery(this.tx.query().has("name", (Predicate)Text.CONTAINS, (Object)"boy").interval("age", (Comparable)Integer.valueOf(60), (Comparable)Integer.valueOf(70)), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "mi");
        TitanGraphTest.evaluateQuery(this.tx.query().interval("age", (Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(100)), ElementCategory.VERTEX, 2, new boolean[]{true, true}, "mi");
        Assert.assertEquals((long)1L, (long)recoveryStats[0]);
        Assert.assertEquals((long)4L, (long)recoveryStats[1]);
    }

    @Test
    public void testIndexUpdatesWithoutReindex() throws InterruptedException {
        Object[] settings = new Object[]{TitanIndexTest.option(GraphDatabaseConfiguration.LOG_SEND_DELAY, "titan"), new StandardDuration(0L, TimeUnit.MILLISECONDS), TitanIndexTest.option(KCVSLog.LOG_READ_LAG_TIME, "titan"), new StandardDuration(50L, TimeUnit.MILLISECONDS), TitanIndexTest.option(GraphDatabaseConfiguration.LOG_READ_INTERVAL, "titan"), new StandardDuration(250L, TimeUnit.MILLISECONDS)};
        this.clopen(settings);
        String defText = "Mountain rocks are great friends";
        int defTime = 5;
        double defHeight = 101.1;
        PropertyKey time = this.mgmt.makePropertyKey("time").dataType(Integer.class).make();
        PropertyKey text = this.mgmt.makePropertyKey("text").dataType(String.class).make();
        PropertyKey height = this.mgmt.makePropertyKey("height").dataType(Decimal.class).make();
        TitanGraphIndex index = this.mgmt.buildIndex("theIndex", Vertex.class).addKey(text, new Parameter[]{this.getTextMapping(), this.getFieldMap(text)}).buildMixedIndex(INDEX);
        this.finishSchema();
        this.addVertex(5, "Mountain rocks are great friends", 101.1);
        this.clopen(settings);
        TitanGraphTest.evaluateQuery(this.tx.query().has("text", (Predicate)Text.CONTAINS, (Object)"rocks"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "theIndex");
        TitanGraphTest.evaluateQuery(this.tx.query().has("time", (Object)5), ElementCategory.VERTEX, 1, new boolean[]{false, true}, new String[0]);
        TitanGraphTest.evaluateQuery(this.tx.query().interval("height", (Comparable)Integer.valueOf(100), (Comparable)Integer.valueOf(200)), ElementCategory.VERTEX, 1, new boolean[]{false, true}, new String[0]);
        TitanGraphTest.evaluateQuery(this.tx.query().interval("height", (Comparable)Integer.valueOf(100), (Comparable)Integer.valueOf(200)).has("time", (Object)5), ElementCategory.VERTEX, 1, new boolean[]{false, true}, new String[0]);
        TitanGraphTest.evaluateQuery(this.tx.query().has("text", (Predicate)Text.CONTAINS, (Object)"rocks").has("time", (Object)5).interval("height", (Comparable)Integer.valueOf(100), (Comparable)Integer.valueOf(200)), ElementCategory.VERTEX, 1, new boolean[]{false, true}, "theIndex");
        this.newTx();
        this.finishSchema();
        time = this.mgmt.getPropertyKey("time");
        this.mgmt.addIndexKey(this.mgmt.getGraphIndex("theIndex"), time, new Parameter[]{this.getFieldMap(time)});
        this.finishSchema();
        this.newTx();
        this.addVertex(5, "Mountain rocks are great friends", 101.1);
        this.tx.commit();
        try {
            this.mgmt.updateIndex((TitanIndex)this.mgmt.getGraphIndex("theIndex"), SchemaAction.ENABLE_INDEX);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.mgmt.commit();
        Thread.sleep(2000L);
        this.finishSchema();
        this.mgmt.updateIndex((TitanIndex)this.mgmt.getGraphIndex("theIndex"), SchemaAction.ENABLE_INDEX);
        this.finishSchema();
        this.addVertex(5, "Mountain rocks are great friends", 101.1);
        this.clopen(settings);
        TitanGraphTest.evaluateQuery(this.tx.query().has("text", (Predicate)Text.CONTAINS, (Object)"rocks"), ElementCategory.VERTEX, 3, new boolean[]{true, true}, "theIndex");
        TitanGraphTest.evaluateQuery(this.tx.query().has("time", (Object)5), ElementCategory.VERTEX, 2, new boolean[]{true, true}, "theIndex");
        TitanGraphTest.evaluateQuery(this.tx.query().interval("height", (Comparable)Integer.valueOf(100), (Comparable)Integer.valueOf(200)), ElementCategory.VERTEX, 3, new boolean[]{false, true}, new String[0]);
        TitanGraphTest.evaluateQuery(this.tx.query().interval("height", (Comparable)Integer.valueOf(100), (Comparable)Integer.valueOf(200)).has("time", (Object)5), ElementCategory.VERTEX, 2, new boolean[]{false, true}, "theIndex");
        TitanGraphTest.evaluateQuery(this.tx.query().has("text", (Predicate)Text.CONTAINS, (Object)"rocks").has("time", (Object)5).interval("height", (Comparable)Integer.valueOf(100), (Comparable)Integer.valueOf(200)), ElementCategory.VERTEX, 2, new boolean[]{false, true}, "theIndex");
        this.newTx();
        this.finishSchema();
        height = this.mgmt.getPropertyKey("height");
        this.mgmt.addIndexKey(this.mgmt.getGraphIndex("theIndex"), height, new Parameter[0]);
        this.finishSchema();
        this.addVertex(5, "Mountain rocks are great friends", 101.1);
        this.tx.commit();
        this.mgmt.commit();
        Thread.sleep(2000L);
        this.finishSchema();
        this.mgmt.updateIndex((TitanIndex)this.mgmt.getGraphIndex("theIndex"), SchemaAction.ENABLE_INDEX);
        this.finishSchema();
        this.addVertex(5, "Mountain rocks are great friends", 101.1);
        this.clopen(settings);
        TitanGraphTest.evaluateQuery(this.tx.query().has("text", (Predicate)Text.CONTAINS, (Object)"rocks"), ElementCategory.VERTEX, 5, new boolean[]{true, true}, "theIndex");
        TitanGraphTest.evaluateQuery(this.tx.query().has("time", (Object)5), ElementCategory.VERTEX, 4, new boolean[]{true, true}, "theIndex");
        TitanGraphTest.evaluateQuery(this.tx.query().interval("height", (Comparable)Integer.valueOf(100), (Comparable)Integer.valueOf(200)), ElementCategory.VERTEX, 2, new boolean[]{true, true}, "theIndex");
        TitanGraphTest.evaluateQuery(this.tx.query().interval("height", (Comparable)Integer.valueOf(100), (Comparable)Integer.valueOf(200)).has("time", (Object)5), ElementCategory.VERTEX, 2, new boolean[]{true, true}, "theIndex");
        TitanGraphTest.evaluateQuery(this.tx.query().has("text", (Predicate)Text.CONTAINS, (Object)"rocks").has("time", (Object)5).interval("height", (Comparable)Integer.valueOf(100), (Comparable)Integer.valueOf(200)), ElementCategory.VERTEX, 2, new boolean[]{true, true}, "theIndex");
        this.newTx();
    }

    private void addVertex(int time, String text, double height) {
        this.newTx();
        TitanVertex v = this.tx.addVertex();
        v.setProperty("text", (Object)text);
        v.setProperty("time", (Object)time);
        v.setProperty("height", (Object)height);
        this.newTx();
    }

    @Test
    public void testVertexTTLWithMixedIndices() throws Exception {
        if (!this.features.hasCellTTL() || !this.indexFeatures.supportsDocumentTTL()) {
            return;
        }
        PropertyKey name = this.makeKey("name", String.class);
        PropertyKey time = this.makeKey("time", Long.class);
        PropertyKey text = this.makeKey("text", String.class);
        VertexLabel event = this.mgmt.makeVertexLabel("event").setStatic().make();
        int eventTTLSeconds = (int)TestGraphConfigs.getTTL(TimeUnit.SECONDS);
        this.mgmt.setTTL((TitanSchemaType)event, eventTTLSeconds, TimeUnit.SECONDS);
        this.mgmt.buildIndex("index1", Vertex.class).addKey(name, new Parameter[]{this.getStringMapping()}).addKey(time).buildMixedIndex(INDEX);
        this.mgmt.buildIndex("index2", Vertex.class).indexOnly((TitanSchemaType)event).addKey(text, new Parameter[]{this.getTextMapping()}).buildMixedIndex(INDEX);
        Assert.assertEquals((long)0L, (long)this.mgmt.getTTL((TitanSchemaType)name).getLength(TimeUnit.SECONDS));
        Assert.assertEquals((long)0L, (long)this.mgmt.getTTL((TitanSchemaType)time).getLength(TimeUnit.SECONDS));
        Assert.assertEquals((long)eventTTLSeconds, (long)this.mgmt.getTTL((TitanSchemaType)event).getLength(TimeUnit.SECONDS));
        this.finishSchema();
        TitanVertex v1 = this.tx.addVertexWithLabel("event");
        v1.setProperty("name", (Object)"first event");
        v1.setProperty("text", (Object)"this text will help to identify the first event");
        long time1 = System.currentTimeMillis();
        v1.setProperty("time", (Object)time1);
        TitanVertex v2 = this.tx.addVertexWithLabel("event");
        v2.setProperty("name", (Object)"second event");
        v2.setProperty("text", (Object)"this text won't match");
        long time2 = time1 + 1L;
        v2.setProperty("time", (Object)time2);
        time = this.tx.getPropertyKey("time");
        TitanGraphTest.evaluateQuery(this.tx.query().has("name", (Object)"first event").orderBy(time, Order.DESC), ElementCategory.VERTEX, 1, new boolean[]{true, true}, time, Order.DESC, "index1");
        TitanGraphTest.evaluateQuery(this.tx.query().has("text", (Predicate)Text.CONTAINS, (Object)"help").has("label", (Object)"event"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "index2");
        this.clopen(new Object[0]);
        Object v1Id = v1.getId();
        Object v2Id = v2.getId();
        time = this.tx.getPropertyKey("time");
        TitanGraphTest.evaluateQuery(this.tx.query().has("name", (Object)"first event").orderBy(time, Order.DESC), ElementCategory.VERTEX, 1, new boolean[]{true, true}, time, Order.DESC, "index1");
        TitanGraphTest.evaluateQuery(this.tx.query().has("text", (Predicate)Text.CONTAINS, (Object)"help").has("label", (Object)"event"), ElementCategory.VERTEX, 1, new boolean[]{true, true}, "index2");
        v1 = this.tx.getVertex(v1Id);
        v2 = this.tx.getVertex(v1Id);
        Assert.assertNotNull((Object)v1);
        Assert.assertNotNull((Object)v2);
        Thread.sleep(TimeUnit.MILLISECONDS.convert((long)Math.ceil((double)eventTTLSeconds * 2.5), TimeUnit.SECONDS));
        this.clopen(new Object[0]);
        time = this.tx.getPropertyKey("time");
        TitanGraphTest.evaluateQuery(this.tx.query().has("text", (Predicate)Text.CONTAINS, (Object)"help").has("label", (Object)"event"), ElementCategory.VERTEX, 0, new boolean[]{true, true}, "index2");
        TitanGraphTest.evaluateQuery(this.tx.query().has("name", (Object)"first event").orderBy(time, Order.DESC), ElementCategory.VERTEX, 0, new boolean[]{true, true}, time, Order.DESC, "index1");
        v1 = this.tx.getVertex(v1Id);
        v2 = this.tx.getVertex(v2Id);
        Assert.assertNull((Object)v1);
        Assert.assertNull((Object)v2);
    }

    @Test
    public void testEdgeTTLWithMixedIndices() throws Exception {
        if (!this.features.hasCellTTL() || !this.indexFeatures.supportsDocumentTTL()) {
            return;
        }
        PropertyKey name = this.mgmt.makePropertyKey("name").dataType(String.class).make();
        PropertyKey text = this.mgmt.makePropertyKey("text").dataType(String.class).make();
        PropertyKey time = this.makeKey("time", Long.class);
        EdgeLabel label = this.mgmt.makeEdgeLabel("likes").make();
        int likesTTLSeconds = (int)TestGraphConfigs.getTTL(TimeUnit.SECONDS);
        this.mgmt.setTTL((TitanSchemaType)label, likesTTLSeconds, TimeUnit.SECONDS);
        this.mgmt.buildIndex("index1", Edge.class).addKey(name, new Parameter[]{this.getStringMapping()}).addKey(time).buildMixedIndex(INDEX);
        this.mgmt.buildIndex("index2", Edge.class).indexOnly((TitanSchemaType)label).addKey(text, new Parameter[]{this.getTextMapping()}).buildMixedIndex(INDEX);
        Assert.assertEquals((long)0L, (long)this.mgmt.getTTL((TitanSchemaType)name).getLength(TimeUnit.SECONDS));
        Assert.assertEquals((long)likesTTLSeconds, (long)this.mgmt.getTTL((TitanSchemaType)label).getLength(TimeUnit.SECONDS));
        this.finishSchema();
        TitanVertex v1 = this.tx.addVertex();
        TitanVertex v2 = this.tx.addVertex();
        TitanVertex v3 = this.tx.addVertex();
        TitanEdge e1 = this.tx.addEdge(v1, v2, "likes");
        e1.setProperty("name", (Object)"v1 likes v2");
        e1.setProperty("text", (Object)"this will help to identify the edge");
        long time1 = System.currentTimeMillis();
        e1.setProperty("time", (Object)time1);
        TitanEdge e2 = this.tx.addEdge(v2, v3, "likes");
        e2.setProperty("name", (Object)"v2 likes v3");
        e2.setProperty("text", (Object)"this won't match anything");
        long time2 = time1 + 1L;
        e2.setProperty("time", (Object)time2);
        Object e1Id = e1.getId();
        Object e2Id = e2.getId();
        this.clopen(new Object[0]);
        time = this.tx.getPropertyKey("time");
        TitanGraphTest.evaluateQuery(this.tx.query().has("text", (Predicate)Text.CONTAINS, (Object)"help").has("label", (Object)"likes"), ElementCategory.EDGE, 1, new boolean[]{true, true}, "index2");
        TitanGraphTest.evaluateQuery(this.tx.query().has("name", (Object)"v2 likes v3").orderBy(time, Order.DESC), ElementCategory.EDGE, 1, new boolean[]{true, true}, time, Order.DESC, "index1");
        v1 = this.tx.getVertex(v1.getLongId());
        v2 = this.tx.getVertex(v2.getLongId());
        v3 = this.tx.getVertex(v3.getLongId());
        e1 = this.tx.getEdge(e1Id);
        e2 = this.tx.getEdge(e1Id);
        Assert.assertNotNull((Object)v1);
        Assert.assertNotNull((Object)v2);
        Assert.assertNotNull((Object)v3);
        Assert.assertNotNull((Object)e1);
        Assert.assertNotNull((Object)e2);
        Assert.assertTrue((boolean)v1.getEdges(Direction.OUT, new String[0]).iterator().hasNext());
        Assert.assertTrue((boolean)v2.getEdges(Direction.OUT, new String[0]).iterator().hasNext());
        Thread.sleep(TimeUnit.MILLISECONDS.convert((long)Math.ceil((double)likesTTLSeconds * 1.25), TimeUnit.SECONDS));
        this.clopen(new Object[0]);
        time = this.tx.getPropertyKey("time");
        TitanGraphTest.evaluateQuery(this.tx.query().has("text", (Predicate)Text.CONTAINS, (Object)"help").has("label", (Object)"likes"), ElementCategory.EDGE, 0, new boolean[]{true, true}, "index2");
        TitanGraphTest.evaluateQuery(this.tx.query().has("name", (Object)"v2 likes v3").orderBy(time, Order.DESC), ElementCategory.EDGE, 0, new boolean[]{true, true}, time, Order.DESC, "index1");
        v1 = this.tx.getVertex(v1.getLongId());
        v2 = this.tx.getVertex(v2.getLongId());
        v3 = this.tx.getVertex(v3.getLongId());
        e1 = this.tx.getEdge(e1Id);
        e2 = this.tx.getEdge(e1Id);
        Assert.assertNotNull((Object)v1);
        Assert.assertNotNull((Object)v2);
        Assert.assertNotNull((Object)v3);
        Assert.assertNull((Object)e1);
        Assert.assertNull((Object)e2);
        Assert.assertFalse((boolean)v1.getEdges(Direction.OUT, new String[0]).iterator().hasNext());
        Assert.assertFalse((boolean)v2.getEdges(Direction.OUT, new String[0]).iterator().hasNext());
    }

    @Test
    public void testDeleteVertexThenDeleteProperty() throws BackendException {
        this.testNestedWrites("x", null);
    }

    @Test
    public void testDeleteVertexThenAddProperty() throws BackendException {
        this.testNestedWrites(null, "y");
    }

    @Test
    public void testDeleteVertexThenModifyProperty() throws BackendException {
        this.testNestedWrites("x", "y");
    }

    @Test
    public void testIndexQueryWithScore() throws InterruptedException {
        PropertyKey textKey = this.mgmt.makePropertyKey("text").dataType(String.class).make();
        this.mgmt.buildIndex("store1", Vertex.class).addKey(textKey).buildMixedIndex(INDEX);
        this.mgmt.commit();
        TitanVertex v1 = this.tx.addVertex();
        TitanVertex v2 = this.tx.addVertex();
        TitanVertex v3 = this.tx.addVertex();
        v1.setProperty("text", (Object)"Hello Hello Hello Hello Hello Hello Hello Hello");
        v2.setProperty("text", (Object)"Hello abab abab fsdfsd sfdfsd sdffs fsdsdf fdf fsdfsd aera fsad abab abab fsdfsd sfdf");
        v3.setProperty("text", (Object)"Hello");
        this.tx.commit();
        Thread.sleep(5000L);
        HashSet<Double> scores = new HashSet<Double>();
        for (TitanIndexQuery.Result r : this.graph.indexQuery("store1", "v.text:(Hello)").vertices()) {
            scores.add(r.getScore());
        }
        junit.framework.Assert.assertEquals((int)3, (int)scores.size());
    }

    @Test
    public void testContainsWithMultipleValues() throws Exception {
        PropertyKey name = this.makeKey("name", String.class);
        this.mgmt.buildIndex("store1", Vertex.class).addKey(name).buildMixedIndex(INDEX);
        this.mgmt.commit();
        TitanVertex v1 = this.tx.addVertex();
        v1.setProperty("name", (Object)"hercules was here");
        this.tx.commit();
        Thread.sleep(2000L);
        Vertex r = (Vertex)Iterables.get((Iterable)this.graph.query().has("name", (Predicate)Text.CONTAINS, (Object)"here hercules").vertices(), (int)0);
        junit.framework.Assert.assertEquals((Object)r.getProperty("name"), (Object)"hercules was here");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testNestedWrites(String initialValue, String updatedValue) throws BackendException {
        Backend b = null;
        try {
            b = this.graph.getConfiguration().getBackend();
            if (b.getStoreFeatures().hasTxIsolation()) {
                log.info("Skipping " + this.getClass().getSimpleName() + "." + this.methodName.getMethodName());
                return;
            }
        }
        finally {
            if (null != b) {
                b.close();
            }
        }
        String propName = "foo";
        PropertyKey prop = this.makeKey("foo", String.class);
        this.createExternalVertexIndex(prop, INDEX);
        this.finishSchema();
        TitanVertex v = this.graph.addVertex(null);
        if (null != initialValue) {
            ElementHelper.setProperties((Element)v, (Object[])new Object[]{"foo", initialValue});
        }
        this.graph.commit();
        Object id = v.getId();
        TitanTransaction vertexDeleter = this.graph.newTransaction();
        TitanTransaction propDeleter = this.graph.newTransaction();
        vertexDeleter.removeVertex(vertexDeleter.getVertex(id));
        if (null == updatedValue) {
            propDeleter.getVertex((Object)propDeleter.getVertex(id)).removeProperty("foo");
        } else {
            propDeleter.getVertex((Object)propDeleter.getVertex(id)).setProperty("foo", (Object)updatedValue);
        }
        vertexDeleter.commit();
        propDeleter.commit();
        this.graph.rollback();
        Assert.assertEquals(null, (Object)this.graph.getVertex(id));
        Assert.assertEquals((Object)false, (Object)this.graph.query().has("foo").vertices().iterator().hasNext());
        if (null != updatedValue) {
            Assert.assertEquals((Object)false, (Object)this.graph.query().has("foo", (Object)updatedValue).vertices().iterator().hasNext());
        }
        this.graph.rollback();
    }
}

