/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricFilter;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.thinkaurelius.titan.core.Cardinality;
import com.thinkaurelius.titan.core.EdgeLabel;
import com.thinkaurelius.titan.core.Multiplicity;
import com.thinkaurelius.titan.core.PropertyKey;
import com.thinkaurelius.titan.core.TitanEdge;
import com.thinkaurelius.titan.core.TitanProperty;
import com.thinkaurelius.titan.core.TitanTransaction;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.core.VertexLabel;
import com.thinkaurelius.titan.core.schema.ConsistencyModifier;
import com.thinkaurelius.titan.core.schema.TitanGraphIndex;
import com.thinkaurelius.titan.core.schema.TitanSchemaElement;
import com.thinkaurelius.titan.diskstorage.configuration.BasicConfiguration;
import com.thinkaurelius.titan.diskstorage.configuration.ModifiableConfiguration;
import com.thinkaurelius.titan.diskstorage.configuration.WriteConfiguration;
import com.thinkaurelius.titan.diskstorage.util.CacheMetricsAction;
import com.thinkaurelius.titan.diskstorage.util.MetricInstrumentedStore;
import com.thinkaurelius.titan.graphdb.TitanGraphBaseTest;
import com.thinkaurelius.titan.graphdb.configuration.GraphDatabaseConfiguration;
import com.thinkaurelius.titan.graphdb.internal.ElementCategory;
import com.thinkaurelius.titan.graphdb.internal.InternalRelationType;
import com.thinkaurelius.titan.graphdb.internal.InternalVertexLabel;
import com.thinkaurelius.titan.graphdb.types.CompositeIndexType;
import com.thinkaurelius.titan.graphdb.types.IndexType;
import com.thinkaurelius.titan.testcategory.SerialTests;
import com.thinkaurelius.titan.util.stats.MetricManager;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.util.ElementHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SerialTests.class})
public abstract class TitanOperationCountingTest
extends TitanGraphBaseTest {
    public MetricManager metric;
    public final String SYSTEM_METRICS = "com.thinkaurelius.titan.sys";
    public static final List<String> STORE_NAMES = ImmutableList.of((Object)"edgestore", (Object)"graphindex", (Object)"titan_ids", (Object)"storeManager");
    private String metricsPrefix;

    public abstract WriteConfiguration getBaseConfiguration();

    public abstract boolean storeUsesConsistentKeyLocker();

    @Override
    public WriteConfiguration getConfiguration() {
        WriteConfiguration config = this.getBaseConfiguration();
        ModifiableConfiguration mconf = new ModifiableConfiguration(GraphDatabaseConfiguration.ROOT_NS, config, BasicConfiguration.Restriction.NONE);
        mconf.set(GraphDatabaseConfiguration.BASIC_METRICS, (Object)true, new String[0]);
        mconf.set(GraphDatabaseConfiguration.METRICS_MERGE_STORES, (Object)false, new String[0]);
        mconf.set(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, (Object)false, new String[0]);
        mconf.set(GraphDatabaseConfiguration.DB_CACHE, (Object)false, new String[0]);
        return config;
    }

    @Override
    public void open(WriteConfiguration config) {
        this.metric = MetricManager.INSTANCE;
        super.open(config);
    }

    @Test
    public void testIdCounts() {
        this.makeVertexIndexedUniqueKey("uid", Integer.class);
        this.mgmt.setConsistency((TitanSchemaElement)this.mgmt.getGraphIndex("uid"), ConsistencyModifier.LOCK);
        this.finishSchema();
        this.verifyStoreMetrics("titan_ids", "com.thinkaurelius.titan.sys", (Map<String, Long>)ImmutableMap.of((Object)"mutate", (Object)3L, (Object)"getSlice", (Object)6L));
    }

    @Test
    public void testReadOperations() {
        this.testReadOperations(false);
    }

    @Test
    public void testReadOperationsWithCache() {
        this.testReadOperations(true);
    }

    public void testReadOperations(boolean cache) {
        this.metricsPrefix = "schema" + cache;
        this.resetEdgeCacheCounts();
        this.makeVertexIndexedUniqueKey("uid", Integer.class);
        this.mgmt.setConsistency((TitanSchemaElement)this.mgmt.getGraphIndex("uid"), ConsistencyModifier.LOCK);
        this.finishSchema();
        if (cache) {
            this.clopen(TitanOperationCountingTest.option(GraphDatabaseConfiguration.DB_CACHE, new String[0]), true, TitanOperationCountingTest.option(GraphDatabaseConfiguration.DB_CACHE_CLEAN_WAIT, new String[0]), 0, TitanOperationCountingTest.option(GraphDatabaseConfiguration.DB_CACHE_TIME, new String[0]), 0);
        } else {
            this.clopen(new Object[0]);
        }
        TitanTransaction tx = this.graph.buildTransaction().setGroupName(this.metricsPrefix).start();
        tx.makePropertyKey("name").dataType(String.class).make();
        tx.makeEdgeLabel("knows").make();
        tx.makeVertexLabel("person").make();
        tx.commit();
        this.verifyStoreMetrics("edgestore");
        if (this.storeUsesConsistentKeyLocker()) {
            this.verifyStoreMetrics("graphindex", (Map<String, Long>)ImmutableMap.of((Object)"getSlice", (Object)6L, (Object)"acquireLock", (Object)0L));
        } else {
            this.verifyStoreMetrics("graphindex", (Map<String, Long>)ImmutableMap.of((Object)"getSlice", (Object)3L, (Object)"acquireLock", (Object)3L));
        }
        this.resetMetrics();
        this.metricsPrefix = "com.thinkaurelius.titan.sys.schema";
        this.resetMetrics();
        for (int t = 0; t < 10; ++t) {
            tx = this.graph.buildTransaction().setGroupName(this.metricsPrefix).start();
            Assert.assertTrue((boolean)tx.containsRelationType("name"));
            Assert.assertTrue((boolean)tx.containsRelationType("knows"));
            Assert.assertTrue((boolean)tx.containsVertexLabel("person"));
            PropertyKey name = tx.getPropertyKey("name");
            EdgeLabel knows = tx.getEdgeLabel("knows");
            VertexLabel person = tx.getVertexLabel("person");
            PropertyKey uid = tx.getPropertyKey("uid");
            Assert.assertEquals((Object)"name", (Object)name.getName());
            Assert.assertEquals((Object)"knows", (Object)knows.getName());
            Assert.assertEquals((Object)"person", (Object)person.getName());
            Assert.assertEquals((Object)"uid", (Object)uid.getName());
            Assert.assertEquals((Object)Cardinality.SINGLE, (Object)name.getCardinality());
            Assert.assertEquals((Object)Multiplicity.MULTI, (Object)knows.getMultiplicity());
            Assert.assertFalse((boolean)person.isPartitioned());
            Assert.assertEquals(Integer.class, (Object)uid.getDataType());
            InternalRelationType namei = (InternalRelationType)name;
            InternalRelationType knowsi = (InternalRelationType)knows;
            InternalRelationType uidi = (InternalRelationType)uid;
            Assert.assertNull((Object)namei.getBaseType());
            Assert.assertNull((Object)knowsi.getBaseType());
            IndexType index = (IndexType)Iterables.getOnlyElement((Iterable)uidi.getKeyIndexes());
            Assert.assertEquals((long)1L, (long)index.getFieldKeys().length);
            Assert.assertEquals((Object)ElementCategory.VERTEX, (Object)index.getElement());
            Assert.assertEquals((Object)ConsistencyModifier.LOCK, (Object)((CompositeIndexType)index).getConsistencyModifier());
            Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)uidi.getRelationIndexes()));
            Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)namei.getRelationIndexes()));
            Assert.assertEquals((Object)namei, (Object)Iterables.getOnlyElement((Iterable)namei.getRelationIndexes()));
            Assert.assertEquals((Object)knowsi, (Object)Iterables.getOnlyElement((Iterable)knowsi.getRelationIndexes()));
            Assert.assertEquals((long)0L, (long)((InternalVertexLabel)person).getTTL());
            tx.commit();
            this.verifyStoreMetrics("edgestore", (Map<String, Long>)ImmutableMap.of((Object)"getSlice", (Object)19L));
            this.verifyStoreMetrics("graphindex", (Map<String, Long>)ImmutableMap.of((Object)"getSlice", (Object)4L, (Object)"acquireLock", (Object)0L));
        }
        this.metricsPrefix = "add" + cache;
        tx = this.graph.buildTransaction().setGroupName(this.metricsPrefix).start();
        TitanVertex v = tx.addVertex();
        TitanVertex u = tx.addVertexWithLabel("person");
        v.setProperty("uid", (Object)1);
        u.setProperty("name", (Object)"juju");
        TitanEdge e = v.addEdge("knows", u);
        e.setProperty("name", (Object)"edge");
        tx.commit();
        this.verifyStoreMetrics("edgestore");
        if (this.storeUsesConsistentKeyLocker()) {
            this.verifyStoreMetrics("graphindex", (Map<String, Long>)ImmutableMap.of((Object)"getSlice", (Object)2L, (Object)"acquireLock", (Object)0L));
        } else {
            this.verifyStoreMetrics("graphindex", (Map<String, Long>)ImmutableMap.of((Object)"getSlice", (Object)1L, (Object)"acquireLock", (Object)1L));
        }
        for (int i = 1; i <= 30; ++i) {
            this.metricsPrefix = "op" + i + cache;
            tx = this.graph.buildTransaction().setGroupName(this.metricsPrefix).start();
            v = (TitanVertex)Iterables.getOnlyElement((Iterable)tx.query().has("uid", (Object)1).vertices());
            Assert.assertEquals((Object)1, (Object)v.getProperty("uid"));
            u = (TitanVertex)Iterables.getOnlyElement((Iterable)v.getVertices(Direction.BOTH, new String[]{"knows"}));
            e = (TitanEdge)Iterables.getOnlyElement((Iterable)u.getEdges(Direction.IN, new String[]{"knows"}));
            Assert.assertEquals((Object)"juju", (Object)u.getProperty("name"));
            Assert.assertEquals((Object)"edge", (Object)e.getProperty("name"));
            tx.commit();
            if (!cache || i == 0) {
                this.verifyStoreMetrics("edgestore", (Map<String, Long>)ImmutableMap.of((Object)"getSlice", (Object)4L));
                this.verifyStoreMetrics("graphindex", (Map<String, Long>)ImmutableMap.of((Object)"getSlice", (Object)1L));
                continue;
            }
            if (!cache || i <= 20) continue;
            this.verifyStoreMetrics("edgestore");
            this.verifyStoreMetrics("graphindex");
        }
    }

    @Test
    public void testSettingProperty() throws Exception {
        this.metricsPrefix = "metrics1";
        this.mgmt.makePropertyKey("foo").dataType(String.class).cardinality(Cardinality.SINGLE).make();
        this.finishSchema();
        TitanVertex v = this.tx.addVertex();
        v.setProperty("foo", (Object)"bar");
        this.tx.commit();
        TitanTransaction tx = this.graph.buildTransaction().checkExternalVertexExistence(false).setGroupName(this.metricsPrefix).start();
        v = tx.getVertex(v.getLongId());
        v.setProperty("foo", (Object)"bus");
        tx.commit();
        if (this.storeUsesConsistentKeyLocker()) {
            this.verifyStoreMetrics(STORE_NAMES.get(1));
        } else {
            this.verifyStoreMetrics(STORE_NAMES.get(0));
        }
        this.verifyStoreMetrics(STORE_NAMES.get(1));
        this.verifyStoreMetrics(STORE_NAMES.get(2));
        this.verifyStoreMetrics(STORE_NAMES.get(3), (Map<String, Long>)ImmutableMap.of((Object)"mutate", (Object)1L));
        tx = this.graph.buildTransaction().checkExternalVertexExistence(false).setGroupName(this.metricsPrefix).start();
        v = tx.getVertex(v.getLongId());
        v.setProperty("foo", (Object)"band");
        Assert.assertEquals((Object)"band", (Object)v.getProperty("foo"));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)v.getProperties("foo")));
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)v.getProperties()));
        tx.commit();
        this.verifyStoreMetrics(STORE_NAMES.get(0), (Map<String, Long>)ImmutableMap.of((Object)"getSlice", (Object)2L));
        this.verifyStoreMetrics(STORE_NAMES.get(1));
        this.verifyStoreMetrics(STORE_NAMES.get(2));
        this.verifyStoreMetrics(STORE_NAMES.get(3), (Map<String, Long>)ImmutableMap.of((Object)"mutate", (Object)2L));
    }

    @Test
    @Ignore
    public void testKCVSAccess1() throws InterruptedException {
        this.metricsPrefix = "metrics1";
        TitanTransaction tx = this.graph.buildTransaction().setGroupName(this.metricsPrefix).start();
        TitanVertex v = tx.addVertex();
        this.verifyStoreMetrics(STORE_NAMES.get(3), "com.thinkaurelius.titan.sys", (Map<String, Long>)ImmutableMap.of((Object)"mutate", (Object)2L, (Object)"getSlice", (Object)4L));
        ElementHelper.setProperties((Element)v, (Object[])new Object[]{"age", 25, "name", "john"});
        TitanVertex u = tx.addVertex();
        ElementHelper.setProperties((Element)u, (Object[])new Object[]{"age", 35, "name", "mary"});
        v.addEdge("knows", u);
        tx.commit();
        this.verifyStoreMetrics(STORE_NAMES.get(0), (Map<String, Long>)ImmutableMap.of((Object)"mutate", (Object)8L));
        this.verifyStoreMetrics(STORE_NAMES.get(1), (Map<String, Long>)ImmutableMap.of((Object)"getSlice", (Object)3L, (Object)"mutate", (Object)6L, (Object)"acquireLock", (Object)3L));
        this.verifyStoreMetrics(STORE_NAMES.get(2));
        Thread.sleep(500L);
        this.verifyStoreMetrics(STORE_NAMES.get(3), "com.thinkaurelius.titan.sys", (Map<String, Long>)ImmutableMap.of((Object)"mutate", (Object)4L, (Object)"getSlice", (Object)8L));
        this.verifyTypeCacheMetrics(3, 3, 0, 0);
        tx = this.graph.buildTransaction().setGroupName(this.metricsPrefix).start();
        v = tx.getVertex(v.getLongId());
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)v.getProperties()));
        this.verifyStoreMetrics(STORE_NAMES.get(0), (Map<String, Long>)ImmutableMap.of((Object)"mutate", (Object)8L, (Object)"getSlice", (Object)4L));
        this.verifyStoreMetrics(STORE_NAMES.get(1), (Map<String, Long>)ImmutableMap.of((Object)"getSlice", (Object)3L, (Object)"mutate", (Object)6L, (Object)"acquireLock", (Object)3L));
        this.verifyStoreMetrics(STORE_NAMES.get(2));
        this.verifyStoreMetrics(STORE_NAMES.get(3), "com.thinkaurelius.titan.sys", (Map<String, Long>)ImmutableMap.of((Object)"mutate", (Object)4L, (Object)"getSlice", (Object)8L));
        this.verifyTypeCacheMetrics(3, 3, 2, 2);
        tx.commit();
        tx = this.graph.buildTransaction().setGroupName(this.metricsPrefix).start();
        v = tx.getVertex(v.getLongId());
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)v.getProperties()));
        this.verifyStoreMetrics(STORE_NAMES.get(0), (Map<String, Long>)ImmutableMap.of((Object)"mutate", (Object)8L, (Object)"getSlice", (Object)6L));
        this.verifyStoreMetrics(STORE_NAMES.get(1), (Map<String, Long>)ImmutableMap.of((Object)"getSlice", (Object)3L, (Object)"mutate", (Object)6L, (Object)"acquireLock", (Object)3L));
        this.verifyStoreMetrics(STORE_NAMES.get(2));
        this.verifyStoreMetrics(STORE_NAMES.get(3), "com.thinkaurelius.titan.sys", (Map<String, Long>)ImmutableMap.of((Object)"mutate", (Object)4L, (Object)"getSlice", (Object)8L));
        this.verifyTypeCacheMetrics(3, 3, 4, 2);
        tx.commit();
        tx = this.graph.buildTransaction().setGroupName(this.metricsPrefix).start();
        v = tx.getVertex(v.getLongId());
        Assert.assertNotNull((Object)v.getProperty("age"));
        Assert.assertNotNull((Object)v.getProperty("name"));
        this.verifyStoreMetrics(STORE_NAMES.get(0), (Map<String, Long>)ImmutableMap.of((Object)"mutate", (Object)8L, (Object)"getSlice", (Object)11L));
        this.verifyStoreMetrics(STORE_NAMES.get(1), (Map<String, Long>)ImmutableMap.of((Object)"getSlice", (Object)5L, (Object)"mutate", (Object)6L, (Object)"acquireLock", (Object)3L));
        this.verifyStoreMetrics(STORE_NAMES.get(2));
        this.verifyStoreMetrics(STORE_NAMES.get(3), "com.thinkaurelius.titan.sys", (Map<String, Long>)ImmutableMap.of((Object)"mutate", (Object)4L, (Object)"getSlice", (Object)8L));
        this.verifyTypeCacheMetrics(9, 5, 8, 4);
        tx.commit();
        tx = this.graph.buildTransaction().setGroupName(this.metricsPrefix).start();
        v = tx.getVertex(v.getLongId());
        Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)v.getEdges(Direction.BOTH, new String[0])));
        Assert.assertEquals((long)2L, (long)Iterables.size((Iterable)v.getProperties()));
        this.verifyStoreMetrics(STORE_NAMES.get(0), (Map<String, Long>)ImmutableMap.of((Object)"mutate", (Object)8L, (Object)"getSlice", (Object)15L));
        this.verifyStoreMetrics(STORE_NAMES.get(1), (Map<String, Long>)ImmutableMap.of((Object)"getSlice", (Object)5L, (Object)"mutate", (Object)6L, (Object)"acquireLock", (Object)3L));
        this.verifyStoreMetrics(STORE_NAMES.get(2));
        this.verifyStoreMetrics(STORE_NAMES.get(3), "com.thinkaurelius.titan.sys", (Map<String, Long>)ImmutableMap.of((Object)"mutate", (Object)4L, (Object)"getSlice", (Object)8L));
        this.verifyTypeCacheMetrics(9, 5, 11, 5);
        tx.commit();
    }

    @Test
    @Ignore
    public void testKCVSAccess2() throws InterruptedException {
        this.metricsPrefix = "metrics2";
        TitanTransaction tx = this.graph.buildTransaction().setGroupName(this.metricsPrefix).start();
        TitanVertex parentVertex = tx.addVertex();
        parentVertex.setProperty("name", (Object)"vParent");
        parentVertex.setProperty("other-prop-key1", (Object)"other-prop-value1");
        parentVertex.setProperty("other-prop-key2", (Object)"other-prop-value2");
        TitanVertex parentVertex2 = tx.addVertex();
        parentVertex2.setProperty("name", (Object)"vParent2");
        parentVertex2.setProperty("other-prop-key1", (Object)"other-prop-value12");
        parentVertex2.setProperty("other-prop-key2", (Object)"other-prop-value22");
        tx.commit();
        this.verifyStoreMetrics("edgeStore", (Map<String, Long>)ImmutableMap.of((Object)"mutate", (Object)8L));
        this.verifyStoreMetrics("vertexIndexStore", (Map<String, Long>)ImmutableMap.of((Object)"getSlice", (Object)3L, (Object)"mutate", (Object)6L, (Object)"acquireLock", (Object)3L));
        this.verifyTypeCacheMetrics(3, 3, 0, 0);
        tx = this.graph.buildTransaction().setGroupName(this.metricsPrefix).start();
        Assert.assertEquals((long)3L, (long)Iterables.size((Iterable)tx.getVertex(parentVertex.getLongId()).getProperties()));
        tx.commit();
        this.verifyStoreMetrics("edgeStore", (Map<String, Long>)ImmutableMap.of((Object)"mutate", (Object)8L, (Object)"getSlice", (Object)5L));
        this.verifyStoreMetrics("vertexIndexStore", (Map<String, Long>)ImmutableMap.of((Object)"getSlice", (Object)3L, (Object)"mutate", (Object)6L, (Object)"acquireLock", (Object)3L));
        this.verifyTypeCacheMetrics(3, 3, 3, 3);
        tx = this.graph.buildTransaction().setGroupName(this.metricsPrefix).start();
        Assert.assertEquals((long)3L, (long)Iterables.size((Iterable)tx.getVertex(parentVertex.getLongId()).getProperties()));
        this.verifyStoreMetrics("edgeStore", (Map<String, Long>)ImmutableMap.of((Object)"mutate", (Object)8L, (Object)"getSlice", (Object)7L));
        this.verifyStoreMetrics("vertexIndexStore", (Map<String, Long>)ImmutableMap.of((Object)"getSlice", (Object)3L, (Object)"mutate", (Object)6L, (Object)"acquireLock", (Object)3L));
        this.verifyTypeCacheMetrics(3, 3, 6, 3);
    }

    @Test
    @Ignore
    public void checkFastPropertyTrue() {
        this.checkFastPropertyAndLocking(true);
    }

    @Test
    @Ignore
    public void checkFastPropertyFalse() {
        this.checkFastPropertyAndLocking(false);
    }

    public void checkFastPropertyAndLocking(boolean fastProperty) {
        PropertyKey uid = this.makeKey("uid", String.class);
        TitanGraphIndex index = this.mgmt.buildIndex("uid", Vertex.class).unique().addKey(uid).buildCompositeIndex();
        this.mgmt.setConsistency((TitanSchemaElement)index, ConsistencyModifier.LOCK);
        this.finishSchema();
        this.clopen(TitanOperationCountingTest.option(GraphDatabaseConfiguration.PROPERTY_PREFETCHING, new String[0]), fastProperty);
        this.metricsPrefix = "metrics3" + fastProperty;
        TitanTransaction tx = this.graph.buildTransaction().setGroupName(this.metricsPrefix).start();
        tx.makePropertyKey("name").dataType(String.class).make();
        tx.makePropertyKey("age").dataType(Integer.class).make();
        TitanVertex v = tx.addVertex();
        ElementHelper.setProperties((Element)v, (Object[])new Object[]{"uid", "v1", "age", 25, "name", "john"});
        tx.commit();
        this.verifyStoreMetrics(STORE_NAMES.get(0), (Map<String, Long>)ImmutableMap.of((Object)"mutate", (Object)7L));
        this.verifyStoreMetrics(STORE_NAMES.get(1), (Map<String, Long>)ImmutableMap.of((Object)"getSlice", (Object)4L, (Object)"mutate", (Object)7L, (Object)"acquireLock", (Object)3L));
        this.verifyTypeCacheMetrics(0, 0, 0, 0);
        tx = this.graph.buildTransaction().setGroupName(this.metricsPrefix).start();
        v = tx.getVertex(v.getLongId());
        v.setProperty("age", (Object)35);
        v.setProperty("name", (Object)"johnny");
        tx.commit();
        if (fastProperty) {
            this.verifyStoreMetrics(STORE_NAMES.get(0), (Map<String, Long>)ImmutableMap.of((Object)"mutate", (Object)8L, (Object)"getSlice", (Object)7L));
        } else {
            this.verifyStoreMetrics(STORE_NAMES.get(0), (Map<String, Long>)ImmutableMap.of((Object)"mutate", (Object)8L, (Object)"getSlice", (Object)7L));
        }
        this.verifyStoreMetrics(STORE_NAMES.get(1), (Map<String, Long>)ImmutableMap.of((Object)"getSlice", (Object)6L, (Object)"mutate", (Object)7L, (Object)"acquireLock", (Object)4L));
        if (fastProperty) {
            this.verifyTypeCacheMetrics(6, 2, 5, 5);
        } else {
            this.verifyTypeCacheMetrics(6, 2, 4, 4);
        }
        tx = this.graph.buildTransaction().setGroupName(this.metricsPrefix).start();
        v = tx.getVertex(v.getLongId());
        v.setProperty("age", (Object)45);
        v.setProperty("name", (Object)"johnnie");
        tx.commit();
        if (fastProperty) {
            this.verifyStoreMetrics(STORE_NAMES.get(0), (Map<String, Long>)ImmutableMap.of((Object)"mutate", (Object)9L, (Object)"getSlice", (Object)9L));
        } else {
            this.verifyStoreMetrics(STORE_NAMES.get(0), (Map<String, Long>)ImmutableMap.of((Object)"mutate", (Object)9L, (Object)"getSlice", (Object)10L));
        }
        this.verifyStoreMetrics(STORE_NAMES.get(1), (Map<String, Long>)ImmutableMap.of((Object)"getSlice", (Object)6L, (Object)"mutate", (Object)7L, (Object)"acquireLock", (Object)4L));
        if (fastProperty) {
            this.verifyTypeCacheMetrics(12, 2, 10, 5);
        } else {
            this.verifyTypeCacheMetrics(12, 2, 8, 4);
        }
        tx = this.graph.buildTransaction().setGroupName(this.metricsPrefix).start();
        v = tx.getVertex(v.getLongId());
        for (TitanProperty p : v.getProperties()) {
            Assert.assertNotNull((Object)p.getValue());
            Assert.assertNotNull((Object)p.getPropertyKey());
        }
        tx.commit();
        this.verifyStoreMetrics(STORE_NAMES.get(1), (Map<String, Long>)ImmutableMap.of((Object)"getSlice", (Object)6L, (Object)"mutate", (Object)7L, (Object)"acquireLock", (Object)4L));
    }

    public void verifyStoreMetrics(String storeName) {
        this.verifyStoreMetrics(storeName, new HashMap<String, Long>(0));
    }

    public void verifyStoreMetrics(String storeName, Map<String, Long> operationCounts) {
        this.verifyStoreMetrics(storeName, this.metricsPrefix, operationCounts);
    }

    public void verifyStoreMetrics(String storeName, String prefix, Map<String, Long> operationCounts) {
        for (String operation : MetricInstrumentedStore.OPERATION_NAMES) {
            Long count = operationCounts.get(operation);
            if (count == null) {
                count = 0L;
            }
            Assert.assertEquals((String)Joiner.on((String)".").join((Object)prefix, (Object)storeName, new Object[]{operation, "calls"}), (long)count, (long)this.metric.getCounter(prefix, new String[]{storeName, operation, "calls"}).getCount());
        }
    }

    public void verifyTypeCacheMetrics(int nameRetrievals, int nameMisses, int relationRetrievals, int relationMisses) {
        this.verifyTypeCacheMetrics(this.metricsPrefix, nameRetrievals, nameMisses, relationRetrievals, relationMisses);
    }

    public void verifyTypeCacheMetrics(String prefix, int nameRetrievals, int nameMisses, int relationRetrievals, int relationMisses) {
        Assert.assertEquals((String)"On type cache name retrievals", (long)nameRetrievals, (long)this.metric.getCounter(prefix, new String[]{"schemacache", "name", CacheMetricsAction.RETRIEVAL.getName()}).getCount());
        Assert.assertEquals((String)"On type cache name misses", (long)nameMisses, (long)this.metric.getCounter(prefix, new String[]{"schemacache", "name", CacheMetricsAction.MISS.getName()}).getCount());
        Assert.assertEquals((String)"On type cache relation retrievals", (long)relationRetrievals, (long)this.metric.getCounter(prefix, new String[]{"schemacache", "relations", CacheMetricsAction.RETRIEVAL.getName()}).getCount());
        Assert.assertEquals((String)"On type cache relation misses", (long)relationMisses, (long)this.metric.getCounter(prefix, new String[]{"schemacache", "relations", CacheMetricsAction.MISS.getName()}).getCount());
    }

    public void printAllMetrics() {
        this.printAllMetrics(this.metricsPrefix);
    }

    public void printAllMetrics(String prefix) {
        for (String store : STORE_NAMES) {
            System.out.println("######## Store: " + store + " (" + prefix + ")");
            for (String operation : MetricInstrumentedStore.OPERATION_NAMES) {
                System.out.println("-- Operation: " + operation);
                System.out.print("\t");
                System.out.println(this.metric.getCounter(prefix, new String[]{store, operation, "calls"}).getCount());
                System.out.print("\t");
                System.out.println(this.metric.getTimer(prefix, new String[]{store, operation, "time"}).getMeanRate());
                if (operation != "getSlice") continue;
                System.out.print("\t");
                System.out.println(this.metric.getCounter(prefix, new String[]{store, operation, "entries-returned"}).getCount());
            }
        }
    }

    @Test
    @Ignore
    public void testCacheConcurrency() throws InterruptedException {
        this.metricsPrefix = "evgt1";
        Object[] newConfig = new Object[]{TitanOperationCountingTest.option(GraphDatabaseConfiguration.DB_CACHE, new String[0]), true, TitanOperationCountingTest.option(GraphDatabaseConfiguration.DB_CACHE_TIME, new String[0]), 0, TitanOperationCountingTest.option(GraphDatabaseConfiguration.DB_CACHE_CLEAN_WAIT, new String[0]), 0, TitanOperationCountingTest.option(GraphDatabaseConfiguration.DB_CACHE_SIZE, new String[0]), 0.25, TitanOperationCountingTest.option(GraphDatabaseConfiguration.BASIC_METRICS, new String[0]), true, TitanOperationCountingTest.option(GraphDatabaseConfiguration.METRICS_MERGE_STORES, new String[0]), false, TitanOperationCountingTest.option(GraphDatabaseConfiguration.METRICS_PREFIX, new String[0]), this.metricsPrefix};
        this.clopen(newConfig);
        String prop = "property";
        this.makeKey("property", Integer.class);
        this.finishSchema();
        int numV = 100;
        final long[] vids = new long[100];
        for (int i = 0; i < 100; ++i) {
            TitanVertex v = this.graph.addVertex(null);
            v.setProperty("property", (Object)0);
            this.graph.commit();
            vids[i] = v.getLongId();
        }
        this.clopen(newConfig);
        this.resetEdgeCacheCounts();
        final AtomicBoolean[] precommit = new AtomicBoolean[100];
        final AtomicBoolean[] postcommit = new AtomicBoolean[100];
        for (int i = 0; i < 100; ++i) {
            precommit[i] = new AtomicBoolean(false);
            postcommit[i] = new AtomicBoolean(false);
        }
        final AtomicInteger lookups = new AtomicInteger(0);
        final Random random = new Random();
        int updateSleepTime = 40;
        int readSleepTime = 2;
        final int numReads = Math.round(4000.0f);
        Thread reader = new Thread(new Runnable(){

            @Override
            public void run() {
                for (int reads = 0; reads < numReads; ++reads) {
                    int pos = random.nextInt(vids.length);
                    long vid = vids[pos];
                    TitanVertex v = TitanOperationCountingTest.this.graph.getVertex(vid);
                    Assert.assertNotNull((Object)v);
                    boolean postCommit = postcommit[pos].get();
                    Integer value = (Integer)v.getProperty("property");
                    lookups.incrementAndGet();
                    Assert.assertNotNull((String)("On pos [" + pos + "]"), (Object)value);
                    if (!precommit[pos].get()) {
                        Assert.assertEquals((long)0L, (long)value.intValue());
                    } else if (postCommit) {
                        Assert.assertEquals((long)1L, (long)value.intValue());
                    }
                    TitanOperationCountingTest.this.graph.commit();
                    try {
                        Thread.sleep(2L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
            }
        });
        reader.start();
        Thread updater = new Thread(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < 100; ++i) {
                    try {
                        TitanVertex v = TitanOperationCountingTest.this.graph.getVertex(vids[i]);
                        v.setProperty("property", (Object)1);
                        precommit[i].set(true);
                        TitanOperationCountingTest.this.graph.commit();
                        postcommit[i].set(true);
                        Thread.sleep(40L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException("Unexpected interruption", e);
                    }
                }
            }
        });
        updater.start();
        updater.join();
        reader.join();
        System.out.println("Retrievals: " + this.getEdgeCacheRetrievals());
        System.out.println("Hits: " + (this.getEdgeCacheRetrievals() - this.getEdgeCacheMisses()));
        System.out.println("Misses: " + this.getEdgeCacheMisses());
        Assert.assertEquals((long)numReads, (long)lookups.get());
        Assert.assertEquals((long)(2 * numReads + 200 + 2), (long)this.getEdgeCacheRetrievals());
        int minMisses = 402;
        Assert.assertTrue((String)("Min misses [" + minMisses + "] vs actual [" + this.getEdgeCacheMisses() + "]"), ((long)minMisses <= this.getEdgeCacheMisses() && (long)(4 * minMisses) >= this.getEdgeCacheMisses() ? 1 : 0) != 0);
    }

    private long getEdgeCacheRetrievals() {
        return MetricManager.INSTANCE.getCounter(this.metricsPrefix, new String[]{"edgeStore.cache", CacheMetricsAction.RETRIEVAL.getName()}).getCount();
    }

    private long getEdgeCacheMisses() {
        return MetricManager.INSTANCE.getCounter(this.metricsPrefix, new String[]{"edgeStore.cache", CacheMetricsAction.MISS.getName()}).getCount();
    }

    private void resetEdgeCacheCounts() {
        Counter counter = MetricManager.INSTANCE.getCounter(this.metricsPrefix, new String[]{"edgeStore.cache", CacheMetricsAction.RETRIEVAL.getName()});
        counter.dec(counter.getCount());
        counter = MetricManager.INSTANCE.getCounter(this.metricsPrefix, new String[]{"edgeStore.cache", CacheMetricsAction.MISS.getName()});
        counter.dec(counter.getCount());
    }

    private void resetMetrics() {
        MetricManager.INSTANCE.getRegistry().removeMatching(MetricFilter.ALL);
    }

    @Test
    public void testCacheSpeedup() {
        Object[] newConfig = new Object[]{TitanOperationCountingTest.option(GraphDatabaseConfiguration.DB_CACHE, new String[0]), true, TitanOperationCountingTest.option(GraphDatabaseConfiguration.DB_CACHE_TIME, new String[0]), 0};
        this.clopen(newConfig);
        int numV = 1000;
        TitanVertex previous = null;
        for (int i = 0; i < numV; ++i) {
            TitanVertex v = this.graph.addVertex(null);
            v.setProperty("name", (Object)("v" + i));
            if (previous != null) {
                v.addEdge("knows", previous);
            }
            previous = v;
        }
        this.graph.commit();
        long vertexId = previous.getLongId();
        Assert.assertEquals((long)numV, (long)Iterables.size((Iterable)this.graph.getVertices()));
        this.clopen(newConfig);
        double timecoldglobal = 0.0;
        double timewarmglobal = 0.0;
        double timehotglobal = 0.0;
        int outerRepeat = 20;
        int measurements = 10;
        Assert.assertTrue((measurements < outerRepeat ? 1 : 0) != 0);
        int innerRepeat = 2;
        for (int c = 0; c < outerRepeat; ++c) {
            double timecold = this.testAllVertices(vertexId, numV);
            double timewarm = 0.0;
            double timehot = 0.0;
            for (int i = 0; i < innerRepeat; ++i) {
                this.graph.commit();
                timewarm += this.testAllVertices(vertexId, numV);
                for (int j = 0; j < innerRepeat; ++j) {
                    timehot += this.testAllVertices(vertexId, numV);
                }
            }
            timewarm /= (double)innerRepeat;
            timehot /= (double)(innerRepeat * innerRepeat);
            if (c >= outerRepeat - measurements) {
                timecoldglobal += timecold;
                timewarmglobal += timewarm;
                timehotglobal += timehot;
            }
            this.clopen(newConfig);
        }
        System.out.println(TitanOperationCountingTest.round(timecoldglobal /= (double)measurements) + "\t" + TitanOperationCountingTest.round(timewarmglobal /= (double)measurements) + "\t" + TitanOperationCountingTest.round(timehotglobal /= (double)measurements));
        Assert.assertTrue((String)(timecoldglobal + " vs " + timewarmglobal), (timecoldglobal > timewarmglobal * 2.0 ? 1 : 0) != 0);
        Assert.assertTrue((String)(timewarmglobal + " vs " + timehotglobal), (timewarmglobal > timehotglobal * 1.2 ? 1 : 0) != 0);
    }

    private double testAllVertices(long vid, int numV) {
        long start = System.nanoTime();
        TitanVertex v = this.graph.getVertex(vid);
        for (int i = 1; i < numV; ++i) {
            v = (Vertex)Iterables.getOnlyElement((Iterable)v.getVertices(Direction.OUT, new String[]{"knows"}));
        }
        return (double)(System.nanoTime() - start) / 1000000.0;
    }
}

