/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb;

import com.carrotsearch.hppc.LongArrayList;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.thinkaurelius.titan.core.Cardinality;
import com.thinkaurelius.titan.core.EdgeLabel;
import com.thinkaurelius.titan.core.Multiplicity;
import com.thinkaurelius.titan.core.PropertyKey;
import com.thinkaurelius.titan.core.TitanEdge;
import com.thinkaurelius.titan.core.TitanProperty;
import com.thinkaurelius.titan.core.TitanRelation;
import com.thinkaurelius.titan.core.TitanTransaction;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.core.VertexLabel;
import com.thinkaurelius.titan.core.VertexList;
import com.thinkaurelius.titan.core.olap.OLAPJobBuilder;
import com.thinkaurelius.titan.core.olap.OLAPResult;
import com.thinkaurelius.titan.core.schema.VertexLabelMaker;
import com.thinkaurelius.titan.diskstorage.configuration.BasicConfiguration;
import com.thinkaurelius.titan.diskstorage.configuration.ModifiableConfiguration;
import com.thinkaurelius.titan.diskstorage.configuration.WriteConfiguration;
import com.thinkaurelius.titan.graphdb.TitanGraphBaseTest;
import com.thinkaurelius.titan.graphdb.configuration.GraphDatabaseConfiguration;
import com.thinkaurelius.titan.graphdb.database.StandardTitanGraph;
import com.thinkaurelius.titan.graphdb.database.idassigner.placement.SimpleBulkPlacementStrategy;
import com.thinkaurelius.titan.graphdb.fulgora.FulgoraBuilder;
import com.thinkaurelius.titan.graphdb.idmanagement.IDManager;
import com.thinkaurelius.titan.olap.OLAPTest;
import com.thinkaurelius.titan.testcategory.OrderedKeyStoreTests;
import com.thinkaurelius.titan.testcategory.UnorderedKeyStoreTests;
import com.thinkaurelius.titan.util.datastructures.AbstractLongListUtil;
import com.tinkerpop.blueprints.Direction;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TitanPartitionGraphTest
extends TitanGraphBaseTest {
    private static final Logger log = LoggerFactory.getLogger(TitanPartitionGraphTest.class);
    static final Random random = new Random();
    static final int numPartitions = 8;

    public abstract WriteConfiguration getBaseConfiguration();

    protected <S> OLAPJobBuilder<S> getOLAPBuilder(StandardTitanGraph graph, Class<S> clazz) {
        return new FulgoraBuilder(graph);
    }

    @Override
    public WriteConfiguration getConfiguration() {
        WriteConfiguration config = this.getBaseConfiguration();
        ModifiableConfiguration mconf = new ModifiableConfiguration(GraphDatabaseConfiguration.ROOT_NS, config, BasicConfiguration.Restriction.NONE);
        mconf.set(GraphDatabaseConfiguration.CLUSTER_MAX_PARTITIONS, (Object)8, new String[0]);
        mconf.set(SimpleBulkPlacementStrategy.CONCURRENT_PARTITIONS, (Object)16, new String[0]);
        return config;
    }

    @Test
    @Category(value={OrderedKeyStoreTests.class})
    public void testOrderedConfig() {
        Assert.assertTrue((boolean)this.graph.getConfiguration().isClusterPartitioned());
    }

    @Test
    @Category(value={UnorderedKeyStoreTests.class})
    public void testUnorderedConfig() {
        Assert.assertFalse((boolean)this.graph.getConfiguration().isClusterPartitioned());
    }

    @Test
    @Category(value={OrderedKeyStoreTests.class})
    public void testSetup() {
        IDManager idManager = this.graph.getIDManager();
        Assert.assertEquals((long)8L, (long)idManager.getPartitionBound());
        HashSet hashs = Sets.newHashSet();
        for (long i = 1L; i < idManager.getPartitionBound() * 2L; ++i) {
            hashs.add(idManager.getPartitionHashForId(i));
        }
        Assert.assertTrue(((long)hashs.size() > idManager.getPartitionBound() / 2L ? 1 : 0) != 0);
        Assert.assertNotEquals((long)idManager.getPartitionHashForId(101L), (long)idManager.getPartitionHashForId(102L));
    }

    @Test
    @Category(value={OrderedKeyStoreTests.class})
    public void testVertexPartitioning() throws Exception {
        TitanVertex g;
        int i;
        Object[] options = new Object[]{TitanPartitionGraphTest.option(GraphDatabaseConfiguration.IDS_FLUSH, new String[0]), false};
        this.clopen(options);
        PropertyKey gid = this.makeVertexIndexedUniqueKey("gid", Integer.class);
        PropertyKey sig = this.makeKey("sig", Integer.class);
        PropertyKey name = this.mgmt.makePropertyKey("name").cardinality(Cardinality.LIST).dataType(String.class).make();
        EdgeLabel knows = this.makeLabel("knows");
        EdgeLabel base = this.makeLabel("base");
        EdgeLabel one = this.mgmt.makeEdgeLabel("one").multiplicity(Multiplicity.ONE2ONE).make();
        VertexLabel person = this.mgmt.makeVertexLabel("person").make();
        VertexLabel group = this.mgmt.makeVertexLabel("group").partition().make();
        this.finishSchema();
        IDManager idManager = this.graph.getIDManager();
        ImmutableSet names = ImmutableSet.of((Object)"Marko", (Object)"Dan", (Object)"Stephen", (Object)"Daniel", (Object)"Josh", (Object)"Thad", (Object[])new String[]{"Pavel", "Matthias"});
        int numG = 10;
        long[] gids = new long[10];
        for (i = 0; i < 10; ++i) {
            g = this.tx.addVertexWithLabel("group");
            g.setProperty("gid", (Object)i);
            g.setProperty("sig", (Object)0);
            for (String n : names) {
                g.addProperty("name", (Object)n);
            }
            Assert.assertEquals((Object)i, (Object)g.getProperty("gid"));
            Assert.assertEquals((Object)0, (Object)g.getProperty("sig"));
            Assert.assertEquals((Object)"group", (Object)g.getLabel());
            Assert.assertEquals((long)names.size(), (long)Iterables.size((Iterable)g.getProperties("name")));
            Assert.assertTrue((boolean)g.hasId());
            gids[i] = g.getLongId();
            if (i > 0) {
                g.addEdge("base", this.tx.getVertex(gids[0]));
            }
            if (i % 2 != 1) continue;
            g.addEdge("one", this.tx.getVertex(gids[i - 1]));
        }
        for (i = 0; i < 10; ++i) {
            g = this.tx.getVertex(gids[i]);
            Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)g.getEdges(Direction.BOTH, new String[]{"one"})));
            Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)g.getEdges(i % 2 == 0 ? Direction.IN : Direction.OUT, new String[]{"one"})));
            Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)g.getEdges(i % 2 == 1 ? Direction.IN : Direction.OUT, new String[]{"one"})));
            if (i > 0) {
                Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)g.getEdges(Direction.OUT, new String[]{"base"})));
                continue;
            }
            Assert.assertEquals((long)9L, (long)Iterables.size((Iterable)g.getEdges(Direction.IN, new String[]{"base"})));
        }
        this.newTx();
        for (i = 0; i < 10; ++i) {
            long gId = gids[i];
            Assert.assertTrue((boolean)idManager.isPartitionedVertex(gId));
            Assert.assertEquals((long)idManager.getCanonicalVertexId(gId), (long)gId);
            TitanVertex g2 = this.tx.getVertex(gId);
            int canonicalPartition = TitanPartitionGraphTest.getPartitionID(g2, idManager);
            Assert.assertEquals((Object)g2, (Object)Iterables.getOnlyElement((Iterable)this.tx.query().has("gid", (Object)i).vertices()));
            Assert.assertEquals((Object)i, (Object)g2.getProperty("gid"));
            Assert.assertEquals((long)names.size(), (long)Iterables.size((Iterable)g2.getProperties("name")));
            TitanProperty p = (TitanProperty)Iterables.getOnlyElement((Iterable)g2.getProperties("gid"));
            Assert.assertEquals((long)canonicalPartition, (long)TitanPartitionGraphTest.getPartitionID((TitanRelation)p, idManager));
            HashSet propPartitions = Sets.newHashSet();
            for (TitanProperty n : g2.getProperties("name")) {
                propPartitions.add(TitanPartitionGraphTest.getPartitionID(n.getVertex(), idManager));
            }
            Assert.assertTrue((propPartitions.size() >= 3 ? 1 : 0) != 0);
            Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)g2.getEdges(Direction.BOTH, new String[]{"one"})));
            Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)g2.getEdges(i % 2 == 0 ? Direction.IN : Direction.OUT, new String[]{"one"})));
            Assert.assertEquals((long)0L, (long)Iterables.size((Iterable)g2.getEdges(i % 2 == 1 ? Direction.IN : Direction.OUT, new String[]{"one"})));
            if (i > 0) {
                Assert.assertEquals((long)1L, (long)Iterables.size((Iterable)g2.getEdges(Direction.OUT, new String[]{"base"})));
                continue;
            }
            Assert.assertEquals((long)9L, (long)Iterables.size((Iterable)g2.getEdges(Direction.IN, new String[]{"base"})));
        }
        this.clopen(options);
        int numTx = 100;
        int vPerTx = 10;
        HashMultiset partitions = HashMultiset.create();
        for (int t = 1; t <= 100; ++t) {
            TitanVertex g1 = this.tx.getVertex(gids[0]);
            TitanVertex g2 = this.tx.getVertex(gids[1]);
            Assert.assertNotNull((Object)g1);
            TitanVertex[] vs = new TitanVertex[10];
            for (int vi = 0; vi < 10; ++vi) {
                vs[vi] = this.tx.addVertexWithLabel("person");
                vs[vi].setProperty("sig", (Object)t);
                TitanEdge e = vs[vi].addEdge("knows", g1);
                e.setProperty("sig", (Object)t);
                e = g1.addEdge("knows", vs[vi]);
                e.setProperty("sig", (Object)t);
                if (vi % 2 != 0) continue;
                e = vs[vi].addEdge("knows", g2);
                e.setProperty("sig", (Object)t);
            }
            this.newTx();
            TitanTransaction txx = this.graph.buildTransaction().readOnly().start();
            g1 = this.tx.getVertex(gids[0]);
            g2 = this.tx.getVertex(gids[1]);
            int partition = -1;
            for (int vi = 0; vi < 10; ++vi) {
                Assert.assertTrue((boolean)vs[vi].hasId());
                int pid = TitanPartitionGraphTest.getPartitionID(vs[vi], idManager);
                if (partition < 0) {
                    partition = pid;
                } else {
                    Assert.assertEquals((long)partition, (long)pid);
                }
                int numRels = 0;
                TitanVertex v = txx.getVertex(vs[vi].getLongId());
                for (TitanRelation r : v.query().relations()) {
                    ++numRels;
                    Assert.assertEquals((long)partition, (long)TitanPartitionGraphTest.getPartitionID(r, idManager));
                    if (!(r instanceof TitanEdge)) continue;
                    TitanVertex o = ((TitanEdge)r).getOtherVertex(v);
                    Assert.assertTrue((o.equals(g1) || o.equals(g2) ? 1 : 0) != 0);
                }
                Assert.assertEquals((long)(3 + (vi % 2 == 0 ? 1 : 0)), (long)numRels);
            }
            partitions.add((Object)partition);
            txx.commit();
        }
        Assert.assertTrue((partitions.elementSet().size() >= 3 ? 1 : 0) != 0);
        this.newTx();
        TitanVertex g1 = this.tx.getVertex(gids[0]);
        Assert.assertEquals((Object)0, (Object)g1.getProperty("gid"));
        Assert.assertEquals((Object)"group", (Object)g1.getLabel());
        Assert.assertEquals((long)names.size(), (long)Iterables.size((Iterable)g1.getProperties("name")));
        Assert.assertEquals((long)1000L, (long)Iterables.size((Iterable)g1.getEdges(Direction.OUT, new String[]{"knows"})));
        Assert.assertEquals((long)1000L, (long)Iterables.size((Iterable)g1.getEdges(Direction.IN, new String[]{"knows"})));
        Assert.assertEquals((long)2000L, (long)Iterables.size((Iterable)g1.getEdges(Direction.BOTH, new String[]{"knows"})));
        Assert.assertEquals((long)1010L, (long)Iterables.size((Iterable)this.tx.getVertices()));
        this.newTx();
        for (int t = 0; t < 10; ++t) {
            int numP = random.nextInt(3) + 1;
            HashSet parts = Sets.newHashSet();
            int numV = 0;
            while (parts.size() < numP) {
                int part = (Integer)Iterables.get((Iterable)partitions.elementSet(), (int)random.nextInt(partitions.elementSet().size()));
                if (!parts.add(part)) continue;
                numV += partitions.count((Object)part);
            }
            numV *= 10;
            int[] partarr = new int[numP];
            int i2 = 0;
            for (Integer part : parts) {
                partarr[i2++] = part;
            }
            TitanTransaction tx2 = this.graph.buildTransaction().setRestrictedPartitions(partarr).readOnly().start();
            g1 = tx2.getVertex(gids[0]);
            Assert.assertEquals((Object)0, (Object)g1.getProperty("gid"));
            Assert.assertEquals((Object)"group", (Object)g1.getLabel());
            Assert.assertTrue((names.size() >= Iterables.size((Iterable)g1.getProperties("name")) ? 1 : 0) != 0);
            Assert.assertEquals((long)numV, (long)Iterables.size((Iterable)g1.getEdges(Direction.OUT, new String[]{"knows"})));
            Assert.assertEquals((long)numV, (long)Iterables.size((Iterable)g1.getEdges(Direction.IN, new String[]{"knows"})));
            Assert.assertEquals((long)(numV * 2), (long)Iterables.size((Iterable)g1.getEdges(Direction.BOTH, new String[]{"knows"})));
            TitanVertex g2 = tx2.getVertex(gids[1]);
            VertexList v1 = g1.query().direction(Direction.IN).labels(new String[]{"knows"}).vertexIds();
            VertexList v2 = g2.query().direction(Direction.IN).labels(new String[]{"knows"}).vertexIds();
            Assert.assertEquals((long)numV, (long)v1.size());
            Assert.assertEquals((long)(numV / 2), (long)v2.size());
            v1.sort();
            v2.sort();
            LongArrayList al1 = v1.getIDs();
            LongArrayList al2 = v2.getIDs();
            Assert.assertTrue((boolean)AbstractLongListUtil.isSorted((LongArrayList)al1));
            Assert.assertTrue((boolean)AbstractLongListUtil.isSorted((LongArrayList)al2));
            LongArrayList alr = AbstractLongListUtil.mergeJoin((LongArrayList)al1, (LongArrayList)al2, (boolean)false);
            Assert.assertEquals((long)(numV / 2), (long)alr.size());
            tx2.commit();
        }
        this.clopen(options);
        OLAPJobBuilder<OLAPTest.Degree> builder = this.getOLAPBuilder(this.graph, OLAPTest.Degree.class);
        OLAPResult<OLAPTest.Degree> degrees = OLAPTest.computeDegree(builder, "name", "sig");
        Assert.assertNotNull(degrees);
        Assert.assertEquals((long)1010L, (long)degrees.size());
        for (Map.Entry entry : degrees.entries()) {
            long vid = (Long)entry.getKey();
            OLAPTest.Degree degree = (OLAPTest.Degree)entry.getValue();
            Assert.assertEquals((long)(degree.in + degree.out), (long)degree.both);
            if (idManager.isPartitionedVertex(vid)) {
                if (vid == gids[0]) {
                    Assert.assertEquals((long)1010L, (long)degree.in);
                    Assert.assertEquals((long)1000L, (long)degree.out);
                } else if (vid == gids[1]) {
                    Assert.assertEquals((long)500L, (long)degree.in);
                    Assert.assertEquals((long)2L, (long)degree.out);
                } else {
                    Assert.assertEquals((long)2L, (long)(degree.in + degree.out));
                }
                Assert.assertEquals((long)names.size(), (long)degree.prop);
                continue;
            }
            Assert.assertEquals((long)1L, (long)degree.in);
            Assert.assertTrue((1 <= degree.out && degree.out <= 2 ? 1 : 0) != 0);
            Assert.assertEquals((long)0L, (long)degree.prop);
        }
    }

    @Test
    @Category(value={UnorderedKeyStoreTests.class})
    public void testVLabelOnUnorderedStorage() {
        String label = "pl";
        VertexLabelMaker maker = this.mgmt.makeVertexLabel("pl");
        try {
            maker.partition().make();
            Assert.fail((String)"Partitioned label must be rejected on unordered key stores");
        }
        catch (IllegalArgumentException e) {
            log.debug("Caught expected exception", (Throwable)e);
        }
    }

    @Test
    @Category(value={OrderedKeyStoreTests.class})
    public void testVLabelOnOrderedStorage() {
        String label = "pl";
        this.mgmt.makeVertexLabel("pl").partition().make();
        this.mgmt.commit();
        this.graph.rollback();
        this.graph.addVertexWithLabel("pl");
        this.graph.commit();
        this.mgmt = this.graph.getManagementSystem();
        VertexLabel vl = this.mgmt.getVertexLabel("pl");
        Assert.assertTrue((boolean)vl.isPartitioned());
        this.mgmt.rollback();
    }

    public static int getPartitionID(TitanVertex vertex, IDManager idManager) {
        long p = idManager.getPartitionId(vertex.getLongId());
        Assert.assertTrue((p >= 0L && p < idManager.getPartitionBound() && p < Integer.MAX_VALUE ? 1 : 0) != 0);
        return (int)p;
    }

    public static int getPartitionID(TitanRelation relation, IDManager idManager) {
        long p = relation.getLongId() & idManager.getPartitionBound() - 1L;
        Assert.assertTrue((p >= 0L && p < idManager.getPartitionBound() && p < Integer.MAX_VALUE ? 1 : 0) != 0);
        return (int)p;
    }
}

