/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.graphdb;

import com.thinkaurelius.titan.core.EdgeLabel;
import com.thinkaurelius.titan.core.PropertyKey;
import com.thinkaurelius.titan.diskstorage.configuration.WriteConfiguration;
import com.thinkaurelius.titan.graphdb.TitanGraphBaseTest;
import com.thinkaurelius.titan.graphdb.configuration.GraphDatabaseConfiguration;
import com.thinkaurelius.titan.graphdb.database.StandardTitanGraph;
import com.thinkaurelius.titan.testcategory.PerformanceTests;
import com.thinkaurelius.titan.testutil.JUnitBenchmarkProvider;
import com.thinkaurelius.titan.testutil.RandomGenerator;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.TransactionalGraph;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.util.wrappers.batch.BatchGraph;
import com.tinkerpop.blueprints.util.wrappers.batch.VertexIDType;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestRule;

@Category(value={PerformanceTests.class})
public abstract class TitanWritePerformanceTest
extends TitanGraphBaseTest {
    private BatchGraph<StandardTitanGraph> bgraph;
    private static final int BUFFER_SIZE = 1024;
    @Rule
    public TestRule benchmark = JUnitBenchmarkProvider.get();

    @Test
    public void testSimpleWriteWithoutBatch() {
        this.createSchema();
        new SimpleBGWrite().run();
    }

    @Test
    public void testSimpleWriteWithBatch() {
        this.createSchema();
        this.clopen(new TitanGraphBaseTest.TestConfigOption(GraphDatabaseConfiguration.STORAGE_BATCH, new String[0]), true);
        new SimpleBGWrite().run();
    }

    @Override
    public void open(WriteConfiguration config) {
        super.open(config);
        this.bgraph = new BatchGraph((TransactionalGraph)this.graph, VertexIDType.NUMBER, 1024L);
        this.bgraph.setVertexIdKey("uid");
    }

    @Override
    public void close() {
        if (this.mgmt != null && this.mgmt.isOpen()) {
            this.mgmt.rollback();
        }
        if (null != this.bgraph) {
            this.bgraph.commit();
        }
        super.close();
    }

    private void createSchema() {
        PropertyKey weight = this.makeKey("weight", Double.class);
        PropertyKey uid = this.makeVertexIndexedUniqueKey("uid", Integer.class);
        PropertyKey name = this.makeVertexIndexedKey("name", String.class);
        EdgeLabel knows = this.makeKeyedEdgeLabel("knows", uid, weight);
        this.finishSchema();
    }

    private class SimpleBGWrite
    implements Runnable {
        private final int noNodes;
        private final int noEdgesPerNode;
        private final String uidPrefix = "u";
        private final int uidLength = "u".length();
        private final StringBuilder sb = new StringBuilder(8);

        private SimpleBGWrite() {
            this(20000, 10);
        }

        private SimpleBGWrite(int noNodes, int noEdgesPerNode) {
            this.noNodes = noNodes;
            this.noEdgesPerNode = noEdgesPerNode;
            this.sb.append("u");
        }

        @Override
        public void run() {
            int i;
            for (i = 0; i < this.noNodes; ++i) {
                Vertex v = TitanWritePerformanceTest.this.bgraph.addVertex((Object)i);
                v.setProperty("name", (Object)this.getName(i));
                v.setProperty("uid", (Object)i);
            }
            for (i = 0; i < this.noNodes; ++i) {
                Vertex n = TitanWritePerformanceTest.this.bgraph.getVertex((Object)i);
                for (int e = 0; e < this.noEdgesPerNode; ++e) {
                    Vertex n2 = TitanWritePerformanceTest.this.bgraph.getVertex((Object)TitanGraphBaseTest.wrapAround(i + e, this.noNodes));
                    Edge edge = n.addEdge("knows", n2);
                    edge.setProperty("uid", (Object)RandomGenerator.randomInt(0, Integer.MAX_VALUE));
                    edge.setProperty("weight", (Object)Math.random());
                }
            }
            TitanWritePerformanceTest.this.bgraph.commit();
        }

        private String getName(int index) {
            this.sb.setLength(this.uidLength);
            this.sb.append(index);
            return this.sb.toString();
        }
    }
}

