/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.olap;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.thinkaurelius.titan.core.Cardinality;
import com.thinkaurelius.titan.core.Multiplicity;
import com.thinkaurelius.titan.core.PropertyKey;
import com.thinkaurelius.titan.core.RelationType;
import com.thinkaurelius.titan.core.TitanEdge;
import com.thinkaurelius.titan.core.TitanProperty;
import com.thinkaurelius.titan.core.TitanVertex;
import com.thinkaurelius.titan.core.olap.Combiner;
import com.thinkaurelius.titan.core.olap.Gather;
import com.thinkaurelius.titan.core.olap.OLAPJob;
import com.thinkaurelius.titan.core.olap.OLAPJobBuilder;
import com.thinkaurelius.titan.core.olap.OLAPQueryBuilder;
import com.thinkaurelius.titan.core.olap.OLAPResult;
import com.thinkaurelius.titan.core.olap.StateInitializer;
import com.thinkaurelius.titan.graphdb.TitanGraphBaseTest;
import com.thinkaurelius.titan.graphdb.database.StandardTitanGraph;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Vertex;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.junit.Assert;
import org.junit.Test;

public abstract class OLAPTest
extends TitanGraphBaseTest {
    private static final double EPSILON = 1.0E-5;
    private static final Random random = new Random();
    private static final double PR_TERMINATION_THRESHOLD = 0.01;

    protected abstract <S> OLAPJobBuilder<S> getOLAPBuilder(StandardTitanGraph var1, Class<S> var2);

    @Test
    public void degreeCount() throws Exception {
        int i;
        this.mgmt.makePropertyKey("uid").dataType(Integer.class).cardinality(Cardinality.SINGLE).make();
        this.mgmt.makeEdgeLabel("knows").multiplicity(Multiplicity.MULTI).make();
        this.mgmt.makePropertyKey("values").cardinality(Cardinality.LIST).dataType(Integer.class).make();
        this.mgmt.makePropertyKey("numvals").dataType(Integer.class).make();
        this.finishSchema();
        int numV = 300;
        int numE = 0;
        TitanVertex[] vs = new TitanVertex[numV];
        for (i = 0; i < numV; ++i) {
            vs[i] = this.tx.addVertex();
            vs[i].setProperty("uid", (Object)(i + 1));
            int numVals = random.nextInt(5) + 1;
            vs[i].setProperty("numvals", (Object)numVals);
            for (int j = 0; j < numVals; ++j) {
                vs[i].addProperty("values", (Object)random.nextInt(100));
            }
        }
        for (i = 0; i < numV; ++i) {
            int edges = i + 1;
            TitanVertex v = vs[i];
            for (int j = 0; j < edges; ++j) {
                TitanVertex u = vs[random.nextInt(numV)];
                v.addEdge("knows", u);
                ++numE;
            }
        }
        Assert.assertEquals((long)(numV * (numV + 1)), (long)(numE * 2));
        this.clopen(new Object[0]);
        Stopwatch w = Stopwatch.createStarted();
        OLAPJobBuilder<Degree> builder = this.getOLAPBuilder(this.graph, Degree.class);
        OLAPResult<Degree> degrees = OLAPTest.computeDegree(builder, "values", "numvals");
        System.out.println("Execution time (ms) [" + numV + "|" + numE + "]: " + w.elapsed(TimeUnit.MILLISECONDS));
        Assert.assertNotNull(degrees);
        Assert.assertEquals((long)numV, (long)degrees.size());
        int totalCount = 0;
        for (Map.Entry entry : degrees.entries()) {
            Degree degree = (Degree)entry.getValue();
            Assert.assertEquals((long)(degree.in + degree.out), (long)degree.both);
            TitanVertex v = this.tx.getVertex(((Long)entry.getKey()).longValue());
            int count = (Integer)v.getProperty("uid");
            Assert.assertEquals((long)count, (long)degree.out);
            int numvals = (Integer)v.getProperty("numvals");
            Assert.assertEquals((long)numvals, (long)degree.prop);
            totalCount += degree.both;
        }
        Assert.assertEquals((long)(numV * (numV + 1)), (long)totalCount);
    }

    public static OLAPResult<Degree> computeDegree(OLAPJobBuilder<Degree> builder, final String aggregatePropKey, final String checkPropKey) throws Exception {
        builder.setInitializer((StateInitializer)new StateInitializer<Degree>(){

            public Degree initialState() {
                return new Degree();
            }
        });
        builder.setNumProcessingThreads(2);
        builder.setStateKey("degree");
        builder.setJob(new OLAPJob(){

            public Degree process(TitanVertex vertex) {
                Degree d = (Degree)vertex.getProperty("all");
                if (d == null) {
                    d = new Degree();
                }
                Degree p = (Degree)vertex.getProperty(aggregatePropKey);
                if (checkPropKey != null) {
                    Assert.assertNotNull((Object)vertex.getProperty(checkPropKey));
                }
                if (p != null) {
                    d.add(p);
                }
                return d;
            }
        });
        builder.addQuery().setName("all").edges((Gather)new Gather<Degree, Degree>(){

            public Degree apply(Degree state, TitanEdge edge, Direction dir) {
                return new Degree(dir == Direction.IN ? 1 : 0, dir == Direction.OUT ? 1 : 0, 0);
            }
        }, (Combiner)new Combiner<Degree>(){

            public Degree combine(Degree m1, Degree m2) {
                m1.add(m2);
                return m1;
            }
        });
        builder.addQuery().keys(new String[]{aggregatePropKey}).properties((Function)new Function<TitanProperty, Degree>(){

            @Nullable
            public Degree apply(@Nullable TitanProperty titanProperty) {
                return new Degree(0, 0, 1);
            }
        }, (Combiner)new Combiner<Degree>(){

            public Degree combine(Degree m1, Degree m2) {
                m1.add(m2);
                return m1;
            }
        });
        if (checkPropKey != null) {
            builder.addQuery().keys(new String[]{checkPropKey}).properties();
        }
        return (OLAPResult)builder.execute().get(200L, TimeUnit.SECONDS);
    }

    private void expand(TitanVertex v, int distance, int diameter, int branch) {
        v.setProperty("distance", (Object)distance);
        if (distance < diameter) {
            TitanVertex previous = null;
            for (int i = 0; i < branch; ++i) {
                TitanVertex u = this.tx.addVertex();
                u.addEdge("likes", v);
                if (previous != null) {
                    u.addEdge("knows", previous);
                }
                previous = u;
                this.expand(u, distance + 1, diameter, branch);
            }
        }
    }

    @Test
    public void pageRank() {
        this.mgmt.makePropertyKey("distance").dataType(Integer.class).cardinality(Cardinality.SINGLE).make();
        this.mgmt.makeEdgeLabel("knows").multiplicity(Multiplicity.MULTI).make();
        this.mgmt.makeEdgeLabel("likes").multiplicity(Multiplicity.MULTI).make();
        this.finishSchema();
        int branch = 5;
        int diameter = 5;
        double alpha = 0.85;
        int numV = (int)((Math.pow(5.0, 6.0) - 1.0) / 4.0);
        TitanVertex v = this.tx.addVertex();
        this.expand(v, 0, 5, 5);
        this.clopen(new Object[0]);
        Assert.assertEquals((long)numV, (long)Iterables.size((Iterable)this.tx.getVertices()));
        this.newTx();
        double[] correctPR = new double[6];
        for (int i = 5; i >= 0; --i) {
            double pr = 1.0 / (double)numV * 0.15000000000000002;
            if (i < 5) {
                pr += 4.25 * correctPR[i + 1];
            }
            correctPR[i] = pr;
        }
        Stopwatch w = Stopwatch.createStarted();
        OLAPResult<PageRank> ranks = this.computePageRank(this.graph, 0.85, 1, numV, "likes");
        System.out.println(String.format("Computing PR on graph with %s vertices took: %s ms", numV, w.elapsed(TimeUnit.MILLISECONDS)));
        double totalPr = 0.0;
        for (Map.Entry entry : ranks.entries()) {
            Vertex u = this.tx.getVertex(entry.getKey());
            int distance = (Integer)u.getProperty("distance");
            double pr = ((PageRank)entry.getValue()).getPr();
            Assert.assertEquals((double)correctPR[distance], (double)pr, (double)1.0E-5);
            totalPr += pr;
        }
    }

    private OLAPResult<PageRank> computePageRank(StandardTitanGraph g, final double alpha, int numThreads, final int numVertices, String ... labels) {
        double totalDelta;
        OLAPResult ranks;
        OLAPJobBuilder<PageRank> builder = this.getOLAPBuilder(this.graph, PageRank.class);
        builder.setNumProcessingThreads(numThreads);
        builder.setStateKey("pageRank");
        builder.setNumVertices((long)numVertices);
        OLAPQueryBuilder query = builder.addQuery().setName("degree").direction(Direction.OUT);
        if (labels != null && labels.length > 0) {
            query.labels(labels);
        }
        query.edges((Gather)new Gather<PageRank, Long>(){

            public Long apply(PageRank state, TitanEdge edge, Direction dir) {
                return 1L;
            }
        }, (Combiner)new Combiner<Long>(){

            public Long combine(Long m1, Long m2) {
                return m1 + m2;
            }
        });
        builder.setJob(new OLAPJob(){

            public PageRank process(TitanVertex vertex) {
                Long degree = (Long)vertex.getProperty("degree");
                return new PageRank(degree == null ? 0L : degree, 1.0 / (double)numVertices);
            }
        });
        try {
            ranks = (OLAPResult)builder.execute().get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Assert.assertEquals((long)numVertices, (long)ranks.size());
        int iteration = 0;
        do {
            builder = this.getOLAPBuilder(this.graph, PageRank.class);
            builder.setNumProcessingThreads(numThreads);
            builder.setStateKey("pageRank");
            builder.setInitialState(ranks);
            query = builder.addQuery().setName("energy").direction(Direction.IN);
            if (labels != null && labels.length > 0) {
                query.labels(labels);
            }
            query.edges((Gather)new Gather<PageRank, Double>(){

                public Double apply(PageRank state, TitanEdge edge, Direction dir) {
                    return state.getPrFlow();
                }
            }, (Combiner)new Combiner<Double>(){

                public Double combine(Double m1, Double m2) {
                    return m1 + m2;
                }
            });
            builder.setJob(new OLAPJob(){

                public PageRank process(TitanVertex vertex) {
                    PageRank pr = (PageRank)vertex.getProperty("pageRank");
                    Double energy = (Double)vertex.getProperty("energy");
                    if (energy == null) {
                        energy = 0.0;
                    }
                    pr.setPr(energy, alpha, numVertices);
                    return pr;
                }
            });
            Stopwatch w = Stopwatch.createStarted();
            try {
                ranks = (OLAPResult)builder.execute().get();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            ++iteration;
            Assert.assertEquals((long)numVertices, (long)ranks.size());
            totalDelta = 0.0;
            for (PageRank pr : ranks.values()) {
                totalDelta += pr.completeIteration();
            }
            System.out.println(String.format("Completed iteration [%s] in time %s ms with delta PR=%s", iteration, w.elapsed(TimeUnit.MILLISECONDS), totalDelta));
        } while (totalDelta > 0.01);
        return ranks;
    }

    @Test
    public void singleSourceShortestPaths() throws Exception {
        PropertyKey distance = this.mgmt.makePropertyKey("distance").dataType(Integer.class).cardinality(Cardinality.SINGLE).make();
        this.mgmt.makeEdgeLabel("connect").signature(new RelationType[]{distance}).multiplicity(Multiplicity.MULTI).make();
        this.finishSchema();
        int maxDepth = 16;
        int maxBranch = 5;
        TitanVertex vertex = this.tx.addVertex();
        int numV = this.growVertex(vertex, 0, maxDepth, maxBranch);
        int numE = numV - 1;
        Assert.assertEquals((long)numV, (long)Iterables.size((Iterable)this.tx.getVertices()));
        Assert.assertEquals((long)numE, (long)Iterables.size((Iterable)this.tx.getEdges()));
        this.clopen(new Object[0]);
        OLAPResult distances = null;
        final AtomicBoolean done = new AtomicBoolean(false);
        while (!done.get()) {
            done.set(true);
            OLAPJobBuilder<Integer> builder = this.getOLAPBuilder(this.graph, Integer.class);
            if (distances == null) {
                builder.setInitializer((StateInitializer)new StateInitializer<Integer>(){

                    public Integer initialState() {
                        return Integer.MAX_VALUE;
                    }
                });
                builder.setInitialState((Map)ImmutableMap.of((Object)vertex.getLongId(), (Object)0));
            } else {
                builder.setInitialState(distances);
            }
            builder.setNumProcessingThreads(2);
            builder.setStateKey("dist");
            builder.setJob((OLAPJob)new OLAPJob<Integer>(){

                public Integer process(TitanVertex vertex) {
                    int result;
                    Integer d = (Integer)vertex.getProperty("dist");
                    Assert.assertNotNull((Object)d);
                    Integer c = (Integer)vertex.getProperty("connect");
                    int n = result = c == null ? d : Math.min(c, d);
                    if (result < d) {
                        done.set(false);
                    }
                    return result;
                }
            });
            builder.addQuery().labels(new String[]{"connect"}).direction(Direction.BOTH).edges((Gather)new Gather<Integer, Integer>(){

                public Integer apply(Integer state, TitanEdge edge, Direction dir) {
                    Assert.assertNotNull((Object)state);
                    if (state == Integer.MAX_VALUE) {
                        return state;
                    }
                    return state + (Integer)edge.getProperty("distance");
                }
            }, (Combiner)new Combiner<Integer>(){

                public Integer combine(Integer m1, Integer m2) {
                    return Math.min(m1, m2);
                }
            });
            Stopwatch w = Stopwatch.createStarted();
            distances = (OLAPResult)builder.execute().get(200L, TimeUnit.SECONDS);
            System.out.println("Execution time (ms) [" + numV + "|" + numE + "]: " + w.elapsed(TimeUnit.MILLISECONDS));
            Assert.assertEquals((long)numV, (long)distances.size());
        }
        for (Map.Entry entry : distances.entries()) {
            int dist = (Integer)entry.getValue();
            Assert.assertTrue((String)("Invalid distance: " + dist), (dist >= 0 && dist < Integer.MAX_VALUE ? 1 : 0) != 0);
            TitanVertex v = this.tx.getVertex(((Long)entry.getKey()).longValue());
            Assert.assertEquals((long)((Integer)v.getProperty("distance")).intValue(), (long)dist);
        }
    }

    private int growVertex(TitanVertex vertex, int depth, int maxDepth, int maxBranch) {
        vertex.setProperty("distance", (Object)depth);
        int total = 1;
        if (depth >= maxDepth) {
            return total;
        }
        for (int i = 0; i < random.nextInt(maxBranch) + 1; ++i) {
            int dist = random.nextInt(3) + 1;
            TitanVertex n = this.tx.addVertex();
            n.addEdge("connect", vertex).setProperty("distance", (Object)dist);
            total += this.growVertex(n, depth + dist, maxDepth, maxBranch);
        }
        return total;
    }

    public static class PageRank {
        private double edgeCount;
        private double oldPR;
        private double newPR;

        public PageRank(long edgeCount, double initialPR) {
            Preconditions.checkArgument((edgeCount >= 0L && initialPR >= 0.0 ? 1 : 0) != 0);
            this.edgeCount = edgeCount;
            this.oldPR = initialPR;
            this.newPR = -1.0;
        }

        public void setPr(double energy, double alpha, long numVertices) {
            this.newPR = alpha * energy + (1.0 - alpha) / (double)numVertices;
        }

        public double getPrFlow() {
            Preconditions.checkArgument((this.oldPR >= 0.0 && this.edgeCount > 0.0 ? 1 : 0) != 0);
            return this.oldPR / this.edgeCount;
        }

        public double getPr() {
            return this.oldPR;
        }

        public double completeIteration() {
            double delta = Math.abs(this.oldPR - this.newPR);
            this.oldPR = this.newPR;
            this.newPR = 0.0;
            return delta;
        }
    }

    public static class Degree {
        public int in;
        public int out;
        public int both;
        public int prop;

        public Degree(int in, int out, int prop) {
            this.in = in;
            this.out = out;
            this.both = in + out;
            this.prop = prop;
        }

        public Degree() {
            this(0, 0, 0);
        }

        public void add(Degree d) {
            this.in += d.in;
            this.out += d.out;
            this.both += d.both;
            this.prop += d.prop;
        }
    }
}

