/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.testutil;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.diskstorage.configuration.WriteConfiguration;
import com.thinkaurelius.titan.diskstorage.configuration.backend.CommonsConfiguration;
import java.io.File;
import java.util.concurrent.TimeUnit;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestGraphConfigs {
    public static String ENV_OVERRIDE_FILE = "TITAN_CONFIG";
    private static final CommonsConfiguration overrides;
    private static final Logger log;

    public static void applyOverrides(WriteConfiguration base) {
        if (null == overrides) {
            return;
        }
        for (String k : overrides.getKeys(null)) {
            base.set(k, overrides.get(k, Object.class));
        }
    }

    public static long getTTL(TimeUnit u) {
        long sec = 10L;
        long l = u.convert(10L, TimeUnit.SECONDS);
        Preconditions.checkState((Integer.MIN_VALUE <= l && Integer.MAX_VALUE >= l ? 1 : 0) != 0, (String)"Test TTL %d is too large to express as an integer in %s", (Object[])new Object[]{10L, u});
        return l;
    }

    public static long getSchemaConvergenceTime(TimeUnit u) {
        long sec = 60L;
        long l = u.convert(60L, TimeUnit.SECONDS);
        Preconditions.checkState((Integer.MIN_VALUE <= l && Integer.MAX_VALUE >= l ? 1 : 0) != 0, (String)"Schema convergence time %d is too large to express as an integer in %s", (Object[])new Object[]{60L, u});
        return l;
    }

    static {
        log = LoggerFactory.getLogger(TestGraphConfigs.class);
        String overridesFile = System.getenv(ENV_OVERRIDE_FILE);
        CommonsConfiguration o = null;
        if (null != overridesFile) {
            if (!new File(overridesFile).isFile()) {
                log.warn("Graph configuration overrides file {} does not exist or is not an ordinary file", (Object)overridesFile);
            } else {
                try {
                    PropertiesConfiguration cc = new PropertiesConfiguration(overridesFile);
                    o = new CommonsConfiguration((Configuration)cc);
                    log.info("Loaded configuration from file {}", (Object)overridesFile);
                }
                catch (ConfigurationException e) {
                    log.error("Unable to load graph configuration from file {}", (Object)overridesFile, (Object)e);
                }
            }
        }
        overrides = o;
    }
}

