/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.testutil;

import com.thinkaurelius.titan.core.Order;
import com.tinkerpop.blueprints.Element;
import java.util.Iterator;
import org.junit.Assert;

public class TestUtil {
    public static void verifyElementOrder(Iterable<? extends Element> elements, String key, Order order, int expectedCount) {
        TestUtil.verifyElementOrder(elements.iterator(), key, order, expectedCount);
    }

    public static void verifyElementOrder(Iterator<? extends Element> elements, String key, Order order, int expectedCount) {
        Comparable previous = null;
        int count = 0;
        while (elements.hasNext()) {
            Element element = elements.next();
            Comparable current = (Comparable)element.getProperty(key);
            if (previous != null) {
                int cmp = previous.compareTo(current);
                Assert.assertTrue((String)(previous + " <> " + current + " @ " + count), (boolean)(order == Order.ASC ? cmp <= 0 : cmp >= 0));
            }
            previous = current;
            ++count;
        }
        Assert.assertEquals((long)expectedCount, (long)count);
    }
}

