/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.testutil.gen;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.thinkaurelius.titan.core.PropertyKey;
import com.thinkaurelius.titan.core.TitanFactory;
import com.thinkaurelius.titan.core.TitanGraph;
import com.thinkaurelius.titan.core.TitanTransaction;
import com.thinkaurelius.titan.testutil.gen.Schema;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.util.io.graphml.GraphMLReader;
import com.tinkerpop.blueprints.util.io.graphml.GraphMLWriter;
import com.tinkerpop.furnace.alpha.generators.DistributionGenerator;
import com.tinkerpop.furnace.alpha.generators.EdgeAnnotator;
import com.tinkerpop.furnace.alpha.generators.PowerLawDistribution;
import com.tinkerpop.furnace.alpha.generators.VertexAnnotator;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Random;
import java.util.zip.GZIPOutputStream;

public class GraphGenerator {
    public static final long INITIAL_VERTEX_UID = 1L;
    public static final double GAMMA = 2.5;
    private final Schema schema;
    private final Random random = new Random(64L);
    private long uidCounter = 1L;
    private final VertexAnnotator vertexAnnotator = new VertexAnnotator(){

        @Override
        public void annotate(Vertex vertex, Map<String, Object> context) {
            vertex.setProperty("uid", (Object)GraphGenerator.this.uidCounter++);
            int length = GraphGenerator.this.schema.getVertexPropKeys();
            int count = GraphGenerator.this.random.nextInt(length);
            int offset = GraphGenerator.this.random.nextInt(length);
            for (int i = 0; i < count; ++i) {
                String key = GraphGenerator.this.schema.getVertexPropertyName((i + offset) % length);
                int value = GraphGenerator.this.random.nextInt(GraphGenerator.this.schema.getMaxVertexPropVal());
                vertex.setProperty(key, (Object)value);
            }
        }
    };
    private final EdgeAnnotator edgeAnnotator = new EdgeAnnotator(){

        @Override
        public void annotate(Edge edge) {
            edge.setProperty(GraphGenerator.this.schema.getSortKeyForLabel(edge.getLabel()), (Object)GraphGenerator.this.random.nextInt(GraphGenerator.this.schema.getMaxEdgePropVal()));
            if (0 >= GraphGenerator.this.schema.getEdgePropKeys() - GraphGenerator.this.schema.getEdgeLabels()) {
                return;
            }
            int eligible = GraphGenerator.this.schema.getEdgePropKeys() - GraphGenerator.this.schema.getEdgeLabels();
            Preconditions.checkArgument((0 < eligible ? 1 : 0) != 0);
            int count = GraphGenerator.this.random.nextInt(eligible);
            int offset = GraphGenerator.this.random.nextInt(eligible);
            int length = GraphGenerator.this.schema.getEdgePropKeys();
            Preconditions.checkArgument((length == eligible + GraphGenerator.this.schema.getEdgeLabels() ? 1 : 0) != 0);
            Preconditions.checkArgument((length >= count + GraphGenerator.this.schema.getEdgeLabels() ? 1 : 0) != 0);
            for (int i = 0; i < count; ++i) {
                String key = GraphGenerator.this.schema.getEdgePropertyName(GraphGenerator.this.schema.getEdgeLabels() + (offset + i) % eligible);
                edge.setProperty(key, (Object)GraphGenerator.this.random.nextInt(GraphGenerator.this.schema.getMaxEdgePropVal()));
            }
        }
    };

    public GraphGenerator(Schema schema) {
        this.schema = schema;
    }

    public void generateTypesAndData(TitanGraph g) {
        this.schema.makeTypes(g);
        this.generateData(g);
    }

    public void generateData(TitanGraph g) {
        for (long i = this.uidCounter; i < (long)this.schema.getVertexCount() + 1L - 1L; ++i) {
            Vertex v = g.addVertex((Object)i);
            this.vertexAnnotator.annotate(v, null);
        }
        for (int i = 0; i < this.schema.getEdgeLabels(); ++i) {
            DistributionGenerator gen = new DistributionGenerator(this.schema.getEdgeLabelName(i), this.edgeAnnotator);
            gen.setOutDistribution(new PowerLawDistribution(2.5));
            gen.setInDistribution(new PowerLawDistribution(2.5));
            gen.generate((Graph)g, this.schema.getEdgeCount());
        }
        g.commit();
        TitanTransaction tx = g.newTransaction();
        Vertex hiOutDeg = tx.addVertex((Object)Schema.SUPERNODE_UID);
        String label = this.schema.getSupernodeOutLabel();
        PropertyKey uidKey = tx.getPropertyKey("uid");
        hiOutDeg.setProperty("uid", (Object)Schema.SUPERNODE_UID);
        String pKey = this.schema.getSortKeyForLabel(label);
        for (long i = 1L; i < (long)this.schema.getVertexCount(); ++i) {
            Vertex in = (Vertex)Iterables.getOnlyElement((Iterable)tx.getVertices(uidKey, (Object)i));
            Edge e = hiOutDeg.addEdge(label, in);
            e.setProperty(pKey, (Object)((int)i));
        }
        tx.commit();
    }

    public static void writeData(TitanGraph g, OutputStream data) throws IOException {
        GraphMLWriter.outputGraph((Graph)g, (OutputStream)data);
    }

    public void generateTypesAndLoadData(TitanGraph g, InputStream data) throws IOException {
        this.schema.makeTypes(g);
        GraphMLReader.inputGraph((Graph)g, (InputStream)data);
    }

    public static void main(String[] args) throws IOException {
        if (4 != args.length) {
            System.err.println("Usage: GraphGenerator titanproperties vertexcount edgecount outfile");
            System.exit(1);
        }
        int i = 0;
        String c = args[i++];
        int v = Integer.valueOf(args[i++]);
        int e = Integer.valueOf(args[i++]);
        String o = args[i++];
        Schema s = new Schema.Builder(v, e).build();
        TitanGraph graph = TitanFactory.open((String)c);
        new GraphGenerator(s).generateTypesAndData(graph);
        GZIPOutputStream out = new GZIPOutputStream(new FileOutputStream(o));
        GraphGenerator.writeData(graph, out);
        ((OutputStream)out).close();
        graph.shutdown();
        System.exit(0);
    }
}

