/*
 * Decompiled with CFR 0.152.
 */
package com.thinkaurelius.titan.testutil.gen;

import com.google.common.base.Preconditions;
import com.thinkaurelius.titan.core.Cardinality;
import com.thinkaurelius.titan.core.PropertyKey;
import com.thinkaurelius.titan.core.RelationType;
import com.thinkaurelius.titan.core.TitanGraph;
import com.thinkaurelius.titan.core.schema.ConsistencyModifier;
import com.thinkaurelius.titan.core.schema.TitanManagement;
import com.thinkaurelius.titan.core.schema.TitanSchemaElement;
import com.thinkaurelius.titan.graphdb.types.StandardEdgeLabelMaker;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Vertex;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Schema {
    public static final String VERTEX_KEY_PREFIX = "vp_";
    public static final String EDGE_KEY_PREFIX = "ep_";
    public static final String LABEL_PREFIX = "el_";
    public static final String UID_PROP = "uid";
    public static long SUPERNODE_UID = 0L;
    private static final int SUPERNODE_INDEX = 0;
    private final int edgeCount;
    private final int vertexCount;
    private final int maxEdgePropVal;
    private final int maxVertexPropVal;
    private final int vertexPropKeys;
    private final int edgePropKeys;
    private final int edgeLabels;
    private final String[] vertexPropNames;
    private final String[] edgePropNames;
    private final String[] edgeLabelNames;
    private final Map<String, String> labelPkeys;
    private static final Logger log = LoggerFactory.getLogger(Schema.class);

    public final String getVertexPropertyName(int i) {
        return this.vertexPropNames[i];
    }

    public final String getEdgePropertyName(int i) {
        return this.edgePropNames[i];
    }

    public final String getEdgeLabelName(int i) {
        return this.edgeLabelNames[i];
    }

    public final String getSortKeyForLabel(String l) {
        return l.replace(LABEL_PREFIX, EDGE_KEY_PREFIX);
    }

    public final int getVertexPropKeys() {
        return this.vertexPropKeys;
    }

    public final int getEdgePropKeys() {
        return this.edgePropKeys;
    }

    public final int getMaxEdgePropVal() {
        return this.maxEdgePropVal;
    }

    public final int getMaxVertexPropVal() {
        return this.maxVertexPropVal;
    }

    public final int getEdgeLabels() {
        return this.edgeLabels;
    }

    public final long getSupernodeUid() {
        return SUPERNODE_UID;
    }

    public final String getSupernodeOutLabel() {
        return this.getEdgeLabelName(0);
    }

    public final long getMaxUid() {
        return this.vertexCount;
    }

    public final int getVertexCount() {
        return this.vertexCount;
    }

    public final int getEdgeCount() {
        return this.edgeCount;
    }

    private Schema(int maxEdgePropVal, int maxVertexPropVal, int vertexCount, int edgeCount, int vertexPropKeys, int edgePropKeys, int edgeLabels) {
        this.maxEdgePropVal = maxEdgePropVal;
        this.maxVertexPropVal = maxVertexPropVal;
        this.vertexCount = vertexCount;
        this.edgeCount = edgeCount;
        this.vertexPropKeys = vertexPropKeys;
        this.edgePropKeys = edgePropKeys;
        this.edgeLabels = edgeLabels;
        this.vertexPropNames = this.generateNames(VERTEX_KEY_PREFIX, this.vertexPropKeys);
        this.edgePropNames = this.generateNames(EDGE_KEY_PREFIX, this.edgePropKeys);
        this.edgeLabelNames = this.generateNames(LABEL_PREFIX, this.edgeLabels);
        Preconditions.checkArgument((this.edgeLabels <= this.edgePropKeys ? 1 : 0) != 0);
        this.labelPkeys = new HashMap<String, String>(this.edgeLabels);
        for (int i = 0; i < this.edgeLabels; ++i) {
            this.labelPkeys.put(this.edgeLabelNames[i], this.edgePropNames[i]);
        }
    }

    public void makeTypes(TitanGraph g) {
        PropertyKey key;
        int i;
        Preconditions.checkArgument((this.edgeLabels <= this.edgePropKeys ? 1 : 0) != 0);
        TitanManagement mgmt = g.getManagementSystem();
        for (i = 0; i < this.vertexPropKeys; ++i) {
            key = mgmt.makePropertyKey(this.getVertexPropertyName(i)).dataType(Integer.class).cardinality(Cardinality.SINGLE).make();
            mgmt.setConsistency((TitanSchemaElement)key, ConsistencyModifier.LOCK);
            mgmt.buildIndex("v-" + this.getVertexPropertyName(i), Vertex.class).addKey(key).buildCompositeIndex();
        }
        for (i = 0; i < this.edgePropKeys; ++i) {
            key = mgmt.makePropertyKey(this.getEdgePropertyName(i)).dataType(Integer.class).cardinality(Cardinality.SINGLE).make();
            mgmt.setConsistency((TitanSchemaElement)key, ConsistencyModifier.LOCK);
            mgmt.buildIndex("e-" + this.getEdgePropertyName(i), Edge.class).addKey(key).buildCompositeIndex();
        }
        for (i = 0; i < this.edgeLabels; ++i) {
            String labelName = this.getEdgeLabelName(i);
            String pkName = this.getSortKeyForLabel(labelName);
            PropertyKey pk = mgmt.getPropertyKey(pkName);
            ((StandardEdgeLabelMaker)mgmt.makeEdgeLabel(this.getEdgeLabelName(i))).sortKey(new RelationType[]{pk}).make();
        }
        PropertyKey uid = mgmt.makePropertyKey(UID_PROP).dataType(Long.class).cardinality(Cardinality.SINGLE).make();
        mgmt.buildIndex("v-uid", Vertex.class).unique().addKey(uid).buildCompositeIndex();
        mgmt.setConsistency((TitanSchemaElement)uid, ConsistencyModifier.LOCK);
        mgmt.commit();
        log.debug("Committed types");
    }

    private String[] generateNames(String prefix, int count) {
        String[] result = new String[count];
        StringBuilder sb = new StringBuilder(8);
        sb.append(prefix);
        for (int i = 0; i < count; ++i) {
            sb.append(i);
            result[i] = sb.toString();
            sb.setLength(prefix.length());
        }
        return result;
    }

    public static class Builder {
        private int maxVertexPropVal = 100;
        private int maxEdgePropVal = 100;
        private int vertexPropKeys = 20;
        private int edgePropKeys = 10;
        private int edgeLabels = 3;
        private int vertexCount = -1;
        private int edgeCount = -1;

        public Builder setMaxVertexPropVal(int m) {
            this.maxVertexPropVal = m;
            return this;
        }

        public Builder setMaxEdgePropVal(int m) {
            this.maxEdgePropVal = m;
            return this;
        }

        public Builder setVertexPropKeys(int vertexPropKeys) {
            this.vertexPropKeys = vertexPropKeys;
            return this;
        }

        public Builder setEdgePropKeys(int edgePropKeys) {
            this.edgePropKeys = edgePropKeys;
            return this;
        }

        public Builder setEdgeLabels(int edgeLabels) {
            this.edgeLabels = edgeLabels;
            return this;
        }

        public Builder setVertexCount(int vertexCount) {
            this.vertexCount = vertexCount;
            Preconditions.checkArgument((0 <= this.vertexCount ? 1 : 0) != 0);
            return this;
        }

        public Builder setEdgeCount(int edgeCount) {
            this.edgeCount = edgeCount;
            Preconditions.checkArgument((0 <= this.edgeCount ? 1 : 0) != 0);
            return this;
        }

        public Builder(int vertexCount, int edgeCount) {
            this.setVertexCount(vertexCount);
            this.setEdgeCount(edgeCount);
        }

        public Schema build() {
            return new Schema(this.maxEdgePropVal, this.maxVertexPropVal, this.vertexCount, this.edgeCount, this.vertexPropKeys, this.edgePropKeys, this.edgeLabels);
        }
    }
}

