/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.furnace.alpha.generators;

import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.furnace.alpha.generators.EdgeAnnotator;
import com.tinkerpop.furnace.alpha.generators.VertexAnnotator;
import java.util.Map;

public abstract class AbstractGenerator {
    private final String label;
    private final EdgeAnnotator edgeAnnotator;
    private final VertexAnnotator vertexAnnotator;

    public AbstractGenerator(String label, EdgeAnnotator edgeAnnotator, VertexAnnotator vertexAnnotator) {
        if (label == null || label.isEmpty()) {
            throw new IllegalArgumentException("Label cannot be empty");
        }
        if (edgeAnnotator == null) {
            throw new NullPointerException();
        }
        if (vertexAnnotator == null) {
            throw new NullPointerException();
        }
        this.label = label;
        this.edgeAnnotator = edgeAnnotator;
        this.vertexAnnotator = vertexAnnotator;
    }

    public AbstractGenerator(String label, EdgeAnnotator annotator) {
        this(label, annotator, VertexAnnotator.NONE);
    }

    public AbstractGenerator(String label) {
        this(label, EdgeAnnotator.NONE);
    }

    public final String getLabel() {
        return this.label;
    }

    public final EdgeAnnotator getEdgeAnnotator() {
        return this.edgeAnnotator;
    }

    public final VertexAnnotator getVertexAnnotator() {
        return this.vertexAnnotator;
    }

    protected final Edge addEdge(Graph graph, Vertex out, Vertex in) {
        Edge e = graph.addEdge(null, out, in, this.label);
        this.edgeAnnotator.annotate(e);
        return e;
    }

    protected final Vertex processVertex(Vertex vertex, Map<String, Object> context) {
        this.vertexAnnotator.annotate(vertex, context);
        return vertex;
    }
}

