/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.furnace.alpha.generators;

import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.furnace.alpha.generators.AbstractGenerator;
import com.tinkerpop.furnace.alpha.generators.Distribution;
import com.tinkerpop.furnace.alpha.generators.EdgeAnnotator;
import com.tinkerpop.furnace.alpha.generators.SizableIterable;
import com.tinkerpop.furnace.alpha.generators.VertexAnnotator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;

public class CommunityGenerator
extends AbstractGenerator {
    public static final double DEFAULT_CROSS_COMMUNITY_PERCENTAGE = 0.1;
    private Distribution communitySize = null;
    private Distribution edgeDegree = null;
    private double crossCommunityPercentage = 0.1;
    private final Random random = new Random();

    public CommunityGenerator(String label, EdgeAnnotator annotator) {
        super(label, annotator);
    }

    public CommunityGenerator(String label, EdgeAnnotator edgeAnnotator, VertexAnnotator vertexAnnotator) {
        super(label, edgeAnnotator, vertexAnnotator);
    }

    public CommunityGenerator(String label) {
        super(label);
    }

    public void setCommunityDistribution(Distribution community) {
        this.communitySize = community;
    }

    public void setDegreeDistribution(Distribution degree) {
        this.edgeDegree = degree;
    }

    public void setCrossCommunityPercentage(double percentage) {
        if (percentage < 0.0 || percentage > 1.0) {
            throw new IllegalArgumentException("Percentage must be between 0 and 1");
        }
        this.crossCommunityPercentage = percentage;
    }

    public double getCrossCommunityPercentage() {
        return this.crossCommunityPercentage;
    }

    public int generate(Graph graph, int expectedNumCommunities, int expectedNumEdges) {
        return this.generate(graph, graph.getVertices(), expectedNumCommunities, expectedNumEdges);
    }

    public int generate(Graph graph, Iterable<Vertex> vertices, int expectedNumCommunities, int expectedNumEdges) {
        if (this.communitySize == null) {
            throw new IllegalStateException("Need to initialize community size distribution");
        }
        if (this.edgeDegree == null) {
            throw new IllegalStateException("Need to initialize degree distribution");
        }
        int numVertices = SizableIterable.sizeOf(vertices);
        Iterator<Vertex> iter = vertices.iterator();
        ArrayList communities = new ArrayList(expectedNumCommunities);
        Distribution communityDist = this.communitySize.initialize(expectedNumCommunities, numVertices);
        HashMap<String, Object> context = new HashMap<String, Object>();
        while (iter.hasNext()) {
            int nextSize = communityDist.nextValue(this.random);
            context.put("communityIndex", communities.size());
            ArrayList<Vertex> community = new ArrayList<Vertex>(nextSize);
            for (int i = 0; i < nextSize && iter.hasNext(); ++i) {
                community.add(this.processVertex(iter.next(), context));
            }
            if (community.isEmpty()) continue;
            communities.add(community);
        }
        double inCommunityPercentage = 1.0 - this.crossCommunityPercentage;
        Distribution degreeDist = this.edgeDegree.initialize(numVertices, expectedNumEdges);
        if (this.crossCommunityPercentage > 0.0 && communities.size() < 2) {
            throw new IllegalArgumentException("Cannot have cross links with only one community");
        }
        int addedEdges = 0;
        for (ArrayList arrayList : communities) {
            for (Vertex v : arrayList) {
                int degree = degreeDist.nextValue(this.random);
                degree = Math.min(degree, (int)Math.ceil((double)(arrayList.size() - 1) / inCommunityPercentage) - 1);
                HashSet<Vertex> inlinks = new HashSet<Vertex>();
                HashSet<Vertex> outlinks = new HashSet<Vertex>();
                for (int i = 0; i < degree; ++i) {
                    Vertex selected = null;
                    if (this.random.nextDouble() < this.crossCommunityPercentage || arrayList.size() - 1 <= inlinks.size()) {
                        ArrayList othercomm = null;
                        while (selected == null) {
                            while (othercomm == null) {
                                othercomm = (ArrayList)communities.get(this.random.nextInt(communities.size()));
                                if (!othercomm.equals(arrayList)) continue;
                                othercomm = null;
                            }
                            selected = (Vertex)othercomm.get(this.random.nextInt(othercomm.size()));
                            if (!outlinks.contains(selected)) continue;
                            selected = null;
                        }
                        outlinks.add(selected);
                    } else {
                        while (selected == null) {
                            selected = (Vertex)arrayList.get(this.random.nextInt(arrayList.size()));
                            if (!v.equals(selected) && !inlinks.contains(selected)) continue;
                            selected = null;
                        }
                        inlinks.add(selected);
                    }
                    this.addEdge(graph, v, selected);
                    ++addedEdges;
                }
            }
        }
        return addedEdges;
    }
}

