/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.furnace.alpha.generators;

import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.furnace.alpha.generators.AbstractGenerator;
import com.tinkerpop.furnace.alpha.generators.CopyDistribution;
import com.tinkerpop.furnace.alpha.generators.Distribution;
import com.tinkerpop.furnace.alpha.generators.EdgeAnnotator;
import com.tinkerpop.furnace.alpha.generators.SizableIterable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;

public class DistributionGenerator
extends AbstractGenerator {
    private Distribution outDistribution;
    private Distribution inDistribution;
    private boolean allowLoops = true;

    public DistributionGenerator(String label, EdgeAnnotator annotator) {
        super(label, annotator);
    }

    public DistributionGenerator(String label) {
        super(label);
    }

    public void setOutDistribution(Distribution distribution) {
        if (distribution == null) {
            throw new NullPointerException();
        }
        this.outDistribution = distribution;
    }

    public void setInDistribution(Distribution distribution) {
        if (distribution == null) {
            throw new NullPointerException();
        }
        this.inDistribution = distribution;
    }

    public void clearInDistribution() {
        this.inDistribution = null;
    }

    public boolean hasAllowLoops() {
        return this.allowLoops;
    }

    public void setAllowLoops(boolean allowLoops) {
        this.allowLoops = allowLoops;
    }

    public int generate(Graph graph, int expectedNumEdges) {
        return this.generate(graph, graph.getVertices(), expectedNumEdges);
    }

    public int generate(Graph graph, Iterable<Vertex> vertices, int expectedNumEdges) {
        return this.generate(graph, vertices, vertices, expectedNumEdges);
    }

    public int generate(Graph graph, Iterable<Vertex> out, Iterable<Vertex> in, int expectedNumEdges) {
        if (this.outDistribution == null) {
            throw new IllegalStateException("Must set out-distribution before generating edges");
        }
        Distribution outDist = this.outDistribution.initialize(SizableIterable.sizeOf(out), expectedNumEdges);
        Distribution inDist = null;
        if (this.inDistribution == null) {
            if (out != in) {
                throw new IllegalArgumentException("Need to specify in-distribution");
            }
            inDist = new CopyDistribution();
        } else {
            inDist = this.inDistribution.initialize(SizableIterable.sizeOf(in), expectedNumEdges);
        }
        long seed = System.currentTimeMillis() * 177L;
        Random outRandom = new Random(seed);
        ArrayList<Vertex> outStubs = new ArrayList<Vertex>(expectedNumEdges);
        for (Vertex v : out) {
            int degree = outDist.nextValue(outRandom);
            for (int i = 0; i < degree; ++i) {
                outStubs.add(v);
            }
        }
        Collections.shuffle(outStubs);
        outRandom = new Random(seed);
        Random inRandom = new Random(System.currentTimeMillis() * 14421L);
        int addedEdges = 0;
        int position = 0;
        for (Vertex v : in) {
            int degree = inDist.nextConditionalValue(inRandom, outDist.nextValue(outRandom));
            for (int i = 0; i < degree; ++i) {
                Vertex other = null;
                while (other == null) {
                    if (position >= outStubs.size()) {
                        return addedEdges;
                    }
                    other = (Vertex)outStubs.get(position);
                    ++position;
                    if (this.allowLoops || !v.equals(other)) continue;
                    other = null;
                }
                this.addEdge(graph, other, v);
                ++addedEdges;
            }
        }
        return addedEdges;
    }
}

