/*
 * Decompiled with CFR 0.152.
 */
package org.hbase.async;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.CacheStats;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.stumbleupon.async.Deferred;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.hbase.async.Bytes;
import org.hbase.async.HBaseClient;
import org.hbase.async.MultiColumnAtomicIncrementRequest;

final class BufferedMultiColumnIncrement {
    private final byte[] table;
    private final byte[] key;
    private final byte[] family;
    private final byte[][] qualifiers;
    private static final Loader LOADER = new Loader();
    static final CacheStats ZERO_STATS = new CacheStats(0L, 0L, 0L, 0L, 0L, 0L);

    private static boolean byteArrayEquals(byte[][] self, byte[][] other) {
        if (self.length != other.length) {
            return false;
        }
        for (int i = 0; i < self.length; ++i) {
            if (Bytes.memcmp(self[i], other[i]) == 0) continue;
            return false;
        }
        return true;
    }

    private static int byteArrayHashCode(byte[][] self) {
        int hashCode = 1;
        for (byte[] aSelf : self) {
            hashCode = Arrays.hashCode(aSelf) + 41 * hashCode;
        }
        return hashCode;
    }

    private static int byteArrayLength(byte[][] self) {
        int len = 0;
        for (byte[] aSelf : self) {
            len += aSelf.length;
        }
        return len;
    }

    private static void byteArrayToString(StringBuilder sb, byte[][] self) {
        for (byte[] aSelf : self) {
            sb.append(Bytes.pretty(aSelf));
        }
    }

    BufferedMultiColumnIncrement(byte[] table, byte[] key, byte[] family, byte[][] qualifiers) {
        this.table = table;
        this.key = key;
        this.family = family;
        this.qualifiers = qualifiers;
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof BufferedMultiColumnIncrement)) {
            return false;
        }
        BufferedMultiColumnIncrement incr = (BufferedMultiColumnIncrement)other;
        return Bytes.equals(this.key, incr.key) && BufferedMultiColumnIncrement.byteArrayEquals(this.qualifiers, incr.qualifiers) && Bytes.equals(this.family, incr.family) && Bytes.equals(this.table, incr.table);
    }

    public int hashCode() {
        return Arrays.hashCode(this.table) + 41 * (Arrays.hashCode(this.key) + 41 * (Arrays.hashCode(this.family) + 41 * (BufferedMultiColumnIncrement.byteArrayHashCode(this.qualifiers) + 41)));
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(52 + this.table.length + this.key.length * 2 + this.family.length + BufferedMultiColumnIncrement.byteArrayLength(this.qualifiers));
        buf.append("BufferedIncrement(table=");
        Bytes.pretty(buf, this.table);
        buf.append(", key=");
        Bytes.pretty(buf, this.key);
        buf.append(", family=");
        Bytes.pretty(buf, this.family);
        buf.append(", qualifier=");
        BufferedMultiColumnIncrement.byteArrayToString(buf, this.qualifiers);
        buf.append(')');
        return buf.toString();
    }

    static LoadingCache<BufferedMultiColumnIncrement, Amounts> newCache(HBaseClient client, int size) {
        int ncpu = Runtime.getRuntime().availableProcessors();
        return CacheBuilder.newBuilder().concurrencyLevel(ncpu * 4).maximumSize((long)size).recordStats().removalListener((RemovalListener)new EvictionHandler(client)).build((CacheLoader)LOADER);
    }

    private static final class EvictionHandler
    implements RemovalListener<BufferedMultiColumnIncrement, Amounts> {
        private final HBaseClient client;

        EvictionHandler(HBaseClient client) {
            this.client = client;
        }

        public void onRemoval(RemovalNotification<BufferedMultiColumnIncrement, Amounts> entry) {
            Amounts amounts = (Amounts)entry.getValue();
            assert (amounts != null);
            long[] raw = amounts.getRawAndInvalidate();
            long[] delta = new long[raw.length];
            boolean hasUpdates = false;
            for (int i = 0; i < raw.length; ++i) {
                delta[i] = Amounts.amount(raw[i]);
                if (Amounts.numUpdatesLeft(raw[i]) >= 16383) continue;
                hasUpdates = true;
            }
            if (hasUpdates) {
                BufferedMultiColumnIncrement incr = (BufferedMultiColumnIncrement)entry.getKey();
                MultiColumnAtomicIncrementRequest req = new MultiColumnAtomicIncrementRequest(incr.table, incr.key, incr.family, incr.qualifiers, delta);
                this.client.atomicIncrement(req).chain(amounts.deferred);
            }
        }
    }

    static final class Loader
    extends CacheLoader<BufferedMultiColumnIncrement, Amounts> {
        private static final short MAX_UPDATES = 16383;

        Loader() {
        }

        public Amounts load(BufferedMultiColumnIncrement key) {
            return new Amounts(16383, key.qualifiers.length);
        }
    }

    static final class Amounts {
        private static final int UPDATE_BITS = 15;
        private static final long UPDATE_MASK = 32767L;
        private static final long OVERFLOW_MASK = -281474976710656L;
        final AtomicLong[] values;
        final Deferred<Map<byte[], Long>> deferred = new Deferred();
        private static final long serialVersionUID = 1333868962L;

        Amounts(short max_updates, int numColumns) {
            assert (max_updates > 0) : "WTF: max_updates=" + max_updates;
            this.values = new AtomicLong[numColumns];
            for (int i = 0; i < numColumns; ++i) {
                this.values[i] = new AtomicLong(max_updates);
            }
        }

        final boolean update(long[] delta) {
            assert (delta.length == this.values.length);
            boolean okToUpdate = true;
            block0: for (int i = 0; i < delta.length && okToUpdate; ++i) {
                int updates;
                long new_amount;
                long next;
                long current;
                do {
                    if ((updates = Amounts.numUpdatesLeft(current = this.values[i].get())) == 0) {
                        okToUpdate = false;
                        continue block0;
                    }
                    new_amount = Amounts.amount(current) + delta[i];
                    if (Amounts.checkOverflow(new_amount)) continue;
                    okToUpdate = false;
                    continue block0;
                } while (!this.values[i].compareAndSet(current, next = new_amount << 15 | (long)(updates - 1)));
                delta[i] = 0L;
            }
            return okToUpdate;
        }

        final long[] getRawAndInvalidate() {
            long[] currents = new long[this.values.length];
            for (int i = 0; i < currents.length; ++i) {
                long next;
                long current;
                while (!this.values[i].compareAndSet(current = this.values[i].get(), next = Amounts.amount(current) << 15)) {
                }
                currents[i] = current;
            }
            return currents;
        }

        static final long amount(long n) {
            return n >> 15;
        }

        static final int numUpdatesLeft(long n) {
            return (int)(n & 0x7FFFL);
        }

        static final boolean checkOverflow(long value) {
            long masked = value & 0xFFFF000000000000L;
            return masked == 0L || masked == -281474976710656L;
        }

        public String toString() {
            long[] currents = new long[this.values.length];
            StringBuilder sb = new StringBuilder();
            sb.append("Amounts: ");
            for (int i = 0; i < this.values.length; ++i) {
                currents[i] = this.values[i].get();
                sb.append(Amounts.amount(currents[i]));
                sb.append("|");
                sb.append(Amounts.numUpdatesLeft(currents[i]));
                sb.append(",");
            }
            sb.append("Deferred: ");
            sb.append(this.deferred);
            return sb.toString();
        }
    }
}

