/*
 * Decompiled with CFR 0.152.
 */
package org.hbase.async;

import com.google.protobuf.AbstractMessageLite;
import com.stumbleupon.async.Callback;
import com.stumbleupon.async.Deferred;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import org.hbase.async.Bytes;
import org.hbase.async.GetRequest;
import org.hbase.async.HBaseClient;
import org.hbase.async.HBaseRpc;
import org.hbase.async.InvalidResponseException;
import org.hbase.async.KeyRegexpFilter;
import org.hbase.async.KeyValue;
import org.hbase.async.NotServingRegionException;
import org.hbase.async.RegionInfo;
import org.hbase.async.ScanFilter;
import org.hbase.async.UnknownScannerException;
import org.hbase.async.generated.ClientPB;
import org.hbase.async.generated.FilterPB;
import org.hbase.async.generated.HBasePB;
import org.jboss.netty.buffer.ChannelBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Scanner {
    private static final Logger LOG = LoggerFactory.getLogger(Scanner.class);
    public static final int DEFAULT_MAX_NUM_KVS = 4096;
    public static final int DEFAULT_MAX_NUM_ROWS = 128;
    private static final RegionInfo DONE = new RegionInfo(HBaseClient.EMPTY_ARRAY, HBaseClient.EMPTY_ARRAY, HBaseClient.EMPTY_ARRAY);
    private final HBaseClient client;
    private final byte[] table;
    private boolean is_reversed = false;
    private boolean is_first_reverse_region = true;
    private byte[] start_key = HBaseClient.EMPTY_ARRAY;
    private byte[] stop_key = HBaseClient.EMPTY_ARRAY;
    private byte[][] families;
    private byte[][][] qualifiers;
    private ScanFilter filter;
    private long min_timestamp = 0L;
    private long max_timestamp = Long.MAX_VALUE;
    private boolean populate_blockcache = true;
    private int max_num_rows = 128;
    private int max_num_kvs = 4096;
    private long max_num_bytes = 0xFFFFFFFL;
    private int versions = 1;
    private RegionInfo region;
    private long scanner_id;
    private GetNextRowsRequest get_next_rows_request;
    private boolean moreRows;
    private boolean scannerClosedOnServer;
    private final Callback<Deferred<ArrayList<ArrayList<KeyValue>>>, Object> opened_scanner = new Callback<Deferred<ArrayList<ArrayList<KeyValue>>>, Object>(){

        public Deferred<ArrayList<ArrayList<KeyValue>>> call(Object arg) {
            Response resp;
            if (arg instanceof Long) {
                Scanner.this.scanner_id = (Long)arg;
                resp = null;
            } else if (arg instanceof Response) {
                resp = (Response)arg;
                Scanner.this.scanner_id = resp.scanner_id;
                Scanner.this.scannerClosedOnServer = resp.scannerClosedOnServer;
                Scanner.this.moreRows = resp.more;
            } else {
                throw new IllegalStateException("WTF? Scanner open callback invoked with impossible argument: " + arg);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Scanner " + Bytes.hex(Scanner.this.scanner_id) + " opened on " + Scanner.this.region);
            }
            if (resp != null) {
                if (resp.rows == null) {
                    return Scanner.this.scanFinished(!resp.more);
                }
                return Deferred.fromResult((Object)resp.rows);
            }
            return Scanner.this.nextRows();
        }

        public String toString() {
            return "scanner opened";
        }
    };
    private final Callback<Object, Object> got_next_row = new Callback<Object, Object>(){

        public Object call(Object response) {
            ArrayList rows = null;
            Response resp = null;
            if (response instanceof Response) {
                resp = (Response)response;
                rows = resp.rows;
                Scanner.this.scannerClosedOnServer = resp.scannerClosedOnServer;
                Scanner.this.moreRows = resp.more;
            } else if (response instanceof ArrayList) {
                ArrayList r;
                rows = r = (ArrayList)response;
            } else if (response != null) {
                throw new InvalidResponseException(ArrayList.class, response);
            }
            if (rows == null) {
                return Scanner.this.scanFinished(resp != null && !resp.more);
            }
            ArrayList lastrow = (ArrayList)rows.get(rows.size() - 1);
            Scanner.access$1002(Scanner.this, ((KeyValue)lastrow.get(0)).key());
            return rows;
        }

        public String toString() {
            return "get nextRows response";
        }
    };
    private static final byte[] SCAN = new byte[]{83, 99, 97, 110};
    private static final byte[] OPEN_SCANNER = new byte[]{111, 112, 101, 110, 83, 99, 97, 110, 110, 101, 114};
    private static final byte[] NEXT = new byte[]{110, 101, 120, 116};

    Scanner(HBaseClient client, byte[] table) {
        KeyValue.checkTable(table);
        this.client = client;
        this.table = table;
    }

    public boolean isReversed() {
        return this.is_reversed;
    }

    public void setReversed(boolean reversed) {
        this.checkScanningNotStarted();
        this.is_reversed = true;
    }

    public boolean isFirstReverseRegion() {
        return this.is_first_reverse_region;
    }

    public byte[] getCurrentKey() {
        return this.start_key;
    }

    public void setStartKey(byte[] start_key) {
        KeyValue.checkKey(start_key);
        this.checkScanningNotStarted();
        this.start_key = start_key;
    }

    public void setStartKey(String start_key) {
        this.setStartKey(start_key.getBytes());
    }

    public void setStopKey(byte[] stop_key) {
        KeyValue.checkKey(stop_key);
        this.checkScanningNotStarted();
        this.stop_key = stop_key;
    }

    public void setStopKey(String stop_key) {
        this.setStopKey(stop_key.getBytes());
    }

    public void setFamily(byte[] family) {
        KeyValue.checkFamily(family);
        this.checkScanningNotStarted();
        this.families = new byte[][]{family};
    }

    public void setFamily(String family) {
        this.setFamily(family.getBytes());
    }

    public void setFamilies(byte[][] families, byte[][][] qualifiers) {
        this.checkScanningNotStarted();
        for (int i = 0; i < families.length; ++i) {
            KeyValue.checkFamily(families[i]);
            if (qualifiers == null || qualifiers[i] == null) continue;
            for (byte[] qualifier : qualifiers[i]) {
                KeyValue.checkQualifier(qualifier);
            }
        }
        this.families = families;
        this.qualifiers = qualifiers;
    }

    public void setFamilies(String ... families) {
        this.checkScanningNotStarted();
        this.families = new byte[families.length][];
        for (int i = 0; i < families.length; ++i) {
            this.families[i] = families[i].getBytes();
            KeyValue.checkFamily(this.families[i]);
        }
        this.qualifiers = null;
    }

    public void setQualifier(byte[] qualifier) {
        KeyValue.checkQualifier(qualifier);
        this.checkScanningNotStarted();
        this.qualifiers = new byte[][][]{new byte[][]{qualifier}};
    }

    public void setQualifier(String qualifier) {
        this.setQualifier(qualifier.getBytes());
    }

    public void setQualifiers(byte[][] qualifiers) {
        this.checkScanningNotStarted();
        for (byte[] qualifier : qualifiers) {
            KeyValue.checkQualifier(qualifier);
        }
        this.qualifiers = new byte[][][]{qualifiers};
    }

    public void setFilter(ScanFilter filter) {
        this.filter = filter;
    }

    public ScanFilter getFilter() {
        return this.filter;
    }

    public void clearFilter() {
        this.filter = null;
    }

    public void setKeyRegexp(String regexp) {
        this.filter = new KeyRegexpFilter(regexp);
    }

    public void setKeyRegexp(String regexp, Charset charset) {
        this.filter = new KeyRegexpFilter(regexp, charset);
    }

    public void setServerBlockCache(boolean populate_blockcache) {
        this.checkScanningNotStarted();
        this.populate_blockcache = populate_blockcache;
    }

    public void setMaxNumRows(int max_num_rows) {
        if (max_num_rows <= 0) {
            throw new IllegalArgumentException("zero or negative argument: " + max_num_rows);
        }
        this.max_num_rows = max_num_rows;
    }

    public void setMaxNumKeyValues(int max_num_kvs) {
        if (max_num_kvs == 0) {
            throw new IllegalArgumentException("batch size can't be zero");
        }
        this.checkScanningNotStarted();
        this.max_num_kvs = max_num_kvs;
    }

    public int getMaxNumKeyValues() {
        return this.max_num_kvs;
    }

    public void setMaxVersions(int versions) {
        if (versions <= 0) {
            throw new IllegalArgumentException("Need a strictly positive number: " + versions);
        }
        this.checkScanningNotStarted();
        this.versions = versions;
    }

    public int getMaxVersions() {
        return this.versions;
    }

    public void setMaxNumBytes(long max_num_bytes) {
        if (max_num_bytes <= 0L) {
            throw new IllegalArgumentException("Need a strictly positive number of bytes, got " + max_num_bytes);
        }
        this.checkScanningNotStarted();
        this.max_num_bytes = max_num_bytes;
    }

    public long getMaxNumBytes() {
        return this.max_num_bytes;
    }

    public void setMinTimestamp(long timestamp) {
        if (timestamp < 0L) {
            throw new IllegalArgumentException("Negative timestamp: " + timestamp);
        }
        if (timestamp > this.max_timestamp) {
            throw new IllegalArgumentException("New minimum timestamp (" + timestamp + ") is greater than the maximum" + " timestamp: " + this.max_timestamp);
        }
        this.checkScanningNotStarted();
        this.min_timestamp = timestamp;
    }

    public long getMinTimestamp() {
        return this.min_timestamp;
    }

    public void setMaxTimestamp(long timestamp) {
        if (timestamp < 0L) {
            throw new IllegalArgumentException("Negative timestamp: " + timestamp);
        }
        if (timestamp < this.min_timestamp) {
            throw new IllegalArgumentException("New maximum timestamp (" + timestamp + ") is greater than the minimum" + " timestamp: " + this.min_timestamp);
        }
        this.checkScanningNotStarted();
        this.max_timestamp = timestamp;
    }

    public long getMaxTimestamp() {
        return this.max_timestamp;
    }

    public void setTimeRange(long min_timestamp, long max_timestamp) {
        if (min_timestamp > max_timestamp) {
            throw new IllegalArgumentException("New minimum timestamp (" + min_timestamp + ") is greater than the new maximum" + " timestamp: " + max_timestamp);
        }
        if (min_timestamp < 0L) {
            throw new IllegalArgumentException("Negative minimum timestamp: " + min_timestamp);
        }
        this.checkScanningNotStarted();
        this.min_timestamp = min_timestamp;
        this.max_timestamp = max_timestamp;
    }

    public Deferred<ArrayList<ArrayList<KeyValue>>> nextRows(int nrows) {
        this.setMaxNumRows(nrows);
        return this.nextRows();
    }

    public Deferred<ArrayList<ArrayList<KeyValue>>> nextRows() {
        if (this.region == DONE) {
            return Deferred.fromResult(null);
        }
        if (this.region == null) {
            if (this.isReversed() && !this.isFirstReverseRegion()) {
                return this.client.openReverseScanner(this).addCallbackDeferring(this.opened_scanner);
            }
            if (this.is_reversed && this.start_key == HBaseClient.EMPTY_ARRAY) {
                this.start_key = Bytes.createMaxByteArray(Short.MAX_VALUE - this.table.length - 3);
            }
            return this.client.openScanner(this).addCallbackDeferring(this.opened_scanner);
        }
        if (this.scannerClosedOnServer) {
            return this.scanFinished(this.moreRows);
        }
        Deferred d = this.client.scanNextRows(this).addCallbacks(this.got_next_row, this.nextRowErrback());
        return d;
    }

    private final Callback<Object, Object> nextRowErrback() {
        return new Callback<Object, Object>(){

            public Object call(Object error) {
                RegionInfo old_region = Scanner.this.region;
                Scanner.this.invalidate();
                if (error instanceof NotServingRegionException) {
                    Scanner.access$1002(Scanner.this, Arrays.copyOf(Scanner.this.start_key, Scanner.this.start_key.length + 1));
                    return Scanner.this.nextRows();
                }
                if (error instanceof UnknownScannerException) {
                    Scanner scnr = Scanner.this;
                    LOG.warn(old_region + " pretends to not know " + scnr + ".  I will" + " retry to open a scanner but this is typically because you've" + " been holding the scanner open and idle for too long (possibly" + " due to a long GC pause on your side or in the RegionServer)", error);
                    return Scanner.this.nextRows();
                }
                return error;
            }

            public String toString() {
                return "NextRow errback";
            }
        };
    }

    public Deferred<Object> close() {
        if (this.region == null || this.region == DONE) {
            return Deferred.fromResult(null);
        }
        return this.client.closeScanner(this).addBoth(this.closedCallback());
    }

    private Callback<Object, Object> closedCallback() {
        return new Callback<Object, Object>(){

            public Object call(Object arg) {
                if (arg instanceof Exception) {
                    Exception error = (Exception)arg;
                    if (error instanceof NotServingRegionException || error instanceof UnknownScannerException) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Ignoring exception when closing " + Scanner.this, (Throwable)error);
                        }
                        arg = null;
                    }
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug("Scanner " + Bytes.hex(Scanner.this.scanner_id) + " closed on " + Scanner.this.region);
                }
                Scanner.this.region = DONE;
                Scanner.this.scanner_id = -2401262971557716307L;
                return arg;
            }

            public String toString() {
                return "scanner closed";
            }
        };
    }

    private Deferred<ArrayList<ArrayList<KeyValue>>> scanFinished(boolean end) {
        byte[] region_stop_key = this.region.stopKey();
        byte[] region_start_key = RegionInfo.startKeyFromRegionName(this.region.name());
        if (!this.is_reversed && (region_stop_key == HBaseClient.EMPTY_ARRAY || this.stop_key != HBaseClient.EMPTY_ARRAY && Bytes.memcmp(this.stop_key, region_stop_key) <= 0) || this.is_reversed && (region_start_key == HBaseClient.EMPTY_ARRAY || this.stop_key != HBaseClient.EMPTY_ARRAY && Bytes.memcmp(this.stop_key, region_start_key) >= 0)) {
            this.get_next_rows_request = null;
            this.families = null;
            this.qualifiers = null;
            this.stop_key = HBaseClient.EMPTY_ARRAY;
            this.start_key = HBaseClient.EMPTY_ARRAY;
            if (end) {
                return Deferred.fromResult(null);
            }
            return this.close().addCallback((Callback)new Callback<ArrayList<ArrayList<KeyValue>>, Object>(){

                public ArrayList<ArrayList<KeyValue>> call(Object arg) {
                    return null;
                }

                public String toString() {
                    return "auto-close scanner " + Bytes.hex(Scanner.this.scanner_id);
                }
            });
        }
        return this.continueScanOnNextRegion();
    }

    private Deferred<ArrayList<ArrayList<KeyValue>>> continueScanOnNextRegion() {
        final long old_scanner_id = this.scanner_id;
        final RegionInfo old_region = this.region;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Scanner " + Bytes.hex(old_scanner_id) + " done scanning " + old_region);
        }
        this.client.closeScanner(this).addCallback((Callback)new Callback<Object, Object>(){

            public Object call(Object arg) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Scanner " + Bytes.hex(old_scanner_id) + " closed on " + old_region);
                }
                return arg;
            }

            public String toString() {
                return "scanner moved";
            }
        });
        this.start_key = this.is_reversed ? RegionInfo.startKeyFromRegionName(this.region.name()) : this.region.stopKey();
        this.scanner_id = -2401262980684521811L;
        this.invalidate();
        return this.nextRows();
    }

    public String toString() {
        String region = this.region == null ? "null" : (this.region == DONE ? "none" : this.region.toString());
        String filter = this.filter == null ? "null" : this.filter.toString();
        int fam_length = 0;
        if (this.families == null) {
            fam_length = 4;
        } else {
            for (byte[] family : this.families) {
                fam_length += family.length + 2 + 2;
            }
        }
        int qual_length = 0;
        if (this.qualifiers == null) {
            qual_length = 4;
        } else {
            for (byte[][] qualifier : this.qualifiers) {
                if (qualifier == null) continue;
                for (byte[] qual : qualifier) {
                    qual_length += qual.length + 2 + 1;
                }
            }
        }
        StringBuilder buf = new StringBuilder(15 + this.table.length + 1 + 12 + 1 + this.start_key.length + 1 + 11 + 1 + this.stop_key.length + 1 + 11 + 1 + fam_length + qual_length + 1 + 23 + 5 + 15 + 5 + 14 + 6 + 9 + 1 + region.length() + 1 + 9 + 1 + filter.length() + 1 + 13 + 18 + 1);
        buf.append("Scanner(table=");
        Bytes.pretty(buf, this.table);
        buf.append(", start_key=");
        Bytes.pretty(buf, this.start_key);
        buf.append(", stop_key=");
        Bytes.pretty(buf, this.stop_key);
        buf.append(", columns={");
        this.familiesToString(buf);
        buf.append("}, populate_blockcache=").append(this.populate_blockcache).append(", max_num_rows=").append(this.max_num_rows).append(", max_num_kvs=").append(this.max_num_kvs).append(", region=").append(region).append(", filter=").append(filter);
        buf.append(", scanner_id=").append(Bytes.hex(this.scanner_id)).append(')');
        return buf.toString();
    }

    private void familiesToString(StringBuilder buf) {
        if (this.families == null) {
            return;
        }
        for (int i = 0; i < this.families.length; ++i) {
            Bytes.pretty(buf, this.families[i]);
            if (this.qualifiers != null && this.qualifiers[i] != null) {
                buf.append(':');
                Bytes.pretty(buf, this.qualifiers[i]);
            }
            buf.append(", ");
        }
        buf.setLength(buf.length() - 2);
    }

    byte[] table() {
        return this.table;
    }

    byte[] startKey() {
        return this.start_key;
    }

    void setRegionName(RegionInfo region) {
        this.region = region;
    }

    void invalidate() {
        this.region = null;
        this.scannerClosedOnServer = false;
    }

    RegionInfo currentRegion() {
        return this.region;
    }

    HBaseRpc getNextRowsRequest() {
        if (this.get_next_rows_request == null) {
            this.get_next_rows_request = new GetNextRowsRequest();
        }
        return this.get_next_rows_request;
    }

    HBaseRpc getOpenRequest() {
        return new OpenScannerRequest();
    }

    HBaseRpc getOpenRequestForReverseScan(byte[] region_start_key) {
        return new OpenScannerRequest(this.table, region_start_key);
    }

    HBaseRpc getCloseRequest() {
        return new CloseScannerRequest(this.scanner_id);
    }

    private void checkScanningNotStarted() {
        if (this.region != null) {
            throw new IllegalStateException("scanning already started");
        }
    }

    private ArrayList<ArrayList<KeyValue>> getRows(ClientPB.ScanResponse resp, ChannelBuffer buf, int cell_size) {
        int nrows;
        int n = nrows = cell_size == 0 ? resp.getResultsCount() : resp.getCellsPerResultCount();
        if (nrows == 0) {
            return null;
        }
        HBaseRpc.checkArrayLength(buf, nrows);
        ArrayList<ArrayList<KeyValue>> rows = new ArrayList<ArrayList<KeyValue>>(nrows);
        if (cell_size != 0) {
            KeyValue kv = null;
            for (int i = 0; i < nrows; ++i) {
                int nkvs = resp.getCellsPerResult(i);
                HBaseRpc.checkArrayLength(buf, nkvs);
                ArrayList<KeyValue> row = new ArrayList<KeyValue>(nkvs);
                for (int j = 0; j < nkvs; ++j) {
                    int kv_length = buf.readInt();
                    kv = KeyValue.fromBuffer(buf, kv);
                    row.add(kv);
                }
                rows.add(row);
            }
        } else {
            for (int i = 0; i < nrows; ++i) {
                rows.add(GetRequest.convertResult(resp.getResults(i), buf, cell_size));
            }
        }
        return rows;
    }

    static /* synthetic */ byte[] access$1002(Scanner x0, byte[] x1) {
        x0.start_key = x1;
        return x1;
    }

    static final class CloseScannerRequest
    extends HBaseRpc {
        private static final byte[] CLOSE = new byte[]{99, 108, 111, 115, 101};
        private final long scanner_id;

        public CloseScannerRequest(long scanner_id) {
            this.scanner_id = scanner_id;
        }

        @Override
        byte[] method(byte server_version) {
            return server_version >= 95 ? SCAN : CLOSE;
        }

        @Override
        ChannelBuffer serialize(byte server_version) {
            if (server_version < 95) {
                ChannelBuffer buf = this.newBuffer(server_version, 13);
                buf.writeInt(1);
                CloseScannerRequest.writeHBaseLong(buf, this.scanner_id);
                return buf;
            }
            ClientPB.ScanRequest req = ClientPB.ScanRequest.newBuilder().setScannerId(this.scanner_id).setCloseScanner(true).setNumberOfRows(0).build();
            return CloseScannerRequest.toChannelBuffer(SCAN, (AbstractMessageLite)req);
        }

        @Override
        Object deserialize(ChannelBuffer buf, int cell_size) {
            HBaseRpc.ensureNoCell(cell_size);
            ClientPB.ScanResponse resp = CloseScannerRequest.readProtobuf(buf, ClientPB.ScanResponse.PARSER);
            long id = resp.getScannerId();
            if (this.scanner_id != id && LOG.isDebugEnabled()) {
                LOG.debug("Scan RPC response was for scanner ID " + id + " but we expected " + this.scanner_id, (Object)resp);
            }
            return null;
        }

        @Override
        public String toString() {
            return "CloseScannerRequest(scanner_id=" + Bytes.hex(this.scanner_id) + ", attempt=" + this.attempt + ')';
        }
    }

    final class GetNextRowsRequest
    extends HBaseRpc {
        GetNextRowsRequest() {
        }

        @Override
        byte[] method(byte server_version) {
            return server_version >= 95 ? SCAN : NEXT;
        }

        @Override
        ChannelBuffer serialize(byte server_version) {
            if (server_version < 95) {
                ChannelBuffer buf = this.newBuffer(server_version, 18);
                buf.writeInt(2);
                GetNextRowsRequest.writeHBaseLong(buf, Scanner.this.scanner_id);
                GetNextRowsRequest.writeHBaseInt(buf, Scanner.this.max_num_rows);
                return buf;
            }
            ClientPB.ScanRequest req = ClientPB.ScanRequest.newBuilder().setScannerId(Scanner.this.scanner_id).setNumberOfRows(Scanner.this.max_num_rows).setClientHandlesHeartbeats(false).setClientHandlesPartials(false).build();
            return GetNextRowsRequest.toChannelBuffer(SCAN, (AbstractMessageLite)req);
        }

        @Override
        Response deserialize(ChannelBuffer buf, int cell_size) {
            ClientPB.ScanResponse resp = GetNextRowsRequest.readProtobuf(buf, ClientPB.ScanResponse.PARSER);
            long id = resp.getScannerId();
            if (Scanner.this.scanner_id != id) {
                throw new InvalidResponseException("Scan RPC response was for scanner ID " + id + " but we expected" + Scanner.this.scanner_id, (Object)resp);
            }
            ArrayList rows = Scanner.this.getRows(resp, buf, cell_size);
            if (rows == null) {
                return null;
            }
            boolean scannerClosedOnServer = resp.hasMoreResultsInRegion() && !resp.getMoreResultsInRegion();
            return new Response(resp.getScannerId(), rows, resp.getMoreResults(), scannerClosedOnServer);
        }

        @Override
        public String toString() {
            return "GetNextRowsRequest(scanner_id=" + Bytes.hex(Scanner.this.scanner_id) + ", max_num_rows=" + Scanner.this.max_num_rows + ", region=" + this.region + ", attempt=" + this.attempt + ')';
        }
    }

    final class OpenScannerRequest
    extends HBaseRpc {
        public OpenScannerRequest() {
            super(Scanner.this.table, Scanner.this.start_key);
            Scanner.this.is_first_reverse_region = false;
        }

        public OpenScannerRequest(byte[] table, byte[] row) {
            super(table, row);
        }

        @Override
        byte[] method(byte server_version) {
            return server_version >= 95 ? SCAN : OPEN_SCANNER;
        }

        private int predictSerializedSize() {
            int size = 0;
            size += 4;
            ++size;
            size += 3;
            size += this.region.name().length;
            ++size;
            ++size;
            ++size;
            size += 3;
            size += Scanner.this.start_key.length;
            size += 3;
            size += Scanner.this.stop_key.length;
            size += 4;
            size += 4;
            size += 4;
            ++size;
            ++size;
            if (Scanner.this.filter != null) {
                size += Scanner.this.filter.predictSerializedSize();
            }
            size += 8;
            size += 8;
            ++size;
            size += 4;
            if (Scanner.this.families != null) {
                size += Scanner.this.families.length;
                for (int i = 0; i < Scanner.this.families.length; ++i) {
                    byte[] family = Scanner.this.families[i];
                    size += family.length;
                    size += 4;
                    if (Scanner.this.qualifiers == null || Scanner.this.qualifiers[i] == null) continue;
                    size += 3 * Scanner.this.qualifiers[i].length;
                    for (byte[] qualifier : Scanner.this.qualifiers[i]) {
                        size += qualifier.length;
                    }
                }
            }
            return size;
        }

        @Override
        ChannelBuffer serialize(byte server_version) {
            Scanner.this.region = this.region;
            if (server_version < 95) {
                return this.serializeOld(server_version);
            }
            ClientPB.Scan.Builder scan = ClientPB.Scan.newBuilder().setStartRow(Bytes.wrap(Scanner.this.start_key)).setStopRow(Bytes.wrap(Scanner.this.stop_key)).setReversed(Scanner.this.is_reversed);
            if (Scanner.this.families != null) {
                for (int i = 0; i < Scanner.this.families.length; ++i) {
                    ClientPB.Column.Builder columns = ClientPB.Column.newBuilder();
                    columns.setFamily(Bytes.wrap(Scanner.this.families[i]));
                    if (Scanner.this.qualifiers != null && Scanner.this.qualifiers[i] != null) {
                        for (byte[] qualifier : Scanner.this.qualifiers[i]) {
                            columns.addQualifier(Bytes.wrap(qualifier));
                        }
                    }
                    scan.addColumn(columns);
                }
            }
            if (Scanner.this.filter != null) {
                scan.setFilter(FilterPB.Filter.newBuilder().setNameBytes(Bytes.wrap(Scanner.this.filter.name())).setSerializedFilter(Bytes.wrap(Scanner.this.filter.serialize())).build());
            }
            if (Scanner.this.min_timestamp != 0L || Scanner.this.max_timestamp != Long.MAX_VALUE) {
                HBasePB.TimeRange.Builder time = HBasePB.TimeRange.newBuilder();
                if (Scanner.this.min_timestamp != 0L) {
                    time.setFrom(Scanner.this.min_timestamp);
                }
                if (Scanner.this.max_timestamp != Long.MAX_VALUE) {
                    time.setTo(Scanner.this.max_timestamp);
                }
                scan.setTimeRange(time.build());
            }
            if (Scanner.this.versions != 1) {
                scan.setMaxVersions(Scanner.this.versions);
            }
            if (!Scanner.this.populate_blockcache) {
                scan.setCacheBlocks(false);
            }
            if (Scanner.this.max_num_kvs > 0) {
                scan.setBatchSize(Scanner.this.max_num_kvs);
            }
            scan.setMaxResultSize(Scanner.this.max_num_bytes);
            ClientPB.ScanRequest req = ClientPB.ScanRequest.newBuilder().setRegion(this.region.toProtobuf()).setScan(scan.build()).setNumberOfRows(Scanner.this.max_num_rows).setClientHandlesHeartbeats(false).setClientHandlesPartials(false).build();
            return OpenScannerRequest.toChannelBuffer(SCAN, (AbstractMessageLite)req);
        }

        private ChannelBuffer serializeOld(byte server_version) {
            ChannelBuffer buf = this.newBuffer(server_version, this.predictSerializedSize());
            buf.writeInt(2);
            OpenScannerRequest.writeHBaseByteArray(buf, this.region.name());
            buf.writeByte(39);
            buf.writeByte(39);
            buf.writeByte(1);
            OpenScannerRequest.writeByteArray(buf, Scanner.this.start_key);
            OpenScannerRequest.writeByteArray(buf, Scanner.this.stop_key);
            buf.writeInt(Scanner.this.versions);
            buf.writeInt(Scanner.this.max_num_kvs);
            buf.writeInt(-559039906);
            buf.writeByte(Scanner.this.populate_blockcache ? 1 : 0);
            if (Scanner.this.filter == null) {
                buf.writeByte(0);
            } else {
                buf.writeByte(1);
                Scanner.this.filter.serializeOld(buf);
            }
            buf.writeLong(Scanner.this.min_timestamp);
            buf.writeLong(Scanner.this.max_timestamp);
            buf.writeByte(Scanner.this.min_timestamp != 0L || Scanner.this.max_timestamp != Long.MAX_VALUE ? 0 : 1);
            if (Scanner.this.families != null) {
                buf.writeInt(Scanner.this.families.length);
                for (int i = 0; i < Scanner.this.families.length; ++i) {
                    OpenScannerRequest.writeByteArray(buf, Scanner.this.families[i]);
                    if (Scanner.this.qualifiers != null && Scanner.this.qualifiers[i] != null) {
                        buf.writeInt(Scanner.this.qualifiers[i].length);
                        for (byte[] qualifier : Scanner.this.qualifiers[i]) {
                            OpenScannerRequest.writeByteArray(buf, qualifier);
                        }
                        continue;
                    }
                    buf.writeInt(0);
                }
            } else {
                buf.writeInt(0);
            }
            return buf;
        }

        @Override
        Response deserialize(ChannelBuffer buf, int cell_size) {
            ClientPB.ScanResponse resp = OpenScannerRequest.readProtobuf(buf, ClientPB.ScanResponse.PARSER);
            if (!resp.hasScannerId()) {
                throw new InvalidResponseException("Scan RPC response doesn't contain a scanner ID", (Object)resp);
            }
            boolean scannerClosedOnServer = resp.hasMoreResultsInRegion() && !resp.getMoreResultsInRegion();
            return new Response(resp.getScannerId(), Scanner.this.getRows(resp, buf, cell_size), resp.getMoreResults(), scannerClosedOnServer);
        }

        @Override
        public String toString() {
            return "OpenScannerRequest(scanner=" + Scanner.this.toString() + ')';
        }
    }

    static final class Response {
        private final long scanner_id;
        private final ArrayList<ArrayList<KeyValue>> rows;
        private final boolean more;
        private final boolean scannerClosedOnServer;

        Response(long scanner_id, ArrayList<ArrayList<KeyValue>> rows, boolean more, boolean scannerClosedOnServer) {
            this.scanner_id = scanner_id;
            this.rows = rows;
            this.more = more;
            this.scannerClosedOnServer = scannerClosedOnServer;
        }

        public String toString() {
            return "Scanner$Response(scanner_id=" + Bytes.hex(this.scanner_id) + ", rows=" + this.rows + ", more=" + this.more + ", scannerClosedOnServer=" + this.scannerClosedOnServer + ")";
        }
    }
}

