/*
 * Decompiled with CFR 0.152.
 */
package org.hbase.async;

import java.lang.reflect.Constructor;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import javax.security.auth.Subject;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.hbase.async.Config;
import org.hbase.async.HBaseClient;
import org.hbase.async.RegionClient;
import org.hbase.async.auth.ClientAuthProvider;
import org.hbase.async.auth.KerberosClientAuthProvider;
import org.hbase.async.auth.SimpleClientAuthProvider;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SecureRpcHelper {
    public static final String SECURITY_AUTHENTICATION_KEY = "hbase.security.authentication";
    public static final String RPC_QOP_KEY = "hbase.rpc.protection";
    private static final Logger LOG = LoggerFactory.getLogger(SecureRpcHelper.class);
    protected final Config config;
    protected final RegionClient region_client;
    protected final String host_ip;
    protected ClientAuthProvider client_auth_provider;
    protected SaslClient sasl_client;
    protected boolean use_wrap;

    public SecureRpcHelper(HBaseClient hbase_client, RegionClient region_client, SocketAddress remote_endpoint) {
        this.config = hbase_client.getConfig();
        this.host_ip = ((InetSocketAddress)remote_endpoint).getAddress().getHostAddress();
        this.region_client = region_client;
        this.initSecureClientProvider(hbase_client);
    }

    private void initSecureClientProvider(HBaseClient hbase_client) {
        String mechanism;
        String string = mechanism = this.config.hasProperty(SECURITY_AUTHENTICATION_KEY) ? this.config.getString(SECURITY_AUTHENTICATION_KEY) : "simple";
        if ("simple".equalsIgnoreCase(mechanism)) {
            this.client_auth_provider = new SimpleClientAuthProvider(hbase_client);
            this.use_wrap = false;
            return;
        }
        if ("kerberos".equalsIgnoreCase(mechanism)) {
            this.client_auth_provider = new KerberosClientAuthProvider(hbase_client);
        } else {
            try {
                Class<?> clazz = Class.forName(mechanism);
                Constructor<?> ctor = clazz.getConstructor(HBaseClient.class);
                this.client_auth_provider = (ClientAuthProvider)ctor.newInstance(hbase_client);
                LOG.info("Successfully instantiated a security provider of type: " + clazz.getCanonicalName());
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to load specified SecureClientProvider: " + mechanism, e);
            }
        }
        String qop = this.parseQOP();
        this.use_wrap = qop != null && !"auth".equalsIgnoreCase(qop);
        HashMap<String, String> props = new HashMap<String, String>(2);
        props.put("javax.security.sasl.qop", this.parseQOP());
        props.put("javax.security.sasl.server.authentication", "true");
        this.sasl_client = this.client_auth_provider.newSaslClient(this.host_ip, props);
    }

    private String parseQOP() {
        String protection;
        String string = protection = this.config.hasProperty(RPC_QOP_KEY) ? this.config.getString(RPC_QOP_KEY) : "authentication";
        if ("integrity".equalsIgnoreCase(protection)) {
            return "auth-int";
        }
        if ("privacy".equalsIgnoreCase(protection)) {
            return "auth-conf";
        }
        if ("authentication".equalsIgnoreCase(protection)) {
            return "auth";
        }
        throw new IllegalArgumentException("Unrecognized rpc protection level: " + protection);
    }

    public ChannelBuffer unwrap(ChannelBuffer payload) {
        if (!this.use_wrap) {
            return payload;
        }
        int len = payload.readInt();
        try {
            ChannelBuffer unwrapped = ChannelBuffers.wrappedBuffer((byte[])this.sasl_client.unwrap(payload.readBytes(len).array(), 0, len));
            return unwrapped;
        }
        catch (SaslException e) {
            throw new IllegalStateException("Failed to unwrap payload", e);
        }
    }

    public ChannelBuffer wrap(ChannelBuffer content) {
        if (!this.use_wrap) {
            return content;
        }
        try {
            byte[] payload = new byte[content.readableBytes()];
            content.readBytes(payload);
            byte[] wrapped = this.sasl_client.wrap(payload, 0, payload.length);
            ChannelBuffer ret = ChannelBuffers.wrappedBuffer((byte[])new byte[4 + wrapped.length]);
            ret.clear();
            ret.writeInt(wrapped.length);
            ret.writeBytes(wrapped);
            return ret;
        }
        catch (SaslException e) {
            throw new IllegalStateException("Failed to wrap payload", e);
        }
    }

    public abstract void sendHello(Channel var1);

    public abstract ChannelBuffer handleResponse(ChannelBuffer var1, Channel var2);

    protected byte[] processChallenge(final byte[] b) {
        try {
            final class PrivilegedAction
            implements PrivilegedExceptionAction<byte[]> {
                PrivilegedAction() {
                }

                @Override
                public byte[] run() {
                    try {
                        return SecureRpcHelper.this.sasl_client.evaluateChallenge(b);
                    }
                    catch (SaslException e) {
                        LOG.error("Failed Sasl challenge", (Throwable)e);
                        return null;
                    }
                }

                public String toString() {
                    return "evaluate sasl challenge";
                }
            }
            return Subject.doAs(this.client_auth_provider.getClientSubject(), new PrivilegedAction());
        }
        catch (PrivilegedActionException e) {
            throw new IllegalStateException("Failed to process challenge", e);
        }
    }
}

