/*
 * Decompiled with CFR 0.152.
 */
package org.hbase.async;

import com.google.protobuf.AbstractMessageLite;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.hbase.async.Bytes;
import org.hbase.async.GetRequest;
import org.hbase.async.HBaseClient;
import org.hbase.async.HBaseException;
import org.hbase.async.HBaseRpc;
import org.hbase.async.KeyValue;
import org.hbase.async.NotServingRegionException;
import org.hbase.async.RegionClient;
import org.hbase.async.RegionInfo;
import org.hbase.async.generated.ClientPB;
import org.hbase.async.generated.FilterPB;
import org.hbase.async.generated.HBasePB;
import org.jboss.netty.buffer.ChannelBuffer;

final class BatchGet
extends HBaseRpc {
    private static final byte[] EMPTY_BYTES = new byte[]{0};
    private static final byte[] MULTI = new byte[]{109, 117, 108, 116, 105};
    private static final byte[] MMULTI = new byte[]{77, 117, 108, 116, 105};
    private final ArrayList<ActionEntry> batch = new ArrayList();
    static final RegionComparator SORT_BY_REGION = new RegionComparator();
    static final RegionComparator REGION_CMP = new RegionComparator();

    BatchGet() {
    }

    @Override
    byte[] method(byte server_version) {
        if (server_version < 95) {
            return MULTI;
        }
        return MMULTI;
    }

    void add(GetRequest rpc) {
        this.batch.add(new ActionEntry(rpc, this.batch.size()));
    }

    void add(ActionEntry rpcEntry) {
        this.batch.add(rpcEntry);
    }

    ArrayList<ActionEntry> actionEntries() {
        return this.batch;
    }

    private int predictSerializedSize(byte server_version) {
        int size = 0;
        size += 4;
        ++size;
        ++size;
        size += 4;
        byte[] prev_region = EMPTY_BYTES;
        for (ActionEntry entry : this.batch) {
            boolean new_region;
            GetRequest req = entry.rpc;
            byte[] region_name = req.getRegion().name();
            boolean bl = new_region = !Bytes.equals(prev_region, region_name);
            if (new_region) {
                size += 3;
                size += region_name.length;
                size += 4;
                prev_region = req.getRegion().name();
            }
            ++size;
            ++size;
            ++size;
            ++size;
            size += req.predictSerializedSize(server_version);
            size += 4;
            size += 3;
        }
        return size;
    }

    @Override
    ChannelBuffer serialize(byte server_version) {
        if (server_version < 95) {
            return this.serializeOld(server_version);
        }
        Collections.sort(this.batch, SORT_BY_REGION);
        ClientPB.MultiRequest.Builder req = ClientPB.MultiRequest.newBuilder();
        ClientPB.RegionAction.Builder actions = null;
        byte[] prev_region = HBaseClient.EMPTY_ARRAY;
        int i = 0;
        for (ActionEntry actionEntry : this.batch) {
            int versions;
            boolean new_region;
            GetRequest rpc = actionEntry.rpc;
            RegionInfo region = rpc.getRegion();
            boolean bl = new_region = !Bytes.equals(prev_region, region.name());
            if (new_region) {
                if (actions != null) {
                    req.addRegionAction(actions.build());
                }
                actions = ClientPB.RegionAction.newBuilder();
                actions.setRegion(rpc.getRegion().toProtobuf());
                prev_region = region.name();
            }
            ClientPB.Get.Builder getpb = ClientPB.Get.newBuilder().setRow(Bytes.wrap(rpc.key()));
            if (rpc.family() != null) {
                ClientPB.Column.Builder column = ClientPB.Column.newBuilder();
                column.setFamily(Bytes.wrap(rpc.family()));
                if (rpc.qualifiers() != null) {
                    for (byte[] qualifier : rpc.qualifiers()) {
                        column.addQualifier(Bytes.wrap(qualifier));
                    }
                }
                getpb.addColumn(column.build());
            }
            if (rpc.getFilter() != null) {
                getpb.setFilter(FilterPB.Filter.newBuilder().setNameBytes(Bytes.wrap(rpc.getFilter().name())).setSerializedFilter(Bytes.wrap(rpc.getFilter().serialize())).build());
            }
            long min_ts = rpc.getMinTimestamp();
            long max_ts = rpc.getMaxTimestamp();
            if (min_ts != 0L || max_ts != Long.MAX_VALUE) {
                HBasePB.TimeRange.Builder time = HBasePB.TimeRange.newBuilder();
                if (min_ts != 0L) {
                    time.setFrom(min_ts);
                }
                if (max_ts != Long.MAX_VALUE) {
                    time.setTo(max_ts);
                }
                getpb.setTimeRange(time.build());
            }
            if ((versions = rpc.maxVersions()) != 1) {
                getpb.setMaxVersions(versions);
            }
            if (!rpc.isGetRequest()) {
                getpb.setExistenceOnly(true);
            }
            ClientPB.Action action = ClientPB.Action.newBuilder().setIndex(i++).setGet(getpb).build();
            actions.addAction(action);
        }
        req.addRegionAction(actions.build());
        return BatchGet.toChannelBuffer(MMULTI, (AbstractMessageLite)req.build());
    }

    private ChannelBuffer serializeOld(byte server_version) {
        Collections.sort(this.batch, REGION_CMP);
        ChannelBuffer buf = this.newBuffer(server_version, this.predictSerializedSize(server_version));
        buf.writeInt(1);
        buf.writeByte(66);
        buf.writeByte(66);
        int nregion_index = buf.writerIndex();
        buf.writeInt(0);
        byte[] prev_region = EMPTY_BYTES;
        int nregions = 0;
        int ngets_index = 0;
        int ngets = 0;
        int i = 0;
        for (ActionEntry entry : this.batch) {
            boolean new_region;
            GetRequest req = entry.rpc;
            byte[] region_name = req.getRegion().name();
            boolean bl = new_region = !Bytes.equals(prev_region, region_name);
            if (new_region) {
                if (ngets_index > 0) {
                    buf.setInt(ngets_index, ngets);
                    ngets = 0;
                }
                BatchGet.writeByteArray(buf, region_name);
                ngets_index = buf.writerIndex();
                buf.writeInt(0);
                prev_region = region_name;
                ++nregions;
            }
            buf.writeByte(65);
            buf.writeByte(65);
            buf.writeByte(64);
            buf.writeByte(32);
            req.serializePayloadInto(server_version, buf);
            buf.writeInt(i);
            BatchGet.writeHBaseNull(buf);
            ++ngets;
            ++i;
        }
        if (ngets_index > 0) {
            buf.setInt(ngets_index, ngets);
        }
        buf.setInt(nregion_index, nregions);
        return buf;
    }

    @Override
    Object deserialize(ChannelBuffer buf, int cell_size) {
        ClientPB.MultiResponse multiResp = BatchGet.readProtobuf(buf, ClientPB.MultiResponse.PARSER);
        int nregions = multiResp.getRegionActionResultCount();
        int nrpcs = this.batch.size();
        int n = 0;
        boolean r = false;
        Object kvs = null;
        boolean kv_index = false;
        ActionResp[] resps = new ActionResp[this.batch.size()];
        for (int i = 0; i < nregions; ++i) {
            ClientPB.RegionActionResult results = multiResp.getRegionActionResult(i);
            int nresults = results.getResultOrExceptionCount();
            for (int j = 0; j < nresults; ++j) {
                Serializable resp;
                ClientPB.ResultOrException roe = results.getResultOrException(j);
                int index = roe.getIndex();
                ActionEntry actionEntry = this.batch.get(index);
                if (roe.hasException()) {
                    HBasePB.NameBytesPair pair = roe.getException();
                    resp = RegionClient.decodeExceptionPair(this.batch.get((int)index).rpc, pair);
                } else {
                    int kvCount = roe.getResult().getAssociatedCellCount();
                    resp = BatchGet.convertResult(roe.getResult(), buf, kvCount);
                }
                resps[n++] = new ActionResp(resp, actionEntry.order);
            }
        }
        return resps;
    }

    static ArrayList<KeyValue> convertResult(ClientPB.Result res, ChannelBuffer buf, int kvCount) {
        int i;
        int size = res.getCellCount();
        ArrayList<KeyValue> rows = new ArrayList<KeyValue>(size + kvCount);
        KeyValue kv = null;
        for (i = 0; i < size; ++i) {
            kv = KeyValue.fromCell(res.getCell(i), kv);
            rows.add(kv);
        }
        for (i = 0; i < kvCount; ++i) {
            int kv_length = buf.readInt();
            kv = KeyValue.fromBuffer(buf, kv);
            rows.add(kv);
        }
        return rows;
    }

    @Override
    public String toString() {
        int i;
        StringBuilder buf = new StringBuilder();
        buf.append("BatchGet(batch=[");
        int nrpcs = this.batch.size();
        for (i = 0; i < nrpcs && buf.length() < 1024; ++i) {
            buf.append(this.batch.get(i)).append(", ");
        }
        if (i < nrpcs) {
            if (i == nrpcs - 1) {
                buf.append("... 1 RPC not shown])");
            } else {
                buf.append("... ").append(nrpcs - 1 - i).append(" RPCs not shown ..., ").append(this.batch.get(nrpcs - 1)).append("])");
            }
        } else {
            buf.setLength(buf.length() - 2);
            buf.append("])");
        }
        return buf.toString();
    }

    ActionResp[] decodeMultiResponse(ChannelBuffer buf) {
        byte code = buf.readByte();
        int nregions = buf.readInt();
        HBaseRpc.checkNonEmptyArrayLength(buf, nregions);
        ActionResp[] resps = new ActionResp[this.batch.size()];
        int n = 0;
        for (int i = 0; i < nregions; ++i) {
            byte[] region_name = HBaseRpc.readByteArray(buf);
            int nrpcs = buf.readInt();
            HBaseRpc.checkNonEmptyArrayLength(buf, nrpcs);
            for (int j = 0; j < nrpcs; ++j) {
                Object resp;
                boolean error;
                int nrpcs_index = buf.readInt();
                ActionEntry entry = this.batch.get(nrpcs_index);
                boolean bl = error = buf.readByte() != 0;
                if (error) {
                    HBaseException e = RegionClient.deserializeException(buf, entry.rpc);
                    resp = e;
                } else {
                    resp = RegionClient.deserializeObject(buf, this);
                    if (resp == null) {
                        resp = new NotServingRegionException("Not serving region: " + Bytes.pretty(region_name), entry.rpc);
                    }
                }
                resps[n++] = new ActionResp(resp, entry.order);
            }
        }
        return resps;
    }

    static class ActionResp {
        Object result;
        int order;

        ActionResp(Object result, int order) {
            this.result = result;
            this.order = order;
        }
    }

    private static final class RegionComparator
    implements Comparator<ActionEntry> {
        private RegionComparator() {
        }

        @Override
        public int compare(ActionEntry a, ActionEntry b) {
            return Bytes.memcmp(a.rpc.getRegion().name(), b.rpc.getRegion().name());
        }
    }

    static class ActionEntry {
        GetRequest rpc;
        int order;

        ActionEntry(GetRequest rpc, int order) {
            this.rpc = rpc;
            this.order = order;
        }
    }
}

