/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.config.annotation;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.hdiv.application.ApplicationHDIV;
import org.hdiv.application.IApplication;
import org.hdiv.cipher.CipherHTTP;
import org.hdiv.cipher.ICipherHTTP;
import org.hdiv.cipher.IKeyFactory;
import org.hdiv.cipher.KeyFactory;
import org.hdiv.config.HDIVConfig;
import org.hdiv.config.StartPage;
import org.hdiv.config.annotation.ExclusionRegistry;
import org.hdiv.config.annotation.LongLivingPagesRegistry;
import org.hdiv.config.annotation.RuleRegistry;
import org.hdiv.config.annotation.ValidationConfigurer;
import org.hdiv.config.annotation.builders.SecurityConfigBuilder;
import org.hdiv.config.annotation.grails.GrailsConfigurationSupport;
import org.hdiv.config.annotation.jsf.JsfConfigurationSupport;
import org.hdiv.config.annotation.springmvc.SpringMvcConfigurationSupport;
import org.hdiv.config.annotation.struts1.Struts1ConfigurationSupport;
import org.hdiv.config.annotation.thymeleaf.ThymeleafConfigurationSupport;
import org.hdiv.config.validations.DefaultValidationParser;
import org.hdiv.dataComposer.DataComposerFactory;
import org.hdiv.dataValidator.DataValidator;
import org.hdiv.dataValidator.IDataValidator;
import org.hdiv.dataValidator.ValidationResult;
import org.hdiv.filter.DefaultValidatorErrorHandler;
import org.hdiv.filter.IValidationHelper;
import org.hdiv.filter.ValidatorErrorHandler;
import org.hdiv.filter.ValidatorHelperRequest;
import org.hdiv.idGenerator.PageIdGenerator;
import org.hdiv.idGenerator.RandomGuidUidGenerator;
import org.hdiv.idGenerator.SequentialPageIdGenerator;
import org.hdiv.idGenerator.UidGenerator;
import org.hdiv.init.DefaultRequestInitializer;
import org.hdiv.init.DefaultServletContextInitializer;
import org.hdiv.init.DefaultSessionInitializer;
import org.hdiv.init.RequestInitializer;
import org.hdiv.init.ServletContextInitializer;
import org.hdiv.init.SessionInitializer;
import org.hdiv.logs.IUserData;
import org.hdiv.logs.Logger;
import org.hdiv.logs.UserData;
import org.hdiv.regex.PatternMatcher;
import org.hdiv.regex.PatternMatcherFactory;
import org.hdiv.session.ISession;
import org.hdiv.session.IStateCache;
import org.hdiv.session.SessionHDIV;
import org.hdiv.session.StateCache;
import org.hdiv.state.StateUtil;
import org.hdiv.state.scope.AppStateScope;
import org.hdiv.state.scope.DefaultStateScopeManager;
import org.hdiv.state.scope.StateScopeManager;
import org.hdiv.state.scope.UserSessionStateScope;
import org.hdiv.urlProcessor.BasicUrlProcessor;
import org.hdiv.urlProcessor.FormUrlProcessor;
import org.hdiv.urlProcessor.LinkUrlProcessor;
import org.hdiv.util.EncodingUtil;
import org.hdiv.validator.DefaultEditableDataValidationProvider;
import org.hdiv.validator.DefaultValidationRepository;
import org.hdiv.validator.EditableDataValidationProvider;
import org.hdiv.validator.IValidation;
import org.hdiv.validator.Validation;
import org.hdiv.validator.ValidationRepository;
import org.hdiv.validator.ValidationTarget;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Scope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Import(value={SpringMvcConfigurationSupport.class, ThymeleafConfigurationSupport.class, GrailsConfigurationSupport.class, JsfConfigurationSupport.class, Struts1ConfigurationSupport.class})
public abstract class HdivWebSecurityConfigurationSupport {
    @Bean
    public HDIVConfig hdivConfig() {
        SecurityConfigBuilder securityConfigBuilder = this.securityConfigBuilder();
        this.configure(securityConfigBuilder);
        HDIVConfig config = securityConfigBuilder.build();
        config.setEditableDataValidationProvider(this.editableDataValidationProvider());
        ExclusionRegistry exclusionRegistry = new ExclusionRegistry(this.patternMatcherFactory());
        this.addExclusions(exclusionRegistry);
        List<StartPage> exclusions = exclusionRegistry.getUrlExclusions();
        config.setUserStartPages(exclusions);
        List<String> paramExclusions = exclusionRegistry.getParamExclusions();
        config.setUserStartParameters(paramExclusions);
        Map<String, List<String>> paramsWithoutValidation = exclusionRegistry.getParamExclusionsForUrl();
        config.setParamsWithoutValidation(paramsWithoutValidation);
        LongLivingPagesRegistry longLivingPagesRegistry = new LongLivingPagesRegistry();
        this.addLongLivingPages(longLivingPagesRegistry);
        Map<String, String> longLivingPages = longLivingPagesRegistry.getLongLivingPages();
        config.setLongLivingPages(longLivingPages);
        return config;
    }

    @Bean
    protected SecurityConfigBuilder securityConfigBuilder() {
        SecurityConfigBuilder builder = new SecurityConfigBuilder(this.patternMatcherFactory());
        return builder;
    }

    abstract void configure(SecurityConfigBuilder var1);

    abstract void addExclusions(ExclusionRegistry var1);

    abstract void addLongLivingPages(LongLivingPagesRegistry var1);

    @Bean
    public IApplication securityApplication() {
        ApplicationHDIV application = new ApplicationHDIV();
        return application;
    }

    @Bean
    public ValidationResult validationResult() {
        ValidationResult result = new ValidationResult();
        return result;
    }

    @Bean
    public PatternMatcherFactory patternMatcherFactory() {
        PatternMatcherFactory patternMatcherFactory = new PatternMatcherFactory();
        return patternMatcherFactory;
    }

    @Bean
    public UidGenerator uidGenerator() {
        RandomGuidUidGenerator uidGenerator = new RandomGuidUidGenerator();
        return uidGenerator;
    }

    @Bean
    @Scope(value="prototype")
    public PageIdGenerator pageIdGenerator() {
        SequentialPageIdGenerator pageIdGenerator = new SequentialPageIdGenerator();
        return pageIdGenerator;
    }

    @Bean
    public IKeyFactory keyFactory() {
        KeyFactory keyFactory = new KeyFactory();
        SecurityConfigBuilder builder = this.securityConfigBuilder();
        SecurityConfigBuilder.CipherConfigure config = builder.getCipherConfigure();
        if (config.getAlgorithm() != null) {
            keyFactory.setAlgorithm(config.getAlgorithm());
        }
        if (config.getKeySize() > 0) {
            keyFactory.setKeySize(config.getKeySize());
        }
        if (config.getPrngAlgorithm() != null) {
            keyFactory.setPrngAlgorithm(config.getPrngAlgorithm());
        }
        if (config.getProvider() != null) {
            keyFactory.setProvider(config.getProvider());
        }
        return keyFactory;
    }

    @Bean
    public IUserData securityUserData() {
        UserData userData = new UserData();
        return userData;
    }

    @Bean
    public Logger securityLogger() {
        Logger logger = new Logger();
        logger.setUserData(this.securityUserData());
        return logger;
    }

    @Bean
    public ValidatorErrorHandler validatorErrorHandler() {
        DefaultValidatorErrorHandler validatorErrorHandler = new DefaultValidatorErrorHandler();
        validatorErrorHandler.setUserData(this.securityUserData());
        validatorErrorHandler.setConfig(this.hdivConfig());
        return validatorErrorHandler;
    }

    @Bean
    @Scope(value="prototype")
    public IStateCache stateCache() {
        SecurityConfigBuilder builder = this.securityConfigBuilder();
        int maxPagesPerSession = builder.getMaxPagesPerSession();
        StateCache stateCache = new StateCache();
        if (maxPagesPerSession > 0) {
            stateCache.setMaxSize(maxPagesPerSession);
        }
        return stateCache;
    }

    @Bean
    public ISession securitySession() {
        SessionHDIV session = new SessionHDIV();
        return session;
    }

    @Bean
    public EncodingUtil encodingUtil() {
        EncodingUtil encodingUtil = new EncodingUtil();
        encodingUtil.setSession(this.securitySession());
        encodingUtil.init();
        return encodingUtil;
    }

    @Bean
    @Scope(value="prototype")
    public ICipherHTTP cipherHTTP() {
        SecurityConfigBuilder builder = this.securityConfigBuilder();
        SecurityConfigBuilder.CipherConfigure config = builder.getCipherConfigure();
        CipherHTTP cipherHTTP = new CipherHTTP();
        if (config.getProvider() != null) {
            cipherHTTP.setProvider(config.getProvider());
        }
        if (config.getTransformation() != null) {
            cipherHTTP.setTransformation(config.getTransformation());
        }
        cipherHTTP.init();
        return cipherHTTP;
    }

    @Bean
    public StateUtil stateUtil() {
        StateUtil stateUtil = new StateUtil();
        stateUtil.setEncodingUtil(this.encodingUtil());
        stateUtil.setConfig(this.hdivConfig());
        stateUtil.setSession(this.securitySession());
        stateUtil.setStateScopeManager(this.stateScopeManager());
        stateUtil.init();
        return stateUtil;
    }

    @Bean
    public IDataValidator dataValidator() {
        DataValidator dataValidator = new DataValidator();
        dataValidator.setConfig(this.hdivConfig());
        return dataValidator;
    }

    @Bean
    public StateScopeManager stateScopeManager() {
        ArrayList<Object> stateScopes = new ArrayList<Object>();
        stateScopes.add(this.userSessionStateScope());
        stateScopes.add(this.appStateScope());
        DefaultStateScopeManager scopeManager = new DefaultStateScopeManager(stateScopes);
        return scopeManager;
    }

    @Bean
    public UserSessionStateScope userSessionStateScope() {
        return new UserSessionStateScope();
    }

    @Bean
    public AppStateScope appStateScope() {
        return new AppStateScope();
    }

    @Bean
    public DataComposerFactory dataComposerFactory() {
        DataComposerFactory dataComposerFactory = new DataComposerFactory();
        dataComposerFactory.setConfig(this.hdivConfig());
        dataComposerFactory.setSession(this.securitySession());
        dataComposerFactory.setEncodingUtil(this.encodingUtil());
        dataComposerFactory.setStateUtil(this.stateUtil());
        dataComposerFactory.setUidGenerator(this.uidGenerator());
        dataComposerFactory.setStateScopeManager(this.stateScopeManager());
        return dataComposerFactory;
    }

    @Bean
    public IValidationHelper requestValidationHelper() {
        ValidatorHelperRequest validatorHelperRequest = new ValidatorHelperRequest();
        validatorHelperRequest.setLogger(this.securityLogger());
        validatorHelperRequest.setStateUtil(this.stateUtil());
        validatorHelperRequest.setHdivConfig(this.hdivConfig());
        validatorHelperRequest.setSession(this.securitySession());
        validatorHelperRequest.setDataValidator(this.dataValidator());
        validatorHelperRequest.setUrlProcessor(this.basicUrlProcessor());
        validatorHelperRequest.setDataComposerFactory(this.dataComposerFactory());
        validatorHelperRequest.setStateScopeManager(this.stateScopeManager());
        validatorHelperRequest.init();
        return validatorHelperRequest;
    }

    @Bean
    public RequestInitializer securityRequestInitializer() {
        DefaultRequestInitializer requestInitializer = new DefaultRequestInitializer();
        requestInitializer.setConfig(this.hdivConfig());
        return requestInitializer;
    }

    @Bean
    public ServletContextInitializer securityServletContextInitializer() {
        DefaultServletContextInitializer servletContextInitializer = new DefaultServletContextInitializer();
        servletContextInitializer.setConfig(this.hdivConfig());
        servletContextInitializer.setApplication(this.securityApplication());
        servletContextInitializer.setFormUrlProcessor(this.formUrlProcessor());
        servletContextInitializer.setLinkUrlProcessor(this.linkUrlProcessor());
        return servletContextInitializer;
    }

    @Bean
    public SessionInitializer securitySessionInitializer() {
        DefaultSessionInitializer sessionInitializer = new DefaultSessionInitializer();
        sessionInitializer.setConfig(this.hdivConfig());
        return sessionInitializer;
    }

    @Bean
    public LinkUrlProcessor linkUrlProcessor() {
        LinkUrlProcessor linkUrlProcessor = new LinkUrlProcessor();
        linkUrlProcessor.setConfig(this.hdivConfig());
        return linkUrlProcessor;
    }

    @Bean
    public FormUrlProcessor formUrlProcessor() {
        FormUrlProcessor formUrlProcessor = new FormUrlProcessor();
        formUrlProcessor.setConfig(this.hdivConfig());
        return formUrlProcessor;
    }

    @Bean
    public BasicUrlProcessor basicUrlProcessor() {
        BasicUrlProcessor basicUrlProcessor = new BasicUrlProcessor();
        basicUrlProcessor.setConfig(this.hdivConfig());
        return basicUrlProcessor;
    }

    @Bean
    public EditableDataValidationProvider editableDataValidationProvider() {
        DefaultEditableDataValidationProvider provider = new DefaultEditableDataValidationProvider();
        provider.setValidationRepository(this.editableValidationRepository());
        return provider;
    }

    @Bean
    public ValidationRepository editableValidationRepository() {
        List<IValidation> defaultRules = this.defaultRules();
        RuleRegistry registry = new RuleRegistry();
        this.addRules(registry);
        Map<String, IValidation> registeredRules = registry.getRules();
        PatternMatcherFactory patternMatcherFactory = this.patternMatcherFactory();
        ValidationConfigurer validationConfigurer = new ValidationConfigurer();
        this.configureEditableValidation(validationConfigurer);
        List<ValidationConfigurer.ValidationConfig> validationConfigs = validationConfigurer.getValidationConfigs();
        LinkedHashMap validationsData = new LinkedHashMap();
        for (ValidationConfigurer.ValidationConfig validationConfig : validationConfigs) {
            String urlPattern = validationConfig.getUrlPattern();
            ValidationConfigurer.ValidationConfig.EditableValidationConfigurer editableValidationConfigurer = validationConfig.getEditableValidationConfigurer();
            boolean useDefaultRules = editableValidationConfigurer.isDefaultRules();
            List<String> selectedRules = editableValidationConfigurer.getRules();
            List<String> selectedParams = editableValidationConfigurer.getParameters();
            ArrayList<IValidation> activeRules = new ArrayList<IValidation>();
            for (String ruleName : selectedRules) {
                IValidation val = registeredRules.get(ruleName);
                if (val == null) {
                    throw new BeanInitializationException("Rule with name '" + ruleName + "' not registered.");
                }
                activeRules.add(val);
            }
            if (useDefaultRules) {
                activeRules.addAll(defaultRules);
            }
            ValidationTarget target = new ValidationTarget();
            PatternMatcher urlMatcher = patternMatcherFactory.getPatternMatcher(urlPattern);
            ArrayList<PatternMatcher> paramMatchers = new ArrayList<PatternMatcher>();
            for (String param : selectedParams) {
                PatternMatcher matcher = patternMatcherFactory.getPatternMatcher(param);
                paramMatchers.add(matcher);
            }
            target.setUrl(urlMatcher);
            target.setParams(paramMatchers);
            validationsData.put(target, activeRules);
        }
        DefaultValidationRepository repository = new DefaultValidationRepository();
        repository.setValidations(validationsData);
        return repository;
    }

    abstract void addRules(RuleRegistry var1);

    abstract void configureEditableValidation(ValidationConfigurer var1);

    private List<IValidation> defaultRules() {
        DefaultValidationParser parser = new DefaultValidationParser();
        parser.readDefaultValidations();
        List<Map<String, String>> validations = parser.getValidations();
        ArrayList<IValidation> defaultRules = new ArrayList<IValidation>();
        for (Map<String, String> validation : validations) {
            String id = validation.get("id");
            String regex = validation.get("regex");
            Validation validationBean = new Validation();
            validationBean.setName(id);
            validationBean.setDefaultValidation(true);
            validationBean.setRejectedPattern(regex);
            defaultRules.add((IValidation)validationBean);
        }
        return defaultRules;
    }
}

