/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.config.validations;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.hdiv.exception.HDIVException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultValidationParser
extends DefaultHandler {
    private static final String DEFAULT_VALIDATION_PATH = "org/hdiv/config/validations/defaultEditableValidations.xml";
    private List<Map<String, String>> validations = new ArrayList<Map<String, String>>();
    private Map<String, String> validation = null;

    public void readDefaultValidations() {
        this.readDefaultValidations(DEFAULT_VALIDATION_PATH);
    }

    public void readDefaultValidations(String filePath) {
        try {
            ClassLoader classLoader = DefaultValidationParser.class.getClassLoader();
            InputStream is = classLoader.getResourceAsStream(filePath);
            SAXParserFactory spf = SAXParserFactory.newInstance();
            SAXParser sp = spf.newSAXParser();
            sp.parse(is, (DefaultHandler)this);
        }
        catch (ParserConfigurationException e) {
            throw new HDIVException(e.getMessage(), (Throwable)e);
        }
        catch (SAXException e) {
            throw new HDIVException(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new HDIVException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (qName != null && qName.equals("validation")) {
            this.validation = new HashMap<String, String>();
            String id = attributes.getValue("id");
            this.validation.put("id", id);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName != null && qName.equals("validation") && this.validation != null) {
            this.validations.add(this.validation);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String val = new String(ch, start, length).trim();
        if (val.length() > 0) {
            this.validation.put("regex", val);
        }
    }

    public List<Map<String, String>> getValidations() {
        return this.validations;
    }
}

