/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.config.annotation;

import java.util.List;
import javax.annotation.PostConstruct;
import org.hdiv.config.annotation.ExclusionRegistry;
import org.hdiv.config.annotation.HdivWebSecurityConfigurationSupport;
import org.hdiv.config.annotation.LongLivingPagesRegistry;
import org.hdiv.config.annotation.RuleRegistry;
import org.hdiv.config.annotation.ValidationConfigurer;
import org.hdiv.config.annotation.builders.SecurityConfigBuilder;
import org.hdiv.config.annotation.configuration.HdivWebSecurityConfigurer;
import org.hdiv.config.annotation.configuration.HdivWebSecurityConfigurerComposite;
import org.hdiv.exception.HDIVException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.SpringVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Configuration
public class DelegatingHdivWebSecurityConfiguration
extends HdivWebSecurityConfigurationSupport {
    protected static final String MIN_SPRING_VERSION = "4.0.0.RELEASE";
    private final HdivWebSecurityConfigurerComposite configurers = new HdivWebSecurityConfigurerComposite();

    @PostConstruct
    public void performVersionChecks() {
        String springVersion = SpringVersion.getVersion();
        if (springVersion != null && springVersion.compareTo(MIN_SPRING_VERSION) < 0) {
            throw new HDIVException("HDIV JavaConfig feature require Spring version equal or greater than 4.0.0.RELEASE. Use XML configuration instead of JavaConfig or update Spring version.");
        }
    }

    @Autowired(required=false)
    public void setConfigurers(List<HdivWebSecurityConfigurer> configurers) {
        if (configurers == null || configurers.isEmpty()) {
            return;
        }
        this.configurers.addHdivSecurityConfigurers(configurers);
    }

    @Override
    public void addExclusions(ExclusionRegistry registry) {
        this.configurers.addExclusions(registry);
    }

    @Override
    public void addLongLivingPages(LongLivingPagesRegistry registry) {
        this.configurers.addLongLivingPages(registry);
    }

    @Override
    public void addRules(RuleRegistry registry) {
        this.configurers.addRules(registry);
    }

    @Override
    public void configureEditableValidation(ValidationConfigurer validationConfigurer) {
        this.configurers.configureEditableValidation(validationConfigurer);
    }

    @Override
    public void configure(SecurityConfigBuilder securityConfigBuilder) {
        this.configurers.configure(securityConfigBuilder);
    }
}

