/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.config.annotation;

import org.hdiv.validator.Validation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class RuleRegistration {
    private static final Logger log = LoggerFactory.getLogger(RuleRegistration.class);
    private final Validation validation = new Validation();

    public RuleRegistration(String name) {
        this.validation.setName(name);
    }

    public RuleRegistration componentType(String componentType) {
        Assert.notNull((Object)componentType, (String)"Component type is required");
        this.validation.setComponentType(componentType);
        return this;
    }

    public RuleRegistration acceptedPattern(String acceptedPattern) {
        Assert.notNull((Object)acceptedPattern, (String)"Accepted pattern is required");
        if (this.validation.getAcceptedPattern() != null) {
            log.warn("Can't add more than one acceptedPattern per rule. This will overwrite the previous one.");
        }
        this.validation.setAcceptedPattern(acceptedPattern);
        return this;
    }

    public RuleRegistration rejectedPattern(String rejectedPattern) {
        Assert.notNull((Object)rejectedPattern, (String)"Rejected pattern is required");
        if (this.validation.getRejectedPattern() != null) {
            log.warn("Can't add more than one rejectedPattern per rule. This will overwrite the previous one.");
        }
        this.validation.setRejectedPattern(rejectedPattern);
        return this;
    }

    protected Validation getRule() {
        return this.validation;
    }
}

