/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.config.annotation.configuration;

import org.hdiv.config.annotation.springmvc.SpringMvcConfigurationSupport;
import org.hdiv.urlProcessor.FormUrlProcessor;
import org.hdiv.urlProcessor.LinkUrlProcessor;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.security.web.servlet.support.csrf.CsrfRequestDataValueProcessor;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigTools {
    public static final boolean springSecurityPresent = ClassUtils.isPresent((String)"org.springframework.security.web.servlet.support.csrf.CsrfRequestDataValueProcessor", (ClassLoader)SpringMvcConfigurationSupport.class.getClassLoader());

    private ConfigTools() {
    }

    public static BeanDefinitionRegistryPostProcessor requestDataValueProcessorPostProcessor(final Class<?> processorClass) {
        return new BeanDefinitionRegistryPostProcessor(){

            public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
            }

            public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) {
                try {
                    registry.removeBeanDefinition("requestDataValueProcessor");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                RootBeanDefinition processor = new RootBeanDefinition(processorClass);
                processor.getPropertyValues().addPropertyValue("formUrlProcessor", (Object)registry.getBeanDefinition(StringUtils.uncapitalize((String)FormUrlProcessor.class.getSimpleName())));
                processor.getPropertyValues().addPropertyValue("linkUrlProcessor", (Object)registry.getBeanDefinition(StringUtils.uncapitalize((String)LinkUrlProcessor.class.getSimpleName())));
                if (springSecurityPresent) {
                    processor.getPropertyValues().addPropertyValue("innerRequestDataValueProcessor", (Object)new RootBeanDefinition(CsrfRequestDataValueProcessor.class));
                }
                registry.registerBeanDefinition("requestDataValueProcessor", (BeanDefinition)processor);
            }
        };
    }
}

