/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.config.xml;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.hdiv.application.ApplicationHDIV;
import org.hdiv.components.support.OutcomeTargetComponentProcessor;
import org.hdiv.components.support.OutputLinkComponentProcessor;
import org.hdiv.config.HDIVConfig;
import org.hdiv.config.StartPage;
import org.hdiv.config.Strategy;
import org.hdiv.config.multipart.IMultipartConfig;
import org.hdiv.config.multipart.JsfMultipartConfig;
import org.hdiv.config.multipart.SpringMVCMultipartConfig;
import org.hdiv.config.multipart.StrutsMultipartConfig;
import org.hdiv.context.RedirectHelper;
import org.hdiv.context.RequestContextFactory;
import org.hdiv.context.RequestContextFactoryImpl;
import org.hdiv.dataComposer.DataComposerFactory;
import org.hdiv.dataValidator.DataValidator;
import org.hdiv.dataValidator.IDataValidator;
import org.hdiv.dataValidator.ValidationResult;
import org.hdiv.filter.DefaultValidationContextFactory;
import org.hdiv.filter.DefaultValidatorErrorHandler;
import org.hdiv.filter.IValidationHelper;
import org.hdiv.filter.JsfValidatorErrorHandler;
import org.hdiv.filter.JsfValidatorHelper;
import org.hdiv.filter.ValidationContextFactory;
import org.hdiv.filter.ValidatorErrorHandler;
import org.hdiv.filter.ValidatorHelperRequest;
import org.hdiv.idGenerator.PageIdGenerator;
import org.hdiv.idGenerator.RandomGuidUidGenerator;
import org.hdiv.idGenerator.SequentialPageIdGenerator;
import org.hdiv.idGenerator.UidGenerator;
import org.hdiv.init.DefaultRequestInitializer;
import org.hdiv.init.DefaultServletContextInitializer;
import org.hdiv.init.DefaultSessionInitializer;
import org.hdiv.init.RequestInitializer;
import org.hdiv.init.ServletContextInitializer;
import org.hdiv.init.SessionInitializer;
import org.hdiv.logs.IUserData;
import org.hdiv.logs.Logger;
import org.hdiv.logs.UserData;
import org.hdiv.regex.PatternMatcherFactory;
import org.hdiv.session.ISession;
import org.hdiv.session.IStateCache;
import org.hdiv.session.SessionHDIV;
import org.hdiv.session.StateCache;
import org.hdiv.state.StateUtil;
import org.hdiv.state.scope.AppStateScope;
import org.hdiv.state.scope.DefaultStateScopeManager;
import org.hdiv.state.scope.StateScopeManager;
import org.hdiv.state.scope.UserSessionStateScope;
import org.hdiv.urlProcessor.BasicUrlProcessor;
import org.hdiv.urlProcessor.FormUrlProcessor;
import org.hdiv.urlProcessor.LinkUrlProcessor;
import org.hdiv.validation.ComponentTreeValidator;
import org.hdiv.validation.DefaultComponentTreeValidator;
import org.hdiv.validator.DefaultEditableDataValidationProvider;
import org.hdiv.web.servlet.support.GrailsHdivRequestDataValueProcessor;
import org.hdiv.web.servlet.support.HdivRequestDataValueProcessor;
import org.hdiv.web.servlet.support.ThymeleafHdivRequestDataValueProcessor;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ListFactoryBean;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.core.SpringVersion;
import org.springframework.security.web.servlet.support.csrf.CsrfRequestDataValueProcessor;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigBeanDefinitionParser
implements BeanDefinitionParser {
    private static final String FORM_URL_PROCESSOR = "formUrlProcessor";
    private static final String LINK_URL_PROCESSOR = "linkUrlProcessor";
    private static final String HDIV_CONFIG = "hdivConfig";
    private static final String STATE_UTIL = "stateUtil";
    private static final String STATE_SCOPE_MANAGER = "stateScopeManager";
    private static final String SESSION = "session";
    private static final String CONFIG = "config";
    public static final String CONFIG_BEAN_NAME = HDIVConfig.class.getName();
    public static final String PATTERN_MATCHER_FACTORY_NAME = PatternMatcherFactory.class.getName();
    public static final String USER_DATA_NAME = IUserData.class.getName();
    public static final String REQUEST_DATA_VALUE_PROCESSOR_BEAN_NAME = "requestDataValueProcessor";
    protected static final String MIN_SPRING_VERSION = "4.0.0.RELEASE";
    protected final boolean springMvcPresent = ClassUtils.isPresent((String)"org.springframework.web.servlet.DispatcherServlet", (ClassLoader)ConfigBeanDefinitionParser.class.getClassLoader());
    protected final boolean grailsPresent = ClassUtils.isPresent((String)"org.codehaus.groovy.grails.web.servlet.GrailsDispatcherServlet", (ClassLoader)ConfigBeanDefinitionParser.class.getClassLoader());
    protected final boolean jsfPresent = ClassUtils.isPresent((String)"javax.faces.webapp.FacesServlet", (ClassLoader)ConfigBeanDefinitionParser.class.getClassLoader());
    protected final boolean jsf1Present = !ClassUtils.isPresent((String)"javax.faces.component.UIOutcomeTarget", (ClassLoader)ConfigBeanDefinitionParser.class.getClassLoader());
    protected final boolean thymeleafPresent = ClassUtils.isPresent((String)"org.thymeleaf.spring3.SpringTemplateEngine", (ClassLoader)ConfigBeanDefinitionParser.class.getClassLoader()) || ClassUtils.isPresent((String)"org.thymeleaf.spring4.SpringTemplateEngine", (ClassLoader)ConfigBeanDefinitionParser.class.getClassLoader());
    protected static final boolean springSecurityPresent = ClassUtils.isPresent((String)"org.springframework.security.web.servlet.support.csrf.CsrfRequestDataValueProcessor", (ClassLoader)ConfigBeanDefinitionParser.class.getClassLoader());
    protected final boolean springMvcModulePresent = ClassUtils.isPresent((String)"org.hdiv.web.servlet.support.HdivRequestDataValueProcessor", (ClassLoader)ConfigBeanDefinitionParser.class.getClassLoader());
    protected final boolean struts1ModulePresent = ClassUtils.isPresent((String)"org.hdiv.action.HDIVRequestProcessor", (ClassLoader)ConfigBeanDefinitionParser.class.getClassLoader());
    protected final boolean jsfModulePresent = ClassUtils.isPresent((String)"org.hdiv.filter.JsfValidatorHelper", (ClassLoader)ConfigBeanDefinitionParser.class.getClassLoader());
    protected List<StartPage> startPages = new ArrayList<StartPage>();
    protected Map<String, String> longLivingPages = new LinkedHashMap<String, String>();
    protected RuntimeBeanReference patternMatcherFactoryRef;
    protected RuntimeBeanReference configRef;
    protected RuntimeBeanReference sessionRef;
    protected RuntimeBeanReference applicationRef;
    protected RuntimeBeanReference uidGeneratorRef;
    protected RuntimeBeanReference stateUtilRef;
    protected RuntimeBeanReference dataValidatorRef;
    protected RuntimeBeanReference dataComposerFactoryRef;
    protected RuntimeBeanReference linkUrlProcessorRef;
    protected RuntimeBeanReference formUrlProcessorRef;
    protected RuntimeBeanReference basicUrlProcessorRef;
    protected RuntimeBeanReference loggerRef;
    protected RuntimeBeanReference userDataRef;
    protected RuntimeBeanReference stateScopeManagerRef;
    protected RuntimeBeanReference validationContextFactoryRef;
    protected RuntimeBeanReference requestContextFactoryRef;
    protected RuntimeBeanReference validatorErrorHandlerRef;

    protected boolean springVersionGrEqThan4() {
        String springVersion = SpringVersion.getVersion();
        return springVersion == null || springVersion.compareTo(MIN_SPRING_VERSION) >= 0;
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        Object source = parserContext.extractSource((Object)element);
        this.patternMatcherFactoryRef = this.createPatternMatcherFactory(source, parserContext);
        this.configRef = this.createConfigBean(element, source, parserContext);
        this.uidGeneratorRef = this.createSimpleBean(source, parserContext, RandomGuidUidGenerator.class, UidGenerator.class.getName());
        this.createPageIdGenerator(source, parserContext);
        this.userDataRef = this.createUserData(element, source, parserContext);
        this.sessionRef = this.createSession(source, parserContext);
        this.stateScopeManagerRef = this.createStateScopeManager(source, parserContext);
        this.validatorErrorHandlerRef = this.createValidatorErrorHandler(source, parserContext);
        this.loggerRef = this.createLogger(source, parserContext);
        this.createStateCache(element, source, parserContext);
        this.applicationRef = this.createSimpleBean(source, parserContext, ApplicationHDIV.class);
        this.createSimpleBean(source, parserContext, ValidationResult.class);
        this.stateUtilRef = this.createStateUtil(source, parserContext);
        this.dataValidatorRef = this.createDataValidator(source, parserContext);
        this.dataComposerFactoryRef = this.createDataComposerFactory(source, parserContext);
        this.linkUrlProcessorRef = this.createLinkUrlProcessor(source, parserContext);
        this.formUrlProcessorRef = this.createFormUrlProcessor(source, parserContext);
        this.basicUrlProcessorRef = this.createBasicUrlProcessor(source, parserContext);
        this.validationContextFactoryRef = this.createValidationContextFactory(source, parserContext);
        this.requestContextFactoryRef = this.createRequestContextFactory(source, parserContext);
        this.createRequestInitializer(source, parserContext);
        this.createServletContextInitializer(source, parserContext);
        this.createSessionInitializer(source, parserContext);
        if (this.springMvcPresent && this.springMvcModulePresent) {
            if (this.grailsPresent) {
                this.createGrailsRequestDataValueProcessor(source, parserContext);
            } else if (this.thymeleafPresent) {
                this.createThymeleafRequestDataValueProcessor(source, parserContext);
            } else {
                this.createRequestDataValueProcessor(source, parserContext);
            }
            this.createSimpleBean(source, parserContext, SpringMVCMultipartConfig.class, IMultipartConfig.class.getName());
        }
        if (this.struts1ModulePresent) {
            this.createSimpleBean(source, parserContext, StrutsMultipartConfig.class, IMultipartConfig.class.getName());
        }
        if (this.jsfPresent && this.jsfModulePresent) {
            this.createJsfValidatorHelper(source, parserContext);
            this.createSimpleBean(source, parserContext, JsfMultipartConfig.class, IMultipartConfig.class.getName());
            this.createComponentTreeValidator(source, parserContext);
            this.createRedirectHelper(source, parserContext);
            if (!this.jsf1Present) {
                this.createOutcomeTargetComponentProcessor(source, parserContext);
            }
            this.createOutputLinkComponentProcessor(source, parserContext);
        } else {
            this.createValidatorHelper(source, parserContext);
        }
        return null;
    }

    protected RuntimeBeanReference createPatternMatcherFactory(Object source, ParserContext parserContext) {
        return this.createSimpleBean(source, parserContext, PatternMatcherFactory.class, PATTERN_MATCHER_FACTORY_NAME);
    }

    protected RuntimeBeanReference createPageIdGenerator(Object source, ParserContext parserContext) {
        RootBeanDefinition bean = new RootBeanDefinition(SequentialPageIdGenerator.class);
        bean.setSource(source);
        bean.setRole(2);
        bean.setScope("prototype");
        return this.registerBean(bean, PageIdGenerator.class.getName(), parserContext);
    }

    protected RuntimeBeanReference createUserData(Element element, Object source, ParserContext parserContext) {
        String userData = element.getAttribute("userData");
        if (userData == null || userData.length() < 1) {
            return this.createSimpleBean(source, parserContext, UserData.class, USER_DATA_NAME);
        }
        parserContext.getRegistry().registerAlias(userData, USER_DATA_NAME);
        return new RuntimeBeanReference(USER_DATA_NAME);
    }

    protected RuntimeBeanReference createLogger(Object source, ParserContext parserContext) {
        RootBeanDefinition bean = new RootBeanDefinition(Logger.class);
        bean.setSource(source);
        bean.setRole(2);
        return this.registerBean(bean, Logger.class.getName(), parserContext);
    }

    protected RuntimeBeanReference createValidatorErrorHandler(Object source, ParserContext parserContext) {
        Class<DefaultValidatorErrorHandler> errorHandlerClass = DefaultValidatorErrorHandler.class;
        if (this.jsfPresent && this.jsfModulePresent) {
            errorHandlerClass = JsfValidatorErrorHandler.class;
        }
        RootBeanDefinition bean = new RootBeanDefinition(errorHandlerClass);
        bean.setSource(source);
        bean.setRole(2);
        bean.getPropertyValues().addPropertyValue(CONFIG, (Object)this.configRef);
        return this.registerBean(bean, ValidatorErrorHandler.class.getName(), parserContext);
    }

    protected RuntimeBeanReference createStateCache(Element element, Object source, ParserContext parserContext) {
        RootBeanDefinition bean = new RootBeanDefinition(StateCache.class);
        bean.setSource(source);
        bean.setRole(2);
        bean.setScope("prototype");
        String maxSize = element.getAttribute("maxPagesPerSession");
        if (StringUtils.hasText((String)maxSize)) {
            bean.getPropertyValues().addPropertyValue("maxSize", (Object)maxSize);
        }
        return this.registerBean(bean, IStateCache.class.getName(), parserContext);
    }

    protected RuntimeBeanReference createSession(Object source, ParserContext parserContext) {
        return this.createSimpleBean(source, parserContext, SessionHDIV.class, ISession.class.getName());
    }

    protected RuntimeBeanReference createStateUtil(Object source, ParserContext parserContext) {
        RootBeanDefinition bean = new RootBeanDefinition(StateUtil.class);
        bean.setSource(source);
        bean.setRole(2);
        bean.setInitMethodName("init");
        bean.getPropertyValues().addPropertyValue(CONFIG, (Object)this.configRef);
        bean.getPropertyValues().addPropertyValue(SESSION, (Object)this.sessionRef);
        bean.getPropertyValues().addPropertyValue(STATE_SCOPE_MANAGER, (Object)this.stateScopeManagerRef);
        return this.registerBean(bean, StateUtil.class.getName(), parserContext);
    }

    protected RuntimeBeanReference createDataValidator(Object source, ParserContext parserContext) {
        RootBeanDefinition bean = new RootBeanDefinition(DataValidator.class);
        bean.setSource(source);
        bean.setRole(2);
        bean.getPropertyValues().addPropertyValue(CONFIG, (Object)this.configRef);
        return this.registerBean(bean, IDataValidator.class.getName(), parserContext);
    }

    protected RuntimeBeanReference createStateScopeManager(Object source, ParserContext parserContext) {
        RootBeanDefinition bean = new RootBeanDefinition(DefaultStateScopeManager.class);
        bean.setSource(source);
        bean.setRole(2);
        ManagedList defs = new ManagedList();
        defs.add((Object)this.createUserSessionStateScope(source, parserContext));
        defs.add((Object)this.createSimpleBean(source, parserContext, AppStateScope.class));
        RootBeanDefinition listBean = new RootBeanDefinition(ListFactoryBean.class);
        listBean.setSource(source);
        listBean.setRole(2);
        listBean.getPropertyValues().addPropertyValue("sourceList", (Object)defs);
        bean.getConstructorArgumentValues().addGenericArgumentValue((Object)listBean);
        return this.registerBean(bean, StateScopeManager.class.getName(), parserContext);
    }

    protected RuntimeBeanReference createUserSessionStateScope(Object source, ParserContext parserContext) {
        RootBeanDefinition bean = new RootBeanDefinition(UserSessionStateScope.class);
        bean.setSource(source);
        bean.setRole(2);
        bean.getPropertyValues().addPropertyValue(SESSION, (Object)this.sessionRef);
        return this.registerBean(bean, UserSessionStateScope.class.getName(), parserContext);
    }

    protected RuntimeBeanReference createDataComposerFactory(Object source, ParserContext parserContext) {
        RootBeanDefinition bean = new RootBeanDefinition(DataComposerFactory.class);
        bean.setSource(source);
        bean.setRole(2);
        bean.getPropertyValues().addPropertyValue(CONFIG, (Object)this.configRef);
        bean.getPropertyValues().addPropertyValue(SESSION, (Object)this.sessionRef);
        bean.getPropertyValues().addPropertyValue(STATE_UTIL, (Object)this.stateUtilRef);
        bean.getPropertyValues().addPropertyValue("uidGenerator", (Object)this.uidGeneratorRef);
        bean.getPropertyValues().addPropertyValue(STATE_SCOPE_MANAGER, (Object)this.stateScopeManagerRef);
        return this.registerBean(bean, DataComposerFactory.class.getName(), parserContext);
    }

    protected RuntimeBeanReference createValidatorHelper(Object source, ParserContext parserContext) {
        RootBeanDefinition bean = new RootBeanDefinition(ValidatorHelperRequest.class);
        bean.setSource(source);
        bean.setRole(2);
        bean.setInitMethodName("init");
        bean.getPropertyValues().addPropertyValue(STATE_UTIL, (Object)this.stateUtilRef);
        bean.getPropertyValues().addPropertyValue(HDIV_CONFIG, (Object)this.configRef);
        bean.getPropertyValues().addPropertyValue(SESSION, (Object)this.sessionRef);
        bean.getPropertyValues().addPropertyValue("dataValidator", (Object)this.dataValidatorRef);
        bean.getPropertyValues().addPropertyValue("urlProcessor", (Object)this.basicUrlProcessorRef);
        bean.getPropertyValues().addPropertyValue("dataComposerFactory", (Object)this.dataComposerFactoryRef);
        bean.getPropertyValues().addPropertyValue(STATE_SCOPE_MANAGER, (Object)this.stateScopeManagerRef);
        return this.registerBean(bean, IValidationHelper.class.getName(), parserContext);
    }

    protected RuntimeBeanReference createRequestInitializer(Object source, ParserContext parserContext) {
        RootBeanDefinition bean = new RootBeanDefinition(DefaultRequestInitializer.class);
        bean.setSource(source);
        bean.setRole(2);
        bean.getPropertyValues().addPropertyValue(CONFIG, (Object)this.configRef);
        bean.getPropertyValues().addPropertyValue(SESSION, (Object)this.sessionRef);
        return this.registerBean(bean, RequestInitializer.class.getName(), parserContext);
    }

    protected RuntimeBeanReference createServletContextInitializer(Object source, ParserContext parserContext) {
        RootBeanDefinition bean = new RootBeanDefinition(DefaultServletContextInitializer.class);
        bean.setSource(source);
        bean.setRole(2);
        bean.getPropertyValues().addPropertyValue(CONFIG, (Object)this.configRef);
        bean.getPropertyValues().addPropertyValue("application", (Object)this.applicationRef);
        bean.getPropertyValues().addPropertyValue(LINK_URL_PROCESSOR, (Object)this.linkUrlProcessorRef);
        bean.getPropertyValues().addPropertyValue(FORM_URL_PROCESSOR, (Object)this.formUrlProcessorRef);
        return this.registerBean(bean, ServletContextInitializer.class.getName(), parserContext);
    }

    protected RuntimeBeanReference createSessionInitializer(Object source, ParserContext parserContext) {
        RootBeanDefinition bean = new RootBeanDefinition(DefaultSessionInitializer.class);
        bean.setSource(source);
        bean.setRole(2);
        bean.getPropertyValues().addPropertyValue(CONFIG, (Object)this.configRef);
        return this.registerBean(bean, SessionInitializer.class.getName(), parserContext);
    }

    protected RuntimeBeanReference createLinkUrlProcessor(Object source, ParserContext parserContext) {
        RootBeanDefinition bean = new RootBeanDefinition(LinkUrlProcessor.class);
        bean.setSource(source);
        bean.setRole(2);
        bean.getPropertyValues().addPropertyValue(CONFIG, (Object)this.configRef);
        return this.registerBean(bean, LinkUrlProcessor.class.getName(), parserContext);
    }

    protected RuntimeBeanReference createFormUrlProcessor(Object source, ParserContext parserContext) {
        RootBeanDefinition bean = new RootBeanDefinition(FormUrlProcessor.class);
        bean.setSource(source);
        bean.setRole(2);
        bean.getPropertyValues().addPropertyValue(CONFIG, (Object)this.configRef);
        return this.registerBean(bean, FormUrlProcessor.class.getName(), parserContext);
    }

    protected RuntimeBeanReference createBasicUrlProcessor(Object source, ParserContext parserContext) {
        RootBeanDefinition bean = new RootBeanDefinition(BasicUrlProcessor.class);
        bean.setSource(source);
        bean.setRole(2);
        bean.getPropertyValues().addPropertyValue(CONFIG, (Object)this.configRef);
        return this.registerBean(bean, BasicUrlProcessor.class.getName(), parserContext);
    }

    protected RuntimeBeanReference createValidationContextFactory(Object source, ParserContext parserContext) {
        RootBeanDefinition bean = new RootBeanDefinition(DefaultValidationContextFactory.class);
        bean.setSource(source);
        bean.setRole(2);
        return this.registerBean(bean, ValidationContextFactory.class.getName(), parserContext);
    }

    protected RuntimeBeanReference createRequestContextFactory(Object source, ParserContext parserContext) {
        RootBeanDefinition bean = new RootBeanDefinition(RequestContextFactoryImpl.class);
        bean.setSource(source);
        bean.setRole(2);
        return this.registerBean(bean, RequestContextFactory.class.getName(), parserContext);
    }

    protected RuntimeBeanReference createRequestDataValueProcessor(Object source, ParserContext parserContext) {
        RootBeanDefinition bean = new RootBeanDefinition(HdivRequestDataValueProcessor.class);
        bean.setSource(source);
        bean.setRole(2);
        bean.getPropertyValues().addPropertyValue(LINK_URL_PROCESSOR, (Object)this.linkUrlProcessorRef);
        bean.getPropertyValues().addPropertyValue(FORM_URL_PROCESSOR, (Object)this.formUrlProcessorRef);
        if (springSecurityPresent && this.springVersionGrEqThan4()) {
            bean.getPropertyValues().addPropertyValue("innerRequestDataValueProcessor", (Object)new CsrfRequestDataValueProcessor());
        }
        parserContext.getRegistry().registerBeanDefinition(REQUEST_DATA_VALUE_PROCESSOR_BEAN_NAME, (BeanDefinition)bean);
        return new RuntimeBeanReference(REQUEST_DATA_VALUE_PROCESSOR_BEAN_NAME);
    }

    protected RuntimeBeanReference createGrailsRequestDataValueProcessor(Object source, ParserContext parserContext) {
        RootBeanDefinition bean = new RootBeanDefinition(GrailsHdivRequestDataValueProcessor.class);
        bean.setSource(source);
        bean.setRole(2);
        bean.getPropertyValues().addPropertyValue(LINK_URL_PROCESSOR, (Object)this.linkUrlProcessorRef);
        bean.getPropertyValues().addPropertyValue(FORM_URL_PROCESSOR, (Object)this.formUrlProcessorRef);
        parserContext.getRegistry().registerBeanDefinition(REQUEST_DATA_VALUE_PROCESSOR_BEAN_NAME, (BeanDefinition)bean);
        return new RuntimeBeanReference(REQUEST_DATA_VALUE_PROCESSOR_BEAN_NAME);
    }

    protected RuntimeBeanReference createThymeleafRequestDataValueProcessor(Object source, ParserContext parserContext) {
        RootBeanDefinition bean = new RootBeanDefinition(ThymeleafHdivRequestDataValueProcessor.class);
        bean.setSource(source);
        bean.setRole(2);
        bean.getPropertyValues().addPropertyValue(LINK_URL_PROCESSOR, (Object)this.linkUrlProcessorRef);
        bean.getPropertyValues().addPropertyValue(FORM_URL_PROCESSOR, (Object)this.formUrlProcessorRef);
        parserContext.getRegistry().registerBeanDefinition(REQUEST_DATA_VALUE_PROCESSOR_BEAN_NAME, (BeanDefinition)bean);
        return new RuntimeBeanReference(REQUEST_DATA_VALUE_PROCESSOR_BEAN_NAME);
    }

    protected RuntimeBeanReference createConfigBean(Element element, Object source, ParserContext parserContext) {
        BeanDefinition bean = this.createConfigBean(element, source, parserContext, HDIVConfig.class);
        parserContext.getRegistry().registerBeanDefinition(CONFIG_BEAN_NAME, bean);
        return new RuntimeBeanReference(CONFIG_BEAN_NAME);
    }

    protected BeanDefinition createConfigBean(Element element, Object source, ParserContext parserContext, Class<?> configClass) {
        RootBeanDefinition bean = new RootBeanDefinition(configClass);
        bean.setSource(source);
        bean.setRole(2);
        bean.getPropertyValues().addPropertyValue("patternMatcherFactory", (Object)this.patternMatcherFactoryRef);
        String confidentiality = element.getAttribute("confidentiality");
        String avoidCookiesIntegrity = element.getAttribute("avoidCookiesIntegrity");
        String avoidCookiesConfidentiality = element.getAttribute("avoidCookiesConfidentiality");
        String avoidValidationInUrlsWithoutParams = element.getAttribute("avoidValidationInUrlsWithoutParams");
        String strategy = element.getAttribute("strategy");
        String randomName = element.getAttribute("randomName");
        String errorPage = element.getAttribute("errorPage");
        String protectedExtensions = element.getAttribute("protectedExtensions");
        String excludedExtensions = element.getAttribute("excludedExtensions");
        String debugMode = element.getAttribute("debugMode");
        String showErrorPageOnEditableValidation = element.getAttribute("showErrorPageOnEditableValidation");
        String reuseExistingPageInAjaxRequest = element.getAttribute("reuseExistingPageInAjaxRequest");
        String editableFieldsRequiredByDefault = element.getAttribute("editableFieldsRequiredByDefault");
        String multipartIntegration = element.getAttribute("multipartIntegration");
        if (StringUtils.hasText((String)confidentiality)) {
            bean.getPropertyValues().addPropertyValue("confidentiality", (Object)confidentiality);
        }
        if (StringUtils.hasText((String)avoidCookiesIntegrity)) {
            bean.getPropertyValues().addPropertyValue("avoidCookiesIntegrity", (Object)avoidCookiesIntegrity);
        }
        if (StringUtils.hasText((String)avoidCookiesConfidentiality)) {
            bean.getPropertyValues().addPropertyValue("avoidCookiesConfidentiality", (Object)avoidCookiesConfidentiality);
        }
        if (StringUtils.hasText((String)avoidValidationInUrlsWithoutParams)) {
            bean.getPropertyValues().addPropertyValue("avoidValidationInUrlsWithoutParams", (Object)avoidValidationInUrlsWithoutParams);
        }
        if (StringUtils.hasText((String)strategy)) {
            bean.getPropertyValues().addPropertyValue("strategy", (Object)Strategy.valueOf((String)strategy.toUpperCase()));
        }
        if (StringUtils.hasText((String)randomName)) {
            bean.getPropertyValues().addPropertyValue("randomName", (Object)randomName);
        }
        if (StringUtils.hasText((String)errorPage)) {
            bean.getPropertyValues().addPropertyValue("errorPage", (Object)errorPage);
        }
        if (StringUtils.hasText((String)protectedExtensions)) {
            bean.getPropertyValues().addPropertyValue("protectedExtensions", this.convertToList(protectedExtensions));
        }
        if (StringUtils.hasText((String)excludedExtensions)) {
            bean.getPropertyValues().addPropertyValue("excludedExtensions", this.convertToList(excludedExtensions));
        }
        if (StringUtils.hasText((String)debugMode)) {
            bean.getPropertyValues().addPropertyValue("debugMode", (Object)debugMode);
        }
        if (StringUtils.hasText((String)showErrorPageOnEditableValidation)) {
            bean.getPropertyValues().addPropertyValue("showErrorPageOnEditableValidation", (Object)showErrorPageOnEditableValidation);
        }
        if (StringUtils.hasText((String)reuseExistingPageInAjaxRequest)) {
            bean.getPropertyValues().addPropertyValue("reuseExistingPageInAjaxRequest", (Object)reuseExistingPageInAjaxRequest);
        }
        if (StringUtils.hasText((String)editableFieldsRequiredByDefault)) {
            bean.getPropertyValues().addPropertyValue("editableFieldsRequiredByDefault", (Object)editableFieldsRequiredByDefault);
        }
        if (StringUtils.hasText((String)multipartIntegration)) {
            bean.getPropertyValues().addPropertyValue("multipartIntegration", (Object)multipartIntegration);
        }
        bean.getPropertyValues().addPropertyValue("editableDataValidationProvider", (Object)new RuntimeBeanReference("org.hdiv.validator.EditableDataValidationProvider"));
        if (!parserContext.getRegistry().containsBeanDefinition("org.hdiv.validator.EditableDataValidationProvider")) {
            this.createDefaultEditableDataValidationProvider(source, parserContext);
        }
        this.processChilds(element, bean);
        return bean;
    }

    protected RuntimeBeanReference createDefaultEditableDataValidationProvider(Object source, ParserContext parserContext) {
        RootBeanDefinition bean = new RootBeanDefinition(DefaultEditableDataValidationProvider.class);
        bean.setSource(source);
        bean.setRole(2);
        parserContext.getRegistry().registerBeanDefinition("org.hdiv.validator.EditableDataValidationProvider", (BeanDefinition)bean);
        return new RuntimeBeanReference("org.hdiv.validator.EditableDataValidationProvider");
    }

    protected RuntimeBeanReference createComponentTreeValidator(Object source, ParserContext parserContext) {
        RootBeanDefinition bean = new RootBeanDefinition(DefaultComponentTreeValidator.class);
        bean.setSource(source);
        bean.setRole(2);
        bean.getPropertyValues().addPropertyValue(CONFIG, (Object)this.configRef);
        bean.setInitMethodName("createComponentValidators");
        return this.registerBean(bean, ComponentTreeValidator.class.getName(), parserContext);
    }

    protected RuntimeBeanReference createJsfValidatorHelper(Object source, ParserContext parserContext) {
        RootBeanDefinition bean = new RootBeanDefinition(JsfValidatorHelper.class);
        bean.setSource(source);
        bean.setRole(2);
        bean.setInitMethodName("init");
        bean.getPropertyValues().addPropertyValue(STATE_UTIL, (Object)this.stateUtilRef);
        bean.getPropertyValues().addPropertyValue(HDIV_CONFIG, (Object)this.configRef);
        bean.getPropertyValues().addPropertyValue(SESSION, (Object)this.sessionRef);
        bean.getPropertyValues().addPropertyValue("dataValidator", (Object)this.dataValidatorRef);
        bean.getPropertyValues().addPropertyValue("urlProcessor", (Object)this.basicUrlProcessorRef);
        bean.getPropertyValues().addPropertyValue("dataComposerFactory", (Object)this.dataComposerFactoryRef);
        bean.getPropertyValues().addPropertyValue(STATE_SCOPE_MANAGER, (Object)this.stateScopeManagerRef);
        return this.registerBean(bean, IValidationHelper.class.getName(), parserContext);
    }

    protected RuntimeBeanReference createRedirectHelper(Object source, ParserContext parserContext) {
        RootBeanDefinition bean = new RootBeanDefinition(RedirectHelper.class);
        bean.setSource(source);
        bean.setRole(2);
        bean.getPropertyValues().addPropertyValue(LINK_URL_PROCESSOR, (Object)this.linkUrlProcessorRef);
        return this.registerBean(bean, RedirectHelper.class.getName(), parserContext);
    }

    protected RuntimeBeanReference createOutcomeTargetComponentProcessor(Object source, ParserContext parserContext) {
        RootBeanDefinition bean = new RootBeanDefinition(OutcomeTargetComponentProcessor.class);
        bean.setSource(source);
        bean.setRole(2);
        bean.getPropertyValues().addPropertyValue(CONFIG, (Object)this.configRef);
        bean.getPropertyValues().addPropertyValue(LINK_URL_PROCESSOR, (Object)this.linkUrlProcessorRef);
        return this.registerBean(bean, OutcomeTargetComponentProcessor.class.getName(), parserContext);
    }

    protected RuntimeBeanReference createOutputLinkComponentProcessor(Object source, ParserContext parserContext) {
        RootBeanDefinition bean = new RootBeanDefinition(OutputLinkComponentProcessor.class);
        bean.setSource(source);
        bean.setRole(2);
        bean.getPropertyValues().addPropertyValue(CONFIG, (Object)this.configRef);
        bean.getPropertyValues().addPropertyValue(LINK_URL_PROCESSOR, (Object)this.linkUrlProcessorRef);
        return this.registerBean(bean, OutputLinkComponentProcessor.class.getName(), parserContext);
    }

    protected RuntimeBeanReference createStringBean(String name, String value, Object source, ParserContext parserContext) {
        RootBeanDefinition bean = new RootBeanDefinition(String.class);
        bean.setSource(source);
        bean.setRole(2);
        bean.getConstructorArgumentValues().addIndexedArgumentValue(0, (Object)value);
        parserContext.getRegistry().registerBeanDefinition(name, (BeanDefinition)bean);
        return new RuntimeBeanReference(name);
    }

    protected RuntimeBeanReference registerBean(RootBeanDefinition bean, String beanName, ParserContext parserContext) {
        boolean exist = parserContext.getRegistry().containsBeanDefinition(beanName);
        if (!exist) {
            parserContext.getRegistry().registerBeanDefinition(beanName, (BeanDefinition)bean);
            return new RuntimeBeanReference(beanName);
        }
        return new RuntimeBeanReference(beanName);
    }

    protected RuntimeBeanReference createSimpleBean(Object source, ParserContext parserContext, Class<?> clazz) {
        RootBeanDefinition bean = new RootBeanDefinition(clazz);
        bean.setSource(source);
        bean.setRole(2);
        String name = parserContext.getReaderContext().generateBeanName((BeanDefinition)bean);
        parserContext.getRegistry().registerBeanDefinition(name, (BeanDefinition)bean);
        return new RuntimeBeanReference(name);
    }

    protected RuntimeBeanReference createSimpleBean(Object source, ParserContext parserContext, Class<?> clazz, String beanName) {
        RootBeanDefinition bean = new RootBeanDefinition(clazz);
        bean.setSource(source);
        bean.setRole(2);
        return this.registerBean(bean, beanName, parserContext);
    }

    protected void processChilds(Element element, RootBeanDefinition bean) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            if ("startPages".equalsIgnoreCase(node.getLocalName())) {
                this.processStartPages(node, bean);
                continue;
            }
            if ("startParameters".equalsIgnoreCase(node.getLocalName())) {
                this.processStartParameters(node, bean);
                continue;
            }
            if ("paramsWithoutValidation".equalsIgnoreCase(node.getLocalName())) {
                this.processParamsWithoutValidation(node, bean);
                continue;
            }
            if ("sessionExpired".equalsIgnoreCase(node.getLocalName())) {
                this.processSessionExpired(node, bean);
                continue;
            }
            if (!"longLivingPages".equalsIgnoreCase(node.getLocalName())) continue;
            this.processLongLivingPages(node, bean);
        }
    }

    protected void processStartPages(Node node, RootBeanDefinition bean) {
        String method = null;
        if (node.getNodeType() == 1) {
            Element element = (Element)node;
            method = element.getAttribute("method");
        }
        String value = node.getTextContent();
        List<String> patterns = this.convertToList(value);
        for (int i = 0; i < patterns.size(); ++i) {
            String pattern = patterns.get(i);
            StartPage startPage = new StartPage(method, pattern);
            this.startPages.add(startPage);
        }
        bean.getPropertyValues().addPropertyValue("userStartPages", this.startPages);
    }

    protected void processStartParameters(Node node, RootBeanDefinition bean) {
        String value = node.getTextContent();
        bean.getPropertyValues().addPropertyValue("userStartParameters", this.convertToList(value));
    }

    protected void processParamsWithoutValidation(Node node, RootBeanDefinition bean) {
        NodeList nodeList = node.getChildNodes();
        LinkedHashMap<String, List<String>> map = new LinkedHashMap<String, List<String>>();
        bean.getPropertyValues().addPropertyValue("paramsWithoutValidation", map);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node mappingNode = nodeList.item(i);
            if (mappingNode.getNodeType() != 1 || !"mapping".equalsIgnoreCase(mappingNode.getLocalName())) continue;
            this.processMapping(mappingNode, map);
        }
    }

    protected void processSessionExpired(Node node, RootBeanDefinition bean) {
        NamedNodeMap attributes = node.getAttributes();
        Node named = attributes.getNamedItem("loginPage");
        if (named != null) {
            String loginPage = named.getTextContent();
            bean.getPropertyValues().addPropertyValue("sessionExpiredLoginPage", (Object)loginPage);
        }
        if ((named = attributes.getNamedItem("homePage")) != null) {
            String homePage = named.getTextContent();
            bean.getPropertyValues().addPropertyValue("sessionExpiredHomePage", (Object)homePage);
        }
    }

    protected void processLongLivingPages(Node node, RootBeanDefinition bean) {
        NamedNodeMap attributes = node.getAttributes();
        Node named = attributes.getNamedItem("scope");
        String scope = named.getTextContent();
        String value = node.getTextContent();
        List<String> patterns = this.convertToList(value);
        for (String pattern : patterns) {
            this.longLivingPages.put(pattern, scope);
        }
        bean.getPropertyValues().addPropertyValue("longLivingPages", this.longLivingPages);
    }

    protected void processMapping(Node node, Map<String, List<String>> map) {
        NamedNodeMap attributes = node.getAttributes();
        Node named = attributes.getNamedItem("url");
        if (named != null) {
            String url = named.getTextContent();
            String parameters = attributes.getNamedItem("parameters").getTextContent();
            List<String> params = map.get(url);
            if (params == null) {
                params = this.convertToList(parameters);
            } else {
                params.addAll(this.convertToList(parameters));
            }
            map.put(url, params);
        }
    }

    protected List<String> convertToList(String data) {
        String[] result = data.split(",");
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < result.length; ++i) {
            list.add(StringUtils.trimWhitespace((String)result[i]));
        }
        return list;
    }
}

