/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.hamcrest;

import java.util.Optional;
import java.util.function.Function;
import mockit.Deencapsulation;
import org.hamcrest.Description;
import org.hamcrest.DiagnosingMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.core.IsEqual;
import org.helenus.util.Objects;

public class Matchers {
    public static <T, S> Matcher<T> that(final Function<T, S> function, final String describer, final Matcher<S> matcher) {
        return new DiagnosingMatcher<T>(){

            public boolean matches(Object obj, Description mismatch) {
                Object s = function.apply(obj);
                if (!matcher.matches(s)) {
                    matcher.describeMismatch(s, mismatch);
                    return false;
                }
                return true;
            }

            public void describeTo(Description description) {
                description.appendText("'").appendText(describer).appendText("' ").appendDescriptionOf((SelfDescribing)matcher);
            }
        };
    }

    public static <T, S> Matcher<T> equalTo(final Function<T, S> function, final String describer, T operand) {
        final S os = function.apply(operand);
        return new DiagnosingMatcher<T>(){

            public boolean matches(Object obj, Description mismatch) {
                Object s = function.apply(obj);
                if (!java.util.Objects.deepEquals(os, s)) {
                    mismatch.appendText("however '").appendText(describer).appendText("' was ").appendValue(s).appendText(" instead of ").appendValue(os);
                    return false;
                }
                return true;
            }

            public void describeTo(Description description) {
                description.appendText("'").appendText(describer).appendText("' is equal to ").appendValue(os);
            }
        };
    }

    public static <T, S> Matcher<T> closeTo(final Function<T, S> function, final String describer, T operand, final double epsilon) {
        final S os = function.apply(operand);
        return new DiagnosingMatcher<T>(){

            public boolean matches(Object obj, Description mismatch) {
                Object s = function.apply(obj);
                if (!Objects.deepEquals((Object)os, s, (double)epsilon)) {
                    mismatch.appendText("however '").appendText(describer).appendText("' was ").appendValue(s).appendText(" instead of ").appendValue(os);
                    return false;
                }
                return true;
            }

            public void describeTo(Description description) {
                description.appendText("'").appendText(describer).appendText("' is close within ").appendText(String.valueOf(epsilon)).appendText(" to ").appendValue(os);
            }
        };
    }

    public static <T, S> Matcher<T> fieldEqualTo(final String field, final Matcher<S> matcher) {
        return new DiagnosingMatcher<T>(){

            public boolean matches(Object obj, Description mismatch) {
                Object s = Deencapsulation.getField((Object)obj, (String)field);
                if (!matcher.matches(s)) {
                    matcher.describeMismatch(s, mismatch);
                    return false;
                }
                return true;
            }

            public void describeTo(Description description) {
                description.appendText("field '").appendText(field).appendText("' ").appendDescriptionOf((SelfDescribing)matcher);
            }
        };
    }

    public static <E> Matcher<Optional<E>> isPresent() {
        return new TypeSafeMatcher<Optional<E>>(){

            public void describeTo(Description description) {
                description.appendText("is present");
            }

            protected boolean matchesSafely(Optional<E> item) {
                return item.isPresent();
            }

            protected void describeMismatchSafely(Optional<E> item, Description mismatchDescription) {
                mismatchDescription.appendText("was empty");
            }
        };
    }

    public static <E> Matcher<Optional<E>> isEmpty() {
        return new TypeSafeMatcher<Optional<E>>(){

            public void describeTo(Description description) {
                description.appendText("is empty");
            }

            protected boolean matchesSafely(Optional<E> item) {
                return !item.isPresent();
            }

            protected void describeMismatchSafely(Optional<E> item, Description mismatchDescription) {
                mismatchDescription.appendText("had value ").appendValue(item.get());
            }
        };
    }

    public static <E> Matcher<Optional<E>> hasValue(E value) {
        return Matchers.hasValue(IsEqual.equalTo(value));
    }

    public static <E> Matcher<Optional<E>> hasValue(final Matcher<? super E> matcher) {
        return new TypeSafeMatcher<Optional<E>>(){

            public void describeTo(Description description) {
                description.appendText("has a value that is ");
                matcher.describeTo(description);
            }

            protected boolean matchesSafely(Optional<E> item) {
                return item.map(v -> matcher.matches(v)).orElse(false);
            }

            protected void describeMismatchSafely(Optional<E> item, Description mismatchDescription) {
                Object v = item.orElse(null);
                if (v != null) {
                    mismatchDescription.appendText("value ");
                    matcher.describeMismatch(v, mismatchDescription);
                } else {
                    mismatchDescription.appendText("was empty");
                }
            }
        };
    }
}

