/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.junit.rules;

import java.util.ArrayList;
import java.util.List;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import org.helenus.junit.Tag;
import org.helenus.junit.Tags;
import org.helenus.util.function.EConsumer;
import org.helenus.util.function.ERunnable;
import org.junit.Test;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

public class MethodRule
implements org.junit.rules.MethodRule {
    final EConsumer<MethodRule, Exception>[] shandlers;
    final List<ERunnable<Exception>> erhandlers = new ArrayList<ERunnable<Exception>>(2);
    final List<EConsumer<Throwable, Exception>> echandlers = new ArrayList<EConsumer<Throwable, Exception>>(2);
    private volatile FrameworkMethod method = null;
    private volatile CtClass ctclass = null;
    private volatile CtMethod ctmethod = null;

    @SafeVarargs
    public MethodRule(EConsumer<MethodRule, Exception> ... handlers) {
        this.shandlers = handlers;
    }

    public Statement apply(final Statement base, final FrameworkMethod method, Object target) {
        this.method = method;
        try {
            ClassPool pool = ClassPool.getDefault();
            this.ctclass = pool.get(method.getDeclaringClass().getCanonicalName());
            this.ctmethod = this.ctclass.getDeclaredMethod(method.getName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new Statement(){

            public void evaluate() throws Throwable {
                try {
                    if (MethodRule.this.shandlers != null) {
                        for (EConsumer<MethodRule, Exception> eConsumer : MethodRule.this.shandlers) {
                            eConsumer.accept((Object)MethodRule.this);
                        }
                    }
                    base.evaluate();
                }
                catch (OutOfMemoryError | StackOverflowError | ThreadDeath e) {
                    throw e;
                }
                catch (Throwable t) {
                    Test test = (Test)method.getAnnotation(Test.class);
                    if (test == null || !test.expected().isAssignableFrom(t.getClass())) {
                        for (ERunnable<Exception> eRunnable : MethodRule.this.erhandlers) {
                            eRunnable.run();
                        }
                        for (EConsumer eConsumer : MethodRule.this.echandlers) {
                            eConsumer.accept((Object)t);
                        }
                    }
                    throw t;
                }
                finally {
                    MethodRule.this.erhandlers.clear();
                    MethodRule.this.echandlers.clear();
                }
            }
        };
    }

    public String getName() {
        FrameworkMethod m = this.method;
        return m != null ? m.getName() : null;
    }

    public String getSourceFile() {
        CtClass c = this.ctclass;
        if (c != null) {
            return c.getClassFile2().getSourceFile();
        }
        return null;
    }

    public int getLineNumber() {
        CtMethod m = this.ctmethod;
        if (m != null) {
            return m.getMethodInfo2().getLineNumber(0);
        }
        return -1;
    }

    public boolean hasTag(String tag) {
        FrameworkMethod m = this.method;
        if (m != null) {
            Tags ts = (Tags)this.method.getAnnotation(Tags.class);
            if (ts != null) {
                for (Tag t : ts.value()) {
                    if (!t.value().equals(tag)) continue;
                    return true;
                }
            } else {
                Tag t = (Tag)this.method.getAnnotation(Tag.class);
                if (t != null) {
                    return t.value().equals(tag);
                }
            }
        }
        return false;
    }

    public MethodRule onFailure(ERunnable<Exception> handler) {
        if (handler != null) {
            this.erhandlers.add(handler);
        }
        return this;
    }

    public MethodRule onFailure(EConsumer<Throwable, Exception> handler) {
        if (handler != null) {
            this.echandlers.add(handler);
        }
        return this;
    }
}

