/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.driver.junit;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.QueryOptions;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.SocketOptions;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.WriteType;
import com.datastax.driver.core.exceptions.DriverException;
import com.datastax.driver.core.policies.LoggingRetryPolicy;
import com.datastax.driver.core.policies.RetryPolicy;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.commitlog.CommitLog;
import org.apache.cassandra.service.CassandraDaemon;
import org.apache.cassandra.service.StorageService;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.helenus.commons.collections.iterators.CombinationIterator;
import org.helenus.commons.lang3.reflect.ReflectionUtils;
import org.helenus.driver.AlterSchema;
import org.helenus.driver.AlterSchemas;
import org.helenus.driver.BatchableStatement;
import org.helenus.driver.Clause;
import org.helenus.driver.CreateIndex;
import org.helenus.driver.CreateKeyspace;
import org.helenus.driver.CreateSchema;
import org.helenus.driver.CreateSchemas;
import org.helenus.driver.CreateTable;
import org.helenus.driver.CreateType;
import org.helenus.driver.Delete;
import org.helenus.driver.ExcludedKeyspaceKeyException;
import org.helenus.driver.GenericStatement;
import org.helenus.driver.Group;
import org.helenus.driver.GroupableStatement;
import org.helenus.driver.Insert;
import org.helenus.driver.Select;
import org.helenus.driver.Sequence;
import org.helenus.driver.SequenceableStatement;
import org.helenus.driver.StatementBuilder;
import org.helenus.driver.StatementManager;
import org.helenus.driver.Truncate;
import org.helenus.driver.Update;
import org.helenus.driver.impl.ClassInfoImpl;
import org.helenus.driver.impl.CreateSchemaImpl;
import org.helenus.driver.impl.GroupImpl;
import org.helenus.driver.impl.ParentStatementImpl;
import org.helenus.driver.impl.RootClassInfoImpl;
import org.helenus.driver.impl.StatementImpl;
import org.helenus.driver.impl.StatementManagerImpl;
import org.helenus.driver.impl.TypeClassInfoImpl;
import org.helenus.driver.impl.UDTClassInfoImpl;
import org.helenus.driver.impl.UDTRootClassInfoImpl;
import org.helenus.driver.impl.UDTTypeClassInfoImpl;
import org.helenus.driver.info.ClassInfo;
import org.helenus.driver.info.FieldInfo;
import org.helenus.driver.info.TableInfo;
import org.helenus.driver.info.TypeClassInfo;
import org.helenus.driver.junit.BeforeObjects;
import org.helenus.driver.junit.PartitionKeyValues;
import org.helenus.driver.junit.SchemaFuture;
import org.helenus.driver.junit.StatementCaptureList;
import org.helenus.driver.junit.util.ReflectionJUnitUtils;
import org.helenus.driver.junit.util.Strings;
import org.helenus.driver.persistence.Keyspace;
import org.helenus.driver.persistence.Table;
import org.helenus.util.function.ERunnable;
import org.junit.rules.MethodRule;
import org.junit.runners.model.FrameworkMethod;

public class HelenusJUnit
implements MethodRule {
    static final Logger logger = LogManager.getFormatterLogger(HelenusJUnit.class);
    static final String TRACE_PREFIX = "HELENUS-JUNIT ";
    public static final long DEFAULT_STARTUP_TIMEOUT = 60000L;
    public static final long DEFAULT_READ_TIMEOUT = 12000L;
    public static final String DEFAULT_CFG_FILE = "cassandra.yaml";
    private static final String RUNTIME_DIR = "target/helenus-junit";
    private static Pattern portPattern = Pattern.compile("^([a-z_]+_port:\\s*)([0-9]+)\\s*$", 8);
    private static Pattern targetPattern = Pattern.compile("^([a-z_]+:[\\s-]*)(target/helenus-junit)(.*)$", 8);
    private static volatile ThreadGroup group = null;
    private static String config = null;
    private static String fork = System.getProperty("fork", "");
    private static volatile CassandraDaemon daemon = null;
    private static StatementManagerUnitImpl manager = null;
    static volatile int numReadRetries = 0;
    static volatile int numWriteRetries = 0;
    private static volatile boolean fullTraces = false;
    private static volatile boolean allStatementTraces = false;
    private static final Set<Pair<String, Keyspace>> keyspaces = ConcurrentHashMap.newKeySet();
    private static final Map<Pair<String, Keyspace>, Set<Table>> tables = new ConcurrentHashMap<Pair<String, Keyspace>, Set<Table>>();
    static final Map<Class<?>, SchemaFuture> schemas = new ConcurrentHashMap();
    static final Map<Class<?>, MutablePair<List<Object>, Group>> initials = new ConcurrentHashMap();
    static final Map<Class<?>, ClassInfoImpl<?>> fromPreviousTestsCacheInfoCache = new ConcurrentHashMap(64);
    private static volatile FrameworkMethod method = null;
    private static volatile Object target = null;
    private static volatile Map<String, Set<String>> keyspaceKeyValues = null;
    static final List<StatementCaptureList<? extends GenericStatement>> captures = new CopyOnWriteArrayList<StatementCaptureList<? extends GenericStatement>>();
    static final List<Consumer<GenericStatement<?, ?>>> sent = new CopyOnWriteArrayList();
    static final AtomicInteger capturing = new AtomicInteger(0);
    static final AtomicInteger recursing = new AtomicInteger(0);
    static volatile boolean traceInternalCQL = false;
    private final String cfgname;
    private final long startupTimeout;
    private final long readTimeout;

    private static <S extends GenericStatement<?, ?>> S initTrace(S s) {
        if (traceInternalCQL) {
            s.enableTracing(TRACE_PREFIX);
        }
        s.enableErrorTracing(TRACE_PREFIX);
        return s;
    }

    private static StackTraceElement getCallerInfo() {
        Exception e = new Exception();
        for (StackTraceElement ste : e.getStackTrace()) {
            if (HelenusJUnit.class.getName().equals(ste.getClassName())) continue;
            return ste;
        }
        throw new IllegalStateException("missing caller's information");
    }

    /*
     * Exception decompiling
     */
    private static String readFully(File file) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void update(File cfgfile) throws IOException {
        String yaml = HelenusJUnit.readFully(cfgfile);
        StringBuffer sb = new StringBuffer(yaml.length() + 40);
        Matcher pm = portPattern.matcher(yaml);
        boolean updated = false;
        while (pm.find()) {
            String pname = pm.group(1);
            int port = Integer.parseInt(pm.group(2));
            if (port == 0) {
                ServerSocket socket = new ServerSocket(0);
                Throwable throwable = null;
                try {
                    pm.appendReplacement(sb, pname + socket.getLocalPort());
                    updated = true;
                    logger.info("Allocated free %s%d", (Object)pname, (Object)socket.getLocalPort());
                    continue;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (socket == null) continue;
                    if (throwable != null) {
                        try {
                            socket.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    socket.close();
                    continue;
                }
            }
            pm.appendReplacement(sb, pm.group());
        }
        pm.appendTail(sb);
        if (!StringUtils.isEmpty((CharSequence)fork)) {
            Matcher tm = targetPattern.matcher(sb.toString());
            sb.setLength(0);
            while (tm.find()) {
                String pname = tm.group(1);
                String tname = tm.group(2);
                String rest = tm.group(3);
                tm.appendReplacement(sb, pname + tname + '/' + fork + rest);
                updated = true;
            }
            tm.appendTail(sb);
        }
        if (updated) {
            FileUtils.writeStringToFile((File)cfgfile, (String)sb.toString(), (String)"utf-8");
        }
    }

    private static void cleanupAndCreateCassandraDirectories() {
        try {
            DatabaseDescriptor.createAllDirectories();
            File dir = new File(DatabaseDescriptor.getCommitLogLocation());
            if (!dir.exists()) {
                throw new FileNotFoundException("missing cassandra commit directory: " + dir.getAbsolutePath());
            }
            FileUtils.deleteDirectory((File)dir);
            for (String dname : DatabaseDescriptor.getAllDataFileLocations()) {
                File d = new File(dname);
                if (!d.exists()) {
                    throw new FileNotFoundException("missing cassandra data directory: " + d.getAbsolutePath());
                }
                FileUtils.deleteDirectory((File)dir);
            }
            DatabaseDescriptor.createAllDirectories();
            CommitLog.instance.getCurrentPosition();
            CommitLog.instance.resetUnsafe(true);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static Collection<Collection<Strings>> getKeyspaceKeyValues(ClassInfo<?> cinfo) {
        Map<String, Set<String>> skvss = keyspaceKeyValues;
        if (skvss == null) {
            return Collections.emptyList();
        }
        return skvss.entrySet().stream().map(e -> {
            FieldInfo finfo = cinfo.getKeyspaceKeyByType((String)e.getKey());
            if (finfo != null) {
                return ((Set)e.getValue()).stream().map(v -> new Strings(finfo.getKeyspaceKeyName(), (String)v)).collect(Collectors.toList());
            }
            return null;
        }).filter(p -> p != null).collect(Collectors.toList());
    }

    private static void processBeforeObjects(Group group, Method m, BeforeObjects bo, Object target, FrameworkMethod method, Map<String, String> kkeys, boolean onlyIfRequiresKeyspaceKeys) {
        if (!ArrayUtils.isEmpty((Object[])bo.value()) && !ArrayUtils.contains((Object[])bo.value(), (Object)method.getName())) {
            return;
        }
        try {
            Object ret;
            Class<?>[] cparms = m.getParameterTypes();
            if (cparms.length == 0) {
                ret = !onlyIfRequiresKeyspaceKeys ? m.invoke(target, new Object[0]) : null;
            } else {
                Type[] tparms = m.getGenericParameterTypes();
                if (cparms.length != 1 || !Map.class.isAssignableFrom(cparms[0]) || tparms.length != 1 || !(tparms[0] instanceof ParameterizedType)) {
                    throw new AssertionError((Object)("expecting one Map<String, String> parameter for @BeforeObjects method " + m.getName() + "(" + m.getDeclaringClass().getName() + ")"));
                }
                ParameterizedType ptype = (ParameterizedType)tparms[0];
                for (Type atype : ptype.getActualTypeArguments()) {
                    Class aclazz = ReflectionUtils.getRawClass((Type)atype);
                    if (String.class != aclazz) {
                        throw new AssertionError((Object)("expecting one Map<String, String> parameter for @BeforeObjects method " + m.getName() + "(" + m.getDeclaringClass().getName() + ")"));
                    }
                }
                ret = m.invoke(target, kkeys);
            }
            HelenusJUnit.processObjects(group, ret);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new IllegalStateException(t);
        }
    }

    private static void processObjects(Group group, Object ret) {
        if (ret == null) {
            return;
        }
        Class<?> type = ret.getClass();
        if (type.isArray()) {
            int l = Array.getLength(ret);
            for (int i = 0; i < l; ++i) {
                group.add((BatchableStatement)HelenusJUnit.initTrace(StatementBuilder.insert((Object)Array.get(ret, i)).intoAll()));
            }
        } else if (ret instanceof Collection) {
            ((Collection)ret).forEach(o -> group.add((BatchableStatement)HelenusJUnit.initTrace(StatementBuilder.insert((Object)o).intoAll())));
        } else if (ret instanceof Stream) {
            ((Stream)ret).forEach(o -> StatementBuilder.insert((Object)o).intoAll());
        } else if (ret instanceof Iterator) {
            Iterator i = (Iterator)ret;
            while (i.hasNext()) {
                group.add((BatchableStatement)HelenusJUnit.initTrace(StatementBuilder.insert(i.next()).intoAll()));
            }
        } else if (ret instanceof Enumeration) {
            Enumeration e = (Enumeration)ret;
            while (e.hasMoreElements()) {
                group.add((BatchableStatement)HelenusJUnit.initTrace(StatementBuilder.insert(e.nextElement()).intoAll()));
            }
        } else if (ret instanceof Iterable) {
            Iterator i = ((Iterable)ret).iterator();
            while (i.hasNext()) {
                group.add((BatchableStatement)HelenusJUnit.initTrace(StatementBuilder.insert(i.next()).intoAll()));
            }
        } else {
            group.add((BatchableStatement)HelenusJUnit.initTrace(StatementBuilder.insert((Object)ret).intoAll()));
        }
    }

    private static void processBeforeObjects() {
        Object target = HelenusJUnit.target;
        FrameworkMethod method = HelenusJUnit.method;
        if (target == null || method == null) {
            return;
        }
        Map<String, Set<String>> kkeys = keyspaceKeyValues;
        Collection<Object> keyspaceKeysByTypes = kkeys != null ? (Collection)kkeys.entrySet().stream().map(e -> ((Set)e.getValue()).stream().map(v -> new Strings((String)e.getKey(), (String)v)).collect(Collectors.toList())).collect(Collectors.toList()) : Collections.emptyList();
        Map methods = ReflectionUtils.getAllAnnotationsForMethodsAnnotatedWith(target.getClass(), BeforeObjects.class, (boolean)true);
        Group group = HelenusJUnit.initTrace(StatementBuilder.group((GroupableStatement[])new GroupableStatement[0]));
        if (CollectionUtils.isEmpty(keyspaceKeysByTypes)) {
            methods.forEach((m, bos) -> HelenusJUnit.processBeforeObjects(group, m, bos[0], target, method, Collections.emptyMap(), false));
        } else {
            boolean keyspace = false;
            CombinationIterator i = new CombinationIterator(Strings.class, keyspaceKeysByTypes);
            while (i.hasNext()) {
                List ikkeys = (List)i.next();
                HashMap kkeyvalues = new HashMap(ikkeys.size() * 3 / 2);
                boolean oirs = keyspace;
                ikkeys.forEach(ss -> kkeyvalues.put(ss.key, ss.value));
                methods.forEach((m, bos) -> HelenusJUnit.processBeforeObjects(group, m, bos[0], target, method, kkeyvalues, oirs));
                keyspace = true;
            }
        }
        group.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void start0(String cfgname, long startupTimeout, long readTimeout) {
        if (config != null) {
            if (config.equals(cfgname)) {
                return;
            }
            throw new AssertionError((Object)"Helenus cannot be started again with a different configuration");
        }
        try {
            File dir;
            config = cfgname;
            if (StringUtils.isEmpty((CharSequence)fork)) {
                logger.info("Starting Helenus...");
                dir = new File(RUNTIME_DIR);
            } else {
                logger.info("Starting Helenus fork #%s...", (Object)fork);
                dir = new File(RUNTIME_DIR + File.separatorChar + fork);
            }
            cfgname = StringUtils.prependIfMissing((String)cfgname, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
            File cfgfile = new File(dir, cfgname.substring(cfgname.lastIndexOf(47)));
            FileUtils.deleteDirectory((File)dir);
            FileUtils.forceMkdir((File)dir);
            InputStream cfgis = HelenusJUnit.class.getResourceAsStream(cfgname);
            if (cfgis == null) {
                throw new AssertionError((Object)("failed to locate config resource: " + cfgname));
            }
            FileUtils.copyInputStreamToFile((InputStream)cfgis, (File)cfgfile);
            HelenusJUnit.update(cfgfile);
            System.setProperty("cassandra.config", "file:" + cfgfile.getAbsolutePath());
            System.setProperty("cassandra-foreground", "true");
            System.setProperty("cassandra.native.epoll.enabled", "false");
            group = new ThreadGroup("Cassandra Daemon Group"){

                @Override
                public void uncaughtException(Thread t, Throwable e) {
                    logger.error("uncaught exception from cassandra daemon thread '" + t.getName() + "': ", e);
                    super.uncaughtException(t, e);
                }
            };
            final CountDownLatch latch = new CountDownLatch(1);
            final AtomicReference failed = new AtomicReference();
            Thread thread = new Thread(group, new Runnable(){

                @Override
                public void run() {
                    try {
                        HelenusJUnit.cleanupAndCreateCassandraDirectories();
                        daemon = new CassandraDaemon();
                        daemon.activate();
                    }
                    catch (Error | RuntimeException e) {
                        daemon = null;
                        failed.set(e);
                        throw e;
                    }
                    finally {
                        latch.countDown();
                    }
                }
            });
            thread.start();
            try {
                if (!latch.await(startupTimeout, TimeUnit.MILLISECONDS)) {
                    logger.error("Cassandra daemon failed to start within " + startupTimeout + "ms; increase the timeout");
                    Thread.getAllStackTraces().forEach((t, se) -> {
                        if (HelenusJUnit.isCassandraDaemonThread(t)) {
                            logger.error(t);
                            for (StackTraceElement te : se) {
                                logger.error("\tat %s", (Object)te);
                            }
                        }
                    });
                    logger.error("Cassandra daemon failed to start within %d ms", (Object)startupTimeout);
                    throw new AssertionError((Object)"cassandra daemon failed to start within timeout");
                }
                Throwable t2 = (Throwable)failed.get();
                if (t2 != null) {
                    logger.error("Cassandra daemon failed to start; %s", t2);
                    throw new AssertionError("cassandra daemon failed to start", t2);
                }
            }
            catch (InterruptedException e) {
                logger.error("interrupted waiting for cassandra daemon to start", (Throwable)e);
                throw new AssertionError((Object)e);
            }
            finally {
                thread.interrupt();
            }
            String host = DatabaseDescriptor.getRpcAddress().getHostName();
            int port = DatabaseDescriptor.getNativeTransportPort();
            logger.info("Cassandra started on '%s:%d'", (Object)host, (Object)port);
            try {
                manager = new StatementManagerUnitImpl((Cluster.Initializer)Cluster.builder().withQueryOptions(new QueryOptions().setRefreshSchemaIntervalMillis(0).setRefreshNodeIntervalMillis(0).setRefreshNodeListIntervalMillis(0)).withSocketOptions(new SocketOptions().setReadTimeoutMillis((int)readTimeout)).withRetryPolicy((RetryPolicy)new LoggingRetryPolicy(new RetryPolicy(){

                    public void init(Cluster cluster) {
                    }

                    public RetryPolicy.RetryDecision onReadTimeout(Statement statement, ConsistencyLevel cl, int requiredResponses, int receivedResponses, boolean dataRetrieved, int nbRetry) {
                        if (nbRetry < numReadRetries) {
                            return RetryPolicy.RetryDecision.rethrow();
                        }
                        return RetryPolicy.RetryDecision.retry((ConsistencyLevel)cl);
                    }

                    public RetryPolicy.RetryDecision onWriteTimeout(Statement statement, ConsistencyLevel cl, WriteType writeType, int requiredAcks, int receivedAcks, int nbRetry) {
                        if (nbRetry < numWriteRetries) {
                            return RetryPolicy.RetryDecision.rethrow();
                        }
                        return RetryPolicy.RetryDecision.retry((ConsistencyLevel)cl);
                    }

                    public RetryPolicy.RetryDecision onUnavailable(Statement statement, ConsistencyLevel cl, int requiredReplica, int aliveReplica, int nbRetry) {
                        return RetryPolicy.RetryDecision.rethrow();
                    }

                    public RetryPolicy.RetryDecision onRequestError(Statement statement, ConsistencyLevel cl, DriverException e, int nbRetry) {
                        return RetryPolicy.RetryDecision.rethrow();
                    }

                    public void close() {
                    }
                })).addContactPoint(host).withPort(port));
                if (fullTraces) {
                    manager.enableFullTraces();
                } else {
                    manager.disableFullTraces();
                }
                if (allStatementTraces) {
                    manager.enableAllStatementsTraces();
                } else {
                    manager.disableAllStatementsTraces();
                }
            }
            catch (SecurityException e) {
                logger.error("Failed to install Helenus statement manager as one is already registered (maybe through mocking)");
                try {
                    Field f = StatementManager.class.getDeclaredField("manager");
                    f.setAccessible(true);
                    Object mgr = f.get(null);
                    logger.error("*** manager: %s", mgr);
                    for (Class<?> c = mgr.getClass(); c != null; c = c.getSuperclass()) {
                        logger.debug("*** class: %s", c);
                    }
                    for (Class<?> clazz : mgr.getClass().getInterfaces()) {
                        logger.debug("*** interface: %s", clazz);
                    }
                    for (AnnotatedElement annotatedElement : mgr.getClass().getDeclaredFields()) {
                        ((Field)annotatedElement).setAccessible(true);
                        logger.debug("*** field(%s): %s", (Object)((Field)annotatedElement).getName(), ((Field)annotatedElement).get(mgr));
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw new AssertionError("failed to install Helenus statement manager", e);
            }
        }
        catch (OutOfMemoryError | StackOverflowError | ThreadDeath e) {
            config = null;
            group = null;
            daemon = null;
            manager = null;
            throw e;
        }
        catch (AssertionError e) {
            config = null;
            group = null;
            manager = null;
            if (daemon != null) {
                try {
                    daemon.deactivate();
                }
                catch (OutOfMemoryError | StackOverflowError | ThreadDeath ee) {
                    throw ee;
                }
                catch (Throwable ee) {
                }
                finally {
                    daemon = null;
                }
            }
            throw e;
        }
        catch (Throwable t3) {
            config = null;
            group = null;
            manager = null;
            if (daemon != null) {
                try {
                    daemon.deactivate();
                }
                catch (OutOfMemoryError | StackOverflowError | ThreadDeath ee) {
                    throw ee;
                }
                catch (Throwable throwable) {
                }
                finally {
                    daemon = null;
                }
            }
            throw new AssertionError("failed to start Cassandra daemon", t3);
        }
    }

    private static <T> void clearSchema0(ClassInfoImpl<T> cinfo, Group group) {
        if (cinfo instanceof UDTClassInfoImpl) {
            return;
        }
        try {
            Collection<Collection<Strings>> kkeys;
            capturing.incrementAndGet();
            recursing.incrementAndGet();
            Collection<Collection<Strings>> collection = kkeys = target != null ? HelenusJUnit.getKeyspaceKeyValues(cinfo) : null;
            if (CollectionUtils.isEmpty(kkeys)) {
                group.add((GroupableStatement)HelenusJUnit.initTrace(StatementBuilder.truncate((Class)cinfo.getObjectClass())));
            } else {
                CombinationIterator i = new CombinationIterator(Strings.class, kkeys);
                block8: while (i.hasNext()) {
                    Truncate truncate = HelenusJUnit.initTrace(StatementBuilder.truncate((Class)cinfo.getObjectClass()));
                    for (Strings ss : (List)i.next()) {
                        try {
                            truncate.where((Clause)StatementBuilder.eq((CharSequence)ss.key, (Object)ss.value));
                        }
                        catch (ExcludedKeyspaceKeyException e) {
                            continue block8;
                        }
                    }
                    group.add((GroupableStatement)truncate);
                }
            }
        }
        catch (AssertionError | OutOfMemoryError | StackOverflowError | ThreadDeath e) {
            throw e;
        }
        catch (Throwable t) {
            throw new AssertionError("failed to clear schema for " + cinfo.getObjectClass().getSimpleName(), t);
        }
        finally {
            recursing.decrementAndGet();
            capturing.decrementAndGet();
        }
    }

    private static synchronized void fullClear0() {
        StatementManagerUnitImpl mgr = manager;
        if (mgr != null) {
            try {
                for (KeyspaceMetadata keyspace : manager.getCluster().getMetadata().getKeyspaces()) {
                    String kname = keyspace.getName();
                    if ("system".equals(kname) || "system_auth".equals(kname) || "system_distributed".equals(kname) || "system_schema".equals(kname) || "system_traces".equals(kname)) continue;
                    mgr.getSession().execute("DROP KEYSPACE " + kname);
                }
                mgr.clearCache();
            }
            catch (AssertionError | OutOfMemoryError | StackOverflowError | ThreadDeath e) {
                throw e;
            }
            catch (Throwable t) {
                throw new AssertionError("failed to clean Cassandra database", t);
            }
        }
        schemas.clear();
        fromPreviousTestsCacheInfoCache.clear();
        initials.clear();
    }

    private static synchronized void clear0() {
        StatementManagerUnitImpl mgr = manager;
        if (mgr != null) {
            try {
                Group group = HelenusJUnit.initTrace(StatementBuilder.group((GroupableStatement[])new GroupableStatement[0]));
                mgr.classInfoImpls().filter(c -> !(c instanceof TypeClassInfo)).collect(Collectors.toSet()).forEach(c -> HelenusJUnit.clearSchema0(c, group));
                group.execute();
                mgr.classInfoImpls().forEach(c -> fromPreviousTestsCacheInfoCache.put(c.getObjectClass(), (ClassInfoImpl<?>)c));
                mgr.clearCache();
                for (String ks : StorageService.instance.getKeyspaces()) {
                    if (ks.startsWith("system")) continue;
                    logger.debug("Flushing and compacting keyspace: %s", (Object)ks);
                    StorageService.instance.forceKeyspaceFlush(ks, new String[0]);
                    StorageService.instance.forceKeyspaceCompaction(false, ks, new String[0]);
                }
            }
            catch (AssertionError | OutOfMemoryError | StackOverflowError | ThreadDeath e) {
                throw e;
            }
            catch (Throwable t) {
                throw new AssertionError("failed to clean Cassandra database", t);
            }
        }
        schemas.clear();
    }

    static <T> ClassInfoImpl<T> createSchema0(ClassInfoImpl<T> cinfo) {
        Validate.notNull(cinfo, (String)"invalid null class info", (Object[])new Object[0]);
        Class clazz = cinfo.getObjectClass();
        SchemaFuture result = new SchemaFuture(true, clazz);
        SchemaFuture future = schemas.putIfAbsent(cinfo.getObjectClass(), result);
        if (future != null) {
            future.waitForCompletion();
            return cinfo;
        }
        try {
            GroupImpl group;
            GroupImpl ygroup;
            GroupImpl igroup;
            GroupImpl tgroup;
            GroupImpl kgroup;
            Sequence sequence;
            ArrayList initials;
            boolean initialsOnly;
            block20: {
                Collection<Collection<Strings>> kkeys;
                block19: {
                    logger.debug("Creating schema for %s", (Object)clazz.getSimpleName());
                    capturing.incrementAndGet();
                    recursing.incrementAndGet();
                    Collection<Collection<Strings>> collection = kkeys = target != null ? HelenusJUnit.getKeyspaceKeyValues(cinfo) : null;
                    if (cinfo.getNumKeyspaceKeys() != CollectionUtils.size(kkeys)) {
                        throw new AssertionError((Object)("unable to create schema for '" + clazz.getSimpleName() + "'; missing required keyspace keys"));
                    }
                    initialsOnly = cinfo instanceof TypeClassInfoImpl && !((TypeClassInfoImpl)cinfo).isDynamic();
                    initials = new ArrayList();
                    sequence = StatementBuilder.sequence((SequenceableStatement[])new SequenceableStatement[0]);
                    kgroup = HelenusJUnit.initTrace((GroupImpl)StatementBuilder.group((GroupableStatement[])new GroupableStatement[0]));
                    tgroup = HelenusJUnit.initTrace((GroupImpl)StatementBuilder.group((GroupableStatement[])new GroupableStatement[0]));
                    igroup = HelenusJUnit.initTrace((GroupImpl)StatementBuilder.group((GroupableStatement[])new GroupableStatement[0]));
                    ygroup = HelenusJUnit.initTrace((GroupImpl)StatementBuilder.group((GroupableStatement[])new GroupableStatement[0]));
                    group = HelenusJUnit.initTrace((GroupImpl)StatementBuilder.group((GroupableStatement[])new GroupableStatement[0]));
                    if (!CollectionUtils.isEmpty(kkeys)) break block19;
                    initials.addAll(cinfo.newContext().getInitialObjects());
                    if (initialsOnly) break block20;
                    CreateSchemaImpl cs = HelenusJUnit.initTrace((CreateSchemaImpl)StatementBuilder.createSchema((Class)clazz));
                    cs.ifNotExists();
                    initials.addAll(cs.getContext().getInitialObjects());
                    if (initialsOnly) break block20;
                    cs.buildSequencedStatements(keyspaces, tables, kgroup, tgroup, igroup, (ParentStatementImpl)ygroup, group);
                    break block20;
                }
                CombinationIterator i = new CombinationIterator(Strings.class, kkeys);
                block8: while (i.hasNext()) {
                    CreateSchemaImpl cs = HelenusJUnit.initTrace((CreateSchemaImpl)StatementBuilder.createSchema((Class)clazz));
                    cs.ifNotExists();
                    for (Strings ss : (List)i.next()) {
                        try {
                            cs.where((Clause)StatementBuilder.eq((CharSequence)ss.key, (Object)ss.value));
                        }
                        catch (ExcludedKeyspaceKeyException e) {
                            continue block8;
                        }
                    }
                    initials.addAll(cs.getContext().getInitialObjects());
                    if (initialsOnly) continue;
                    cs.buildSequencedStatements(keyspaces, tables, kgroup, tgroup, igroup, (ParentStatementImpl)ygroup, group);
                }
            }
            HelenusJUnit.initials.put(clazz, (MutablePair<List<Object>, Group>)MutablePair.of(initials, null));
            if (initialsOnly) {
                HelenusJUnit.resetSchema0(cinfo, result);
            } else {
                if (!kgroup.isEmpty()) {
                    sequence.add((SequenceableStatement)kgroup);
                }
                if (!ygroup.isEmpty()) {
                    sequence.add((SequenceableStatement)ygroup);
                }
                if (!tgroup.isEmpty()) {
                    sequence.add((SequenceableStatement)tgroup);
                }
                if (!igroup.isEmpty()) {
                    sequence.add((SequenceableStatement)igroup);
                }
                if (!group.isEmpty()) {
                    sequence.add((SequenceableStatement)group);
                }
                sequence.execute();
            }
            result.completed();
            ClassInfoImpl<T> classInfoImpl = cinfo;
            return classInfoImpl;
        }
        catch (AssertionError | OutOfMemoryError | StackOverflowError | ThreadDeath e) {
            schemas.remove(clazz);
            initials.remove(clazz);
            throw result.failed((Throwable)e);
        }
        catch (Throwable t) {
            schemas.remove(clazz);
            initials.remove(clazz);
            throw result.failed(t);
        }
        finally {
            recursing.decrementAndGet();
            capturing.decrementAndGet();
        }
    }

    static <T> void resetSchema0(ClassInfoImpl<T> cinfo, SchemaFuture result) {
        Validate.notNull(cinfo, (String)"invalid null class info", (Object[])new Object[0]);
        Class clazz = cinfo.getObjectClass();
        if (result == null) {
            SchemaFuture myresult = new SchemaFuture(false, clazz);
            SchemaFuture future = schemas.putIfAbsent(cinfo.getObjectClass(), myresult);
            if (future != null) {
                future.waitForCompletion();
                return;
            }
            logger.debug("Resetting schema for %s", (Object)clazz.getSimpleName());
            result = myresult;
        }
        try {
            Group group;
            capturing.incrementAndGet();
            recursing.incrementAndGet();
            MutablePair p = initials.get(clazz);
            if (p == null) {
                Collection<Collection<Strings>> kkeys = target != null ? HelenusJUnit.getKeyspaceKeyValues(cinfo) : null;
                boolean initialsOnly = cinfo instanceof TypeClassInfoImpl && !((TypeClassInfoImpl)cinfo).isDynamic();
                ArrayList initials = new ArrayList();
                if (CollectionUtils.isEmpty(kkeys)) {
                    initials.addAll(cinfo.newContext().getInitialObjects());
                    if (!initialsOnly) {
                        CreateSchemaImpl cs = HelenusJUnit.initTrace((CreateSchemaImpl)StatementBuilder.createSchema((Class)clazz));
                        initials.addAll(cs.getContext().getInitialObjects());
                    }
                } else {
                    CombinationIterator i = new CombinationIterator(Strings.class, kkeys);
                    block8: while (i.hasNext()) {
                        CreateSchemaImpl cs = HelenusJUnit.initTrace((CreateSchemaImpl)StatementBuilder.createSchema((Class)clazz));
                        for (Strings ss : (List)i.next()) {
                            try {
                                cs.where((Clause)StatementBuilder.eq((CharSequence)ss.key, (Object)ss.value));
                            }
                            catch (ExcludedKeyspaceKeyException e) {
                                continue block8;
                            }
                        }
                        initials.addAll(cs.getContext().getInitialObjects());
                    }
                }
                p = MutablePair.of(initials, null);
                HelenusJUnit.initials.put(clazz, (MutablePair<List<Object>, Group>)p);
            }
            if (p.getRight() != null) {
                group = (Group)p.getRight();
            } else {
                group = HelenusJUnit.initTrace(StatementBuilder.group((GroupableStatement[])new GroupableStatement[0]));
                for (Object io : (List)p.getLeft()) {
                    group.add((BatchableStatement)HelenusJUnit.initTrace(StatementBuilder.insert(io).intoAll()));
                }
                p.setRight((Object)group);
            }
            group.execute();
            result.completed();
        }
        catch (AssertionError | OutOfMemoryError | StackOverflowError | ThreadDeath e) {
            schemas.remove(clazz);
            throw result.failed((Throwable)e);
        }
        catch (Throwable t) {
            schemas.remove(clazz);
            throw result.failed(t);
        }
        finally {
            recursing.decrementAndGet();
            capturing.decrementAndGet();
        }
    }

    public static boolean isCassandraDaemonThread(Thread thread) {
        if (thread != null) {
            for (ThreadGroup group = thread.getThreadGroup(); group != null; group = group.getParent()) {
                if (group != HelenusJUnit.group) continue;
                return true;
            }
        }
        return false;
    }

    public HelenusJUnit() {
        this(DEFAULT_CFG_FILE, 60000L, 12000L);
    }

    public HelenusJUnit(long startupTimeout) {
        this(DEFAULT_CFG_FILE, startupTimeout, 12000L);
    }

    public HelenusJUnit(long startupTimeout, long readTimeout) {
        this(DEFAULT_CFG_FILE, startupTimeout, readTimeout);
    }

    public HelenusJUnit(String cfgname, long startupTimeout) {
        this(cfgname, startupTimeout, 12000L);
    }

    public HelenusJUnit(String cfgname, long startupTimeout, long readTimeout) {
        Validate.notNull((Object)cfgname, (String)"invalid null config file", (Object[])new Object[0]);
        this.cfgname = cfgname;
        this.startupTimeout = startupTimeout;
        this.readTimeout = readTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void before(FrameworkMethod method, Object target) {
        LinkedHashMap<String, Set<String>> kkeys = new LinkedHashMap<String, Set<String>>(12);
        Class<HelenusJUnit> clazz = HelenusJUnit.class;
        synchronized (HelenusJUnit.class) {
            if (HelenusJUnit.method != null) {
                throw (AssertionError)((Object)logger.throwing((Throwable)((Object)new AssertionError((Object)("already running test case " + method.getName() + "(" + method.getDeclaringClass().getName() + ")")))));
            }
            try {
                capturing.set(Integer.MAX_VALUE);
                HelenusJUnit.start0(this.cfgname, this.startupTimeout, this.readTimeout);
                HelenusJUnit.method = method;
                HelenusJUnit.target = target;
                for (PartitionKeyValues skvs : (PartitionKeyValues[])ReflectionJUnitUtils.getAnnotationsByType((Method)method.getMethod(), PartitionKeyValues.class)) {
                    kkeys.compute(skvs.type(), (t, s) -> {
                        if (s == null) {
                            s = new LinkedHashSet<String>(Math.max(1, skvs.values().length) * 3 / 2);
                        }
                        for (String v : skvs.values()) {
                            s.add(v);
                        }
                        return s;
                    });
                }
                keyspaceKeyValues = kkeys;
                HelenusJUnit.clear0();
            }
            catch (AssertionError | OutOfMemoryError | StackOverflowError | ThreadDeath e) {
                HelenusJUnit.method = null;
                HelenusJUnit.target = null;
                logger.error("Failed to start Cassandra daemon", (Throwable)e);
                throw e;
            }
            catch (Throwable t2) {
                HelenusJUnit.method = null;
                HelenusJUnit.target = null;
                logger.error("Failed to start Cassandra daemon", t2);
                throw new AssertionError("failed to start Cassandra daemon", t2);
            }
            finally {
                captures.clear();
            }
            try {
                capturing.set(0);
                capturing.incrementAndGet();
                recursing.set(0);
                recursing.incrementAndGet();
                HelenusJUnit.processBeforeObjects();
            }
            catch (AssertionError | OutOfMemoryError | StackOverflowError | ThreadDeath e) {
                HelenusJUnit.method = null;
                HelenusJUnit.target = null;
                throw e;
            }
            catch (Throwable t3) {
                HelenusJUnit.method = null;
                HelenusJUnit.target = null;
                throw new AssertionError("failed to install @BeforeObjects objects into Cassandra", t3);
            }
            finally {
                captures.clear();
            }
            recursing.set(0);
            capturing.set(0);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void after(FrameworkMethod method, Object target) {
        Class<HelenusJUnit> clazz = HelenusJUnit.class;
        synchronized (HelenusJUnit.class) {
            if (HelenusJUnit.method == method && HelenusJUnit.target == target) {
                HelenusJUnit.method = null;
                HelenusJUnit.target = null;
                capturing.set(0);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public void setNumberRetries(int retries) {
        numReadRetries = retries;
        numWriteRetries = retries;
    }

    public void setNumberReadRetries(int retries) {
        numReadRetries = retries;
    }

    public void setNumberWriteRetries(int retries) {
        numWriteRetries = retries;
    }

    public void enableInternalCQLTracing() {
        traceInternalCQL = true;
    }

    public void disableInternalCQLTracing() {
        traceInternalCQL = false;
    }

    public void enableFullTraces() {
        fullTraces = true;
        if (manager != null) {
            manager.enableFullTraces();
        }
    }

    public void disableFullTraces() {
        fullTraces = false;
        if (manager != null) {
            manager.disableFullTraces();
        }
    }

    public void enableAllStatementsTraces() {
        allStatementTraces = true;
        if (manager != null) {
            manager.enableAllStatementsTraces();
        }
    }

    public void disableAllStatementsTraces() {
        allStatementTraces = false;
        if (manager != null) {
            manager.disableAllStatementsTraces();
        }
    }

    public org.junit.runners.model.Statement apply(final org.junit.runners.model.Statement base, final FrameworkMethod method, final Object target) {
        return new org.junit.runners.model.Statement(){

            public void evaluate() throws Throwable {
                HelenusJUnit.this.before(method, target);
                try {
                    base.evaluate();
                }
                finally {
                    HelenusJUnit.this.after(method, target);
                }
            }
        };
    }

    public HelenusJUnit clear() {
        logger.debug("Clearing all schemas");
        HelenusJUnit.fullClear0();
        return this;
    }

    public HelenusJUnit createSchema(Class<?> clazz) {
        manager.getClassInfoImpl(clazz);
        return this;
    }

    public HelenusJUnit populate(Supplier<? super Object> objs) {
        if (objs == null) {
            return this;
        }
        try {
            capturing.incrementAndGet();
            Group group = HelenusJUnit.initTrace(StatementBuilder.group((GroupableStatement[])new GroupableStatement[0]));
            HelenusJUnit.processObjects(group, objs.get());
            group.execute();
        }
        catch (AssertionError | OutOfMemoryError | StackOverflowError | ThreadDeath e) {
            throw e;
        }
        catch (Throwable t) {
            throw new AssertionError("failed to populate objects", t);
        }
        finally {
            capturing.decrementAndGet();
        }
        return this;
    }

    public HelenusJUnit populate(Function<Map<String, String>, ? super Object> objs) {
        if (objs == null) {
            return this;
        }
        try {
            capturing.incrementAndGet();
            Map<String, Set<String>> kkeysValues = keyspaceKeyValues;
            Collection<Object> kkeysByTypes = kkeysValues != null ? (Collection)kkeysValues.entrySet().stream().map(e -> ((Set)e.getValue()).stream().map(v -> new Strings((String)e.getKey(), (String)v)).collect(Collectors.toList())).collect(Collectors.toList()) : Collections.emptyList();
            Group group = HelenusJUnit.initTrace(StatementBuilder.group((GroupableStatement[])new GroupableStatement[0]));
            if (CollectionUtils.isEmpty(kkeysByTypes)) {
                HelenusJUnit.processObjects(group, objs.apply(Collections.emptyMap()));
            } else {
                CombinationIterator i = new CombinationIterator(Strings.class, kkeysByTypes);
                while (i.hasNext()) {
                    List ikkeys = (List)i.next();
                    HashMap kkeys = new HashMap(ikkeys.size() * 3 / 2);
                    ikkeys.forEach(ss -> kkeys.put(ss.key, ss.value));
                    HelenusJUnit.processObjects(group, objs.apply(kkeys));
                }
            }
            group.execute();
        }
        catch (AssertionError | OutOfMemoryError | StackOverflowError | ThreadDeath e2) {
            throw e2;
        }
        catch (Throwable t) {
            throw new AssertionError("failed to populate objects", t);
        }
        finally {
            capturing.decrementAndGet();
        }
        return this;
    }

    public HelenusJUnit populate(Object ... objs) {
        if (objs == null) {
            return this;
        }
        return this.populate(Stream.of(objs));
    }

    public HelenusJUnit populate(Iterable<? super Object> objs) {
        if (objs == null) {
            return this;
        }
        return this.populate(objs.iterator());
    }

    public HelenusJUnit populate(Iterator<? super Object> objs) {
        if (objs == null) {
            return this;
        }
        try {
            capturing.incrementAndGet();
            Group group = HelenusJUnit.initTrace(StatementBuilder.group((GroupableStatement[])new GroupableStatement[0]));
            while (objs.hasNext()) {
                group.add((BatchableStatement)HelenusJUnit.initTrace(StatementBuilder.insert((Object)objs.next()).intoAll()));
            }
            group.execute();
        }
        catch (AssertionError | OutOfMemoryError | StackOverflowError | ThreadDeath e) {
            throw e;
        }
        catch (Throwable t) {
            throw new AssertionError("failed to populate objects", t);
        }
        finally {
            capturing.decrementAndGet();
        }
        return this;
    }

    public HelenusJUnit populate(Stream<? super Object> objs) {
        if (objs == null) {
            return this;
        }
        try {
            capturing.incrementAndGet();
            Group group = HelenusJUnit.initTrace(StatementBuilder.group((GroupableStatement[])new GroupableStatement[0]));
            objs.forEachOrdered(o -> group.add((BatchableStatement)HelenusJUnit.initTrace(StatementBuilder.insert((Object)o).intoAll())));
            group.execute();
        }
        catch (AssertionError | OutOfMemoryError | StackOverflowError | ThreadDeath e) {
            throw e;
        }
        catch (Throwable t) {
            throw new AssertionError("failed to populate objects", t);
        }
        finally {
            capturing.decrementAndGet();
        }
        return this;
    }

    public HelenusJUnit truncate(Class<?> ... classes) {
        if (classes == null) {
            return this;
        }
        return this.truncate(Stream.of(classes));
    }

    public HelenusJUnit truncate(Iterable<Class<?>> classes) {
        if (classes == null) {
            return this;
        }
        return this.truncate(classes.iterator());
    }

    public HelenusJUnit truncate(Iterator<Class<?>> classes) {
        if (classes == null) {
            return this;
        }
        try {
            capturing.incrementAndGet();
            Group group = HelenusJUnit.initTrace(StatementBuilder.group((GroupableStatement[])new GroupableStatement[0]));
            while (classes.hasNext()) {
                group.add((GroupableStatement)HelenusJUnit.initTrace(StatementBuilder.truncate(classes.next())));
            }
            group.execute();
        }
        catch (AssertionError | OutOfMemoryError | StackOverflowError | ThreadDeath e) {
            throw e;
        }
        catch (Throwable t) {
            throw new AssertionError("failed to truncate classes", t);
        }
        finally {
            capturing.decrementAndGet();
        }
        return this;
    }

    public HelenusJUnit truncate(Stream<Class<?>> classes) {
        if (classes == null) {
            return this;
        }
        try {
            capturing.incrementAndGet();
            Group group = HelenusJUnit.initTrace(StatementBuilder.group((GroupableStatement[])new GroupableStatement[0]));
            classes.forEach(c -> {
                Collection<Collection<Strings>> kkeys;
                ClassInfo cinfo = StatementBuilder.getClassInfo((Class)c);
                Collection<Collection<Strings>> collection = kkeys = target != null ? HelenusJUnit.getKeyspaceKeyValues(cinfo) : null;
                if (CollectionUtils.isEmpty(kkeys)) {
                    group.add((GroupableStatement)HelenusJUnit.initTrace(StatementBuilder.truncate((Class)c)));
                } else {
                    CombinationIterator i = new CombinationIterator(Strings.class, kkeys);
                    block2: while (i.hasNext()) {
                        Truncate truncate = HelenusJUnit.initTrace(StatementBuilder.truncate((Class)c));
                        for (Strings ss : (List)i.next()) {
                            try {
                                truncate.where((Clause)StatementBuilder.eq((CharSequence)ss.key, (Object)ss.value));
                            }
                            catch (ExcludedKeyspaceKeyException e) {
                                continue block2;
                            }
                        }
                        group.add((GroupableStatement)truncate);
                    }
                }
            });
            group.execute();
        }
        catch (AssertionError | OutOfMemoryError | StackOverflowError | ThreadDeath e) {
            throw e;
        }
        catch (Throwable t) {
            throw new AssertionError("failed to truncate classes", t);
        }
        finally {
            capturing.decrementAndGet();
        }
        return this;
    }

    public HelenusJUnit execute(String ... statements) {
        if (statements == null) {
            return this;
        }
        return this.execute(Stream.of(statements));
    }

    public HelenusJUnit execute(Iterable<String> statements) {
        if (statements == null) {
            return this;
        }
        return this.execute(statements.iterator());
    }

    public HelenusJUnit execute(Iterator<String> statements) {
        if (statements == null) {
            return this;
        }
        try {
            capturing.incrementAndGet();
            Sequence sequence = HelenusJUnit.initTrace(StatementBuilder.sequence((SequenceableStatement[])new SequenceableStatement[0]));
            while (statements.hasNext()) {
                sequence.add((RegularStatement)new SimpleStatement(statements.next()));
            }
            sequence.execute();
        }
        catch (AssertionError | OutOfMemoryError | StackOverflowError | ThreadDeath e) {
            throw e;
        }
        catch (Throwable t) {
            throw new AssertionError("failed to execute statements", t);
        }
        finally {
            capturing.decrementAndGet();
        }
        return this;
    }

    public HelenusJUnit execute(Stream<String> statements) {
        if (statements == null) {
            return this;
        }
        try {
            capturing.incrementAndGet();
            Sequence sequence = HelenusJUnit.initTrace(StatementBuilder.sequence((SequenceableStatement[])new SequenceableStatement[0]));
            statements.forEach(s -> sequence.add((RegularStatement)new SimpleStatement(s)));
            sequence.execute();
        }
        catch (AssertionError | OutOfMemoryError | StackOverflowError | ThreadDeath e) {
            throw e;
        }
        catch (Throwable t) {
            throw new AssertionError("failed to execute statements", t);
        }
        finally {
            capturing.decrementAndGet();
        }
        return this;
    }

    public HelenusJUnit schema(Class<?> ... classes) {
        if (classes == null) {
            return this;
        }
        return this.schema(Stream.of(classes));
    }

    public HelenusJUnit schema(Iterable<Class<?>> classes) {
        if (classes == null) {
            return this;
        }
        return this.schema(classes.iterator());
    }

    public HelenusJUnit schema(Iterator<Class<?>> classes) {
        if (classes == null) {
            return this;
        }
        try {
            capturing.incrementAndGet();
            while (classes.hasNext()) {
                StatementBuilder.getClassInfo(classes.next());
            }
        }
        catch (AssertionError | OutOfMemoryError | StackOverflowError | ThreadDeath e) {
            throw e;
        }
        catch (Throwable t) {
            throw new AssertionError("failed to initialize schemas", t);
        }
        finally {
            capturing.decrementAndGet();
        }
        return this;
    }

    public HelenusJUnit schema(Stream<Class<?>> classes) {
        if (classes == null) {
            return this;
        }
        try {
            capturing.incrementAndGet();
            classes.forEach(c -> StatementBuilder.getClassInfo((Class)c));
        }
        catch (AssertionError | OutOfMemoryError | StackOverflowError | ThreadDeath e) {
            throw e;
        }
        catch (Throwable t) {
            throw new AssertionError("failed to initialize schemas", t);
        }
        finally {
            capturing.decrementAndGet();
        }
        return this;
    }

    public StatementCaptureList<GenericStatement> withCapture() {
        return this.withCapture(GenericStatement.class);
    }

    public <T extends GenericStatement> StatementCaptureList<T> withCapture(Class<T> clazz) {
        Validate.notNull(clazz, (String)"invalid null class", (Object[])new Object[0]);
        StatementCaptureList<T> cl = new StatementCaptureList<T>(HelenusJUnit.getCallerInfo(), clazz);
        captures.add(cl);
        return cl;
    }

    public HelenusJUnit withoutCapture() {
        captures.forEach(cl -> cl.stop());
        return this;
    }

    public <E extends Throwable> HelenusJUnit inhibitCapturing(ERunnable<E> cmd) throws E {
        try {
            capturing.incrementAndGet();
            cmd.run();
        }
        finally {
            capturing.decrementAndGet();
        }
        return this;
    }

    public boolean dumpCaptures(Logger logger, Level level) {
        if (!captures.isEmpty() && logger.isEnabled(level)) {
            logger.log(level, "StatementCaptureLists:");
            captures.forEach(cl -> cl.dump(logger, level));
            return true;
        }
        return false;
    }

    public HelenusJUnit whenSent(Consumer<GenericStatement<?, ?>> consumer) {
        sent.add(consumer);
        return this;
    }

    private static class StatementManagerUnitImpl
    extends StatementManagerImpl {
        StatementManagerUnitImpl(Cluster.Initializer initializer) {
            super(initializer, 1, true);
        }

        private <T> void handleBaseClassInfo(ClassInfo<T> cinfo) {
            if (recursing.get() > 0) {
                return;
            }
            if (cinfo instanceof RootClassInfoImpl) {
                ((RootClassInfoImpl)cinfo).types().forEachOrdered(t -> this.getClassInfoImpl(t.getObjectClass()));
            } else if (cinfo instanceof TypeClassInfoImpl) {
                TypeClassInfoImpl tcinfo = (TypeClassInfoImpl)cinfo;
                tcinfo.getRoot().types().filter(t -> !cinfo.getObjectClass().equals(t.getObjectClass())).filter(t -> cinfo.getObjectClass().isAssignableFrom(t.getObjectClass())).forEachOrdered(t -> this.getClassInfoImpl(t.getObjectClass()));
            } else if (cinfo instanceof UDTRootClassInfoImpl) {
                ((UDTRootClassInfoImpl)cinfo).types().forEachOrdered(t -> this.getClassInfoImpl(t.getObjectClass()));
            } else if (cinfo instanceof UDTTypeClassInfoImpl) {
                UDTTypeClassInfoImpl tcinfo = (UDTTypeClassInfoImpl)cinfo;
                tcinfo.getRoot().types().filter(t -> !cinfo.getObjectClass().equals(t.getObjectClass())).filter(t -> cinfo.getObjectClass().isAssignableFrom(t.getObjectClass())).forEachOrdered(t -> this.getClassInfoImpl(t.getObjectClass()));
            }
        }

        protected void clearCache() {
            super.clearCache();
        }

        protected void executing(StatementImpl<?, ?, ?> statement) {
            if (statement.isEnabled() && (capturing.get() == 0 || captures.isEmpty())) {
                captures.forEach(l -> l.executing(statement));
            }
        }

        protected ResultSetFuture sent(StatementImpl<?, ?, ?> statement, ResultSetFuture future) {
            if (capturing.get() == 0) {
                sent.forEach(c -> c.accept(statement));
            }
            return future;
        }

        protected <T> Insert.Builder<T> insert(T object) {
            if (object != null) {
                this.handleBaseClassInfo(this.getClassInfo(object.getClass()));
            }
            try {
                recursing.incrementAndGet();
                Insert.Builder builder = super.insert(object);
                return builder;
            }
            finally {
                recursing.decrementAndGet();
            }
        }

        protected <T> Update<T> update(T object) {
            if (object != null) {
                this.handleBaseClassInfo(this.getClassInfo(object.getClass()));
            }
            try {
                recursing.incrementAndGet();
                Update update = super.update(object);
                return update;
            }
            finally {
                recursing.decrementAndGet();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected <T> Update<T> update(T object, String ... tables) {
            if (object != null) {
                this.handleBaseClassInfo(this.getClassInfo(object.getClass()));
            }
            try {
                recursing.incrementAndGet();
                Update update = super.update(object, tables);
                return update;
            }
            finally {
                recursing.decrementAndGet();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected <T> Delete.Builder<T> delete(T object, String ... columns) {
            if (object != null) {
                this.handleBaseClassInfo(this.getClassInfo(object.getClass()));
            }
            try {
                recursing.incrementAndGet();
                Delete.Builder builder = super.delete(object, columns);
                return builder;
            }
            finally {
                recursing.decrementAndGet();
            }
        }

        protected <T> Delete.Selection<T> delete(T object) {
            if (object != null) {
                this.handleBaseClassInfo(this.getClassInfo(object.getClass()));
            }
            try {
                recursing.incrementAndGet();
                Delete.Selection selection = super.delete(object);
                return selection;
            }
            finally {
                recursing.decrementAndGet();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected <T> Delete.Builder<T> delete(Class<T> clazz, String ... columns) {
            if (clazz != null) {
                this.handleBaseClassInfo(this.getClassInfo(clazz));
            }
            try {
                recursing.incrementAndGet();
                Delete.Builder builder = super.delete(clazz, columns);
                return builder;
            }
            finally {
                recursing.decrementAndGet();
            }
        }

        protected <T> Delete.Selection<T> delete(Class<T> clazz) {
            if (clazz != null) {
                this.handleBaseClassInfo(this.getClassInfo(clazz));
            }
            try {
                recursing.incrementAndGet();
                Delete.Selection selection = super.delete(clazz);
                return selection;
            }
            finally {
                recursing.decrementAndGet();
            }
        }

        protected <T> CreateKeyspace<T> createKeyspace(Class<T> clazz) {
            if (clazz != null) {
                this.handleBaseClassInfo(this.getClassInfo(clazz));
            }
            try {
                recursing.incrementAndGet();
                CreateKeyspace createKeyspace = super.createKeyspace(clazz);
                return createKeyspace;
            }
            finally {
                recursing.decrementAndGet();
            }
        }

        protected <T> CreateType<T> createType(Class<T> clazz) {
            if (clazz != null) {
                this.handleBaseClassInfo(this.getClassInfo(clazz));
            }
            try {
                recursing.incrementAndGet();
                CreateType createType = super.createType(clazz);
                return createType;
            }
            finally {
                recursing.decrementAndGet();
            }
        }

        protected <T> CreateTable<T> createTable(Class<T> clazz) {
            if (clazz != null) {
                this.handleBaseClassInfo(this.getClassInfo(clazz));
            }
            try {
                recursing.incrementAndGet();
                CreateTable createTable = super.createTable(clazz);
                return createTable;
            }
            finally {
                recursing.decrementAndGet();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected <T> CreateTable<T> createTable(Class<T> clazz, String ... tables) {
            if (clazz != null) {
                this.handleBaseClassInfo(this.getClassInfo(clazz));
            }
            try {
                recursing.incrementAndGet();
                CreateTable createTable = super.createTable(clazz, tables);
                return createTable;
            }
            finally {
                recursing.decrementAndGet();
            }
        }

        protected <T> CreateIndex.Builder<T> createIndex(Class<T> clazz) {
            if (clazz != null) {
                this.handleBaseClassInfo(this.getClassInfo(clazz));
            }
            try {
                recursing.incrementAndGet();
                CreateIndex.Builder builder = super.createIndex(clazz);
                return builder;
            }
            finally {
                recursing.decrementAndGet();
            }
        }

        protected <T> CreateSchema<T> createSchema(Class<T> clazz) {
            if (clazz != null) {
                this.handleBaseClassInfo(this.getClassInfo(clazz));
            }
            try {
                recursing.incrementAndGet();
                CreateSchema createSchema = super.createSchema(clazz);
                return createSchema;
            }
            finally {
                recursing.decrementAndGet();
            }
        }

        protected CreateSchemas createSchemas(String[] pkgs) {
            CreateSchemas c;
            try {
                recursing.incrementAndGet();
                c = super.createSchemas(pkgs);
            }
            finally {
                recursing.decrementAndGet();
            }
            c.classInfos().forEachOrdered(cinfo -> this.handleBaseClassInfo((ClassInfo)cinfo));
            return c;
        }

        protected CreateSchemas createMatchingSchemas(String[] pkgs) {
            CreateSchemas c;
            try {
                recursing.incrementAndGet();
                c = super.createMatchingSchemas(pkgs);
            }
            finally {
                recursing.decrementAndGet();
            }
            c.classInfos().forEachOrdered(cinfo -> this.handleBaseClassInfo((ClassInfo)cinfo));
            return c;
        }

        protected <T> AlterSchema<T> alterSchema(Class<T> clazz) {
            if (clazz != null) {
                this.handleBaseClassInfo(this.getClassInfo(clazz));
            }
            try {
                recursing.incrementAndGet();
                AlterSchema alterSchema = super.alterSchema(clazz);
                return alterSchema;
            }
            finally {
                recursing.decrementAndGet();
            }
        }

        protected AlterSchemas alterSchemas(String[] pkgs) {
            AlterSchemas a;
            try {
                recursing.incrementAndGet();
                a = super.alterSchemas(pkgs);
            }
            finally {
                recursing.decrementAndGet();
            }
            a.classInfos().forEachOrdered(cinfo -> this.handleBaseClassInfo((ClassInfo)cinfo));
            return a;
        }

        protected AlterSchemas alterMatchingSchemas(String[] pkgs) {
            AlterSchemas a;
            try {
                recursing.incrementAndGet();
                a = super.alterMatchingSchemas(pkgs);
            }
            finally {
                recursing.decrementAndGet();
            }
            a.classInfos().forEachOrdered(cinfo -> this.handleBaseClassInfo((ClassInfo)cinfo));
            return a;
        }

        protected <T> Truncate<T> truncate(Class<T> clazz) {
            if (clazz != null) {
                this.handleBaseClassInfo(this.getClassInfo(clazz));
            }
            try {
                recursing.incrementAndGet();
                Truncate truncate = super.truncate(clazz);
                return truncate;
            }
            finally {
                recursing.decrementAndGet();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected <T> Truncate<T> truncate(Class<T> clazz, String ... tables) {
            if (clazz != null) {
                this.handleBaseClassInfo(this.getClassInfo(clazz));
            }
            try {
                recursing.incrementAndGet();
                Truncate truncate = super.truncate(clazz, tables);
                return truncate;
            }
            finally {
                recursing.decrementAndGet();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected <T> Select.Builder<T> select(Class<T> clazz, CharSequence ... columns) {
            if (clazz != null) {
                this.handleBaseClassInfo(this.getClassInfo(clazz));
            }
            try {
                recursing.incrementAndGet();
                Select.Builder builder = super.select(clazz, columns);
                return builder;
            }
            finally {
                recursing.decrementAndGet();
            }
        }

        protected <T> Select.Selection<T> select(Class<T> clazz) {
            if (clazz != null) {
                this.handleBaseClassInfo(this.getClassInfo(clazz));
            }
            try {
                recursing.incrementAndGet();
                Select.Selection selection = super.select(clazz);
                return selection;
            }
            finally {
                recursing.decrementAndGet();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected <T> Select<T> selectFrom(TableInfo<T> table, CharSequence ... columns) {
            if (table != null) {
                this.handleBaseClassInfo(table.getClassInfo());
            }
            try {
                recursing.incrementAndGet();
                Select select = super.selectFrom(table, columns);
                return select;
            }
            finally {
                recursing.decrementAndGet();
            }
        }

        protected <T> Select.TableSelection<T> selectFrom(TableInfo<T> table) {
            if (table != null) {
                this.handleBaseClassInfo(table.getClassInfo());
            }
            try {
                recursing.incrementAndGet();
                Select.TableSelection tableSelection = super.selectFrom(table);
                return tableSelection;
            }
            finally {
                recursing.decrementAndGet();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> ClassInfoImpl<T> getClassInfoImpl(Class<T> clazz) {
            try {
                recursing.incrementAndGet();
                ClassInfoImpl cinfo = fromPreviousTestsCacheInfoCache.remove(clazz);
                if (cinfo != null) {
                    if (cinfo instanceof TypeClassInfoImpl) {
                        this.getClassInfoImpl(((TypeClassInfoImpl)cinfo).getRoot().getObjectClass());
                    }
                    HelenusJUnit.resetSchema0(cinfo, null);
                    super.cacheClassInfoIfAbsent(cinfo);
                    ClassInfoImpl classInfoImpl = cinfo;
                    return classInfoImpl;
                }
                cinfo = this.get(clazz);
                if (cinfo != null) {
                    ClassInfoImpl classInfoImpl = cinfo;
                    return classInfoImpl;
                }
                ClassInfoImpl classInfoImpl = HelenusJUnit.createSchema0(super.getClassInfoImpl(clazz));
                return classInfoImpl;
            }
            finally {
                recursing.decrementAndGet();
            }
        }
    }
}

