/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.driver.junit;

class SchemaFuture {
    private final Thread owner = Thread.currentThread();
    private final boolean creating;
    private final Class<?> clazz;
    private volatile boolean done = false;
    private Throwable error = null;

    SchemaFuture(boolean creating, Class<?> clazz) {
        this.creating = creating;
        this.clazz = clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForCompletion() {
        if (this.owner != Thread.currentThread()) {
            SchemaFuture schemaFuture = this;
            synchronized (schemaFuture) {
                boolean interrupted = false;
                try {
                    while (!this.done) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e) {
                            interrupted = true;
                        }
                    }
                }
                finally {
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
                if (this.error instanceof Error) {
                    throw (Error)this.error;
                }
                if (this.error instanceof RuntimeException) {
                    throw (RuntimeException)this.error;
                }
                throw new AssertionError("failed to " + (this.creating ? "create" : "reset") + " for " + this.clazz.getSimpleName(), this.error);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completed() {
        if (!this.done) {
            SchemaFuture schemaFuture = this;
            synchronized (schemaFuture) {
                this.done = true;
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Error failed(Throwable t) throws Error {
        if (!this.done) {
            SchemaFuture schemaFuture = this;
            synchronized (schemaFuture) {
                this.done = true;
                this.error = t;
                this.notifyAll();
            }
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw new AssertionError("failed to " + (this.creating ? "create" : "reset") + " schema for " + this.clazz.getSimpleName(), t);
    }
}

