/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.driver.junit;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.hamcrest.Matcher;
import org.helenus.driver.Delete;
import org.helenus.driver.GenericStatement;
import org.helenus.driver.Insert;
import org.helenus.driver.Select;
import org.helenus.driver.Update;
import org.helenus.driver.impl.ParentStatementImpl;
import org.helenus.driver.impl.StatementImpl;
import org.helenus.driver.junit.StatementCaptureListMatcher;
import org.helenus.driver.junit.StatementCaptureListMatchers;

public class StatementCaptureList<T extends GenericStatement> {
    private final StackTraceElement created;
    private final List<? extends GenericStatement> list = new ArrayList<GenericStatement>(8);
    private final List<MutablePair<Consumer<? extends GenericStatement>, Integer>> interceptors = new ArrayList<MutablePair<Consumer<? extends GenericStatement>, Integer>>(4);
    private final Class<T> clazz;
    private volatile boolean capturing = true;

    private static String getType(GenericStatement statement) {
        if (statement instanceof Update) {
            return "Update";
        }
        if (statement instanceof Insert) {
            return "Insert";
        }
        if (statement instanceof Delete) {
            return "Delete";
        }
        if (statement instanceof Select) {
            return "Select";
        }
        return StringUtils.removeEnd((String)StringUtils.removeEnd((String)statement.getClass().getSimpleName(), (String)"Impl"), (String)"Statement");
    }

    StatementCaptureList(StackTraceElement created, Class<T> clazz) {
        this.created = created;
        this.clazz = clazz;
    }

    synchronized void executing(StatementImpl<?, ?, ?> statement) {
        if (this.capturing) {
            Stream s = statement instanceof ParentStatementImpl ? ((ParentStatementImpl)statement).objectStatements() : Stream.of(statement);
            s.forEachOrdered(os -> {
                if (this.clazz.isInstance(os)) {
                    if (this.list.stream().anyMatch(ls -> ls == os)) {
                        return;
                    }
                    Iterator<MutablePair<Consumer<? extends GenericStatement>, Integer>> i = this.interceptors.iterator();
                    while (i.hasNext()) {
                        MutablePair<Consumer<? extends GenericStatement>, Integer> m = i.next();
                        int num = (Integer)m.getRight() - 1;
                        if (num <= 0) {
                            i.remove();
                        }
                        ((Consumer)m.getLeft()).accept(os);
                    }
                    this.list.add((GenericStatement)os);
                }
            });
        }
    }

    public StatementCaptureList<T> stop() {
        this.capturing = false;
        return this;
    }

    public StatementCaptureList<T> dump(Logger logger, Level level) {
        if (logger.isEnabled(level)) {
            int s = this.size();
            logger.log(level, "");
            logger.log(level, "%20s = %s", (Object)"Created at", (Object)this.created);
            logger.log(level, "%20s = %s", (Object)"Statement class", (Object)this.clazz.getSimpleName());
            if (s == this.list.size()) {
                logger.log(level, "%20s = %d", (Object)"Size", (Object)s);
            } else {
                logger.log(level, "%20s = %d (Collected: %d)", (Object)"Size", (Object)s, (Object)this.list.size());
            }
            logger.log(level, "%20s:", (Object)"Content");
            int j = -1;
            for (GenericStatement genericStatement : this.list) {
                if (!genericStatement.isEnabled()) continue;
                logger.log(level, "%20s = %10s -> %s", (Object)("[" + ++j + "]"), (Object)StatementCaptureList.getType(genericStatement), (Object)genericStatement);
            }
        }
        return this;
    }

    public int size() {
        return (int)this.list.stream().filter(GenericStatement::isEnabled).count();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public StatementCaptureList<T> intercept(Consumer<T> consumer) {
        return this.intercept(Integer.MAX_VALUE, consumer);
    }

    public StatementCaptureList<T> intercept(int num, Consumer<T> consumer) {
        Validate.notNull(consumer, (String)"invalid null consumer", (Object[])new Object[0]);
        if (num > 0) {
            this.interceptors.add((MutablePair<Consumer<? extends GenericStatement>, Integer>)MutablePair.of(consumer, (Object)num));
        }
        return this;
    }

    public StatementCaptureList<T> fail(RuntimeException e) {
        return this.fail(Integer.MAX_VALUE, e);
    }

    public StatementCaptureList<T> fail(int num, RuntimeException e) {
        Validate.notNull((Object)e, (String)"invalid null error", (Object[])new Object[0]);
        return this.intercept(num, s -> {
            e.fillInStackTrace();
            throw e;
        });
    }

    public StatementCaptureList<T> stopIntercepting() {
        this.interceptors.clear();
        return this;
    }

    public T on(int i) {
        int j = -1;
        for (GenericStatement genericStatement : this.list) {
            if (!genericStatement.isEnabled() || ++j != i) continue;
            return (T)genericStatement;
        }
        throw new AssertionError((Object)("not enough captured statements; only " + (j + 1) + " statements were captured and at least " + (i + 1) + " was expected"));
    }

    public StatementCaptureList<T> andExpect(StatementCaptureListMatcher<T> matcher) throws Exception {
        matcher.match(this);
        return this;
    }

    public StatementCaptureList<T> andExpect(Matcher<StatementCaptureList<T>> matcher) throws Exception {
        StatementCaptureListMatchers.assertThat("Capture List", this, matcher);
        return this;
    }
}

