/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.driver.junit;

import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;
import org.helenus.driver.GenericStatement;
import org.helenus.driver.junit.StatementCaptureList;
import org.helenus.driver.junit.StatementCaptureListMatcher;

public abstract class StatementCaptureListMatchers {
    static <T> void assertThat(T actual, Matcher<T> matcher) {
        StatementCaptureListMatchers.assertThat("", actual, matcher);
    }

    static <T> void assertThat(String reason, T actual, Matcher<T> matcher) {
        if (!matcher.matches(actual)) {
            StringDescription description = new StringDescription();
            if (!reason.isEmpty()) {
                description.appendText(reason).appendText("\n");
            }
            description.appendText("Expected: ").appendDescriptionOf(matcher).appendText("\n     but: ");
            matcher.describeMismatch(actual, (Description)description);
            throw new AssertionError((Object)description.toString());
        }
    }

    public static <T extends GenericStatement> StatementCaptureListMatcher<T> size(final Matcher<Integer> matcher) {
        return new StatementCaptureListMatcher<T>(){

            @Override
            public void match(StatementCaptureList<T> list) throws Exception {
                StatementCaptureListMatchers.assertThat("Size", list.size(), matcher);
            }
        };
    }

    public static <T extends GenericStatement> Matcher<StatementCaptureList<T>> isEmpty() {
        return new BaseMatcher<StatementCaptureList<T>>(){

            public boolean matches(Object obj) {
                return ((StatementCaptureList)obj).isEmpty();
            }

            public void describeMismatch(Object obj, Description description) {
                description.appendText("not empty");
            }

            public void describeTo(Description description) {
                description.appendValue((Object)"is empty");
            }
        };
    }

    public static <T extends GenericStatement> Matcher<StatementCaptureList<T>> isNotEmpty() {
        return new BaseMatcher<StatementCaptureList<T>>(){

            public boolean matches(Object obj) {
                return !((StatementCaptureList)obj).isEmpty();
            }

            public void describeMismatch(Object obj, Description description) {
                description.appendText("empty");
            }

            public void describeTo(Description description) {
                description.appendValue((Object)"is not empty");
            }
        };
    }
}

