/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.driver.junit.hamcrest;

import java.lang.reflect.Field;
import java.util.Optional;
import org.hamcrest.Description;
import org.hamcrest.DiagnosingMatcher;
import org.helenus.driver.persistence.Column;
import org.helenus.util.Objects;

class AreColumnsEqual<T>
extends DiagnosingMatcher<T> {
    final T expected;
    final Field field;
    final String columns;
    final Double epsilon;

    AreColumnsEqual(T expected, Field field, Column[] columns) {
        this(expected, field, columns, null);
    }

    AreColumnsEqual(T expected, Field field, Column[] columns, Double epsilon) {
        this.expected = expected;
        this.field = field;
        StringBuilder sb = new StringBuilder();
        for (Column c : columns) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(c.name());
        }
        this.columns = sb.toString();
        this.epsilon = epsilon;
        field.setAccessible(true);
    }

    AreColumnsEqual(T expected, Field field, String column) {
        this(expected, field, column, null);
    }

    AreColumnsEqual(T expected, Field field, String column, Double epsilon) {
        this.expected = expected;
        this.field = field;
        this.columns = column;
        this.epsilon = epsilon;
        field.setAccessible(true);
    }

    protected boolean matches(Object item, Description mismatch) {
        if (item == null) {
            if (this.expected != null) {
                mismatch.appendText("however the pojo was null");
                return false;
            }
            return true;
        }
        if (item == this.expected) {
            return true;
        }
        if (this.expected == null) {
            mismatch.appendText("however the pojo was not null");
            return false;
        }
        if (!this.expected.getClass().isInstance(item)) {
            mismatch.appendText("however the pojo was not an instance of ").appendText(this.expected.getClass().getName());
            return false;
        }
        try {
            boolean matched;
            Object ival = this.field.get(item);
            Object eval = this.field.get(this.expected);
            if (ival instanceof Optional || eval instanceof Optional) {
                if (!(ival instanceof Optional) || !(eval instanceof Optional)) {
                    matched = false;
                } else {
                    Object ioval = ((Optional)ival).orElse(null);
                    Object eoval = ((Optional)eval).orElse(null);
                    matched = this.epsilon != null ? Objects.deepEquals(ioval, eoval, (double)this.epsilon) : java.util.Objects.deepEquals(ioval, eoval);
                }
            } else {
                matched = this.epsilon != null ? Objects.deepEquals((Object)ival, (Object)eval, (double)this.epsilon) : java.util.Objects.deepEquals(ival, eval);
            }
            if (!matched) {
                mismatch.appendText("however the column '").appendText(this.columns).appendText("' was ").appendValue(ival).appendText(" instead of ").appendValue(eval);
                return false;
            }
            return true;
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (ExceptionInInitializerError e) {
            Throwable t = e.getException();
            if (t instanceof AssertionError) {
                throw (AssertionError)((Object)t);
            }
            throw new AssertionError((Object)t);
        }
    }

    public void describeTo(Description description) {
        description.appendText("column '").appendText(this.columns);
        if (this.epsilon == null) {
            description.appendText("' are equal");
        } else {
            description.appendText("' are close to within ").appendText(this.epsilon.toString());
        }
    }
}

