/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.driver.junit.hamcrest;

import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Validate;
import org.hamcrest.Description;
import org.hamcrest.DiagnosingMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;
import org.helenus.commons.lang3.reflect.ReflectionUtils;
import org.helenus.driver.junit.hamcrest.AreColumnsEqual;
import org.helenus.driver.junit.hamcrest.ColumnMatches;
import org.helenus.driver.junit.hamcrest.IsColumnNotNull;
import org.helenus.driver.junit.hamcrest.IsColumnNull;
import org.helenus.driver.persistence.Column;

public abstract class ColumnMatchers {
    private static boolean ignoreField(Column[] columns, Set<String> found, String ... ignore) {
        for (Column c : columns) {
            if (!ArrayUtils.contains((Object[])ignore, (Object)c.name())) continue;
            found.add(c.name());
            return true;
        }
        return false;
    }

    private static boolean acceptField(Column[] columns, String column) {
        for (Column c : columns) {
            if (!c.name().equals(column)) continue;
            return true;
        }
        return false;
    }

    public static <T> Matcher<T> columnsEqualTo(final T operand, String ... ignore) {
        HashSet found = new HashSet(ignore.length * 3 / 2);
        final StringBuilder sb = new StringBuilder();
        final List matchers = ReflectionUtils.getAllAnnotationsForFieldsAnnotatedWith(operand.getClass(), Column.class, (boolean)true).entrySet().stream().filter(e -> !ColumnMatchers.ignoreField((Column[])e.getValue(), found, ignore)).map(e -> new AreColumnsEqual<Object>(operand, (Field)e.getKey(), (Column[])e.getValue())).peek(a -> {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(a.columns).append("=");
            try {
                Object o = a.field.get(operand);
                if (o != null && o.getClass().isArray()) {
                    sb.append(ArrayUtils.toString((Object)o));
                } else {
                    sb.append(o);
                }
            }
            catch (Exception e) {
                sb.append("???");
            }
        }).collect(Collectors.toList());
        Validate.isTrue((!matchers.isEmpty() ? 1 : 0) != 0, (String)"no matching columns left defined in pojo class '%s'", (Object[])new Object[]{operand.getClass().getSimpleName()});
        for (String i : ignore) {
            Validate.isTrue((boolean)found.contains(i), (String)"column '%s' not defined in pojo class '%s'", (Object[])new Object[]{i, operand.getClass().getSimpleName()});
        }
        return new DiagnosingMatcher<T>(){

            public boolean matches(Object o, Description mismatch) {
                for (Matcher matcher : matchers) {
                    if (matcher.matches(o)) continue;
                    matcher.describeMismatch(o, mismatch);
                    return false;
                }
                return true;
            }

            public void describeTo(Description description) {
                description.appendText(operand.getClass().getSimpleName()).appendText("[").appendText(matchers.stream().map(m -> m.columns).collect(Collectors.joining(", "))).appendText("] are all equal to [" + sb + "]");
            }
        };
    }

    public static <T> Matcher<T> columnsEqualTo(String column, final T operand) {
        final StringBuilder sb = new StringBuilder();
        final List matchers = ReflectionUtils.getAllAnnotationsForFieldsAnnotatedWith(operand.getClass(), Column.class, (boolean)true).entrySet().stream().filter(e -> ColumnMatchers.acceptField((Column[])e.getValue(), column)).map(e -> new AreColumnsEqual<Object>(operand, (Field)e.getKey(), column)).peek(a -> {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(a.columns).append("=");
            try {
                Object o = a.field.get(operand);
                if (o != null && o.getClass().isArray()) {
                    sb.append(ArrayUtils.toString((Object)o));
                } else {
                    sb.append(o);
                }
            }
            catch (Exception e) {
                sb.append("???");
            }
        }).collect(Collectors.toList());
        Validate.isTrue((!matchers.isEmpty() ? 1 : 0) != 0, (String)"column '%s' not defined in pojo class '%s'", (Object[])new Object[]{column, operand.getClass().getSimpleName()});
        return new DiagnosingMatcher<T>(){

            public boolean matches(Object o, Description mismatch) {
                for (Matcher matcher : matchers) {
                    if (matcher.matches(o)) continue;
                    matcher.describeMismatch(o, mismatch);
                    return false;
                }
                return true;
            }

            public void describeTo(Description description) {
                description.appendText(operand.getClass().getSimpleName()).appendText("[").appendText(matchers.stream().map(m -> m.columns).collect(Collectors.joining(", "))).appendText("] is equal to [" + sb + "]");
            }
        };
    }

    public static <T> Matcher<T> columnsCloseTo(final T operand, final double epsilon, String ... ignore) {
        HashSet found = new HashSet(ignore.length * 3 / 2);
        final StringBuilder sb = new StringBuilder();
        final List matchers = ReflectionUtils.getAllAnnotationsForFieldsAnnotatedWith(operand.getClass(), Column.class, (boolean)true).entrySet().stream().filter(e -> !ColumnMatchers.ignoreField((Column[])e.getValue(), found, ignore)).map(e -> new AreColumnsEqual<Object>(operand, (Field)e.getKey(), (Column[])e.getValue(), (Double)epsilon)).peek(a -> {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(a.columns).append("=");
            try {
                Object o = a.field.get(operand);
                if (o != null && o.getClass().isArray()) {
                    sb.append(ArrayUtils.toString((Object)o));
                } else {
                    sb.append(o);
                }
            }
            catch (Exception e) {
                sb.append("???");
            }
        }).collect(Collectors.toList());
        Validate.isTrue((!matchers.isEmpty() ? 1 : 0) != 0, (String)"no matching columns left defined in pojo class '%s'", (Object[])new Object[]{operand.getClass().getSimpleName()});
        for (String i : ignore) {
            Validate.isTrue((boolean)found.contains(i), (String)"column '%s' not defined in pojo class '%s'", (Object[])new Object[]{i, operand.getClass().getSimpleName()});
        }
        return new DiagnosingMatcher<T>(){

            public boolean matches(Object o, Description mismatch) {
                for (Matcher matcher : matchers) {
                    if (matcher.matches(o)) continue;
                    matcher.describeMismatch(o, mismatch);
                    return false;
                }
                return true;
            }

            public void describeTo(Description description) {
                description.appendText(operand.getClass().getSimpleName()).appendText("[").appendText(matchers.stream().map(m -> m.columns).collect(Collectors.joining(", "))).appendText("] are all close within " + epsilon + " from [" + sb + "]");
            }
        };
    }

    public static <T> Matcher<T> columnsCloseTo(String column, final T operand, final double epsilon) {
        final StringBuilder sb = new StringBuilder();
        final List matchers = ReflectionUtils.getAllAnnotationsForFieldsAnnotatedWith(operand.getClass(), Column.class, (boolean)true).entrySet().stream().filter(e -> ColumnMatchers.acceptField((Column[])e.getValue(), column)).map(e -> new AreColumnsEqual<Object>(operand, (Field)e.getKey(), column, (Double)epsilon)).peek(a -> {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(a.columns).append("=");
            try {
                Object o = a.field.get(operand);
                if (o != null && o.getClass().isArray()) {
                    sb.append(ArrayUtils.toString((Object)o));
                } else {
                    sb.append(o);
                }
            }
            catch (Exception e) {
                sb.append("???");
            }
        }).collect(Collectors.toList());
        Validate.isTrue((!matchers.isEmpty() ? 1 : 0) != 0, (String)"column '%s' not defined in pojo class '%s'", (Object[])new Object[]{column, operand.getClass().getSimpleName()});
        return new DiagnosingMatcher<T>(){

            public boolean matches(Object o, Description mismatch) {
                for (Matcher matcher : matchers) {
                    if (matcher.matches(o)) continue;
                    matcher.describeMismatch(o, mismatch);
                    return false;
                }
                return true;
            }

            public void describeTo(Description description) {
                description.appendText(operand.getClass().getSimpleName()).appendText("[").appendText(matchers.stream().map(m -> m.columns).collect(Collectors.joining(", "))).appendText("] is close within " + epsilon + " from [" + sb + "]");
            }
        };
    }

    public static <T> Matcher<T> columnIsNull(String column, final Class<T> operand) {
        final List matchers = ReflectionUtils.getAllAnnotationsForFieldsAnnotatedWith(operand, Column.class, (boolean)true).entrySet().stream().filter(e -> ColumnMatchers.acceptField((Column[])e.getValue(), column)).map(e -> new IsColumnNull(operand, (Field)e.getKey(), column)).collect(Collectors.toList());
        Validate.isTrue((!matchers.isEmpty() ? 1 : 0) != 0, (String)"column '%s' not defined in pojo class '%s'", (Object[])new Object[]{column, operand.getSimpleName()});
        return new DiagnosingMatcher<T>(){

            public boolean matches(Object o, Description mismatch) {
                for (Matcher matcher : matchers) {
                    if (matcher.matches(o)) continue;
                    matcher.describeMismatch(o, mismatch);
                    return false;
                }
                return true;
            }

            public void describeTo(Description description) {
                description.appendText(operand.getSimpleName()).appendText("[").appendText(matchers.stream().map(m -> m.column).collect(Collectors.joining(", "))).appendText("] is null");
            }
        };
    }

    public static <T> Matcher<T> columnIsNotNull(String column, final Class<T> operand) {
        final List matchers = ReflectionUtils.getAllAnnotationsForFieldsAnnotatedWith(operand, Column.class, (boolean)true).entrySet().stream().filter(e -> ColumnMatchers.acceptField((Column[])e.getValue(), column)).map(e -> new IsColumnNotNull(operand, (Field)e.getKey(), column)).collect(Collectors.toList());
        Validate.isTrue((!matchers.isEmpty() ? 1 : 0) != 0, (String)"column '%s' not defined in pojo class '%s'", (Object[])new Object[]{column, operand.getSimpleName()});
        return new DiagnosingMatcher<T>(){

            public boolean matches(Object o, Description mismatch) {
                for (Matcher matcher : matchers) {
                    if (matcher.matches(o)) continue;
                    matcher.describeMismatch(o, mismatch);
                    return false;
                }
                return true;
            }

            public void describeTo(Description description) {
                description.appendText(operand.getSimpleName()).appendText("[").appendText(matchers.stream().map(m -> m.column).collect(Collectors.joining(", "))).appendText("] is not null");
            }
        };
    }

    public static <T, V> Matcher<T> columnMatches(String column, final Class<T> operand, final Matcher<V> matcher) {
        final List matchers = ReflectionUtils.getAllAnnotationsForFieldsAnnotatedWith(operand, Column.class, (boolean)true).entrySet().stream().filter(e -> ColumnMatchers.acceptField((Column[])e.getValue(), column)).map(e -> new ColumnMatches(operand, (Field)e.getKey(), column, matcher)).collect(Collectors.toList());
        Validate.isTrue((!matchers.isEmpty() ? 1 : 0) != 0, (String)"column '%s' not defined in pojo class '%s'", (Object[])new Object[]{column, operand.getSimpleName()});
        return new DiagnosingMatcher<T>(){

            public boolean matches(Object o, Description mismatch) {
                for (Matcher matcher2 : matchers) {
                    if (matcher2.matches(o)) continue;
                    matcher2.describeMismatch(o, mismatch);
                    return false;
                }
                return true;
            }

            public void describeTo(Description description) {
                description.appendText(operand.getSimpleName()).appendText("[").appendText(matchers.stream().map(m -> m.column).collect(Collectors.joining(", "))).appendText("] ").appendDescriptionOf((SelfDescribing)matcher);
            }
        };
    }
}

