/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.driver.junit.hamcrest;

import java.lang.reflect.Field;
import org.hamcrest.Description;
import org.hamcrest.DiagnosingMatcher;
import org.hamcrest.Matcher;

class ColumnMatches<T, V>
extends DiagnosingMatcher<T> {
    final Class<T> expected;
    final Field field;
    final String column;
    final Matcher<V> matcher;

    ColumnMatches(Class<T> expected, Field field, String column, Matcher<V> matcher) {
        this.expected = expected;
        this.field = field;
        this.column = column;
        this.matcher = matcher;
        field.setAccessible(true);
    }

    protected boolean matches(Object item, Description mismatch) {
        if (item == null) {
            mismatch.appendText("however the pojo was null");
            return false;
        }
        if (!this.expected.isInstance(item)) {
            mismatch.appendText("however the pojo was not an instance of ").appendText(this.expected.getName());
            return false;
        }
        try {
            Object ival = this.field.get(item);
            if (!this.matcher.matches(ival)) {
                mismatch.appendText("however the column '").appendText(this.column).appendText("' ");
                this.matcher.describeMismatch(ival, mismatch);
                return false;
            }
            return true;
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (ExceptionInInitializerError e) {
            Throwable t = e.getException();
            if (t instanceof AssertionError) {
                throw (AssertionError)((Object)t);
            }
            throw new AssertionError((Object)t);
        }
    }

    public void describeTo(Description description) {
        description.appendText("column '").appendText(this.column).appendText("' ").appendDescriptionOf(this.matcher);
    }
}

