/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.driver.junit.hamcrest;

import java.lang.reflect.Field;
import org.hamcrest.Description;
import org.hamcrest.DiagnosingMatcher;

class IsColumnNull<T>
extends DiagnosingMatcher<T> {
    final Class<T> expected;
    final Field field;
    final String column;

    IsColumnNull(Class<T> expected, Field field, String column) {
        this.expected = expected;
        this.field = field;
        this.column = column;
        field.setAccessible(true);
    }

    protected boolean matches(Object item, Description mismatch) {
        if (item == null) {
            return true;
        }
        if (!this.expected.isInstance(item)) {
            mismatch.appendText("however the pojo was not an instance of ").appendText(this.expected.getName());
            return false;
        }
        try {
            Object ival = this.field.get(item);
            if (ival != null) {
                mismatch.appendText("however the column '").appendText(this.column).appendText("' was not null");
                return false;
            }
            return true;
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (ExceptionInInitializerError e) {
            Throwable t = e.getException();
            if (t instanceof AssertionError) {
                throw (AssertionError)((Object)t);
            }
            throw new AssertionError((Object)t);
        }
    }

    public void describeTo(Description description) {
        description.appendText("column '").appendText(this.column).appendText("' is null");
    }
}

