/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.driver.junit.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.apache.commons.lang3.Validate;

public class ReflectionJUnitUtils {
    public static <A extends Annotation> A[] getAnnotationsByType(Method method, Class<A> annotationClass) {
        Validate.notNull((Object)method, (String)"invalid null method", (Object[])new Object[0]);
        ArrayList<Annotation> annotations = new ArrayList<Annotation>(8);
        for (Annotation a : method.getAnnotationsByType(annotationClass)) {
            annotations.add(a);
        }
        for (Annotation a : method.getDeclaringClass().getAnnotationsByType(annotationClass)) {
            annotations.add(a);
        }
        Annotation[] as = (Annotation[])Array.newInstance(annotationClass, annotations.size());
        return annotations.toArray(as);
    }

    private ReflectionJUnitUtils() {
        throw new IllegalStateException("invalid constructor called");
    }
}

