/*
 * Decompiled with CFR 0.152.
 */
package herddb.jdbc;

import herddb.client.HDBClient;
import herddb.jdbc.BasicHerdDBDataSource;
import herddb.server.Server;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HerdDBWrappingDataSource
extends BasicHerdDBDataSource {
    private static final Logger LOGGER = Logger.getLogger(HerdDBWrappingDataSource.class.getName());
    private Server server;

    public HerdDBWrappingDataSource(HDBClient client) {
        super(client);
    }

    public HerdDBWrappingDataSource(HDBClient client, Server server) {
        super(client);
        this.server = server;
    }

    @Override
    protected synchronized void ensureClient() throws SQLException {
        super.ensureClient();
        this.doWaitForTableSpace();
    }

    @Override
    public synchronized void close() {
        super.close();
        if (this.server != null) {
            try {
                this.server.close();
            }
            catch (Exception err) {
                LOGGER.log(Level.SEVERE, "error during server shutdown:" + err, err);
            }
            this.server = null;
        }
    }
}

