/*
 * Decompiled with CFR 0.152.
 */
package herddb.jdbc;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import herddb.jdbc.HerdDBEmbeddedDataSource;
import herddb.utils.Version;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

@SuppressFBWarnings(value={"NM_SAME_SIMPLE_NAME_AS_INTERFACE"})
public class Driver
implements java.sql.Driver,
AutoCloseable {
    private static final Logger LOG = Logger.getLogger(Driver.class.getName());
    private static final DataSourceManager DATASOURCE_MANAGER = new DataSourceManager();

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (!this.acceptsURL(url)) {
            return null;
        }
        HerdDBEmbeddedDataSource datasource = Driver.DATASOURCE_MANAGER.ensureDatasource(url, info);
        return datasource.getConnection();
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return url != null && url.startsWith("jdbc:herddb:");
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    @Override
    public int getMajorVersion() {
        return Version.getJDBC_DRIVER_MAJOR_VERSION();
    }

    @Override
    public int getMinorVersion() {
        return Version.getJDBC_DRIVER_MINOR_VERSION();
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return LOG;
    }

    private static String computeKey(String url, Properties info) {
        StringBuilder res = new StringBuilder(url);
        res.append('#');
        if (info != null) {
            ArrayList<String> keys = new ArrayList<String>(info.stringPropertyNames());
            keys.sort(Comparator.naturalOrder());
            for (String key : keys) {
                String value = info.getProperty(key, "");
                res.append(key);
                res.append('=');
                res.append(value);
                res.append('.');
            }
        }
        return res.toString();
    }

    @Override
    public synchronized void close() {
        Driver.DATASOURCE_MANAGER.closeAll();
    }

    static {
        try {
            Runnable awaiter = PreloadClasses.run();
            Driver driver = new Driver();
            DriverManager.registerDriver(driver, () -> {
                driver.close();
                awaiter.run();
            });
        }
        catch (SQLException error) {
            LOG.log(Level.SEVERE, "error while registring JDBC driver:" + error, error);
        }
    }

    private static final class PreloadClasses {
        private PreloadClasses() {
        }

        public static Runnable run() {
            if (Boolean.getBoolean("herddb.driver.preloadClasses.skip")) {
                return () -> {};
            }
            ClassLoader loader = Optional.ofNullable(Thread.currentThread().getContextClassLoader()).orElseGet(ClassLoader::getSystemClassLoader);
            List<String> classes = Arrays.asList("org.apache.calcite.sql.fun.SqlStdOperatorTable", "herddb.sql.CalcitePlanner", "herddb.core.TableSpaceManager", "herddb.client.ClientConfiguration", "herddb.server.ServerConfiguration", "org.apache.calcite.rel.metadata.JaninoRelMetadataProvider", "org.apache.calcite.sql.validate.SqlValidator$Config", "org.apache.calcite.tools.Programs", "org.apache.calcite.plan.RelOptRules", "org.apache.calcite.sql2rel.StandardConvertletTable");
            int threads = Math.min(classes.size(), Math.max(1, Runtime.getRuntime().availableProcessors()));
            ExecutorService es = Executors.newFixedThreadPool(threads, new ThreadFactory(){
                private final AtomicInteger counter = new AtomicInteger();

                @Override
                public Thread newThread(Runnable r) {
                    return new Thread(r, "herddb-classes-preaload-" + this.counter.incrementAndGet());
                }
            });
            AtomicInteger counter = new AtomicInteger(classes.size());
            CountDownLatch latch = new CountDownLatch(classes.size());
            for (String name : classes) {
                es.execute(() -> {
                    try {
                        Class.forName(name, true, loader);
                    }
                    catch (ClassNotFoundException | Error throwable) {
                    }
                    finally {
                        latch.countDown();
                        if (counter.decrementAndGet() == 0) {
                            PreloadClasses.doStop(es, latch);
                        }
                    }
                });
            }
            return () -> {
                PreloadClasses.doStop(es, latch);
                System.setProperty("herddb.driver.preloadClasses.skip", "true");
            };
        }

        private static void doStop(ExecutorService es, CountDownLatch latch) {
            if (es.isShutdown() || es.isTerminated()) {
                return;
            }
            try {
                latch.await();
                es.shutdownNow();
                es.awaitTermination(200L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private static class DataSourceManager {
        private final HashMap<String, HerdDBEmbeddedDataSource> datasources = new HashMap();

        private DataSourceManager() {
        }

        private synchronized HerdDBEmbeddedDataSource ensureDatasource(String url, Properties info) {
            String key = Driver.computeKey(url, info);
            HerdDBEmbeddedDataSource ds = this.datasources.get(key);
            if (ds != null) {
                return ds;
            }
            ds = new HerdDBEmbeddedDataSource(info);
            ds.setUrl(url);
            if (!url.contains("poolConnections") && !info.containsKey("poolConnections")) {
                ds.setPoolConnections(false);
            }
            DataSourceManager dr = this;
            ds.setOnAutoClose(d -> {
                DataSourceManager dataSourceManager = dr;
                synchronized (dataSourceManager) {
                    if (d.isAutoClose()) {
                        LOG.log(Level.INFO, "AutoClosing JDBC Driver created DS {0}", d);
                        d.close();
                        this.datasources.remove(key);
                    }
                }
            });
            LOG.log(Level.INFO, "JDBC Driver created DS {0}", ds);
            this.datasources.put(key, ds);
            return ds;
        }

        private synchronized void closeAll() {
            LOG.log(Level.INFO, "Unregistering HerdDB JDBC Driver {0}", this);
            this.datasources.forEach((key, ds) -> {
                LOG.log(Level.INFO, "Unregistering HerdDB JDBC Driver {0} Datasource ID {1}", new Object[]{this, key});
                ds.close();
            });
            this.datasources.clear();
        }

        public synchronized void closeDatasources(String url) {
            List entries = this.datasources.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(url + '#')).collect(Collectors.toList());
            for (Map.Entry entry : entries) {
                this.datasources.remove(entry.getKey());
                ((HerdDBEmbeddedDataSource)entry.getValue()).close();
            }
        }
    }
}

