/*
 * Decompiled with CFR 0.152.
 */
package herddb.network.netty;

import herddb.network.Channel;
import herddb.network.ChannelEventListener;
import herddb.network.SendResultCallback;
import herddb.network.netty.AbstractChannel;
import herddb.proto.Pdu;
import herddb.proto.PduCodec;
import io.netty.buffer.ByteBuf;
import io.netty.util.ReferenceCountUtil;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.ExecutorService;

public class LocalVMChannel
extends AbstractChannel
implements Comparable<LocalVMChannel> {
    private final ServerSideLocalVMChannel serverSideChannel;

    LocalVMChannel(String name, ChannelEventListener clientSidePeer, ExecutorService executorService) {
        super(name, "jvm-local", executorService);
        this.setMessagesReceiver(clientSidePeer);
        this.serverSideChannel = new ServerSideLocalVMChannel("jvm-local", "jvm-local", executorService);
    }

    public Channel getServerSideChannel() {
        return this.serverSideChannel;
    }

    @Override
    public void sendOneWayMessage(ByteBuf message, SendResultCallback callback) {
        if (this.isClosed()) {
            ReferenceCountUtil.safeRelease((Object)message);
            callback.messageSent(new IOException("channel closed"));
            return;
        }
        try {
            Pdu pdu = PduCodec.decodePdu((ByteBuf)message);
            this.serverSideChannel.directProcessPdu(pdu);
        }
        catch (IOException ex) {
            ReferenceCountUtil.safeRelease((Object)message);
            callback.messageSent(ex);
        }
    }

    @Override
    protected String describeSocket() {
        return "jvm-local";
    }

    @Override
    protected void doClose() {
        this.channelClosed();
        this.serverSideChannel.close();
    }

    @Override
    public boolean isValid() {
        return !this.ioErrors;
    }

    @Override
    public boolean isLocalChannel() {
        return true;
    }

    public int hashCode() {
        int hash = 5;
        hash = 19 * hash + Objects.hashCode(this.getId());
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LocalVMChannel other = (LocalVMChannel)obj;
        return Objects.equals(this.getId(), other.getId());
    }

    @Override
    public int compareTo(LocalVMChannel o) {
        return Long.compare(this.getId(), o.getId());
    }

    private class ServerSideLocalVMChannel
    extends AbstractChannel {
        public ServerSideLocalVMChannel(String name, String remoteAddress, ExecutorService executor) {
            super(name, remoteAddress, executor);
        }

        @Override
        public void sendOneWayMessage(ByteBuf message, SendResultCallback callback) {
            if (this.isClosed()) {
                ReferenceCountUtil.safeRelease((Object)message);
                callback.messageSent(new IOException("channel closed"));
                return;
            }
            try {
                Pdu pdu = PduCodec.decodePdu((ByteBuf)message);
                LocalVMChannel.this.directProcessPdu(pdu);
            }
            catch (IOException ex) {
                ReferenceCountUtil.safeRelease((Object)message);
                callback.messageSent(ex);
            }
        }

        @Override
        protected String describeSocket() {
            return LocalVMChannel.this.describeSocket();
        }

        @Override
        protected void doClose() {
            this.channelClosed();
            LocalVMChannel.this.close();
        }

        @Override
        public boolean isValid() {
            return LocalVMChannel.this.isValid();
        }

        @Override
        public boolean isLocalChannel() {
            return true;
        }

        public String toString() {
            return "server-localvm-channel";
        }
    }
}

