/*
 * Decompiled with CFR 0.152.
 */
package herddb.network.netty;

import io.netty.channel.epoll.Epoll;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NetworkUtils {
    private static final Logger LOG = Logger.getLogger(NetworkUtils.class.getName());
    private static Boolean nettyEpoolNativeAvailable;

    public static synchronized boolean isEnableEpoolNative() {
        if (nettyEpoolNativeAvailable == null && !(nettyEpoolNativeAvailable = Boolean.valueOf(System.getProperty("os.name").equalsIgnoreCase("linux") && !Boolean.getBoolean("herddb.network.disablenativeepoll") && Epoll.isAvailable())).booleanValue() && !Epoll.isAvailable()) {
            LOG.log(Level.INFO, "Netty Epoll is not enabled, os.name {0}, Epoll.isAvailable(): {1} cause: {2}", new Object[]{System.getProperty("os.name"), Epoll.isAvailable(), Epoll.unavailabilityCause()});
        }
        return nettyEpoolNativeAvailable;
    }

    public static String getAddress(InetSocketAddress address) {
        if (address.getAddress() != null) {
            return address.getAddress().getHostAddress();
        }
        return address.getHostName();
    }

    public static int assignFirstFreePort() throws IOException {
        try (ServerSocket socket = new ServerSocket(0);){
            int n = socket.getLocalPort();
            return n;
        }
    }

    public static String getLocalNetworkAddress() throws UnknownHostException {
        return InetAddress.getLocalHost().getHostName();
    }
}

