/*
 * Decompiled with CFR 0.152.
 */
package herddb.network.netty;

import herddb.network.netty.NettyChannel;
import herddb.proto.Pdu;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ServerInboundMessageHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger LOG = Logger.getLogger(ServerInboundMessageHandler.class.getName());
    private final NettyChannel session;

    public ServerInboundMessageHandler(NettyChannel session) {
        this.session = session;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        LOG.log(Level.SEVERE, "error on channel " + ctx, cause);
        ctx.close();
        this.session.exceptionCaught(cause);
    }

    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        this.session.channelClosed();
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        this.session.pduReceived((Pdu)msg);
    }
}

