/*
 Licensed to Diennea S.r.l. under one
 or more contributor license agreements. See the NOTICE file
 distributed with this work for additional information
 regarding copyright ownership. Diennea S.r.l. licenses this file
 to you under the Apache License, Version 2.0 (the
 "License"); you may not use this file except in compliance
 with the License.  You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing,
 software distributed under the License is distributed on an
 "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 KIND, either express or implied.  See the License for the
 specific language governing permissions and limitations
 under the License.

 */

package herddb.network.netty;

import java.util.concurrent.ConcurrentHashMap;

/**
 * Registry for Local Servers, to bypass network
 *
 * @author enrico.olivelli
 */
public class LocalServerRegistry {

    private static final ConcurrentHashMap<String, LocalVMChannelAcceptor> localServers = new ConcurrentHashMap<>();

    static void registerLocalServer(String host, int port, LocalVMChannelAcceptor acceptor) {
        localServers.put(composeServerKey(host, port), acceptor);
    }

    private static String composeServerKey(String host, int port) {
        return host + ":" + port;
    }

    static void unregisterLocalServer(String host, int port) {
        localServers.remove(composeServerKey(host, port));
    }

    static LocalVMChannelAcceptor getLocalServer(String host, int port) {
        return localServers.get(composeServerKey(host, port));
    }
}
