/*
 * Decompiled with CFR 0.152.
 */
package herddb.network.netty;

import herddb.network.ServerSideConnectionAcceptor;
import herddb.network.netty.LocalServerRegistry;
import herddb.network.netty.LocalVMChannelAcceptor;
import herddb.network.netty.NettyChannel;
import herddb.network.netty.NetworkUtils;
import herddb.network.netty.ProtocolMessageDecoder;
import herddb.network.netty.ServerInboundMessageHandler;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.codec.LengthFieldPrepender;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import io.netty.util.concurrent.FastThreadLocalThread;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.bookkeeper.stats.Gauge;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;

public class NettyChannelAcceptor
implements AutoCloseable {
    private static final Logger LOGGER = Logger.getLogger(NettyChannelAcceptor.class.getName());
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;
    private int port = 7000;
    private String host = "localhost";
    private String jvmhostAddress;
    private boolean ssl;
    private ServerSideConnectionAcceptor acceptor;
    private SslContext sslCtx;
    private List<String> sslCiphers;
    private File sslCertChainFile;
    private File sslCertFile;
    private String sslCertPassword;
    private int workerThreads = 16;
    private int callbackThreads = 64;
    private ExecutorService callbackExecutor;
    private BlockingQueue callbackExecutorQueue;
    private boolean enableRealNetwork = true;
    private boolean enableJVMNetwork = true;
    private final LocalVMChannelAcceptor localVMChannelAcceptor;
    private Channel channel;
    private StatsLogger statsLogger;
    private static final ThreadFactory threadFactory = new ThreadFactory(){
        private final AtomicLong count = new AtomicLong();

        @Override
        public Thread newThread(Runnable r) {
            return new FastThreadLocalThread(r, "herddb-srvcall-" + this.count.incrementAndGet());
        }
    };

    public boolean isEnableRealNetwork() {
        return this.enableRealNetwork;
    }

    public void setEnableRealNetwork(boolean enableRealNetwork) {
        this.enableRealNetwork = enableRealNetwork;
    }

    public boolean isEnableJVMNetwork() {
        return this.enableJVMNetwork;
    }

    public void setEnableJVMNetwork(boolean enableJVMNetwork) {
        this.enableJVMNetwork = enableJVMNetwork;
    }

    public int getCallbackThreads() {
        return this.callbackThreads;
    }

    public void setCallbackThreads(int callbackThreads) {
        this.callbackThreads = callbackThreads;
    }

    public int getWorkerThreads() {
        return this.workerThreads;
    }

    public void setWorkerThreads(int workerThreads) {
        this.workerThreads = workerThreads;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }

    public File getSslCertChainFile() {
        return this.sslCertChainFile;
    }

    public void setSslCertChainFile(File sslCertChainFile) {
        this.sslCertChainFile = sslCertChainFile;
    }

    public File getSslCertFile() {
        return this.sslCertFile;
    }

    public void setSslCertFile(File sslCertFile) {
        this.sslCertFile = sslCertFile;
    }

    public String getSslCertPassword() {
        return this.sslCertPassword;
    }

    public void setSslCertPassword(String sslCertPassword) {
        this.sslCertPassword = sslCertPassword;
    }

    public List<String> getSslCiphers() {
        return this.sslCiphers;
    }

    public void setSslCiphers(List<String> sslCiphers) {
        this.sslCiphers = sslCiphers;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public NettyChannelAcceptor(String host, int port, boolean ssl) {
        this(host, port, ssl, (StatsLogger)NullStatsLogger.INSTANCE);
    }

    public NettyChannelAcceptor(String host, int port, boolean ssl, StatsLogger statsLogger) {
        this.host = host;
        this.port = port;
        this.ssl = ssl;
        this.statsLogger = statsLogger;
        this.localVMChannelAcceptor = new LocalVMChannelAcceptor();
    }

    public void start() throws Exception {
        if (this.ssl) {
            if (this.sslCertFile == null) {
                LOGGER.log(Level.INFO, "start SSL with self-signed auto-generated certificate");
                if (this.sslCiphers != null) {
                    LOGGER.log(Level.INFO, "required sslCiphers " + this.sslCiphers);
                }
                SelfSignedCertificate ssc = new SelfSignedCertificate();
                try {
                    this.sslCtx = SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).ciphers(this.sslCiphers).build();
                }
                finally {
                    ssc.delete();
                }
            } else {
                LOGGER.log(Level.INFO, "start SSL with certificate " + this.sslCertFile.getAbsolutePath() + " chain file " + this.sslCertChainFile.getAbsolutePath());
                if (this.sslCiphers != null) {
                    LOGGER.log(Level.INFO, "required sslCiphers " + this.sslCiphers);
                }
                this.sslCtx = SslContextBuilder.forServer((File)this.sslCertChainFile, (File)this.sslCertFile, (String)this.sslCertPassword).ciphers(this.sslCiphers).build();
            }
        }
        if (this.callbackThreads == 0) {
            this.callbackExecutorQueue = new SynchronousQueue();
            this.callbackExecutor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, (BlockingQueue<Runnable>)this.callbackExecutorQueue, threadFactory);
        } else {
            this.callbackExecutorQueue = new LinkedBlockingQueue();
            this.callbackExecutor = new ThreadPoolExecutor(this.callbackThreads, this.callbackThreads, 0L, TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)this.callbackExecutorQueue, threadFactory);
        }
        this.statsLogger.registerGauge("callbacksqueue", (Gauge)new Gauge<Integer>(){

            public Integer getDefaultValue() {
                return 0;
            }

            public Integer getSample() {
                return NettyChannelAcceptor.this.callbackExecutorQueue.size();
            }
        });
        InetSocketAddress address = new InetSocketAddress(this.host, this.port);
        if (this.enableRealNetwork) {
            LOGGER.log(Level.INFO, "Starting HerdDB network server at {0}:{1}", new Object[]{this.host, this.port + ""});
        }
        if (this.enableRealNetwork && address.isUnresolved()) {
            throw new IOException("Bind address " + this.host + ":" + this.port + " cannot be resolved");
        }
        ChannelInitializer<Channel> channelInitialized = new ChannelInitializer<Channel>(){

            public void initChannel(Channel ch) throws Exception {
                NettyChannel session = new NettyChannel("unnamed", ch, NettyChannelAcceptor.this.callbackExecutor);
                if (NettyChannelAcceptor.this.acceptor != null) {
                    NettyChannelAcceptor.this.acceptor.createConnection(session);
                }
                if (NettyChannelAcceptor.this.ssl) {
                    ch.pipeline().addLast(new ChannelHandler[]{NettyChannelAcceptor.this.sslCtx.newHandler(ch.alloc())});
                }
                ch.pipeline().addLast("lengthprepender", (ChannelHandler)new LengthFieldPrepender(4));
                ch.pipeline().addLast("lengthbaseddecoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(Integer.MAX_VALUE, 0, 4, 0, 4));
                ch.pipeline().addLast("messagedecoder", (ChannelHandler)new ProtocolMessageDecoder());
                ch.pipeline().addLast(new ChannelHandler[]{new ServerInboundMessageHandler(session)});
            }
        };
        if (this.enableRealNetwork) {
            if (NetworkUtils.isEnableEpoolNative()) {
                this.bossGroup = new EpollEventLoopGroup(this.workerThreads);
                this.workerGroup = new EpollEventLoopGroup(this.workerThreads);
                LOGGER.log(Level.FINE, "Using netty-native-epoll network type");
            } else {
                this.bossGroup = new NioEventLoopGroup(this.workerThreads);
                this.workerGroup = new NioEventLoopGroup(this.workerThreads);
                LOGGER.log(Level.FINE, "Using nio network type");
            }
            ServerBootstrap b = new ServerBootstrap();
            ((ServerBootstrap)b.group(this.bossGroup, this.workerGroup).channel(NetworkUtils.isEnableEpoolNative() ? EpollServerSocketChannel.class : NioServerSocketChannel.class)).childHandler((ChannelHandler)channelInitialized).option(ChannelOption.SO_BACKLOG, (Object)128);
            ChannelFuture f = b.bind((SocketAddress)address).sync();
            this.channel = f.channel();
        }
        if (this.enableJVMNetwork) {
            this.jvmhostAddress = NetworkUtils.getAddress(address);
            LocalServerRegistry.registerLocalServer(this.jvmhostAddress, this.port, this.localVMChannelAcceptor);
        }
    }

    @Override
    public void close() {
        if (this.channel != null) {
            this.channel.close();
        }
        if (this.enableJVMNetwork && this.jvmhostAddress != null) {
            LocalServerRegistry.unregisterLocalServer(this.jvmhostAddress, this.port);
        }
        this.localVMChannelAcceptor.close();
        if (this.workerGroup != null) {
            this.workerGroup.shutdownGracefully();
        }
        if (this.bossGroup != null) {
            this.bossGroup.shutdownGracefully();
        }
        if (this.callbackExecutor != null) {
            this.callbackExecutor.shutdown();
        }
    }

    public ServerSideConnectionAcceptor getAcceptor() {
        return this.acceptor;
    }

    public void setAcceptor(ServerSideConnectionAcceptor acceptor) {
        this.acceptor = acceptor;
        this.localVMChannelAcceptor.setAcceptor(acceptor);
    }
}

