/*
 * Decompiled with CFR 0.152.
 */
package herddb.core;

import herddb.core.Page;
import herddb.core.PageReplacementPolicy;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClockProPolicy
implements PageReplacementPolicy {
    private static final Logger LOGGER = Logger.getLogger(ClockProPolicy.class.getName());
    private static final boolean COMPILE_EXPENSIVE_LOGS = false;
    private static final byte HOT = 1;
    private static final byte COLD = 2;
    private static final byte NON_RESIDENT_COLD = 4;
    private final int m;
    int mc = 0;
    int countHot = 0;
    int countCold = 0;
    int countNonResident = 0;
    private CPMetadata handHot;
    private CPMetadata handCold;
    private CPMetadata handTest;
    private final Lock lock = new ReentrantLock();
    private Map<CPMetadata, CPMetadata> space;

    public ClockProPolicy(int capacity) {
        this.m = capacity;
        this.mc = capacity;
        this.space = new HashMap<CPMetadata, CPMetadata>(2 * capacity);
    }

    @Override
    public CPMetadata add(Page<?> page) {
        CPMetadata remove;
        LOGGER.log(Level.FINER, () -> "Adding page " + page);
        this.lock.lock();
        try {
            remove = this.unsafeAdd(page);
        }
        finally {
            this.lock.unlock();
        }
        if (remove == null) {
            LOGGER.log(Level.FINER, () -> "Added page " + page + ", no page removal needed");
        } else {
            LOGGER.log(Level.FINER, () -> "Added page " + page + ", page selected for removal: " + remove);
        }
        return remove;
    }

    @Override
    public boolean remove(Page<?> page) {
        boolean removed;
        LOGGER.log(Level.FINER, () -> "Removing page " + page);
        this.lock.lock();
        try {
            removed = this.unsafeRemove((CPMetadata)page.metadata);
        }
        finally {
            this.lock.unlock();
        }
        if (removed) {
            LOGGER.log(Level.FINER, () -> "Removed page " + page);
        } else {
            LOGGER.log(Level.FINER, () -> "Unknown page " + page);
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <P extends Page<?>> void remove(Collection<P> pages) {
        this.lock.lock();
        try {
            for (Page page : pages) {
                this.unsafeRemove((CPMetadata)page.metadata);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int size() {
        return this.countHot + this.countCold;
    }

    @Override
    public int capacity() {
        return this.m;
    }

    @Override
    public void clear() {
        this.lock.lock();
        try {
            this.countNonResident = 0;
            this.countCold = 0;
            this.countHot = 0;
            this.mc = 0;
            this.handTest = null;
            this.handCold = null;
            this.handHot = null;
            this.space.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void pageHit(Page<?> page) {
        ClockProPolicy.hit(page);
    }

    private CPMetadata unsafeAdd(Page<?> page) {
        if (this.handHot == null) {
            CPMetadata metadata = new CPMetadata(page);
            metadata.reference = false;
            metadata.test = true;
            metadata.warm = (byte)2;
            page.metadata = metadata;
            metadata.next = metadata;
            metadata.prev = metadata;
            this.space.put(metadata, metadata);
            this.handCold = this.handTest = metadata;
            this.handHot = this.handTest;
            ++this.countCold;
            return null;
        }
        if (this.countHot + this.countCold < this.m) {
            return this.unsafeAdd(page, false);
        }
        return this.unsafeAdd(page, true);
    }

    private CPMetadata unsafeAdd(Page<?> page, boolean freespace) {
        CPMetadata unloaded = freespace ? this.coldSweep() : null;
        CPMetadata metadata = new CPMetadata(page);
        CPMetadata known = this.space.get(metadata);
        if (known == null) {
            metadata.reference = false;
            metadata.test = true;
            metadata.warm = (byte)2;
            page.metadata = metadata;
            this.space.put(metadata, metadata);
            this.insertBefore(metadata, this.handHot);
            ++this.countCold;
            if (this.countCold + this.countNonResident > this.mc + this.m) {
                this.testSweep();
            }
        } else {
            if (known.warm != 4) {
                throw new IllegalArgumentException("Added a page twice: " + page);
            }
            known.warm = 1;
            page.metadata = known;
            this.moveBefore(known, this.handHot);
            ++this.countHot;
            --this.countNonResident;
            if (known.test) {
                ++this.mc;
                this.mc = Math.min(this.m, this.mc);
                if (this.mc < 0 || this.mc > this.m) {
                    throw new IllegalStateException("Mc doens't match 0 <= mc <= m: mc " + this.mc + " m " + this.m);
                }
            }
            this.hotSweep();
        }
        return unloaded;
    }

    private boolean unsafeRemove(CPMetadata metadata) {
        CPMetadata known = this.space.remove(metadata);
        if (known == null) {
            return false;
        }
        switch (known.warm) {
            case 1: {
                --this.countHot;
                break;
            }
            case 2: {
                --this.countCold;
                break;
            }
            case 4: {
                --this.countNonResident;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown warm state " + known.warm);
            }
        }
        this.delete(known);
        return true;
    }

    private CPMetadata coldSweep() {
        CPMetadata unloading = null;
        while (unloading == null) {
            if (this.handCold.warm == 2) {
                if (this.handCold.reference) {
                    if (this.handCold.test) {
                        this.handCold.warm = 1;
                        --this.countCold;
                        ++this.countHot;
                        ++this.mc;
                        this.mc = Math.min(this.m, this.mc);
                        if (this.mc < 0 || this.mc > this.m) {
                            throw new IllegalStateException("Mc doens't match 0 <= mc <= m: mc " + this.mc + " m " + this.m);
                        }
                        this.hotSweep();
                    }
                    this.handCold.reference = false;
                } else if (this.handCold.test) {
                    this.handCold.warm = (byte)4;
                    unloading = this.handCold;
                    --this.countCold;
                    ++this.countNonResident;
                    while (this.countNonResident > this.m) {
                        this.testSweep();
                    }
                } else {
                    unloading = this.handCold;
                    --this.countCold;
                    this.handCold = this.deleteAndStayStill(this.handCold);
                }
            }
            this.handCold = this.handCold.next;
        }
        if (this.countCold > 0) {
            boolean notcoldskip = false;
            while (this.handCold.warm != 2) {
                this.handCold = this.handCold.next;
            }
        }
        return unloading;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void hotSweep() {
        if (this.countHot < this.m - this.mc) {
            return;
        }
        while (true) {
            block11: {
                block10: {
                    if (this.handHot.warm != 1) break block10;
                    if (this.handHot.reference) {
                        this.handHot.reference = false;
                        break block11;
                    } else {
                        this.handHot.warm = (byte)2;
                        ++this.countCold;
                        --this.countHot;
                        if (this.countHot <= 0) return;
                        break;
                    }
                }
                this.handHot.test = false;
                if (this.handHot.warm == 4) {
                    --this.countNonResident;
                    this.handHot = this.deleteAndStayStill(this.handHot);
                } else if (!this.handHot.reference) {
                    --this.mc;
                    this.mc = Math.max(0, this.mc);
                    if (this.mc < 0 || this.mc > this.m) {
                        throw new IllegalStateException("Mc doens't match 0 <= mc <= m: mc " + this.mc + " m " + this.m);
                    }
                }
            }
            this.handHot = this.handHot.next;
        }
        boolean nothotskip = false;
        do {
            this.handHot = this.handHot.next;
        } while (this.handHot.warm != 1);
    }

    private void testSweep() {
        boolean hotskip = false;
        while (this.handTest.warm == 1) {
            this.handTest = this.handTest.next;
        }
        this.handTest.test = false;
        if (this.handTest.warm == 4) {
            this.handTest = this.deleteAndStayStill(this.handTest);
            --this.countNonResident;
            --this.mc;
            this.mc = Math.max(0, this.mc);
            if (this.mc < 0 || this.mc > this.m) {
                throw new IllegalStateException("Mc doens't match 0 <= mc <= m: mc " + this.mc + " m " + this.m);
            }
        } else if (!this.handTest.reference) {
            --this.mc;
            this.mc = Math.max(0, this.mc);
            if (this.mc < 0 || this.mc > this.m) {
                throw new IllegalStateException("Mc doens't match 0 <= mc <= m: mc " + this.mc + " m " + this.m);
            }
        }
        this.handTest = this.handTest.next;
        hotskip = false;
        while (this.handTest.warm == 1) {
            this.handTest = this.handTest.next;
        }
    }

    private CPMetadata deleteAndStayStill(CPMetadata node) {
        CPMetadata prev = node.prev;
        this.delete(node);
        return prev;
    }

    private void delete(CPMetadata node) {
        if (node == node.next) {
            this.handTest = null;
            this.handHot = null;
            this.handCold = null;
        } else {
            if (this.handHot == node) {
                this.handHot = node.next;
            }
            if (this.handCold == node) {
                this.handCold = node.next;
            }
            if (this.handTest == node) {
                this.handTest = node.next;
            }
        }
        this.detach(node);
        this.space.remove(node);
    }

    private void insertBefore(CPMetadata inserting, CPMetadata point) {
        inserting.prev = point.prev;
        inserting.next = point;
        point.prev.next = inserting;
        point.prev = inserting;
    }

    private void moveBefore(CPMetadata moving, CPMetadata point) {
        if (moving == point) {
            return;
        }
        this.detach(moving);
        this.insertBefore(moving, point);
    }

    private void detach(CPMetadata node) {
        node.prev.next = node.next;
        node.next.prev = node.prev;
        node.next = (node.prev = null);
    }

    private static <P extends Page<?>> P hit(P page) {
        if (page != null && page.metadata != null) {
            ((CPMetadata)page.metadata).reference = true;
        }
        return page;
    }

    private static class CPMetadata
    extends Page.Metadata {
        public volatile boolean reference;
        public byte warm;
        public boolean test;
        private CPMetadata prev;
        private CPMetadata next;
        private final int hashcode;

        public CPMetadata(Page<?> page) {
            this((Page.Owner)page.owner, page.pageId);
        }

        public CPMetadata(Page.Owner owner, long pageId) {
            super(owner, pageId);
            this.hashcode = Objects.hash(owner, pageId);
            this.reference = false;
        }

        public int hashCode() {
            return this.hashcode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof CPMetadata)) {
                return false;
            }
            CPMetadata other = (CPMetadata)obj;
            if (this.owner == null ? other.owner != null : !this.owner.equals(other.owner)) {
                return false;
            }
            return this.pageId == other.pageId;
        }

        public String toString() {
            return "CPMetadata {pageId=" + this.pageId + ", owner=" + this.owner + ", reference=" + this.reference + " test=" + this.test + " warm=" + this.warm + '}';
        }
    }
}

