/*
 * Decompiled with CFR 0.152.
 */
package herddb.utils;

import herddb.utils.Bytes;
import herddb.utils.NullOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class ExtendedDataOutputStream
extends DataOutputStream {
    public static final ExtendedDataOutputStream NULL = new ExtendedDataOutputStream(NullOutputStream.INSTANCE);

    public ExtendedDataOutputStream(OutputStream out) {
        super(out);
    }

    public void writeVInt(int i) throws IOException {
        if ((i & 0xFFFFFF80) != 0) {
            this.writeByte((byte)(i & 0x7F | 0x80));
            if (((i >>>= 7) & 0xFFFFFF80) != 0) {
                this.writeByte((byte)(i & 0x7F | 0x80));
                if (((i >>>= 7) & 0xFFFFFF80) != 0) {
                    this.writeByte((byte)(i & 0x7F | 0x80));
                    if (((i >>>= 7) & 0xFFFFFF80) != 0) {
                        this.writeByte((byte)(i & 0x7F | 0x80));
                        i >>>= 7;
                    }
                }
            }
        }
        this.writeByte((byte)i);
    }

    public void writeVLong(long i) throws IOException {
        if (i < 0L) {
            throw new IllegalArgumentException("cannot write negative vLong (got: " + i + ")");
        }
        this.writeSignedVLong(i);
    }

    private void writeSignedVLong(long i) throws IOException {
        while ((i & 0xFFFFFFFFFFFFFF80L) != 0L) {
            this.writeByte((byte)(i & 0x7FL | 0x80L));
            i >>>= 7;
        }
        this.writeByte((byte)i);
    }

    public void writeZInt(int i) throws IOException {
        this.writeVInt(i >> 31 ^ i << 1);
    }

    public void writeZLong(long l) throws IOException {
        this.writeSignedVLong(l >> 63 ^ l << 1);
    }

    public void writeArray(Bytes data) throws IOException {
        if (data == null) {
            this.writeNullArray();
        } else {
            this.writeVInt(data.getLength());
            this.write(data.getBuffer(), data.getOffset(), data.getLength());
        }
    }

    public void writeNullArray() throws IOException {
        this.writeVInt(-1);
    }

    public void writeArray(byte[] data) throws IOException {
        if (data == null) {
            this.writeNullArray();
        } else {
            this.writeVInt(data.length);
            this.write(data);
        }
    }

    public void writeArray(byte[] data, int offset, int len) throws IOException {
        this.writeVInt(len);
        this.write(data, offset, len);
    }
}

