/*
 * Decompiled with CFR 0.152.
 */
package herddb.utils;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.stream.Collectors;

public class Futures {
    private static final Function<Throwable, Exception> DEFAULT_EXCEPTION_HANDLER = cause -> {
        if (cause instanceof Exception) {
            return (Exception)cause;
        }
        return new Exception((Throwable)cause);
    };

    public static <T> CompletableFuture<T> exception(Throwable cause) {
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(cause);
        return future;
    }

    public static <T> CompletableFuture<List<T>> collect(List<CompletableFuture<T>> futureList) {
        CompletableFuture<Void> finalFuture = CompletableFuture.allOf(futureList.toArray(new CompletableFuture[futureList.size()]));
        return finalFuture.thenApply(result -> futureList.stream().map(CompletableFuture::join).collect(Collectors.toList()));
    }

    public static <T, ExceptionT extends Throwable> T result(CompletableFuture<T> future, long timeout, TimeUnit timeUnit) throws ExceptionT, TimeoutException, InterruptedException, Exception {
        return Futures.result(future, DEFAULT_EXCEPTION_HANDLER, timeout, timeUnit);
    }

    public static <T, ExceptionT extends Throwable> T result(CompletableFuture<T> future) throws ExceptionT, TimeoutException, InterruptedException, Exception {
        return Futures.result(future, DEFAULT_EXCEPTION_HANDLER);
    }

    @SuppressFBWarnings(value={"NP_NONNULL_PARAM_VIOLATION"})
    public static <T> T getIfSuccess(CompletableFuture<T> future) {
        if (future.isDone() && !future.isCompletedExceptionally()) {
            return future.getNow(null);
        }
        return null;
    }

    public static <T, ExceptionT extends Throwable> T result(CompletableFuture<T> future, Function<Throwable, ExceptionT> exceptionHandler, long timeout, TimeUnit timeUnit) throws ExceptionT, TimeoutException, InterruptedException {
        try {
            return future.get(timeout, timeUnit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw e;
        }
        catch (ExecutionException e) {
            Throwable cause = (Throwable)exceptionHandler.apply(e.getCause());
            if (null == cause) {
                return null;
            }
            throw cause;
        }
    }

    public static <T, ExceptionT extends Throwable> T result(CompletableFuture<T> future, Function<Throwable, ExceptionT> exceptionHandler) throws ExceptionT, InterruptedException {
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw e;
        }
        catch (ExecutionException e) {
            Throwable cause = (Throwable)exceptionHandler.apply(e.getCause());
            if (null == cause) {
                return null;
            }
            throw cause;
        }
    }
}

