/*
 * Decompiled with CFR 0.152.
 */
package herddb.utils;

import io.netty.util.internal.PlatformDependent;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.logging.Logger;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class OpenFileUtils {
    private static final Logger LOG = Logger.getLogger(OpenFileUtils.class.getName());

    public static FileChannel openFileChannelWithO_DIRECT(Path path, OpenOption ... options) throws IOException {
        return FileChannel.open(path, options);
    }

    public static long getBlockSize(Path p) throws IOException {
        return 4096L;
    }

    public static boolean isO_DIRECT_Supported() {
        return false;
    }

    public static ByteBuffer alignedSlice(ByteBuffer buffer, int alignment) {
        return buffer;
    }

    public static void releaseAlignedBuffer(ByteBuffer buffer) {
        PlatformDependent.freeDirectBuffer((ByteBuffer)buffer);
    }

    static {
        LOG.info("This JVM is not able to use O_DIRECT (only from Java 10+)");
    }
}

