/*
 * Decompiled with CFR 0.152.
 */
package herddb.utils;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class SimpleBufferedOutputStream
extends FilterOutputStream {
    private byte[] buf;
    private int count;
    private static final int COPY_BUFFER_SIZE = 65536;

    public SimpleBufferedOutputStream(OutputStream out) {
        this(out, 65536);
    }

    public SimpleBufferedOutputStream(OutputStream out, int size) {
        super(out);
        if (size <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.buf = new byte[size];
    }

    private void flushBuffer() throws IOException {
        if (this.count > 0) {
            this.out.write(this.buf, 0, this.count);
            this.count = 0;
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (this.count >= this.buf.length) {
            this.flushBuffer();
        }
        this.buf[this.count++] = (byte)b;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (len >= this.buf.length) {
            this.flushBuffer();
            this.out.write(b, off, len);
            return;
        }
        if (len > this.buf.length - this.count) {
            this.flushBuffer();
        }
        System.arraycopy(b, off, this.buf, this.count, len);
        this.count += len;
    }

    @Override
    public void flush() throws IOException {
        this.flushBuffer();
        this.out.flush();
    }
}

